/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workmail.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeUserResponse extends WorkMailResponse implements
        ToCopyableBuilder<DescribeUserResponse.Builder, DescribeUserResponse> {
    private static final SdkField<String> USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("UserId")
            .getter(getter(DescribeUserResponse::userId)).setter(setter(Builder::userId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(DescribeUserResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> EMAIL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Email")
            .getter(getter(DescribeUserResponse::email)).setter(setter(Builder::email))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Email").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DisplayName").getter(getter(DescribeUserResponse::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(DescribeUserResponse::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<String> USER_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserRole").getter(getter(DescribeUserResponse::userRoleAsString)).setter(setter(Builder::userRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserRole").build()).build();

    private static final SdkField<Instant> ENABLED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EnabledDate").getter(getter(DescribeUserResponse::enabledDate)).setter(setter(Builder::enabledDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnabledDate").build()).build();

    private static final SdkField<Instant> DISABLED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("DisabledDate").getter(getter(DescribeUserResponse::disabledDate)).setter(setter(Builder::disabledDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisabledDate").build()).build();

    private static final SdkField<Instant> MAILBOX_PROVISIONED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("MailboxProvisionedDate").getter(getter(DescribeUserResponse::mailboxProvisionedDate))
            .setter(setter(Builder::mailboxProvisionedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MailboxProvisionedDate").build())
            .build();

    private static final SdkField<Instant> MAILBOX_DEPROVISIONED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("MailboxDeprovisionedDate").getter(getter(DescribeUserResponse::mailboxDeprovisionedDate))
            .setter(setter(Builder::mailboxDeprovisionedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MailboxDeprovisionedDate").build())
            .build();

    private static final SdkField<String> FIRST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FirstName").getter(getter(DescribeUserResponse::firstName)).setter(setter(Builder::firstName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirstName").build()).build();

    private static final SdkField<String> LAST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastName").getter(getter(DescribeUserResponse::lastName)).setter(setter(Builder::lastName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastName").build()).build();

    private static final SdkField<Boolean> HIDDEN_FROM_GLOBAL_ADDRESS_LIST_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("HiddenFromGlobalAddressList")
            .getter(getter(DescribeUserResponse::hiddenFromGlobalAddressList))
            .setter(setter(Builder::hiddenFromGlobalAddressList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HiddenFromGlobalAddressList")
                    .build()).build();

    private static final SdkField<String> INITIALS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Initials").getter(getter(DescribeUserResponse::initials)).setter(setter(Builder::initials))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Initials").build()).build();

    private static final SdkField<String> TELEPHONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Telephone").getter(getter(DescribeUserResponse::telephone)).setter(setter(Builder::telephone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Telephone").build()).build();

    private static final SdkField<String> STREET_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Street")
            .getter(getter(DescribeUserResponse::street)).setter(setter(Builder::street))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Street").build()).build();

    private static final SdkField<String> JOB_TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobTitle").getter(getter(DescribeUserResponse::jobTitle)).setter(setter(Builder::jobTitle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobTitle").build()).build();

    private static final SdkField<String> CITY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("City")
            .getter(getter(DescribeUserResponse::city)).setter(setter(Builder::city))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("City").build()).build();

    private static final SdkField<String> COMPANY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Company")
            .getter(getter(DescribeUserResponse::company)).setter(setter(Builder::company))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Company").build()).build();

    private static final SdkField<String> ZIP_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ZipCode").getter(getter(DescribeUserResponse::zipCode)).setter(setter(Builder::zipCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ZipCode").build()).build();

    private static final SdkField<String> DEPARTMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Department").getter(getter(DescribeUserResponse::department)).setter(setter(Builder::department))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Department").build()).build();

    private static final SdkField<String> COUNTRY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Country")
            .getter(getter(DescribeUserResponse::country)).setter(setter(Builder::country))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Country").build()).build();

    private static final SdkField<String> OFFICE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Office")
            .getter(getter(DescribeUserResponse::office)).setter(setter(Builder::office))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Office").build()).build();

    private static final SdkField<String> IDENTITY_PROVIDER_USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdentityProviderUserId").getter(getter(DescribeUserResponse::identityProviderUserId))
            .setter(setter(Builder::identityProviderUserId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityProviderUserId").build())
            .build();

    private static final SdkField<String> IDENTITY_PROVIDER_IDENTITY_STORE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IdentityProviderIdentityStoreId")
            .getter(getter(DescribeUserResponse::identityProviderIdentityStoreId))
            .setter(setter(Builder::identityProviderIdentityStoreId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityProviderIdentityStoreId")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_ID_FIELD, NAME_FIELD,
            EMAIL_FIELD, DISPLAY_NAME_FIELD, STATE_FIELD, USER_ROLE_FIELD, ENABLED_DATE_FIELD, DISABLED_DATE_FIELD,
            MAILBOX_PROVISIONED_DATE_FIELD, MAILBOX_DEPROVISIONED_DATE_FIELD, FIRST_NAME_FIELD, LAST_NAME_FIELD,
            HIDDEN_FROM_GLOBAL_ADDRESS_LIST_FIELD, INITIALS_FIELD, TELEPHONE_FIELD, STREET_FIELD, JOB_TITLE_FIELD, CITY_FIELD,
            COMPANY_FIELD, ZIP_CODE_FIELD, DEPARTMENT_FIELD, COUNTRY_FIELD, OFFICE_FIELD, IDENTITY_PROVIDER_USER_ID_FIELD,
            IDENTITY_PROVIDER_IDENTITY_STORE_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String userId;

    private final String name;

    private final String email;

    private final String displayName;

    private final String state;

    private final String userRole;

    private final Instant enabledDate;

    private final Instant disabledDate;

    private final Instant mailboxProvisionedDate;

    private final Instant mailboxDeprovisionedDate;

    private final String firstName;

    private final String lastName;

    private final Boolean hiddenFromGlobalAddressList;

    private final String initials;

    private final String telephone;

    private final String street;

    private final String jobTitle;

    private final String city;

    private final String company;

    private final String zipCode;

    private final String department;

    private final String country;

    private final String office;

    private final String identityProviderUserId;

    private final String identityProviderIdentityStoreId;

    private DescribeUserResponse(BuilderImpl builder) {
        super(builder);
        this.userId = builder.userId;
        this.name = builder.name;
        this.email = builder.email;
        this.displayName = builder.displayName;
        this.state = builder.state;
        this.userRole = builder.userRole;
        this.enabledDate = builder.enabledDate;
        this.disabledDate = builder.disabledDate;
        this.mailboxProvisionedDate = builder.mailboxProvisionedDate;
        this.mailboxDeprovisionedDate = builder.mailboxDeprovisionedDate;
        this.firstName = builder.firstName;
        this.lastName = builder.lastName;
        this.hiddenFromGlobalAddressList = builder.hiddenFromGlobalAddressList;
        this.initials = builder.initials;
        this.telephone = builder.telephone;
        this.street = builder.street;
        this.jobTitle = builder.jobTitle;
        this.city = builder.city;
        this.company = builder.company;
        this.zipCode = builder.zipCode;
        this.department = builder.department;
        this.country = builder.country;
        this.office = builder.office;
        this.identityProviderUserId = builder.identityProviderUserId;
        this.identityProviderIdentityStoreId = builder.identityProviderIdentityStoreId;
    }

    /**
     * <p>
     * The identifier for the described user.
     * </p>
     * 
     * @return The identifier for the described user.
     */
    public final String userId() {
        return userId;
    }

    /**
     * <p>
     * The name for the user.
     * </p>
     * 
     * @return The name for the user.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The email of the user.
     * </p>
     * 
     * @return The email of the user.
     */
    public final String email() {
        return email;
    }

    /**
     * <p>
     * The display name of the user.
     * </p>
     * 
     * @return The display name of the user.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The state of a user: enabled (registered to WorkMail) or disabled (deregistered or never registered to WorkMail).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link EntityState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of a user: enabled (registered to WorkMail) or disabled (deregistered or never registered to
     *         WorkMail).
     * @see EntityState
     */
    public final EntityState state() {
        return EntityState.fromValue(state);
    }

    /**
     * <p>
     * The state of a user: enabled (registered to WorkMail) or disabled (deregistered or never registered to WorkMail).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link EntityState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of a user: enabled (registered to WorkMail) or disabled (deregistered or never registered to
     *         WorkMail).
     * @see EntityState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * In certain cases, other entities are modeled as users. If interoperability is enabled, resources are imported
     * into WorkMail as users. Because different WorkMail organizations rely on different directory types,
     * administrators can distinguish between an unregistered user (account is disabled and has a user role) and the
     * directory administrators. The values are USER, RESOURCE, SYSTEM_USER, and REMOTE_USER.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #userRole} will
     * return {@link UserRole#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #userRoleAsString}.
     * </p>
     * 
     * @return In certain cases, other entities are modeled as users. If interoperability is enabled, resources are
     *         imported into WorkMail as users. Because different WorkMail organizations rely on different directory
     *         types, administrators can distinguish between an unregistered user (account is disabled and has a user
     *         role) and the directory administrators. The values are USER, RESOURCE, SYSTEM_USER, and REMOTE_USER.
     * @see UserRole
     */
    public final UserRole userRole() {
        return UserRole.fromValue(userRole);
    }

    /**
     * <p>
     * In certain cases, other entities are modeled as users. If interoperability is enabled, resources are imported
     * into WorkMail as users. Because different WorkMail organizations rely on different directory types,
     * administrators can distinguish between an unregistered user (account is disabled and has a user role) and the
     * directory administrators. The values are USER, RESOURCE, SYSTEM_USER, and REMOTE_USER.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #userRole} will
     * return {@link UserRole#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #userRoleAsString}.
     * </p>
     * 
     * @return In certain cases, other entities are modeled as users. If interoperability is enabled, resources are
     *         imported into WorkMail as users. Because different WorkMail organizations rely on different directory
     *         types, administrators can distinguish between an unregistered user (account is disabled and has a user
     *         role) and the directory administrators. The values are USER, RESOURCE, SYSTEM_USER, and REMOTE_USER.
     * @see UserRole
     */
    public final String userRoleAsString() {
        return userRole;
    }

    /**
     * <p>
     * The date and time at which the user was enabled for WorkMailusage, in UNIX epoch time format.
     * </p>
     * 
     * @return The date and time at which the user was enabled for WorkMailusage, in UNIX epoch time format.
     */
    public final Instant enabledDate() {
        return enabledDate;
    }

    /**
     * <p>
     * The date and time at which the user was disabled for WorkMail usage, in UNIX epoch time format.
     * </p>
     * 
     * @return The date and time at which the user was disabled for WorkMail usage, in UNIX epoch time format.
     */
    public final Instant disabledDate() {
        return disabledDate;
    }

    /**
     * <p>
     * The date when the mailbox was created for the user.
     * </p>
     * 
     * @return The date when the mailbox was created for the user.
     */
    public final Instant mailboxProvisionedDate() {
        return mailboxProvisionedDate;
    }

    /**
     * <p>
     * The date when the mailbox was removed for the user.
     * </p>
     * 
     * @return The date when the mailbox was removed for the user.
     */
    public final Instant mailboxDeprovisionedDate() {
        return mailboxDeprovisionedDate;
    }

    /**
     * <p>
     * First name of the user.
     * </p>
     * 
     * @return First name of the user.
     */
    public final String firstName() {
        return firstName;
    }

    /**
     * <p>
     * Last name of the user.
     * </p>
     * 
     * @return Last name of the user.
     */
    public final String lastName() {
        return lastName;
    }

    /**
     * <p>
     * If enabled, the user is hidden from the global address list.
     * </p>
     * 
     * @return If enabled, the user is hidden from the global address list.
     */
    public final Boolean hiddenFromGlobalAddressList() {
        return hiddenFromGlobalAddressList;
    }

    /**
     * <p>
     * Initials of the user.
     * </p>
     * 
     * @return Initials of the user.
     */
    public final String initials() {
        return initials;
    }

    /**
     * <p>
     * User's contact number.
     * </p>
     * 
     * @return User's contact number.
     */
    public final String telephone() {
        return telephone;
    }

    /**
     * <p>
     * Street where the user is located.
     * </p>
     * 
     * @return Street where the user is located.
     */
    public final String street() {
        return street;
    }

    /**
     * <p>
     * Job title of the user.
     * </p>
     * 
     * @return Job title of the user.
     */
    public final String jobTitle() {
        return jobTitle;
    }

    /**
     * <p>
     * City where the user is located.
     * </p>
     * 
     * @return City where the user is located.
     */
    public final String city() {
        return city;
    }

    /**
     * <p>
     * Company of the user.
     * </p>
     * 
     * @return Company of the user.
     */
    public final String company() {
        return company;
    }

    /**
     * <p>
     * Zip code of the user.
     * </p>
     * 
     * @return Zip code of the user.
     */
    public final String zipCode() {
        return zipCode;
    }

    /**
     * <p>
     * Department of the user.
     * </p>
     * 
     * @return Department of the user.
     */
    public final String department() {
        return department;
    }

    /**
     * <p>
     * Country where the user is located.
     * </p>
     * 
     * @return Country where the user is located.
     */
    public final String country() {
        return country;
    }

    /**
     * <p>
     * Office where the user is located.
     * </p>
     * 
     * @return Office where the user is located.
     */
    public final String office() {
        return office;
    }

    /**
     * <p>
     * User ID from the IAM Identity Center. If this parameter is empty it will be updated automatically when the user
     * logs in for the first time to the mailbox associated with WorkMail.
     * </p>
     * 
     * @return User ID from the IAM Identity Center. If this parameter is empty it will be updated automatically when
     *         the user logs in for the first time to the mailbox associated with WorkMail.
     */
    public final String identityProviderUserId() {
        return identityProviderUserId;
    }

    /**
     * <p>
     * Identity Store ID from the IAM Identity Center. If this parameter is empty it will be updated automatically when
     * the user logs in for the first time to the mailbox associated with WorkMail.
     * </p>
     * 
     * @return Identity Store ID from the IAM Identity Center. If this parameter is empty it will be updated
     *         automatically when the user logs in for the first time to the mailbox associated with WorkMail.
     */
    public final String identityProviderIdentityStoreId() {
        return identityProviderIdentityStoreId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(userId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(email());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(userRoleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(enabledDate());
        hashCode = 31 * hashCode + Objects.hashCode(disabledDate());
        hashCode = 31 * hashCode + Objects.hashCode(mailboxProvisionedDate());
        hashCode = 31 * hashCode + Objects.hashCode(mailboxDeprovisionedDate());
        hashCode = 31 * hashCode + Objects.hashCode(firstName());
        hashCode = 31 * hashCode + Objects.hashCode(lastName());
        hashCode = 31 * hashCode + Objects.hashCode(hiddenFromGlobalAddressList());
        hashCode = 31 * hashCode + Objects.hashCode(initials());
        hashCode = 31 * hashCode + Objects.hashCode(telephone());
        hashCode = 31 * hashCode + Objects.hashCode(street());
        hashCode = 31 * hashCode + Objects.hashCode(jobTitle());
        hashCode = 31 * hashCode + Objects.hashCode(city());
        hashCode = 31 * hashCode + Objects.hashCode(company());
        hashCode = 31 * hashCode + Objects.hashCode(zipCode());
        hashCode = 31 * hashCode + Objects.hashCode(department());
        hashCode = 31 * hashCode + Objects.hashCode(country());
        hashCode = 31 * hashCode + Objects.hashCode(office());
        hashCode = 31 * hashCode + Objects.hashCode(identityProviderUserId());
        hashCode = 31 * hashCode + Objects.hashCode(identityProviderIdentityStoreId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeUserResponse)) {
            return false;
        }
        DescribeUserResponse other = (DescribeUserResponse) obj;
        return Objects.equals(userId(), other.userId()) && Objects.equals(name(), other.name())
                && Objects.equals(email(), other.email()) && Objects.equals(displayName(), other.displayName())
                && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(userRoleAsString(), other.userRoleAsString())
                && Objects.equals(enabledDate(), other.enabledDate()) && Objects.equals(disabledDate(), other.disabledDate())
                && Objects.equals(mailboxProvisionedDate(), other.mailboxProvisionedDate())
                && Objects.equals(mailboxDeprovisionedDate(), other.mailboxDeprovisionedDate())
                && Objects.equals(firstName(), other.firstName()) && Objects.equals(lastName(), other.lastName())
                && Objects.equals(hiddenFromGlobalAddressList(), other.hiddenFromGlobalAddressList())
                && Objects.equals(initials(), other.initials()) && Objects.equals(telephone(), other.telephone())
                && Objects.equals(street(), other.street()) && Objects.equals(jobTitle(), other.jobTitle())
                && Objects.equals(city(), other.city()) && Objects.equals(company(), other.company())
                && Objects.equals(zipCode(), other.zipCode()) && Objects.equals(department(), other.department())
                && Objects.equals(country(), other.country()) && Objects.equals(office(), other.office())
                && Objects.equals(identityProviderUserId(), other.identityProviderUserId())
                && Objects.equals(identityProviderIdentityStoreId(), other.identityProviderIdentityStoreId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeUserResponse").add("UserId", userId()).add("Name", name()).add("Email", email())
                .add("DisplayName", displayName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("State", stateAsString()).add("UserRole", userRoleAsString()).add("EnabledDate", enabledDate())
                .add("DisabledDate", disabledDate()).add("MailboxProvisionedDate", mailboxProvisionedDate())
                .add("MailboxDeprovisionedDate", mailboxDeprovisionedDate())
                .add("FirstName", firstName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("LastName", lastName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("HiddenFromGlobalAddressList", hiddenFromGlobalAddressList())
                .add("Initials", initials() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Telephone", telephone() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Street", street() == null ? null : "*** Sensitive Data Redacted ***")
                .add("JobTitle", jobTitle() == null ? null : "*** Sensitive Data Redacted ***")
                .add("City", city() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Company", company() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ZipCode", zipCode() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Department", department() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Country", country() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Office", office() == null ? null : "*** Sensitive Data Redacted ***")
                .add("IdentityProviderUserId", identityProviderUserId())
                .add("IdentityProviderIdentityStoreId", identityProviderIdentityStoreId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserId":
            return Optional.ofNullable(clazz.cast(userId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Email":
            return Optional.ofNullable(clazz.cast(email()));
        case "DisplayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "UserRole":
            return Optional.ofNullable(clazz.cast(userRoleAsString()));
        case "EnabledDate":
            return Optional.ofNullable(clazz.cast(enabledDate()));
        case "DisabledDate":
            return Optional.ofNullable(clazz.cast(disabledDate()));
        case "MailboxProvisionedDate":
            return Optional.ofNullable(clazz.cast(mailboxProvisionedDate()));
        case "MailboxDeprovisionedDate":
            return Optional.ofNullable(clazz.cast(mailboxDeprovisionedDate()));
        case "FirstName":
            return Optional.ofNullable(clazz.cast(firstName()));
        case "LastName":
            return Optional.ofNullable(clazz.cast(lastName()));
        case "HiddenFromGlobalAddressList":
            return Optional.ofNullable(clazz.cast(hiddenFromGlobalAddressList()));
        case "Initials":
            return Optional.ofNullable(clazz.cast(initials()));
        case "Telephone":
            return Optional.ofNullable(clazz.cast(telephone()));
        case "Street":
            return Optional.ofNullable(clazz.cast(street()));
        case "JobTitle":
            return Optional.ofNullable(clazz.cast(jobTitle()));
        case "City":
            return Optional.ofNullable(clazz.cast(city()));
        case "Company":
            return Optional.ofNullable(clazz.cast(company()));
        case "ZipCode":
            return Optional.ofNullable(clazz.cast(zipCode()));
        case "Department":
            return Optional.ofNullable(clazz.cast(department()));
        case "Country":
            return Optional.ofNullable(clazz.cast(country()));
        case "Office":
            return Optional.ofNullable(clazz.cast(office()));
        case "IdentityProviderUserId":
            return Optional.ofNullable(clazz.cast(identityProviderUserId()));
        case "IdentityProviderIdentityStoreId":
            return Optional.ofNullable(clazz.cast(identityProviderIdentityStoreId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("UserId", USER_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Email", EMAIL_FIELD);
        map.put("DisplayName", DISPLAY_NAME_FIELD);
        map.put("State", STATE_FIELD);
        map.put("UserRole", USER_ROLE_FIELD);
        map.put("EnabledDate", ENABLED_DATE_FIELD);
        map.put("DisabledDate", DISABLED_DATE_FIELD);
        map.put("MailboxProvisionedDate", MAILBOX_PROVISIONED_DATE_FIELD);
        map.put("MailboxDeprovisionedDate", MAILBOX_DEPROVISIONED_DATE_FIELD);
        map.put("FirstName", FIRST_NAME_FIELD);
        map.put("LastName", LAST_NAME_FIELD);
        map.put("HiddenFromGlobalAddressList", HIDDEN_FROM_GLOBAL_ADDRESS_LIST_FIELD);
        map.put("Initials", INITIALS_FIELD);
        map.put("Telephone", TELEPHONE_FIELD);
        map.put("Street", STREET_FIELD);
        map.put("JobTitle", JOB_TITLE_FIELD);
        map.put("City", CITY_FIELD);
        map.put("Company", COMPANY_FIELD);
        map.put("ZipCode", ZIP_CODE_FIELD);
        map.put("Department", DEPARTMENT_FIELD);
        map.put("Country", COUNTRY_FIELD);
        map.put("Office", OFFICE_FIELD);
        map.put("IdentityProviderUserId", IDENTITY_PROVIDER_USER_ID_FIELD);
        map.put("IdentityProviderIdentityStoreId", IDENTITY_PROVIDER_IDENTITY_STORE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeUserResponse, T> g) {
        return obj -> g.apply((DescribeUserResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends WorkMailResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeUserResponse> {
        /**
         * <p>
         * The identifier for the described user.
         * </p>
         * 
         * @param userId
         *        The identifier for the described user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);

        /**
         * <p>
         * The name for the user.
         * </p>
         * 
         * @param name
         *        The name for the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The email of the user.
         * </p>
         * 
         * @param email
         *        The email of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder email(String email);

        /**
         * <p>
         * The display name of the user.
         * </p>
         * 
         * @param displayName
         *        The display name of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The state of a user: enabled (registered to WorkMail) or disabled (deregistered or never registered to
         * WorkMail).
         * </p>
         * 
         * @param state
         *        The state of a user: enabled (registered to WorkMail) or disabled (deregistered or never registered to
         *        WorkMail).
         * @see EntityState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EntityState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of a user: enabled (registered to WorkMail) or disabled (deregistered or never registered to
         * WorkMail).
         * </p>
         * 
         * @param state
         *        The state of a user: enabled (registered to WorkMail) or disabled (deregistered or never registered to
         *        WorkMail).
         * @see EntityState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EntityState
         */
        Builder state(EntityState state);

        /**
         * <p>
         * In certain cases, other entities are modeled as users. If interoperability is enabled, resources are imported
         * into WorkMail as users. Because different WorkMail organizations rely on different directory types,
         * administrators can distinguish between an unregistered user (account is disabled and has a user role) and the
         * directory administrators. The values are USER, RESOURCE, SYSTEM_USER, and REMOTE_USER.
         * </p>
         * 
         * @param userRole
         *        In certain cases, other entities are modeled as users. If interoperability is enabled, resources are
         *        imported into WorkMail as users. Because different WorkMail organizations rely on different directory
         *        types, administrators can distinguish between an unregistered user (account is disabled and has a user
         *        role) and the directory administrators. The values are USER, RESOURCE, SYSTEM_USER, and REMOTE_USER.
         * @see UserRole
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserRole
         */
        Builder userRole(String userRole);

        /**
         * <p>
         * In certain cases, other entities are modeled as users. If interoperability is enabled, resources are imported
         * into WorkMail as users. Because different WorkMail organizations rely on different directory types,
         * administrators can distinguish between an unregistered user (account is disabled and has a user role) and the
         * directory administrators. The values are USER, RESOURCE, SYSTEM_USER, and REMOTE_USER.
         * </p>
         * 
         * @param userRole
         *        In certain cases, other entities are modeled as users. If interoperability is enabled, resources are
         *        imported into WorkMail as users. Because different WorkMail organizations rely on different directory
         *        types, administrators can distinguish between an unregistered user (account is disabled and has a user
         *        role) and the directory administrators. The values are USER, RESOURCE, SYSTEM_USER, and REMOTE_USER.
         * @see UserRole
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserRole
         */
        Builder userRole(UserRole userRole);

        /**
         * <p>
         * The date and time at which the user was enabled for WorkMailusage, in UNIX epoch time format.
         * </p>
         * 
         * @param enabledDate
         *        The date and time at which the user was enabled for WorkMailusage, in UNIX epoch time format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabledDate(Instant enabledDate);

        /**
         * <p>
         * The date and time at which the user was disabled for WorkMail usage, in UNIX epoch time format.
         * </p>
         * 
         * @param disabledDate
         *        The date and time at which the user was disabled for WorkMail usage, in UNIX epoch time format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disabledDate(Instant disabledDate);

        /**
         * <p>
         * The date when the mailbox was created for the user.
         * </p>
         * 
         * @param mailboxProvisionedDate
         *        The date when the mailbox was created for the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mailboxProvisionedDate(Instant mailboxProvisionedDate);

        /**
         * <p>
         * The date when the mailbox was removed for the user.
         * </p>
         * 
         * @param mailboxDeprovisionedDate
         *        The date when the mailbox was removed for the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mailboxDeprovisionedDate(Instant mailboxDeprovisionedDate);

        /**
         * <p>
         * First name of the user.
         * </p>
         * 
         * @param firstName
         *        First name of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firstName(String firstName);

        /**
         * <p>
         * Last name of the user.
         * </p>
         * 
         * @param lastName
         *        Last name of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastName(String lastName);

        /**
         * <p>
         * If enabled, the user is hidden from the global address list.
         * </p>
         * 
         * @param hiddenFromGlobalAddressList
         *        If enabled, the user is hidden from the global address list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hiddenFromGlobalAddressList(Boolean hiddenFromGlobalAddressList);

        /**
         * <p>
         * Initials of the user.
         * </p>
         * 
         * @param initials
         *        Initials of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initials(String initials);

        /**
         * <p>
         * User's contact number.
         * </p>
         * 
         * @param telephone
         *        User's contact number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder telephone(String telephone);

        /**
         * <p>
         * Street where the user is located.
         * </p>
         * 
         * @param street
         *        Street where the user is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder street(String street);

        /**
         * <p>
         * Job title of the user.
         * </p>
         * 
         * @param jobTitle
         *        Job title of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobTitle(String jobTitle);

        /**
         * <p>
         * City where the user is located.
         * </p>
         * 
         * @param city
         *        City where the user is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder city(String city);

        /**
         * <p>
         * Company of the user.
         * </p>
         * 
         * @param company
         *        Company of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder company(String company);

        /**
         * <p>
         * Zip code of the user.
         * </p>
         * 
         * @param zipCode
         *        Zip code of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder zipCode(String zipCode);

        /**
         * <p>
         * Department of the user.
         * </p>
         * 
         * @param department
         *        Department of the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder department(String department);

        /**
         * <p>
         * Country where the user is located.
         * </p>
         * 
         * @param country
         *        Country where the user is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder country(String country);

        /**
         * <p>
         * Office where the user is located.
         * </p>
         * 
         * @param office
         *        Office where the user is located.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder office(String office);

        /**
         * <p>
         * User ID from the IAM Identity Center. If this parameter is empty it will be updated automatically when the
         * user logs in for the first time to the mailbox associated with WorkMail.
         * </p>
         * 
         * @param identityProviderUserId
         *        User ID from the IAM Identity Center. If this parameter is empty it will be updated automatically when
         *        the user logs in for the first time to the mailbox associated with WorkMail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityProviderUserId(String identityProviderUserId);

        /**
         * <p>
         * Identity Store ID from the IAM Identity Center. If this parameter is empty it will be updated automatically
         * when the user logs in for the first time to the mailbox associated with WorkMail.
         * </p>
         * 
         * @param identityProviderIdentityStoreId
         *        Identity Store ID from the IAM Identity Center. If this parameter is empty it will be updated
         *        automatically when the user logs in for the first time to the mailbox associated with WorkMail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityProviderIdentityStoreId(String identityProviderIdentityStoreId);
    }

    static final class BuilderImpl extends WorkMailResponse.BuilderImpl implements Builder {
        private String userId;

        private String name;

        private String email;

        private String displayName;

        private String state;

        private String userRole;

        private Instant enabledDate;

        private Instant disabledDate;

        private Instant mailboxProvisionedDate;

        private Instant mailboxDeprovisionedDate;

        private String firstName;

        private String lastName;

        private Boolean hiddenFromGlobalAddressList;

        private String initials;

        private String telephone;

        private String street;

        private String jobTitle;

        private String city;

        private String company;

        private String zipCode;

        private String department;

        private String country;

        private String office;

        private String identityProviderUserId;

        private String identityProviderIdentityStoreId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeUserResponse model) {
            super(model);
            userId(model.userId);
            name(model.name);
            email(model.email);
            displayName(model.displayName);
            state(model.state);
            userRole(model.userRole);
            enabledDate(model.enabledDate);
            disabledDate(model.disabledDate);
            mailboxProvisionedDate(model.mailboxProvisionedDate);
            mailboxDeprovisionedDate(model.mailboxDeprovisionedDate);
            firstName(model.firstName);
            lastName(model.lastName);
            hiddenFromGlobalAddressList(model.hiddenFromGlobalAddressList);
            initials(model.initials);
            telephone(model.telephone);
            street(model.street);
            jobTitle(model.jobTitle);
            city(model.city);
            company(model.company);
            zipCode(model.zipCode);
            department(model.department);
            country(model.country);
            office(model.office);
            identityProviderUserId(model.identityProviderUserId);
            identityProviderIdentityStoreId(model.identityProviderIdentityStoreId);
        }

        public final String getUserId() {
            return userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getEmail() {
            return email;
        }

        public final void setEmail(String email) {
            this.email = email;
        }

        @Override
        public final Builder email(String email) {
            this.email = email;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(EntityState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getUserRole() {
            return userRole;
        }

        public final void setUserRole(String userRole) {
            this.userRole = userRole;
        }

        @Override
        public final Builder userRole(String userRole) {
            this.userRole = userRole;
            return this;
        }

        @Override
        public final Builder userRole(UserRole userRole) {
            this.userRole(userRole == null ? null : userRole.toString());
            return this;
        }

        public final Instant getEnabledDate() {
            return enabledDate;
        }

        public final void setEnabledDate(Instant enabledDate) {
            this.enabledDate = enabledDate;
        }

        @Override
        public final Builder enabledDate(Instant enabledDate) {
            this.enabledDate = enabledDate;
            return this;
        }

        public final Instant getDisabledDate() {
            return disabledDate;
        }

        public final void setDisabledDate(Instant disabledDate) {
            this.disabledDate = disabledDate;
        }

        @Override
        public final Builder disabledDate(Instant disabledDate) {
            this.disabledDate = disabledDate;
            return this;
        }

        public final Instant getMailboxProvisionedDate() {
            return mailboxProvisionedDate;
        }

        public final void setMailboxProvisionedDate(Instant mailboxProvisionedDate) {
            this.mailboxProvisionedDate = mailboxProvisionedDate;
        }

        @Override
        public final Builder mailboxProvisionedDate(Instant mailboxProvisionedDate) {
            this.mailboxProvisionedDate = mailboxProvisionedDate;
            return this;
        }

        public final Instant getMailboxDeprovisionedDate() {
            return mailboxDeprovisionedDate;
        }

        public final void setMailboxDeprovisionedDate(Instant mailboxDeprovisionedDate) {
            this.mailboxDeprovisionedDate = mailboxDeprovisionedDate;
        }

        @Override
        public final Builder mailboxDeprovisionedDate(Instant mailboxDeprovisionedDate) {
            this.mailboxDeprovisionedDate = mailboxDeprovisionedDate;
            return this;
        }

        public final String getFirstName() {
            return firstName;
        }

        public final void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        @Override
        public final Builder firstName(String firstName) {
            this.firstName = firstName;
            return this;
        }

        public final String getLastName() {
            return lastName;
        }

        public final void setLastName(String lastName) {
            this.lastName = lastName;
        }

        @Override
        public final Builder lastName(String lastName) {
            this.lastName = lastName;
            return this;
        }

        public final Boolean getHiddenFromGlobalAddressList() {
            return hiddenFromGlobalAddressList;
        }

        public final void setHiddenFromGlobalAddressList(Boolean hiddenFromGlobalAddressList) {
            this.hiddenFromGlobalAddressList = hiddenFromGlobalAddressList;
        }

        @Override
        public final Builder hiddenFromGlobalAddressList(Boolean hiddenFromGlobalAddressList) {
            this.hiddenFromGlobalAddressList = hiddenFromGlobalAddressList;
            return this;
        }

        public final String getInitials() {
            return initials;
        }

        public final void setInitials(String initials) {
            this.initials = initials;
        }

        @Override
        public final Builder initials(String initials) {
            this.initials = initials;
            return this;
        }

        public final String getTelephone() {
            return telephone;
        }

        public final void setTelephone(String telephone) {
            this.telephone = telephone;
        }

        @Override
        public final Builder telephone(String telephone) {
            this.telephone = telephone;
            return this;
        }

        public final String getStreet() {
            return street;
        }

        public final void setStreet(String street) {
            this.street = street;
        }

        @Override
        public final Builder street(String street) {
            this.street = street;
            return this;
        }

        public final String getJobTitle() {
            return jobTitle;
        }

        public final void setJobTitle(String jobTitle) {
            this.jobTitle = jobTitle;
        }

        @Override
        public final Builder jobTitle(String jobTitle) {
            this.jobTitle = jobTitle;
            return this;
        }

        public final String getCity() {
            return city;
        }

        public final void setCity(String city) {
            this.city = city;
        }

        @Override
        public final Builder city(String city) {
            this.city = city;
            return this;
        }

        public final String getCompany() {
            return company;
        }

        public final void setCompany(String company) {
            this.company = company;
        }

        @Override
        public final Builder company(String company) {
            this.company = company;
            return this;
        }

        public final String getZipCode() {
            return zipCode;
        }

        public final void setZipCode(String zipCode) {
            this.zipCode = zipCode;
        }

        @Override
        public final Builder zipCode(String zipCode) {
            this.zipCode = zipCode;
            return this;
        }

        public final String getDepartment() {
            return department;
        }

        public final void setDepartment(String department) {
            this.department = department;
        }

        @Override
        public final Builder department(String department) {
            this.department = department;
            return this;
        }

        public final String getCountry() {
            return country;
        }

        public final void setCountry(String country) {
            this.country = country;
        }

        @Override
        public final Builder country(String country) {
            this.country = country;
            return this;
        }

        public final String getOffice() {
            return office;
        }

        public final void setOffice(String office) {
            this.office = office;
        }

        @Override
        public final Builder office(String office) {
            this.office = office;
            return this;
        }

        public final String getIdentityProviderUserId() {
            return identityProviderUserId;
        }

        public final void setIdentityProviderUserId(String identityProviderUserId) {
            this.identityProviderUserId = identityProviderUserId;
        }

        @Override
        public final Builder identityProviderUserId(String identityProviderUserId) {
            this.identityProviderUserId = identityProviderUserId;
            return this;
        }

        public final String getIdentityProviderIdentityStoreId() {
            return identityProviderIdentityStoreId;
        }

        public final void setIdentityProviderIdentityStoreId(String identityProviderIdentityStoreId) {
            this.identityProviderIdentityStoreId = identityProviderIdentityStoreId;
        }

        @Override
        public final Builder identityProviderIdentityStoreId(String identityProviderIdentityStoreId) {
            this.identityProviderIdentityStoreId = identityProviderIdentityStoreId;
            return this;
        }

        @Override
        public DescribeUserResponse build() {
            return new DescribeUserResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
