/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workmail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Filtering options for <i>ListGroups</i> operation. This is only used as input to Operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListGroupsFilters implements SdkPojo, Serializable,
        ToCopyableBuilder<ListGroupsFilters.Builder, ListGroupsFilters> {
    private static final SdkField<String> NAME_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NamePrefix").getter(getter(ListGroupsFilters::namePrefix)).setter(setter(Builder::namePrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NamePrefix").build()).build();

    private static final SdkField<String> PRIMARY_EMAIL_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PrimaryEmailPrefix").getter(getter(ListGroupsFilters::primaryEmailPrefix))
            .setter(setter(Builder::primaryEmailPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryEmailPrefix").build())
            .build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(ListGroupsFilters::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_PREFIX_FIELD,
            PRIMARY_EMAIL_PREFIX_FIELD, STATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String namePrefix;

    private final String primaryEmailPrefix;

    private final String state;

    private ListGroupsFilters(BuilderImpl builder) {
        this.namePrefix = builder.namePrefix;
        this.primaryEmailPrefix = builder.primaryEmailPrefix;
        this.state = builder.state;
    }

    /**
     * <p>
     * Filters only groups with the provided name prefix.
     * </p>
     * 
     * @return Filters only groups with the provided name prefix.
     */
    public final String namePrefix() {
        return namePrefix;
    }

    /**
     * <p>
     * Filters only groups with the provided primary email prefix.
     * </p>
     * 
     * @return Filters only groups with the provided primary email prefix.
     */
    public final String primaryEmailPrefix() {
        return primaryEmailPrefix;
    }

    /**
     * <p>
     * Filters only groups with the provided state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link EntityState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return Filters only groups with the provided state.
     * @see EntityState
     */
    public final EntityState state() {
        return EntityState.fromValue(state);
    }

    /**
     * <p>
     * Filters only groups with the provided state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link EntityState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return Filters only groups with the provided state.
     * @see EntityState
     */
    public final String stateAsString() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(namePrefix());
        hashCode = 31 * hashCode + Objects.hashCode(primaryEmailPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGroupsFilters)) {
            return false;
        }
        ListGroupsFilters other = (ListGroupsFilters) obj;
        return Objects.equals(namePrefix(), other.namePrefix())
                && Objects.equals(primaryEmailPrefix(), other.primaryEmailPrefix())
                && Objects.equals(stateAsString(), other.stateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListGroupsFilters").add("NamePrefix", namePrefix())
                .add("PrimaryEmailPrefix", primaryEmailPrefix()).add("State", stateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NamePrefix":
            return Optional.ofNullable(clazz.cast(namePrefix()));
        case "PrimaryEmailPrefix":
            return Optional.ofNullable(clazz.cast(primaryEmailPrefix()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NamePrefix", NAME_PREFIX_FIELD);
        map.put("PrimaryEmailPrefix", PRIMARY_EMAIL_PREFIX_FIELD);
        map.put("State", STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListGroupsFilters, T> g) {
        return obj -> g.apply((ListGroupsFilters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ListGroupsFilters> {
        /**
         * <p>
         * Filters only groups with the provided name prefix.
         * </p>
         * 
         * @param namePrefix
         *        Filters only groups with the provided name prefix.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namePrefix(String namePrefix);

        /**
         * <p>
         * Filters only groups with the provided primary email prefix.
         * </p>
         * 
         * @param primaryEmailPrefix
         *        Filters only groups with the provided primary email prefix.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryEmailPrefix(String primaryEmailPrefix);

        /**
         * <p>
         * Filters only groups with the provided state.
         * </p>
         * 
         * @param state
         *        Filters only groups with the provided state.
         * @see EntityState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EntityState
         */
        Builder state(String state);

        /**
         * <p>
         * Filters only groups with the provided state.
         * </p>
         * 
         * @param state
         *        Filters only groups with the provided state.
         * @see EntityState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EntityState
         */
        Builder state(EntityState state);
    }

    static final class BuilderImpl implements Builder {
        private String namePrefix;

        private String primaryEmailPrefix;

        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(ListGroupsFilters model) {
            namePrefix(model.namePrefix);
            primaryEmailPrefix(model.primaryEmailPrefix);
            state(model.state);
        }

        public final String getNamePrefix() {
            return namePrefix;
        }

        public final void setNamePrefix(String namePrefix) {
            this.namePrefix = namePrefix;
        }

        @Override
        public final Builder namePrefix(String namePrefix) {
            this.namePrefix = namePrefix;
            return this;
        }

        public final String getPrimaryEmailPrefix() {
            return primaryEmailPrefix;
        }

        public final void setPrimaryEmailPrefix(String primaryEmailPrefix) {
            this.primaryEmailPrefix = primaryEmailPrefix;
        }

        @Override
        public final Builder primaryEmailPrefix(String primaryEmailPrefix) {
            this.primaryEmailPrefix = primaryEmailPrefix;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(EntityState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        @Override
        public ListGroupsFilters build() {
            return new ListGroupsFilters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
