/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workmail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutMailboxPermissionsRequest extends WorkMailRequest implements
        ToCopyableBuilder<PutMailboxPermissionsRequest.Builder, PutMailboxPermissionsRequest> {
    private static final SdkField<String> ORGANIZATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OrganizationId").getter(getter(PutMailboxPermissionsRequest::organizationId))
            .setter(setter(Builder::organizationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationId").build()).build();

    private static final SdkField<String> ENTITY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EntityId").getter(getter(PutMailboxPermissionsRequest::entityId)).setter(setter(Builder::entityId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntityId").build()).build();

    private static final SdkField<String> GRANTEE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GranteeId").getter(getter(PutMailboxPermissionsRequest::granteeId)).setter(setter(Builder::granteeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GranteeId").build()).build();

    private static final SdkField<List<String>> PERMISSION_VALUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("PermissionValues")
            .getter(getter(PutMailboxPermissionsRequest::permissionValuesAsStrings))
            .setter(setter(Builder::permissionValuesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PermissionValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORGANIZATION_ID_FIELD,
            ENTITY_ID_FIELD, GRANTEE_ID_FIELD, PERMISSION_VALUES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String organizationId;

    private final String entityId;

    private final String granteeId;

    private final List<String> permissionValues;

    private PutMailboxPermissionsRequest(BuilderImpl builder) {
        super(builder);
        this.organizationId = builder.organizationId;
        this.entityId = builder.entityId;
        this.granteeId = builder.granteeId;
        this.permissionValues = builder.permissionValues;
    }

    /**
     * <p>
     * The identifier of the organization under which the user, group, or resource exists.
     * </p>
     * 
     * @return The identifier of the organization under which the user, group, or resource exists.
     */
    public final String organizationId() {
        return organizationId;
    }

    /**
     * <p>
     * The identifier of the user or resource for which to update mailbox permissions.
     * </p>
     * <p>
     * The identifier can be <i>UserId, ResourceID, or Group Id</i>, <i>Username, Resourcename, or Groupname</i>, or
     * <i>email</i>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Entity ID: 12345678-1234-1234-1234-123456789012, r-0123456789a0123456789b0123456789, or
     * S-1-1-12-1234567890-123456789-123456789-1234
     * </p>
     * </li>
     * <li>
     * <p>
     * Email address: entity@domain.tld
     * </p>
     * </li>
     * <li>
     * <p>
     * Entity name: entity
     * </p>
     * </li>
     * </ul>
     * 
     * @return The identifier of the user or resource for which to update mailbox permissions.</p>
     *         <p>
     *         The identifier can be <i>UserId, ResourceID, or Group Id</i>, <i>Username, Resourcename, or
     *         Groupname</i>, or <i>email</i>.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Entity ID: 12345678-1234-1234-1234-123456789012, r-0123456789a0123456789b0123456789, or
     *         S-1-1-12-1234567890-123456789-123456789-1234
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Email address: entity@domain.tld
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Entity name: entity
     *         </p>
     *         </li>
     */
    public final String entityId() {
        return entityId;
    }

    /**
     * <p>
     * The identifier of the user, group, or resource to which to grant the permissions.
     * </p>
     * <p>
     * The identifier can be <i>UserId, ResourceID, or Group Id</i>, <i>Username, Resourcename, or Groupname</i>, or
     * <i>email</i>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Grantee ID: 12345678-1234-1234-1234-123456789012, r-0123456789a0123456789b0123456789, or
     * S-1-1-12-1234567890-123456789-123456789-1234
     * </p>
     * </li>
     * <li>
     * <p>
     * Email address: grantee@domain.tld
     * </p>
     * </li>
     * <li>
     * <p>
     * Grantee name: grantee
     * </p>
     * </li>
     * </ul>
     * 
     * @return The identifier of the user, group, or resource to which to grant the permissions.</p>
     *         <p>
     *         The identifier can be <i>UserId, ResourceID, or Group Id</i>, <i>Username, Resourcename, or
     *         Groupname</i>, or <i>email</i>.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Grantee ID: 12345678-1234-1234-1234-123456789012, r-0123456789a0123456789b0123456789, or
     *         S-1-1-12-1234567890-123456789-123456789-1234
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Email address: grantee@domain.tld
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Grantee name: grantee
     *         </p>
     *         </li>
     */
    public final String granteeId() {
        return granteeId;
    }

    /**
     * <p>
     * The permissions granted to the grantee. SEND_AS allows the grantee to send email as the owner of the mailbox (the
     * grantee is not mentioned on these emails). SEND_ON_BEHALF allows the grantee to send email on behalf of the owner
     * of the mailbox (the grantee is not mentioned as the physical sender of these emails). FULL_ACCESS allows the
     * grantee full access to the mailbox, irrespective of other folder-level permissions set on the mailbox.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPermissionValues} method.
     * </p>
     * 
     * @return The permissions granted to the grantee. SEND_AS allows the grantee to send email as the owner of the
     *         mailbox (the grantee is not mentioned on these emails). SEND_ON_BEHALF allows the grantee to send email
     *         on behalf of the owner of the mailbox (the grantee is not mentioned as the physical sender of these
     *         emails). FULL_ACCESS allows the grantee full access to the mailbox, irrespective of other folder-level
     *         permissions set on the mailbox.
     */
    public final List<PermissionType> permissionValues() {
        return PermissionValuesCopier.copyStringToEnum(permissionValues);
    }

    /**
     * For responses, this returns true if the service returned a value for the PermissionValues property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPermissionValues() {
        return permissionValues != null && !(permissionValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The permissions granted to the grantee. SEND_AS allows the grantee to send email as the owner of the mailbox (the
     * grantee is not mentioned on these emails). SEND_ON_BEHALF allows the grantee to send email on behalf of the owner
     * of the mailbox (the grantee is not mentioned as the physical sender of these emails). FULL_ACCESS allows the
     * grantee full access to the mailbox, irrespective of other folder-level permissions set on the mailbox.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPermissionValues} method.
     * </p>
     * 
     * @return The permissions granted to the grantee. SEND_AS allows the grantee to send email as the owner of the
     *         mailbox (the grantee is not mentioned on these emails). SEND_ON_BEHALF allows the grantee to send email
     *         on behalf of the owner of the mailbox (the grantee is not mentioned as the physical sender of these
     *         emails). FULL_ACCESS allows the grantee full access to the mailbox, irrespective of other folder-level
     *         permissions set on the mailbox.
     */
    public final List<String> permissionValuesAsStrings() {
        return permissionValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(organizationId());
        hashCode = 31 * hashCode + Objects.hashCode(entityId());
        hashCode = 31 * hashCode + Objects.hashCode(granteeId());
        hashCode = 31 * hashCode + Objects.hashCode(hasPermissionValues() ? permissionValuesAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutMailboxPermissionsRequest)) {
            return false;
        }
        PutMailboxPermissionsRequest other = (PutMailboxPermissionsRequest) obj;
        return Objects.equals(organizationId(), other.organizationId()) && Objects.equals(entityId(), other.entityId())
                && Objects.equals(granteeId(), other.granteeId()) && hasPermissionValues() == other.hasPermissionValues()
                && Objects.equals(permissionValuesAsStrings(), other.permissionValuesAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutMailboxPermissionsRequest").add("OrganizationId", organizationId())
                .add("EntityId", entityId()).add("GranteeId", granteeId())
                .add("PermissionValues", hasPermissionValues() ? permissionValuesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OrganizationId":
            return Optional.ofNullable(clazz.cast(organizationId()));
        case "EntityId":
            return Optional.ofNullable(clazz.cast(entityId()));
        case "GranteeId":
            return Optional.ofNullable(clazz.cast(granteeId()));
        case "PermissionValues":
            return Optional.ofNullable(clazz.cast(permissionValuesAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("OrganizationId", ORGANIZATION_ID_FIELD);
        map.put("EntityId", ENTITY_ID_FIELD);
        map.put("GranteeId", GRANTEE_ID_FIELD);
        map.put("PermissionValues", PERMISSION_VALUES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutMailboxPermissionsRequest, T> g) {
        return obj -> g.apply((PutMailboxPermissionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends WorkMailRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutMailboxPermissionsRequest> {
        /**
         * <p>
         * The identifier of the organization under which the user, group, or resource exists.
         * </p>
         * 
         * @param organizationId
         *        The identifier of the organization under which the user, group, or resource exists.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationId(String organizationId);

        /**
         * <p>
         * The identifier of the user or resource for which to update mailbox permissions.
         * </p>
         * <p>
         * The identifier can be <i>UserId, ResourceID, or Group Id</i>, <i>Username, Resourcename, or Groupname</i>, or
         * <i>email</i>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Entity ID: 12345678-1234-1234-1234-123456789012, r-0123456789a0123456789b0123456789, or
         * S-1-1-12-1234567890-123456789-123456789-1234
         * </p>
         * </li>
         * <li>
         * <p>
         * Email address: entity@domain.tld
         * </p>
         * </li>
         * <li>
         * <p>
         * Entity name: entity
         * </p>
         * </li>
         * </ul>
         * 
         * @param entityId
         *        The identifier of the user or resource for which to update mailbox permissions.</p>
         *        <p>
         *        The identifier can be <i>UserId, ResourceID, or Group Id</i>, <i>Username, Resourcename, or
         *        Groupname</i>, or <i>email</i>.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Entity ID: 12345678-1234-1234-1234-123456789012, r-0123456789a0123456789b0123456789, or
         *        S-1-1-12-1234567890-123456789-123456789-1234
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Email address: entity@domain.tld
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Entity name: entity
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityId(String entityId);

        /**
         * <p>
         * The identifier of the user, group, or resource to which to grant the permissions.
         * </p>
         * <p>
         * The identifier can be <i>UserId, ResourceID, or Group Id</i>, <i>Username, Resourcename, or Groupname</i>, or
         * <i>email</i>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Grantee ID: 12345678-1234-1234-1234-123456789012, r-0123456789a0123456789b0123456789, or
         * S-1-1-12-1234567890-123456789-123456789-1234
         * </p>
         * </li>
         * <li>
         * <p>
         * Email address: grantee@domain.tld
         * </p>
         * </li>
         * <li>
         * <p>
         * Grantee name: grantee
         * </p>
         * </li>
         * </ul>
         * 
         * @param granteeId
         *        The identifier of the user, group, or resource to which to grant the permissions.</p>
         *        <p>
         *        The identifier can be <i>UserId, ResourceID, or Group Id</i>, <i>Username, Resourcename, or
         *        Groupname</i>, or <i>email</i>.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Grantee ID: 12345678-1234-1234-1234-123456789012, r-0123456789a0123456789b0123456789, or
         *        S-1-1-12-1234567890-123456789-123456789-1234
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Email address: grantee@domain.tld
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Grantee name: grantee
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder granteeId(String granteeId);

        /**
         * <p>
         * The permissions granted to the grantee. SEND_AS allows the grantee to send email as the owner of the mailbox
         * (the grantee is not mentioned on these emails). SEND_ON_BEHALF allows the grantee to send email on behalf of
         * the owner of the mailbox (the grantee is not mentioned as the physical sender of these emails). FULL_ACCESS
         * allows the grantee full access to the mailbox, irrespective of other folder-level permissions set on the
         * mailbox.
         * </p>
         * 
         * @param permissionValues
         *        The permissions granted to the grantee. SEND_AS allows the grantee to send email as the owner of the
         *        mailbox (the grantee is not mentioned on these emails). SEND_ON_BEHALF allows the grantee to send
         *        email on behalf of the owner of the mailbox (the grantee is not mentioned as the physical sender of
         *        these emails). FULL_ACCESS allows the grantee full access to the mailbox, irrespective of other
         *        folder-level permissions set on the mailbox.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionValuesWithStrings(Collection<String> permissionValues);

        /**
         * <p>
         * The permissions granted to the grantee. SEND_AS allows the grantee to send email as the owner of the mailbox
         * (the grantee is not mentioned on these emails). SEND_ON_BEHALF allows the grantee to send email on behalf of
         * the owner of the mailbox (the grantee is not mentioned as the physical sender of these emails). FULL_ACCESS
         * allows the grantee full access to the mailbox, irrespective of other folder-level permissions set on the
         * mailbox.
         * </p>
         * 
         * @param permissionValues
         *        The permissions granted to the grantee. SEND_AS allows the grantee to send email as the owner of the
         *        mailbox (the grantee is not mentioned on these emails). SEND_ON_BEHALF allows the grantee to send
         *        email on behalf of the owner of the mailbox (the grantee is not mentioned as the physical sender of
         *        these emails). FULL_ACCESS allows the grantee full access to the mailbox, irrespective of other
         *        folder-level permissions set on the mailbox.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionValuesWithStrings(String... permissionValues);

        /**
         * <p>
         * The permissions granted to the grantee. SEND_AS allows the grantee to send email as the owner of the mailbox
         * (the grantee is not mentioned on these emails). SEND_ON_BEHALF allows the grantee to send email on behalf of
         * the owner of the mailbox (the grantee is not mentioned as the physical sender of these emails). FULL_ACCESS
         * allows the grantee full access to the mailbox, irrespective of other folder-level permissions set on the
         * mailbox.
         * </p>
         * 
         * @param permissionValues
         *        The permissions granted to the grantee. SEND_AS allows the grantee to send email as the owner of the
         *        mailbox (the grantee is not mentioned on these emails). SEND_ON_BEHALF allows the grantee to send
         *        email on behalf of the owner of the mailbox (the grantee is not mentioned as the physical sender of
         *        these emails). FULL_ACCESS allows the grantee full access to the mailbox, irrespective of other
         *        folder-level permissions set on the mailbox.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionValues(Collection<PermissionType> permissionValues);

        /**
         * <p>
         * The permissions granted to the grantee. SEND_AS allows the grantee to send email as the owner of the mailbox
         * (the grantee is not mentioned on these emails). SEND_ON_BEHALF allows the grantee to send email on behalf of
         * the owner of the mailbox (the grantee is not mentioned as the physical sender of these emails). FULL_ACCESS
         * allows the grantee full access to the mailbox, irrespective of other folder-level permissions set on the
         * mailbox.
         * </p>
         * 
         * @param permissionValues
         *        The permissions granted to the grantee. SEND_AS allows the grantee to send email as the owner of the
         *        mailbox (the grantee is not mentioned on these emails). SEND_ON_BEHALF allows the grantee to send
         *        email on behalf of the owner of the mailbox (the grantee is not mentioned as the physical sender of
         *        these emails). FULL_ACCESS allows the grantee full access to the mailbox, irrespective of other
         *        folder-level permissions set on the mailbox.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionValues(PermissionType... permissionValues);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkMailRequest.BuilderImpl implements Builder {
        private String organizationId;

        private String entityId;

        private String granteeId;

        private List<String> permissionValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutMailboxPermissionsRequest model) {
            super(model);
            organizationId(model.organizationId);
            entityId(model.entityId);
            granteeId(model.granteeId);
            permissionValuesWithStrings(model.permissionValues);
        }

        public final String getOrganizationId() {
            return organizationId;
        }

        public final void setOrganizationId(String organizationId) {
            this.organizationId = organizationId;
        }

        @Override
        public final Builder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public final String getEntityId() {
            return entityId;
        }

        public final void setEntityId(String entityId) {
            this.entityId = entityId;
        }

        @Override
        public final Builder entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        public final String getGranteeId() {
            return granteeId;
        }

        public final void setGranteeId(String granteeId) {
            this.granteeId = granteeId;
        }

        @Override
        public final Builder granteeId(String granteeId) {
            this.granteeId = granteeId;
            return this;
        }

        public final Collection<String> getPermissionValues() {
            if (permissionValues instanceof SdkAutoConstructList) {
                return null;
            }
            return permissionValues;
        }

        public final void setPermissionValues(Collection<String> permissionValues) {
            this.permissionValues = PermissionValuesCopier.copy(permissionValues);
        }

        @Override
        public final Builder permissionValuesWithStrings(Collection<String> permissionValues) {
            this.permissionValues = PermissionValuesCopier.copy(permissionValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissionValuesWithStrings(String... permissionValues) {
            permissionValuesWithStrings(Arrays.asList(permissionValues));
            return this;
        }

        @Override
        public final Builder permissionValues(Collection<PermissionType> permissionValues) {
            this.permissionValues = PermissionValuesCopier.copyEnumToString(permissionValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissionValues(PermissionType... permissionValues) {
            permissionValues(Arrays.asList(permissionValues));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutMailboxPermissionsRequest build() {
            return new PutMailboxPermissionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
