/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workmail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class TestAvailabilityConfigurationResponse extends WorkMailResponse implements
        ToCopyableBuilder<TestAvailabilityConfigurationResponse.Builder, TestAvailabilityConfigurationResponse> {
    private static final SdkField<Boolean> TEST_PASSED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("TestPassed").getter(getter(TestAvailabilityConfigurationResponse::testPassed))
            .setter(setter(Builder::testPassed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TestPassed").build()).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureReason").getter(getter(TestAvailabilityConfigurationResponse::failureReason))
            .setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEST_PASSED_FIELD,
            FAILURE_REASON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Boolean testPassed;

    private final String failureReason;

    private TestAvailabilityConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.testPassed = builder.testPassed;
        this.failureReason = builder.failureReason;
    }

    /**
     * <p>
     * Boolean indicating whether the test passed or failed.
     * </p>
     * 
     * @return Boolean indicating whether the test passed or failed.
     */
    public final Boolean testPassed() {
        return testPassed;
    }

    /**
     * <p>
     * String containing the reason for a failed test if <code>TestPassed</code> is false.
     * </p>
     * 
     * @return String containing the reason for a failed test if <code>TestPassed</code> is false.
     */
    public final String failureReason() {
        return failureReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(testPassed());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestAvailabilityConfigurationResponse)) {
            return false;
        }
        TestAvailabilityConfigurationResponse other = (TestAvailabilityConfigurationResponse) obj;
        return Objects.equals(testPassed(), other.testPassed()) && Objects.equals(failureReason(), other.failureReason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TestAvailabilityConfigurationResponse").add("TestPassed", testPassed())
                .add("FailureReason", failureReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TestPassed":
            return Optional.ofNullable(clazz.cast(testPassed()));
        case "FailureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TestPassed", TEST_PASSED_FIELD);
        map.put("FailureReason", FAILURE_REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TestAvailabilityConfigurationResponse, T> g) {
        return obj -> g.apply((TestAvailabilityConfigurationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends WorkMailResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, TestAvailabilityConfigurationResponse> {
        /**
         * <p>
         * Boolean indicating whether the test passed or failed.
         * </p>
         * 
         * @param testPassed
         *        Boolean indicating whether the test passed or failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testPassed(Boolean testPassed);

        /**
         * <p>
         * String containing the reason for a failed test if <code>TestPassed</code> is false.
         * </p>
         * 
         * @param failureReason
         *        String containing the reason for a failed test if <code>TestPassed</code> is false.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);
    }

    static final class BuilderImpl extends WorkMailResponse.BuilderImpl implements Builder {
        private Boolean testPassed;

        private String failureReason;

        private BuilderImpl() {
        }

        private BuilderImpl(TestAvailabilityConfigurationResponse model) {
            super(model);
            testPassed(model.testPassed);
            failureReason(model.failureReason);
        }

        public final Boolean getTestPassed() {
            return testPassed;
        }

        public final void setTestPassed(Boolean testPassed) {
            this.testPassed = testPassed;
        }

        @Override
        public final Builder testPassed(Boolean testPassed) {
            this.testPassed = testPassed;
            return this;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        @Override
        public TestAvailabilityConfigurationResponse build() {
            return new TestAvailabilityConfigurationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
