/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workmail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateResourceRequest extends WorkMailRequest implements
        ToCopyableBuilder<UpdateResourceRequest.Builder, UpdateResourceRequest> {
    private static final SdkField<String> ORGANIZATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OrganizationId").getter(getter(UpdateResourceRequest::organizationId))
            .setter(setter(Builder::organizationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationId").build()).build();

    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceId").getter(getter(UpdateResourceRequest::resourceId)).setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateResourceRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<BookingOptions> BOOKING_OPTIONS_FIELD = SdkField
            .<BookingOptions> builder(MarshallingType.SDK_POJO).memberName("BookingOptions")
            .getter(getter(UpdateResourceRequest::bookingOptions)).setter(setter(Builder::bookingOptions))
            .constructor(BookingOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BookingOptions").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateResourceRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(UpdateResourceRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<Boolean> HIDDEN_FROM_GLOBAL_ADDRESS_LIST_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("HiddenFromGlobalAddressList")
            .getter(getter(UpdateResourceRequest::hiddenFromGlobalAddressList))
            .setter(setter(Builder::hiddenFromGlobalAddressList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HiddenFromGlobalAddressList")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORGANIZATION_ID_FIELD,
            RESOURCE_ID_FIELD, NAME_FIELD, BOOKING_OPTIONS_FIELD, DESCRIPTION_FIELD, TYPE_FIELD,
            HIDDEN_FROM_GLOBAL_ADDRESS_LIST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String organizationId;

    private final String resourceId;

    private final String name;

    private final BookingOptions bookingOptions;

    private final String description;

    private final String type;

    private final Boolean hiddenFromGlobalAddressList;

    private UpdateResourceRequest(BuilderImpl builder) {
        super(builder);
        this.organizationId = builder.organizationId;
        this.resourceId = builder.resourceId;
        this.name = builder.name;
        this.bookingOptions = builder.bookingOptions;
        this.description = builder.description;
        this.type = builder.type;
        this.hiddenFromGlobalAddressList = builder.hiddenFromGlobalAddressList;
    }

    /**
     * <p>
     * The identifier associated with the organization for which the resource is updated.
     * </p>
     * 
     * @return The identifier associated with the organization for which the resource is updated.
     */
    public final String organizationId() {
        return organizationId;
    }

    /**
     * <p>
     * The identifier of the resource to be updated.
     * </p>
     * <p>
     * The identifier can accept <i>ResourceId</i>, <i>Resourcename</i>, or <i>email</i>. The following identity formats
     * are available:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Resource ID: r-0123456789a0123456789b0123456789
     * </p>
     * </li>
     * <li>
     * <p>
     * Email address: resource@domain.tld
     * </p>
     * </li>
     * <li>
     * <p>
     * Resource name: resource
     * </p>
     * </li>
     * </ul>
     * 
     * @return The identifier of the resource to be updated.</p>
     *         <p>
     *         The identifier can accept <i>ResourceId</i>, <i>Resourcename</i>, or <i>email</i>. The following identity
     *         formats are available:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Resource ID: r-0123456789a0123456789b0123456789
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Email address: resource@domain.tld
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Resource name: resource
     *         </p>
     *         </li>
     */
    public final String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * The name of the resource to be updated.
     * </p>
     * 
     * @return The name of the resource to be updated.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The resource's booking options to be updated.
     * </p>
     * 
     * @return The resource's booking options to be updated.
     */
    public final BookingOptions bookingOptions() {
        return bookingOptions;
    }

    /**
     * <p>
     * Updates the resource description.
     * </p>
     * 
     * @return Updates the resource description.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Updates the resource type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Updates the resource type.
     * @see ResourceType
     */
    public final ResourceType type() {
        return ResourceType.fromValue(type);
    }

    /**
     * <p>
     * Updates the resource type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Updates the resource type.
     * @see ResourceType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * If enabled, the resource is hidden from the global address list.
     * </p>
     * 
     * @return If enabled, the resource is hidden from the global address list.
     */
    public final Boolean hiddenFromGlobalAddressList() {
        return hiddenFromGlobalAddressList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(organizationId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(bookingOptions());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hiddenFromGlobalAddressList());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateResourceRequest)) {
            return false;
        }
        UpdateResourceRequest other = (UpdateResourceRequest) obj;
        return Objects.equals(organizationId(), other.organizationId()) && Objects.equals(resourceId(), other.resourceId())
                && Objects.equals(name(), other.name()) && Objects.equals(bookingOptions(), other.bookingOptions())
                && Objects.equals(description(), other.description()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(hiddenFromGlobalAddressList(), other.hiddenFromGlobalAddressList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateResourceRequest").add("OrganizationId", organizationId()).add("ResourceId", resourceId())
                .add("Name", name()).add("BookingOptions", bookingOptions())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***").add("Type", typeAsString())
                .add("HiddenFromGlobalAddressList", hiddenFromGlobalAddressList()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OrganizationId":
            return Optional.ofNullable(clazz.cast(organizationId()));
        case "ResourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "BookingOptions":
            return Optional.ofNullable(clazz.cast(bookingOptions()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "HiddenFromGlobalAddressList":
            return Optional.ofNullable(clazz.cast(hiddenFromGlobalAddressList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("OrganizationId", ORGANIZATION_ID_FIELD);
        map.put("ResourceId", RESOURCE_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("BookingOptions", BOOKING_OPTIONS_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("HiddenFromGlobalAddressList", HIDDEN_FROM_GLOBAL_ADDRESS_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateResourceRequest, T> g) {
        return obj -> g.apply((UpdateResourceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends WorkMailRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateResourceRequest> {
        /**
         * <p>
         * The identifier associated with the organization for which the resource is updated.
         * </p>
         * 
         * @param organizationId
         *        The identifier associated with the organization for which the resource is updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationId(String organizationId);

        /**
         * <p>
         * The identifier of the resource to be updated.
         * </p>
         * <p>
         * The identifier can accept <i>ResourceId</i>, <i>Resourcename</i>, or <i>email</i>. The following identity
         * formats are available:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Resource ID: r-0123456789a0123456789b0123456789
         * </p>
         * </li>
         * <li>
         * <p>
         * Email address: resource@domain.tld
         * </p>
         * </li>
         * <li>
         * <p>
         * Resource name: resource
         * </p>
         * </li>
         * </ul>
         * 
         * @param resourceId
         *        The identifier of the resource to be updated.</p>
         *        <p>
         *        The identifier can accept <i>ResourceId</i>, <i>Resourcename</i>, or <i>email</i>. The following
         *        identity formats are available:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Resource ID: r-0123456789a0123456789b0123456789
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Email address: resource@domain.tld
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Resource name: resource
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * The name of the resource to be updated.
         * </p>
         * 
         * @param name
         *        The name of the resource to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The resource's booking options to be updated.
         * </p>
         * 
         * @param bookingOptions
         *        The resource's booking options to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bookingOptions(BookingOptions bookingOptions);

        /**
         * <p>
         * The resource's booking options to be updated.
         * </p>
         * This is a convenience method that creates an instance of the {@link BookingOptions.Builder} avoiding the need
         * to create one manually via {@link BookingOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BookingOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #bookingOptions(BookingOptions)}.
         * 
         * @param bookingOptions
         *        a consumer that will call methods on {@link BookingOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bookingOptions(BookingOptions)
         */
        default Builder bookingOptions(Consumer<BookingOptions.Builder> bookingOptions) {
            return bookingOptions(BookingOptions.builder().applyMutation(bookingOptions).build());
        }

        /**
         * <p>
         * Updates the resource description.
         * </p>
         * 
         * @param description
         *        Updates the resource description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Updates the resource type.
         * </p>
         * 
         * @param type
         *        Updates the resource type.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder type(String type);

        /**
         * <p>
         * Updates the resource type.
         * </p>
         * 
         * @param type
         *        Updates the resource type.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder type(ResourceType type);

        /**
         * <p>
         * If enabled, the resource is hidden from the global address list.
         * </p>
         * 
         * @param hiddenFromGlobalAddressList
         *        If enabled, the resource is hidden from the global address list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hiddenFromGlobalAddressList(Boolean hiddenFromGlobalAddressList);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkMailRequest.BuilderImpl implements Builder {
        private String organizationId;

        private String resourceId;

        private String name;

        private BookingOptions bookingOptions;

        private String description;

        private String type;

        private Boolean hiddenFromGlobalAddressList;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateResourceRequest model) {
            super(model);
            organizationId(model.organizationId);
            resourceId(model.resourceId);
            name(model.name);
            bookingOptions(model.bookingOptions);
            description(model.description);
            type(model.type);
            hiddenFromGlobalAddressList(model.hiddenFromGlobalAddressList);
        }

        public final String getOrganizationId() {
            return organizationId;
        }

        public final void setOrganizationId(String organizationId) {
            this.organizationId = organizationId;
        }

        @Override
        public final Builder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public final String getResourceId() {
            return resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final BookingOptions.Builder getBookingOptions() {
            return bookingOptions != null ? bookingOptions.toBuilder() : null;
        }

        public final void setBookingOptions(BookingOptions.BuilderImpl bookingOptions) {
            this.bookingOptions = bookingOptions != null ? bookingOptions.build() : null;
        }

        @Override
        public final Builder bookingOptions(BookingOptions bookingOptions) {
            this.bookingOptions = bookingOptions;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ResourceType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Boolean getHiddenFromGlobalAddressList() {
            return hiddenFromGlobalAddressList;
        }

        public final void setHiddenFromGlobalAddressList(Boolean hiddenFromGlobalAddressList) {
            this.hiddenFromGlobalAddressList = hiddenFromGlobalAddressList;
        }

        @Override
        public final Builder hiddenFromGlobalAddressList(Boolean hiddenFromGlobalAddressList) {
            this.hiddenFromGlobalAddressList = hiddenFromGlobalAddressList;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateResourceRequest build() {
            return new UpdateResourceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
