/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workmail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateUserRequest extends WorkMailRequest implements
        ToCopyableBuilder<CreateUserRequest.Builder, CreateUserRequest> {
    private static final SdkField<String> ORGANIZATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OrganizationId").getter(getter(CreateUserRequest::organizationId))
            .setter(setter(Builder::organizationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateUserRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DisplayName").getter(getter(CreateUserRequest::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()).build();

    private static final SdkField<String> PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Password").getter(getter(CreateUserRequest::password)).setter(setter(Builder::password))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Password").build()).build();

    private static final SdkField<String> ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Role")
            .getter(getter(CreateUserRequest::roleAsString)).setter(setter(Builder::role))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()).build();

    private static final SdkField<String> FIRST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FirstName").getter(getter(CreateUserRequest::firstName)).setter(setter(Builder::firstName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirstName").build()).build();

    private static final SdkField<String> LAST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastName").getter(getter(CreateUserRequest::lastName)).setter(setter(Builder::lastName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastName").build()).build();

    private static final SdkField<Boolean> HIDDEN_FROM_GLOBAL_ADDRESS_LIST_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("HiddenFromGlobalAddressList")
            .getter(getter(CreateUserRequest::hiddenFromGlobalAddressList))
            .setter(setter(Builder::hiddenFromGlobalAddressList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HiddenFromGlobalAddressList")
                    .build()).build();

    private static final SdkField<String> IDENTITY_PROVIDER_USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IdentityProviderUserId").getter(getter(CreateUserRequest::identityProviderUserId))
            .setter(setter(Builder::identityProviderUserId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityProviderUserId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORGANIZATION_ID_FIELD,
            NAME_FIELD, DISPLAY_NAME_FIELD, PASSWORD_FIELD, ROLE_FIELD, FIRST_NAME_FIELD, LAST_NAME_FIELD,
            HIDDEN_FROM_GLOBAL_ADDRESS_LIST_FIELD, IDENTITY_PROVIDER_USER_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String organizationId;

    private final String name;

    private final String displayName;

    private final String password;

    private final String role;

    private final String firstName;

    private final String lastName;

    private final Boolean hiddenFromGlobalAddressList;

    private final String identityProviderUserId;

    private CreateUserRequest(BuilderImpl builder) {
        super(builder);
        this.organizationId = builder.organizationId;
        this.name = builder.name;
        this.displayName = builder.displayName;
        this.password = builder.password;
        this.role = builder.role;
        this.firstName = builder.firstName;
        this.lastName = builder.lastName;
        this.hiddenFromGlobalAddressList = builder.hiddenFromGlobalAddressList;
        this.identityProviderUserId = builder.identityProviderUserId;
    }

    /**
     * <p>
     * The identifier of the organization for which the user is created.
     * </p>
     * 
     * @return The identifier of the organization for which the user is created.
     */
    public final String organizationId() {
        return organizationId;
    }

    /**
     * <p>
     * The name for the new user. WorkMail directory user names have a maximum length of 64. All others have a maximum
     * length of 20.
     * </p>
     * 
     * @return The name for the new user. WorkMail directory user names have a maximum length of 64. All others have a
     *         maximum length of 20.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The display name for the new user.
     * </p>
     * 
     * @return The display name for the new user.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The password for the new user.
     * </p>
     * 
     * @return The password for the new user.
     */
    public final String password() {
        return password;
    }

    /**
     * <p>
     * The role of the new user.
     * </p>
     * <p>
     * You cannot pass <i>SYSTEM_USER</i> or <i>RESOURCE</i> role in a single request. When a user role is not selected,
     * the default role of <i>USER</i> is selected.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #role} will return
     * {@link UserRole#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #roleAsString}.
     * </p>
     * 
     * @return The role of the new user.</p>
     *         <p>
     *         You cannot pass <i>SYSTEM_USER</i> or <i>RESOURCE</i> role in a single request. When a user role is not
     *         selected, the default role of <i>USER</i> is selected.
     * @see UserRole
     */
    public final UserRole role() {
        return UserRole.fromValue(role);
    }

    /**
     * <p>
     * The role of the new user.
     * </p>
     * <p>
     * You cannot pass <i>SYSTEM_USER</i> or <i>RESOURCE</i> role in a single request. When a user role is not selected,
     * the default role of <i>USER</i> is selected.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #role} will return
     * {@link UserRole#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #roleAsString}.
     * </p>
     * 
     * @return The role of the new user.</p>
     *         <p>
     *         You cannot pass <i>SYSTEM_USER</i> or <i>RESOURCE</i> role in a single request. When a user role is not
     *         selected, the default role of <i>USER</i> is selected.
     * @see UserRole
     */
    public final String roleAsString() {
        return role;
    }

    /**
     * <p>
     * The first name of the new user.
     * </p>
     * 
     * @return The first name of the new user.
     */
    public final String firstName() {
        return firstName;
    }

    /**
     * <p>
     * The last name of the new user.
     * </p>
     * 
     * @return The last name of the new user.
     */
    public final String lastName() {
        return lastName;
    }

    /**
     * <p>
     * If this parameter is enabled, the user will be hidden from the address book.
     * </p>
     * 
     * @return If this parameter is enabled, the user will be hidden from the address book.
     */
    public final Boolean hiddenFromGlobalAddressList() {
        return hiddenFromGlobalAddressList;
    }

    /**
     * <p>
     * User ID from the IAM Identity Center. If this parameter is empty it will be updated automatically when the user
     * logs in for the first time to the mailbox associated with WorkMail.
     * </p>
     * 
     * @return User ID from the IAM Identity Center. If this parameter is empty it will be updated automatically when
     *         the user logs in for the first time to the mailbox associated with WorkMail.
     */
    public final String identityProviderUserId() {
        return identityProviderUserId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(organizationId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(password());
        hashCode = 31 * hashCode + Objects.hashCode(roleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(firstName());
        hashCode = 31 * hashCode + Objects.hashCode(lastName());
        hashCode = 31 * hashCode + Objects.hashCode(hiddenFromGlobalAddressList());
        hashCode = 31 * hashCode + Objects.hashCode(identityProviderUserId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateUserRequest)) {
            return false;
        }
        CreateUserRequest other = (CreateUserRequest) obj;
        return Objects.equals(organizationId(), other.organizationId()) && Objects.equals(name(), other.name())
                && Objects.equals(displayName(), other.displayName()) && Objects.equals(password(), other.password())
                && Objects.equals(roleAsString(), other.roleAsString()) && Objects.equals(firstName(), other.firstName())
                && Objects.equals(lastName(), other.lastName())
                && Objects.equals(hiddenFromGlobalAddressList(), other.hiddenFromGlobalAddressList())
                && Objects.equals(identityProviderUserId(), other.identityProviderUserId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateUserRequest").add("OrganizationId", organizationId()).add("Name", name())
                .add("DisplayName", displayName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Password", password() == null ? null : "*** Sensitive Data Redacted ***").add("Role", roleAsString())
                .add("FirstName", firstName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("LastName", lastName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("HiddenFromGlobalAddressList", hiddenFromGlobalAddressList())
                .add("IdentityProviderUserId", identityProviderUserId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OrganizationId":
            return Optional.ofNullable(clazz.cast(organizationId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "DisplayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "Password":
            return Optional.ofNullable(clazz.cast(password()));
        case "Role":
            return Optional.ofNullable(clazz.cast(roleAsString()));
        case "FirstName":
            return Optional.ofNullable(clazz.cast(firstName()));
        case "LastName":
            return Optional.ofNullable(clazz.cast(lastName()));
        case "HiddenFromGlobalAddressList":
            return Optional.ofNullable(clazz.cast(hiddenFromGlobalAddressList()));
        case "IdentityProviderUserId":
            return Optional.ofNullable(clazz.cast(identityProviderUserId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("OrganizationId", ORGANIZATION_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("DisplayName", DISPLAY_NAME_FIELD);
        map.put("Password", PASSWORD_FIELD);
        map.put("Role", ROLE_FIELD);
        map.put("FirstName", FIRST_NAME_FIELD);
        map.put("LastName", LAST_NAME_FIELD);
        map.put("HiddenFromGlobalAddressList", HIDDEN_FROM_GLOBAL_ADDRESS_LIST_FIELD);
        map.put("IdentityProviderUserId", IDENTITY_PROVIDER_USER_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateUserRequest, T> g) {
        return obj -> g.apply((CreateUserRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends WorkMailRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateUserRequest> {
        /**
         * <p>
         * The identifier of the organization for which the user is created.
         * </p>
         * 
         * @param organizationId
         *        The identifier of the organization for which the user is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationId(String organizationId);

        /**
         * <p>
         * The name for the new user. WorkMail directory user names have a maximum length of 64. All others have a
         * maximum length of 20.
         * </p>
         * 
         * @param name
         *        The name for the new user. WorkMail directory user names have a maximum length of 64. All others have
         *        a maximum length of 20.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The display name for the new user.
         * </p>
         * 
         * @param displayName
         *        The display name for the new user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The password for the new user.
         * </p>
         * 
         * @param password
         *        The password for the new user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder password(String password);

        /**
         * <p>
         * The role of the new user.
         * </p>
         * <p>
         * You cannot pass <i>SYSTEM_USER</i> or <i>RESOURCE</i> role in a single request. When a user role is not
         * selected, the default role of <i>USER</i> is selected.
         * </p>
         * 
         * @param role
         *        The role of the new user.</p>
         *        <p>
         *        You cannot pass <i>SYSTEM_USER</i> or <i>RESOURCE</i> role in a single request. When a user role is
         *        not selected, the default role of <i>USER</i> is selected.
         * @see UserRole
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserRole
         */
        Builder role(String role);

        /**
         * <p>
         * The role of the new user.
         * </p>
         * <p>
         * You cannot pass <i>SYSTEM_USER</i> or <i>RESOURCE</i> role in a single request. When a user role is not
         * selected, the default role of <i>USER</i> is selected.
         * </p>
         * 
         * @param role
         *        The role of the new user.</p>
         *        <p>
         *        You cannot pass <i>SYSTEM_USER</i> or <i>RESOURCE</i> role in a single request. When a user role is
         *        not selected, the default role of <i>USER</i> is selected.
         * @see UserRole
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UserRole
         */
        Builder role(UserRole role);

        /**
         * <p>
         * The first name of the new user.
         * </p>
         * 
         * @param firstName
         *        The first name of the new user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firstName(String firstName);

        /**
         * <p>
         * The last name of the new user.
         * </p>
         * 
         * @param lastName
         *        The last name of the new user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastName(String lastName);

        /**
         * <p>
         * If this parameter is enabled, the user will be hidden from the address book.
         * </p>
         * 
         * @param hiddenFromGlobalAddressList
         *        If this parameter is enabled, the user will be hidden from the address book.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hiddenFromGlobalAddressList(Boolean hiddenFromGlobalAddressList);

        /**
         * <p>
         * User ID from the IAM Identity Center. If this parameter is empty it will be updated automatically when the
         * user logs in for the first time to the mailbox associated with WorkMail.
         * </p>
         * 
         * @param identityProviderUserId
         *        User ID from the IAM Identity Center. If this parameter is empty it will be updated automatically when
         *        the user logs in for the first time to the mailbox associated with WorkMail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityProviderUserId(String identityProviderUserId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkMailRequest.BuilderImpl implements Builder {
        private String organizationId;

        private String name;

        private String displayName;

        private String password;

        private String role;

        private String firstName;

        private String lastName;

        private Boolean hiddenFromGlobalAddressList;

        private String identityProviderUserId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateUserRequest model) {
            super(model);
            organizationId(model.organizationId);
            name(model.name);
            displayName(model.displayName);
            password(model.password);
            role(model.role);
            firstName(model.firstName);
            lastName(model.lastName);
            hiddenFromGlobalAddressList(model.hiddenFromGlobalAddressList);
            identityProviderUserId(model.identityProviderUserId);
        }

        public final String getOrganizationId() {
            return organizationId;
        }

        public final void setOrganizationId(String organizationId) {
            this.organizationId = organizationId;
        }

        @Override
        public final Builder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getPassword() {
            return password;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        @Override
        public final Builder password(String password) {
            this.password = password;
            return this;
        }

        public final String getRole() {
            return role;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        @Override
        public final Builder role(UserRole role) {
            this.role(role == null ? null : role.toString());
            return this;
        }

        public final String getFirstName() {
            return firstName;
        }

        public final void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        @Override
        public final Builder firstName(String firstName) {
            this.firstName = firstName;
            return this;
        }

        public final String getLastName() {
            return lastName;
        }

        public final void setLastName(String lastName) {
            this.lastName = lastName;
        }

        @Override
        public final Builder lastName(String lastName) {
            this.lastName = lastName;
            return this;
        }

        public final Boolean getHiddenFromGlobalAddressList() {
            return hiddenFromGlobalAddressList;
        }

        public final void setHiddenFromGlobalAddressList(Boolean hiddenFromGlobalAddressList) {
            this.hiddenFromGlobalAddressList = hiddenFromGlobalAddressList;
        }

        @Override
        public final Builder hiddenFromGlobalAddressList(Boolean hiddenFromGlobalAddressList) {
            this.hiddenFromGlobalAddressList = hiddenFromGlobalAddressList;
            return this;
        }

        public final String getIdentityProviderUserId() {
            return identityProviderUserId;
        }

        public final void setIdentityProviderUserId(String identityProviderUserId) {
            this.identityProviderUserId = identityProviderUserId;
        }

        @Override
        public final Builder identityProviderUserId(String identityProviderUserId) {
            this.identityProviderUserId = identityProviderUserId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateUserRequest build() {
            return new CreateUserRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
