/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workmail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The rules for the given impersonation role.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImpersonationRule implements SdkPojo, Serializable,
        ToCopyableBuilder<ImpersonationRule.Builder, ImpersonationRule> {
    private static final SdkField<String> IMPERSONATION_RULE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImpersonationRuleId").getter(getter(ImpersonationRule::impersonationRuleId))
            .setter(setter(Builder::impersonationRuleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImpersonationRuleId").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ImpersonationRule::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(ImpersonationRule::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> EFFECT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Effect")
            .getter(getter(ImpersonationRule::effectAsString)).setter(setter(Builder::effect))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Effect").build()).build();

    private static final SdkField<List<String>> TARGET_USERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("TargetUsers")
            .getter(getter(ImpersonationRule::targetUsers))
            .setter(setter(Builder::targetUsers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetUsers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> NOT_TARGET_USERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("NotTargetUsers")
            .getter(getter(ImpersonationRule::notTargetUsers))
            .setter(setter(Builder::notTargetUsers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotTargetUsers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMPERSONATION_RULE_ID_FIELD,
            NAME_FIELD, DESCRIPTION_FIELD, EFFECT_FIELD, TARGET_USERS_FIELD, NOT_TARGET_USERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String impersonationRuleId;

    private final String name;

    private final String description;

    private final String effect;

    private final List<String> targetUsers;

    private final List<String> notTargetUsers;

    private ImpersonationRule(BuilderImpl builder) {
        this.impersonationRuleId = builder.impersonationRuleId;
        this.name = builder.name;
        this.description = builder.description;
        this.effect = builder.effect;
        this.targetUsers = builder.targetUsers;
        this.notTargetUsers = builder.notTargetUsers;
    }

    /**
     * <p>
     * The identifier of the rule.
     * </p>
     * 
     * @return The identifier of the rule.
     */
    public final String impersonationRuleId() {
        return impersonationRuleId;
    }

    /**
     * <p>
     * The rule name.
     * </p>
     * 
     * @return The rule name.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The rule description.
     * </p>
     * 
     * @return The rule description.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The effect of the rule when it matches the input. Allowed effect values are <code>ALLOW</code> or
     * <code>DENY</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #effect} will
     * return {@link AccessEffect#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #effectAsString}.
     * </p>
     * 
     * @return The effect of the rule when it matches the input. Allowed effect values are <code>ALLOW</code> or
     *         <code>DENY</code>.
     * @see AccessEffect
     */
    public final AccessEffect effect() {
        return AccessEffect.fromValue(effect);
    }

    /**
     * <p>
     * The effect of the rule when it matches the input. Allowed effect values are <code>ALLOW</code> or
     * <code>DENY</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #effect} will
     * return {@link AccessEffect#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #effectAsString}.
     * </p>
     * 
     * @return The effect of the rule when it matches the input. Allowed effect values are <code>ALLOW</code> or
     *         <code>DENY</code>.
     * @see AccessEffect
     */
    public final String effectAsString() {
        return effect;
    }

    /**
     * For responses, this returns true if the service returned a value for the TargetUsers property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTargetUsers() {
        return targetUsers != null && !(targetUsers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of user IDs that match the rule.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargetUsers} method.
     * </p>
     * 
     * @return A list of user IDs that match the rule.
     */
    public final List<String> targetUsers() {
        return targetUsers;
    }

    /**
     * For responses, this returns true if the service returned a value for the NotTargetUsers property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasNotTargetUsers() {
        return notTargetUsers != null && !(notTargetUsers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of user IDs that don't match the rule.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNotTargetUsers} method.
     * </p>
     * 
     * @return A list of user IDs that don't match the rule.
     */
    public final List<String> notTargetUsers() {
        return notTargetUsers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(impersonationRuleId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(effectAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTargetUsers() ? targetUsers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasNotTargetUsers() ? notTargetUsers() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImpersonationRule)) {
            return false;
        }
        ImpersonationRule other = (ImpersonationRule) obj;
        return Objects.equals(impersonationRuleId(), other.impersonationRuleId()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(effectAsString(), other.effectAsString())
                && hasTargetUsers() == other.hasTargetUsers() && Objects.equals(targetUsers(), other.targetUsers())
                && hasNotTargetUsers() == other.hasNotTargetUsers() && Objects.equals(notTargetUsers(), other.notTargetUsers());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImpersonationRule").add("ImpersonationRuleId", impersonationRuleId()).add("Name", name())
                .add("Description", description()).add("Effect", effectAsString())
                .add("TargetUsers", hasTargetUsers() ? targetUsers() : null)
                .add("NotTargetUsers", hasNotTargetUsers() ? notTargetUsers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ImpersonationRuleId":
            return Optional.ofNullable(clazz.cast(impersonationRuleId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Effect":
            return Optional.ofNullable(clazz.cast(effectAsString()));
        case "TargetUsers":
            return Optional.ofNullable(clazz.cast(targetUsers()));
        case "NotTargetUsers":
            return Optional.ofNullable(clazz.cast(notTargetUsers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ImpersonationRuleId", IMPERSONATION_RULE_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Effect", EFFECT_FIELD);
        map.put("TargetUsers", TARGET_USERS_FIELD);
        map.put("NotTargetUsers", NOT_TARGET_USERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImpersonationRule, T> g) {
        return obj -> g.apply((ImpersonationRule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ImpersonationRule> {
        /**
         * <p>
         * The identifier of the rule.
         * </p>
         * 
         * @param impersonationRuleId
         *        The identifier of the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder impersonationRuleId(String impersonationRuleId);

        /**
         * <p>
         * The rule name.
         * </p>
         * 
         * @param name
         *        The rule name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The rule description.
         * </p>
         * 
         * @param description
         *        The rule description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The effect of the rule when it matches the input. Allowed effect values are <code>ALLOW</code> or
         * <code>DENY</code>.
         * </p>
         * 
         * @param effect
         *        The effect of the rule when it matches the input. Allowed effect values are <code>ALLOW</code> or
         *        <code>DENY</code>.
         * @see AccessEffect
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccessEffect
         */
        Builder effect(String effect);

        /**
         * <p>
         * The effect of the rule when it matches the input. Allowed effect values are <code>ALLOW</code> or
         * <code>DENY</code>.
         * </p>
         * 
         * @param effect
         *        The effect of the rule when it matches the input. Allowed effect values are <code>ALLOW</code> or
         *        <code>DENY</code>.
         * @see AccessEffect
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccessEffect
         */
        Builder effect(AccessEffect effect);

        /**
         * <p>
         * A list of user IDs that match the rule.
         * </p>
         * 
         * @param targetUsers
         *        A list of user IDs that match the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetUsers(Collection<String> targetUsers);

        /**
         * <p>
         * A list of user IDs that match the rule.
         * </p>
         * 
         * @param targetUsers
         *        A list of user IDs that match the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetUsers(String... targetUsers);

        /**
         * <p>
         * A list of user IDs that don't match the rule.
         * </p>
         * 
         * @param notTargetUsers
         *        A list of user IDs that don't match the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notTargetUsers(Collection<String> notTargetUsers);

        /**
         * <p>
         * A list of user IDs that don't match the rule.
         * </p>
         * 
         * @param notTargetUsers
         *        A list of user IDs that don't match the rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notTargetUsers(String... notTargetUsers);
    }

    static final class BuilderImpl implements Builder {
        private String impersonationRuleId;

        private String name;

        private String description;

        private String effect;

        private List<String> targetUsers = DefaultSdkAutoConstructList.getInstance();

        private List<String> notTargetUsers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ImpersonationRule model) {
            impersonationRuleId(model.impersonationRuleId);
            name(model.name);
            description(model.description);
            effect(model.effect);
            targetUsers(model.targetUsers);
            notTargetUsers(model.notTargetUsers);
        }

        public final String getImpersonationRuleId() {
            return impersonationRuleId;
        }

        public final void setImpersonationRuleId(String impersonationRuleId) {
            this.impersonationRuleId = impersonationRuleId;
        }

        @Override
        public final Builder impersonationRuleId(String impersonationRuleId) {
            this.impersonationRuleId = impersonationRuleId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getEffect() {
            return effect;
        }

        public final void setEffect(String effect) {
            this.effect = effect;
        }

        @Override
        public final Builder effect(String effect) {
            this.effect = effect;
            return this;
        }

        @Override
        public final Builder effect(AccessEffect effect) {
            this.effect(effect == null ? null : effect.toString());
            return this;
        }

        public final Collection<String> getTargetUsers() {
            if (targetUsers instanceof SdkAutoConstructList) {
                return null;
            }
            return targetUsers;
        }

        public final void setTargetUsers(Collection<String> targetUsers) {
            this.targetUsers = TargetUsersCopier.copy(targetUsers);
        }

        @Override
        public final Builder targetUsers(Collection<String> targetUsers) {
            this.targetUsers = TargetUsersCopier.copy(targetUsers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetUsers(String... targetUsers) {
            targetUsers(Arrays.asList(targetUsers));
            return this;
        }

        public final Collection<String> getNotTargetUsers() {
            if (notTargetUsers instanceof SdkAutoConstructList) {
                return null;
            }
            return notTargetUsers;
        }

        public final void setNotTargetUsers(Collection<String> notTargetUsers) {
            this.notTargetUsers = TargetUsersCopier.copy(notTargetUsers);
        }

        @Override
        public final Builder notTargetUsers(Collection<String> notTargetUsers) {
            this.notTargetUsers = TargetUsersCopier.copy(notTargetUsers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notTargetUsers(String... notTargetUsers) {
            notTargetUsers(Arrays.asList(notTargetUsers));
            return this;
        }

        @Override
        public ImpersonationRule build() {
            return new ImpersonationRule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
