/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workmail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateImpersonationRoleRequest extends WorkMailRequest implements
        ToCopyableBuilder<UpdateImpersonationRoleRequest.Builder, UpdateImpersonationRoleRequest> {
    private static final SdkField<String> ORGANIZATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OrganizationId").getter(getter(UpdateImpersonationRoleRequest::organizationId))
            .setter(setter(Builder::organizationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationId").build()).build();

    private static final SdkField<String> IMPERSONATION_ROLE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImpersonationRoleId").getter(getter(UpdateImpersonationRoleRequest::impersonationRoleId))
            .setter(setter(Builder::impersonationRoleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImpersonationRoleId").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateImpersonationRoleRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(UpdateImpersonationRoleRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateImpersonationRoleRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<List<ImpersonationRule>> RULES_FIELD = SdkField
            .<List<ImpersonationRule>> builder(MarshallingType.LIST)
            .memberName("Rules")
            .getter(getter(UpdateImpersonationRoleRequest::rules))
            .setter(setter(Builder::rules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ImpersonationRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(ImpersonationRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORGANIZATION_ID_FIELD,
            IMPERSONATION_ROLE_ID_FIELD, NAME_FIELD, TYPE_FIELD, DESCRIPTION_FIELD, RULES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String organizationId;

    private final String impersonationRoleId;

    private final String name;

    private final String type;

    private final String description;

    private final List<ImpersonationRule> rules;

    private UpdateImpersonationRoleRequest(BuilderImpl builder) {
        super(builder);
        this.organizationId = builder.organizationId;
        this.impersonationRoleId = builder.impersonationRoleId;
        this.name = builder.name;
        this.type = builder.type;
        this.description = builder.description;
        this.rules = builder.rules;
    }

    /**
     * <p>
     * The WorkMail organization that contains the impersonation role to update.
     * </p>
     * 
     * @return The WorkMail organization that contains the impersonation role to update.
     */
    public final String organizationId() {
        return organizationId;
    }

    /**
     * <p>
     * The ID of the impersonation role to update.
     * </p>
     * 
     * @return The ID of the impersonation role to update.
     */
    public final String impersonationRoleId() {
        return impersonationRoleId;
    }

    /**
     * <p>
     * The updated impersonation role name.
     * </p>
     * 
     * @return The updated impersonation role name.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The updated impersonation role type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ImpersonationRoleType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The updated impersonation role type.
     * @see ImpersonationRoleType
     */
    public final ImpersonationRoleType type() {
        return ImpersonationRoleType.fromValue(type);
    }

    /**
     * <p>
     * The updated impersonation role type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ImpersonationRoleType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The updated impersonation role type.
     * @see ImpersonationRoleType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The updated impersonation role description.
     * </p>
     * 
     * @return The updated impersonation role description.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Rules property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasRules() {
        return rules != null && !(rules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The updated list of rules.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRules} method.
     * </p>
     * 
     * @return The updated list of rules.
     */
    public final List<ImpersonationRule> rules() {
        return rules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(organizationId());
        hashCode = 31 * hashCode + Objects.hashCode(impersonationRoleId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasRules() ? rules() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateImpersonationRoleRequest)) {
            return false;
        }
        UpdateImpersonationRoleRequest other = (UpdateImpersonationRoleRequest) obj;
        return Objects.equals(organizationId(), other.organizationId())
                && Objects.equals(impersonationRoleId(), other.impersonationRoleId()) && Objects.equals(name(), other.name())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(description(), other.description())
                && hasRules() == other.hasRules() && Objects.equals(rules(), other.rules());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateImpersonationRoleRequest").add("OrganizationId", organizationId())
                .add("ImpersonationRoleId", impersonationRoleId()).add("Name", name()).add("Type", typeAsString())
                .add("Description", description()).add("Rules", hasRules() ? rules() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OrganizationId":
            return Optional.ofNullable(clazz.cast(organizationId()));
        case "ImpersonationRoleId":
            return Optional.ofNullable(clazz.cast(impersonationRoleId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Rules":
            return Optional.ofNullable(clazz.cast(rules()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("OrganizationId", ORGANIZATION_ID_FIELD);
        map.put("ImpersonationRoleId", IMPERSONATION_ROLE_ID_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Rules", RULES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateImpersonationRoleRequest, T> g) {
        return obj -> g.apply((UpdateImpersonationRoleRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends WorkMailRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateImpersonationRoleRequest> {
        /**
         * <p>
         * The WorkMail organization that contains the impersonation role to update.
         * </p>
         * 
         * @param organizationId
         *        The WorkMail organization that contains the impersonation role to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationId(String organizationId);

        /**
         * <p>
         * The ID of the impersonation role to update.
         * </p>
         * 
         * @param impersonationRoleId
         *        The ID of the impersonation role to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder impersonationRoleId(String impersonationRoleId);

        /**
         * <p>
         * The updated impersonation role name.
         * </p>
         * 
         * @param name
         *        The updated impersonation role name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The updated impersonation role type.
         * </p>
         * 
         * @param type
         *        The updated impersonation role type.
         * @see ImpersonationRoleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImpersonationRoleType
         */
        Builder type(String type);

        /**
         * <p>
         * The updated impersonation role type.
         * </p>
         * 
         * @param type
         *        The updated impersonation role type.
         * @see ImpersonationRoleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImpersonationRoleType
         */
        Builder type(ImpersonationRoleType type);

        /**
         * <p>
         * The updated impersonation role description.
         * </p>
         * 
         * @param description
         *        The updated impersonation role description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The updated list of rules.
         * </p>
         * 
         * @param rules
         *        The updated list of rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(Collection<ImpersonationRule> rules);

        /**
         * <p>
         * The updated list of rules.
         * </p>
         * 
         * @param rules
         *        The updated list of rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(ImpersonationRule... rules);

        /**
         * <p>
         * The updated list of rules.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.workmail.model.ImpersonationRule.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.workmail.model.ImpersonationRule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.workmail.model.ImpersonationRule.Builder#build()} is called
         * immediately and its result is passed to {@link #rules(List<ImpersonationRule>)}.
         * 
         * @param rules
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.workmail.model.ImpersonationRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rules(java.util.Collection<ImpersonationRule>)
         */
        Builder rules(Consumer<ImpersonationRule.Builder>... rules);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkMailRequest.BuilderImpl implements Builder {
        private String organizationId;

        private String impersonationRoleId;

        private String name;

        private String type;

        private String description;

        private List<ImpersonationRule> rules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateImpersonationRoleRequest model) {
            super(model);
            organizationId(model.organizationId);
            impersonationRoleId(model.impersonationRoleId);
            name(model.name);
            type(model.type);
            description(model.description);
            rules(model.rules);
        }

        public final String getOrganizationId() {
            return organizationId;
        }

        public final void setOrganizationId(String organizationId) {
            this.organizationId = organizationId;
        }

        @Override
        public final Builder organizationId(String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public final String getImpersonationRoleId() {
            return impersonationRoleId;
        }

        public final void setImpersonationRoleId(String impersonationRoleId) {
            this.impersonationRoleId = impersonationRoleId;
        }

        @Override
        public final Builder impersonationRoleId(String impersonationRoleId) {
            this.impersonationRoleId = impersonationRoleId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ImpersonationRoleType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<ImpersonationRule.Builder> getRules() {
            List<ImpersonationRule.Builder> result = ImpersonationRuleListCopier.copyToBuilder(this.rules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRules(Collection<ImpersonationRule.BuilderImpl> rules) {
            this.rules = ImpersonationRuleListCopier.copyFromBuilder(rules);
        }

        @Override
        public final Builder rules(Collection<ImpersonationRule> rules) {
            this.rules = ImpersonationRuleListCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(ImpersonationRule... rules) {
            rules(Arrays.asList(rules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Consumer<ImpersonationRule.Builder>... rules) {
            rules(Stream.of(rules).map(c -> ImpersonationRule.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateImpersonationRoleRequest build() {
            return new UpdateImpersonationRoleRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
