/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workmail.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeResourceResponse extends WorkMailResponse implements
        ToCopyableBuilder<DescribeResourceResponse.Builder, DescribeResourceResponse> {
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeResourceResponse::resourceId)).setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()).build();

    private static final SdkField<String> EMAIL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeResourceResponse::email)).setter(setter(Builder::email))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Email").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeResourceResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeResourceResponse::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<BookingOptions> BOOKING_OPTIONS_FIELD = SdkField
            .<BookingOptions> builder(MarshallingType.SDK_POJO).getter(getter(DescribeResourceResponse::bookingOptions))
            .setter(setter(Builder::bookingOptions)).constructor(BookingOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BookingOptions").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeResourceResponse::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<Instant> ENABLED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DescribeResourceResponse::enabledDate)).setter(setter(Builder::enabledDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnabledDate").build()).build();

    private static final SdkField<Instant> DISABLED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DescribeResourceResponse::disabledDate)).setter(setter(Builder::disabledDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisabledDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ID_FIELD,
            EMAIL_FIELD, NAME_FIELD, TYPE_FIELD, BOOKING_OPTIONS_FIELD, STATE_FIELD, ENABLED_DATE_FIELD, DISABLED_DATE_FIELD));

    private final String resourceId;

    private final String email;

    private final String name;

    private final String type;

    private final BookingOptions bookingOptions;

    private final String state;

    private final Instant enabledDate;

    private final Instant disabledDate;

    private DescribeResourceResponse(BuilderImpl builder) {
        super(builder);
        this.resourceId = builder.resourceId;
        this.email = builder.email;
        this.name = builder.name;
        this.type = builder.type;
        this.bookingOptions = builder.bookingOptions;
        this.state = builder.state;
        this.enabledDate = builder.enabledDate;
        this.disabledDate = builder.disabledDate;
    }

    /**
     * <p>
     * The identifier of the described resource.
     * </p>
     * 
     * @return The identifier of the described resource.
     */
    public String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * The email of the described resource.
     * </p>
     * 
     * @return The email of the described resource.
     */
    public String email() {
        return email;
    }

    /**
     * <p>
     * The name of the described resource.
     * </p>
     * 
     * @return The name of the described resource.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The type of the described resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the described resource.
     * @see ResourceType
     */
    public ResourceType type() {
        return ResourceType.fromValue(type);
    }

    /**
     * <p>
     * The type of the described resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the described resource.
     * @see ResourceType
     */
    public String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The booking options for the described resource.
     * </p>
     * 
     * @return The booking options for the described resource.
     */
    public BookingOptions bookingOptions() {
        return bookingOptions;
    }

    /**
     * <p>
     * The state of the resource: enabled (registered to Amazon WorkMail) or disabled (deregistered or never registered
     * to WorkMail).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link EntityState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the resource: enabled (registered to Amazon WorkMail) or disabled (deregistered or never
     *         registered to WorkMail).
     * @see EntityState
     */
    public EntityState state() {
        return EntityState.fromValue(state);
    }

    /**
     * <p>
     * The state of the resource: enabled (registered to Amazon WorkMail) or disabled (deregistered or never registered
     * to WorkMail).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link EntityState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the resource: enabled (registered to Amazon WorkMail) or disabled (deregistered or never
     *         registered to WorkMail).
     * @see EntityState
     */
    public String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The date and time when a resource was enabled for WorkMail, in UNIX epoch time format.
     * </p>
     * 
     * @return The date and time when a resource was enabled for WorkMail, in UNIX epoch time format.
     */
    public Instant enabledDate() {
        return enabledDate;
    }

    /**
     * <p>
     * The date and time when a resource was disabled from WorkMail, in UNIX epoch time format.
     * </p>
     * 
     * @return The date and time when a resource was disabled from WorkMail, in UNIX epoch time format.
     */
    public Instant disabledDate() {
        return disabledDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(email());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(bookingOptions());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(enabledDate());
        hashCode = 31 * hashCode + Objects.hashCode(disabledDate());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeResourceResponse)) {
            return false;
        }
        DescribeResourceResponse other = (DescribeResourceResponse) obj;
        return Objects.equals(resourceId(), other.resourceId()) && Objects.equals(email(), other.email())
                && Objects.equals(name(), other.name()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(bookingOptions(), other.bookingOptions())
                && Objects.equals(stateAsString(), other.stateAsString()) && Objects.equals(enabledDate(), other.enabledDate())
                && Objects.equals(disabledDate(), other.disabledDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeResourceResponse").add("ResourceId", resourceId()).add("Email", email())
                .add("Name", name()).add("Type", typeAsString()).add("BookingOptions", bookingOptions())
                .add("State", stateAsString()).add("EnabledDate", enabledDate()).add("DisabledDate", disabledDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "Email":
            return Optional.ofNullable(clazz.cast(email()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "BookingOptions":
            return Optional.ofNullable(clazz.cast(bookingOptions()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "EnabledDate":
            return Optional.ofNullable(clazz.cast(enabledDate()));
        case "DisabledDate":
            return Optional.ofNullable(clazz.cast(disabledDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeResourceResponse, T> g) {
        return obj -> g.apply((DescribeResourceResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkMailResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeResourceResponse> {
        /**
         * <p>
         * The identifier of the described resource.
         * </p>
         * 
         * @param resourceId
         *        The identifier of the described resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * The email of the described resource.
         * </p>
         * 
         * @param email
         *        The email of the described resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder email(String email);

        /**
         * <p>
         * The name of the described resource.
         * </p>
         * 
         * @param name
         *        The name of the described resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The type of the described resource.
         * </p>
         * 
         * @param type
         *        The type of the described resource.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the described resource.
         * </p>
         * 
         * @param type
         *        The type of the described resource.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder type(ResourceType type);

        /**
         * <p>
         * The booking options for the described resource.
         * </p>
         * 
         * @param bookingOptions
         *        The booking options for the described resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bookingOptions(BookingOptions bookingOptions);

        /**
         * <p>
         * The booking options for the described resource.
         * </p>
         * This is a convenience that creates an instance of the {@link BookingOptions.Builder} avoiding the need to
         * create one manually via {@link BookingOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link BookingOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #bookingOptions(BookingOptions)}.
         * 
         * @param bookingOptions
         *        a consumer that will call methods on {@link BookingOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bookingOptions(BookingOptions)
         */
        default Builder bookingOptions(Consumer<BookingOptions.Builder> bookingOptions) {
            return bookingOptions(BookingOptions.builder().applyMutation(bookingOptions).build());
        }

        /**
         * <p>
         * The state of the resource: enabled (registered to Amazon WorkMail) or disabled (deregistered or never
         * registered to WorkMail).
         * </p>
         * 
         * @param state
         *        The state of the resource: enabled (registered to Amazon WorkMail) or disabled (deregistered or never
         *        registered to WorkMail).
         * @see EntityState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EntityState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the resource: enabled (registered to Amazon WorkMail) or disabled (deregistered or never
         * registered to WorkMail).
         * </p>
         * 
         * @param state
         *        The state of the resource: enabled (registered to Amazon WorkMail) or disabled (deregistered or never
         *        registered to WorkMail).
         * @see EntityState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EntityState
         */
        Builder state(EntityState state);

        /**
         * <p>
         * The date and time when a resource was enabled for WorkMail, in UNIX epoch time format.
         * </p>
         * 
         * @param enabledDate
         *        The date and time when a resource was enabled for WorkMail, in UNIX epoch time format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabledDate(Instant enabledDate);

        /**
         * <p>
         * The date and time when a resource was disabled from WorkMail, in UNIX epoch time format.
         * </p>
         * 
         * @param disabledDate
         *        The date and time when a resource was disabled from WorkMail, in UNIX epoch time format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disabledDate(Instant disabledDate);
    }

    static final class BuilderImpl extends WorkMailResponse.BuilderImpl implements Builder {
        private String resourceId;

        private String email;

        private String name;

        private String type;

        private BookingOptions bookingOptions;

        private String state;

        private Instant enabledDate;

        private Instant disabledDate;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeResourceResponse model) {
            super(model);
            resourceId(model.resourceId);
            email(model.email);
            name(model.name);
            type(model.type);
            bookingOptions(model.bookingOptions);
            state(model.state);
            enabledDate(model.enabledDate);
            disabledDate(model.disabledDate);
        }

        public final String getResourceId() {
            return resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        public final String getEmail() {
            return email;
        }

        @Override
        public final Builder email(String email) {
            this.email = email;
            return this;
        }

        public final void setEmail(String email) {
            this.email = email;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getTypeAsString() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ResourceType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final BookingOptions.Builder getBookingOptions() {
            return bookingOptions != null ? bookingOptions.toBuilder() : null;
        }

        @Override
        public final Builder bookingOptions(BookingOptions bookingOptions) {
            this.bookingOptions = bookingOptions;
            return this;
        }

        public final void setBookingOptions(BookingOptions.BuilderImpl bookingOptions) {
            this.bookingOptions = bookingOptions != null ? bookingOptions.build() : null;
        }

        public final String getStateAsString() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(EntityState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final Instant getEnabledDate() {
            return enabledDate;
        }

        @Override
        public final Builder enabledDate(Instant enabledDate) {
            this.enabledDate = enabledDate;
            return this;
        }

        public final void setEnabledDate(Instant enabledDate) {
            this.enabledDate = enabledDate;
        }

        public final Instant getDisabledDate() {
            return disabledDate;
        }

        @Override
        public final Builder disabledDate(Instant disabledDate) {
            this.disabledDate = disabledDate;
            return this;
        }

        public final void setDisabledDate(Instant disabledDate) {
            this.disabledDate = disabledDate;
        }

        @Override
        public DescribeResourceResponse build() {
            return new DescribeResourceResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
