/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workmail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.workmail.model.MemberType;
import software.amazon.awssdk.services.workmail.model.PermissionType;
import software.amazon.awssdk.services.workmail.model.PermissionValuesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Permission
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Permission> {
    private static final SdkField<String> GRANTEE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Permission.getter(Permission::granteeId)).setter(Permission.setter(Builder::granteeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GranteeId").build()}).build();
    private static final SdkField<String> GRANTEE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Permission.getter(Permission::granteeTypeAsString)).setter(Permission.setter(Builder::granteeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GranteeType").build()}).build();
    private static final SdkField<List<String>> PERMISSION_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Permission.getter(Permission::permissionValuesAsStrings)).setter(Permission.setter(Builder::permissionValuesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PermissionValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GRANTEE_ID_FIELD, GRANTEE_TYPE_FIELD, PERMISSION_VALUES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String granteeId;
    private final String granteeType;
    private final List<String> permissionValues;

    private Permission(BuilderImpl builder) {
        this.granteeId = builder.granteeId;
        this.granteeType = builder.granteeType;
        this.permissionValues = builder.permissionValues;
    }

    public String granteeId() {
        return this.granteeId;
    }

    public MemberType granteeType() {
        return MemberType.fromValue(this.granteeType);
    }

    public String granteeTypeAsString() {
        return this.granteeType;
    }

    public List<PermissionType> permissionValues() {
        return PermissionValuesCopier.copyStringToEnum(this.permissionValues);
    }

    public List<String> permissionValuesAsStrings() {
        return this.permissionValues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.granteeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.granteeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.permissionValuesAsStrings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Permission)) {
            return false;
        }
        Permission other = (Permission)obj;
        return Objects.equals(this.granteeId(), other.granteeId()) && Objects.equals(this.granteeTypeAsString(), other.granteeTypeAsString()) && Objects.equals(this.permissionValuesAsStrings(), other.permissionValuesAsStrings());
    }

    public String toString() {
        return ToString.builder((String)"Permission").add("GranteeId", (Object)this.granteeId()).add("GranteeType", (Object)this.granteeTypeAsString()).add("PermissionValues", this.permissionValuesAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GranteeId": {
                return Optional.ofNullable(clazz.cast(this.granteeId()));
            }
            case "GranteeType": {
                return Optional.ofNullable(clazz.cast(this.granteeTypeAsString()));
            }
            case "PermissionValues": {
                return Optional.ofNullable(clazz.cast(this.permissionValuesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Permission, T> g) {
        return obj -> g.apply((Permission)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String granteeId;
        private String granteeType;
        private List<String> permissionValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Permission model) {
            this.granteeId(model.granteeId);
            this.granteeType(model.granteeType);
            this.permissionValuesWithStrings(model.permissionValues);
        }

        public final String getGranteeId() {
            return this.granteeId;
        }

        @Override
        public final Builder granteeId(String granteeId) {
            this.granteeId = granteeId;
            return this;
        }

        public final void setGranteeId(String granteeId) {
            this.granteeId = granteeId;
        }

        public final String getGranteeTypeAsString() {
            return this.granteeType;
        }

        @Override
        public final Builder granteeType(String granteeType) {
            this.granteeType = granteeType;
            return this;
        }

        @Override
        public final Builder granteeType(MemberType granteeType) {
            this.granteeType(granteeType == null ? null : granteeType.toString());
            return this;
        }

        public final void setGranteeType(String granteeType) {
            this.granteeType = granteeType;
        }

        public final Collection<String> getPermissionValuesAsStrings() {
            return this.permissionValues;
        }

        @Override
        public final Builder permissionValuesWithStrings(Collection<String> permissionValues) {
            this.permissionValues = PermissionValuesCopier.copy(permissionValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissionValuesWithStrings(String ... permissionValues) {
            this.permissionValuesWithStrings(Arrays.asList(permissionValues));
            return this;
        }

        @Override
        public final Builder permissionValues(Collection<PermissionType> permissionValues) {
            this.permissionValues = PermissionValuesCopier.copyEnumToString(permissionValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissionValues(PermissionType ... permissionValues) {
            this.permissionValues(Arrays.asList(permissionValues));
            return this;
        }

        public final void setPermissionValuesWithStrings(Collection<String> permissionValues) {
            this.permissionValues = PermissionValuesCopier.copy(permissionValues);
        }

        public Permission build() {
            return new Permission(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Permission> {
        public Builder granteeId(String var1);

        public Builder granteeType(String var1);

        public Builder granteeType(MemberType var1);

        public Builder permissionValuesWithStrings(Collection<String> var1);

        public Builder permissionValuesWithStrings(String ... var1);

        public Builder permissionValues(Collection<PermissionType> var1);

        public Builder permissionValues(PermissionType ... var1);
    }
}

