/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workmail.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.workmail.WorkMailClient;
import software.amazon.awssdk.services.workmail.model.ListGroupsRequest;
import software.amazon.awssdk.services.workmail.model.ListGroupsResponse;

public class ListGroupsIterable
implements SdkIterable<ListGroupsResponse> {
    private final WorkMailClient client;
    private final ListGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListGroupsIterable(WorkMailClient client, ListGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListGroupsResponseFetcher();
    }

    public Iterator<ListGroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListGroupsResponseFetcher
    implements SyncPageFetcher<ListGroupsResponse> {
        private ListGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListGroupsResponse nextPage(ListGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListGroupsIterable.this.client.listGroups(ListGroupsIterable.this.firstRequest);
            }
            return ListGroupsIterable.this.client.listGroups((ListGroupsRequest)((Object)ListGroupsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

