/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workmailmessageflow;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.sync.ResponseTransformer;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.workmailmessageflow.WorkMailMessageFlowClient;
import software.amazon.awssdk.services.workmailmessageflow.WorkMailMessageFlowServiceClientConfiguration;
import software.amazon.awssdk.services.workmailmessageflow.internal.WorkMailMessageFlowServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.workmailmessageflow.model.GetRawMessageContentRequest;
import software.amazon.awssdk.services.workmailmessageflow.model.GetRawMessageContentResponse;
import software.amazon.awssdk.services.workmailmessageflow.model.InvalidContentLocationException;
import software.amazon.awssdk.services.workmailmessageflow.model.MessageFrozenException;
import software.amazon.awssdk.services.workmailmessageflow.model.MessageRejectedException;
import software.amazon.awssdk.services.workmailmessageflow.model.PutRawMessageContentRequest;
import software.amazon.awssdk.services.workmailmessageflow.model.PutRawMessageContentResponse;
import software.amazon.awssdk.services.workmailmessageflow.model.ResourceNotFoundException;
import software.amazon.awssdk.services.workmailmessageflow.model.WorkMailMessageFlowException;
import software.amazon.awssdk.services.workmailmessageflow.transform.GetRawMessageContentRequestMarshaller;
import software.amazon.awssdk.services.workmailmessageflow.transform.PutRawMessageContentRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultWorkMailMessageFlowClient
implements WorkMailMessageFlowClient {
    private static final Logger log = Logger.loggerFor(DefaultWorkMailMessageFlowClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.REST_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultWorkMailMessageFlowClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"WorkMailMessageFlow#2.32.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <ReturnT> ReturnT getRawMessageContent(GetRawMessageContentRequest getRawMessageContentRequest, ResponseTransformer<GetRawMessageContentResponse, ReturnT> responseTransformer) throws ResourceNotFoundException, AwsServiceException, SdkClientException, WorkMailMessageFlowException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(true).isPayloadJson(false).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRawMessageContentResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidContentLocation": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContentLocation").exceptionBuilderSupplier(InvalidContentLocationException::builder).build());
                }
                case "MessageFrozen": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageFrozen").exceptionBuilderSupplier(MessageFrozenException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getRawMessageContentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWorkMailMessageFlowClient.resolveMetricPublishers(clientConfiguration, getRawMessageContentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkMailMessageFlow");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRawMessageContent");
            Object object = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRawMessageContent").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getRawMessageContentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withResponseTransformer(responseTransformer).withMarshaller((Marshaller)new GetRawMessageContentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)), responseTransformer);
            return (ReturnT)object;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkMailMessageFlowClient.lambda$getRawMessageContent$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutRawMessageContentResponse putRawMessageContent(PutRawMessageContentRequest putRawMessageContentRequest) throws ResourceNotFoundException, InvalidContentLocationException, MessageRejectedException, MessageFrozenException, AwsServiceException, SdkClientException, WorkMailMessageFlowException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutRawMessageContentResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "InvalidContentLocation": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidContentLocation").exceptionBuilderSupplier(InvalidContentLocationException::builder).build());
                }
                case "MessageFrozen": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageFrozen").exceptionBuilderSupplier(MessageFrozenException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(404)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "MessageRejected": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MessageRejected").exceptionBuilderSupplier(MessageRejectedException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putRawMessageContentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultWorkMailMessageFlowClient.resolveMetricPublishers(clientConfiguration, putRawMessageContentRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"WorkMailMessageFlow");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutRawMessageContent");
            PutRawMessageContentResponse putRawMessageContentResponse = (PutRawMessageContentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutRawMessageContent").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putRawMessageContentRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutRawMessageContentRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putRawMessageContentResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultWorkMailMessageFlowClient.lambda$putRawMessageContent$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    public final String serviceName() {
        return "workmailmessageflow";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        WorkMailMessageFlowServiceClientConfigurationBuilder serviceConfigBuilder = new WorkMailMessageFlowServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(WorkMailMessageFlowException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1");
    }

    @Override
    public final WorkMailMessageFlowServiceClientConfiguration serviceClientConfiguration() {
        return new WorkMailMessageFlowServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$putRawMessageContent$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRawMessageContent$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

