/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workmailmessageflow.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the MIME content of the updated email message as an S3 object. All MIME content must meet the following
 * criteria:
 * </p>
 * <ul>
 * <li>
 * <p>
 * Each part of a multipart MIME message must be formatted properly.
 * </p>
 * </li>
 * <li>
 * <p>
 * Attachments must be of a content type that Amazon SES supports. For more information, see <a
 * href="https://docs.aws.amazon.com/ses/latest/DeveloperGuide/mime-types-appendix.html">Unsupported Attachment
 * Types</a>.
 * </p>
 * </li>
 * <li>
 * <p>
 * If any of the MIME parts in a message contain content that is outside of the 7-bit ASCII character range, we
 * recommend encoding that content.
 * </p>
 * </li>
 * <li>
 * <p>
 * Per <a href="https://tools.ietf.org/html/rfc5321#section-4.5.3.1.6">RFC 5321</a>, the maximum length of each line of
 * text, including the &lt;CRLF&gt;, must not exceed 1,000 characters.
 * </p>
 * </li>
 * <li>
 * <p>
 * The message must contain all the required header fields. Check the returned error message for more information.
 * </p>
 * </li>
 * <li>
 * <p>
 * The value of immutable headers must remain unchanged. Check the returned error message for more information.
 * </p>
 * </li>
 * <li>
 * <p>
 * Certain unique headers can only appear once. Check the returned error message for more information.
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RawMessageContent implements SdkPojo, Serializable,
        ToCopyableBuilder<RawMessageContent.Builder, RawMessageContent> {
    private static final SdkField<S3Reference> S3_REFERENCE_FIELD = SdkField.<S3Reference> builder(MarshallingType.SDK_POJO)
            .memberName("s3Reference").getter(getter(RawMessageContent::s3Reference)).setter(setter(Builder::s3Reference))
            .constructor(S3Reference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Reference").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_REFERENCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final S3Reference s3Reference;

    private RawMessageContent(BuilderImpl builder) {
        this.s3Reference = builder.s3Reference;
    }

    /**
     * <p>
     * The S3 reference of an email message.
     * </p>
     * 
     * @return The S3 reference of an email message.
     */
    public final S3Reference s3Reference() {
        return s3Reference;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3Reference());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RawMessageContent)) {
            return false;
        }
        RawMessageContent other = (RawMessageContent) obj;
        return Objects.equals(s3Reference(), other.s3Reference());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RawMessageContent").add("S3Reference", s3Reference()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "s3Reference":
            return Optional.ofNullable(clazz.cast(s3Reference()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("s3Reference", S3_REFERENCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RawMessageContent, T> g) {
        return obj -> g.apply((RawMessageContent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RawMessageContent> {
        /**
         * <p>
         * The S3 reference of an email message.
         * </p>
         * 
         * @param s3Reference
         *        The S3 reference of an email message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Reference(S3Reference s3Reference);

        /**
         * <p>
         * The S3 reference of an email message.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3Reference.Builder} avoiding the need to
         * create one manually via {@link S3Reference#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3Reference.Builder#build()} is called immediately and its result
         * is passed to {@link #s3Reference(S3Reference)}.
         * 
         * @param s3Reference
         *        a consumer that will call methods on {@link S3Reference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Reference(S3Reference)
         */
        default Builder s3Reference(Consumer<S3Reference.Builder> s3Reference) {
            return s3Reference(S3Reference.builder().applyMutation(s3Reference).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private S3Reference s3Reference;

        private BuilderImpl() {
        }

        private BuilderImpl(RawMessageContent model) {
            s3Reference(model.s3Reference);
        }

        public final S3Reference.Builder getS3Reference() {
            return s3Reference != null ? s3Reference.toBuilder() : null;
        }

        public final void setS3Reference(S3Reference.BuilderImpl s3Reference) {
            this.s3Reference = s3Reference != null ? s3Reference.build() : null;
        }

        @Override
        public final Builder s3Reference(S3Reference s3Reference) {
            this.s3Reference = s3Reference;
            return this;
        }

        @Override
        public RawMessageContent build() {
            return new RawMessageContent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
