/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspacesinstances;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.workspacesinstances.model.AssociateVolumeRequest;
import software.amazon.awssdk.services.workspacesinstances.model.AssociateVolumeResponse;
import software.amazon.awssdk.services.workspacesinstances.model.CreateVolumeRequest;
import software.amazon.awssdk.services.workspacesinstances.model.CreateVolumeResponse;
import software.amazon.awssdk.services.workspacesinstances.model.CreateWorkspaceInstanceRequest;
import software.amazon.awssdk.services.workspacesinstances.model.CreateWorkspaceInstanceResponse;
import software.amazon.awssdk.services.workspacesinstances.model.DeleteVolumeRequest;
import software.amazon.awssdk.services.workspacesinstances.model.DeleteVolumeResponse;
import software.amazon.awssdk.services.workspacesinstances.model.DeleteWorkspaceInstanceRequest;
import software.amazon.awssdk.services.workspacesinstances.model.DeleteWorkspaceInstanceResponse;
import software.amazon.awssdk.services.workspacesinstances.model.DisassociateVolumeRequest;
import software.amazon.awssdk.services.workspacesinstances.model.DisassociateVolumeResponse;
import software.amazon.awssdk.services.workspacesinstances.model.GetWorkspaceInstanceRequest;
import software.amazon.awssdk.services.workspacesinstances.model.GetWorkspaceInstanceResponse;
import software.amazon.awssdk.services.workspacesinstances.model.ListInstanceTypesRequest;
import software.amazon.awssdk.services.workspacesinstances.model.ListInstanceTypesResponse;
import software.amazon.awssdk.services.workspacesinstances.model.ListRegionsRequest;
import software.amazon.awssdk.services.workspacesinstances.model.ListRegionsResponse;
import software.amazon.awssdk.services.workspacesinstances.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.workspacesinstances.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.workspacesinstances.model.ListWorkspaceInstancesRequest;
import software.amazon.awssdk.services.workspacesinstances.model.ListWorkspaceInstancesResponse;
import software.amazon.awssdk.services.workspacesinstances.model.TagResourceRequest;
import software.amazon.awssdk.services.workspacesinstances.model.TagResourceResponse;
import software.amazon.awssdk.services.workspacesinstances.model.UntagResourceRequest;
import software.amazon.awssdk.services.workspacesinstances.model.UntagResourceResponse;
import software.amazon.awssdk.services.workspacesinstances.paginators.ListInstanceTypesPublisher;
import software.amazon.awssdk.services.workspacesinstances.paginators.ListRegionsPublisher;
import software.amazon.awssdk.services.workspacesinstances.paginators.ListWorkspaceInstancesPublisher;

/**
 * Service client for accessing Amazon Workspaces Instances asynchronously. This can be created using the static
 * {@link #builder()} method.The asynchronous client performs non-blocking I/O when configured with any
 * {@code SdkAsyncHttpClient} supported in the SDK. However, full non-blocking is not guaranteed as the async client may
 * perform blocking calls in some cases such as credentials retrieval and endpoint discovery as part of the async API
 * call.
 *
 * <p>
 * Amazon WorkSpaces Instances provides an API framework for managing virtual workspace environments across multiple AWS
 * regions, enabling programmatic creation and configuration of desktop infrastructure.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface WorkspacesInstancesAsyncClient extends AwsClient {
    String SERVICE_NAME = "workspaces-instances";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "workspaces-instances";

    /**
     * <p>
     * Attaches a volume to a WorkSpace Instance.
     * </p>
     *
     * @param associateVolumeRequest
     *        Specifies volume attachment parameters.
     * @return A Java Future containing the result of the AssociateVolume operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException Indicates invalid input parameters in the request.</li>
     *         <li>AccessDeniedException Indicates insufficient permissions to perform the requested action.</li>
     *         <li>ThrottlingException Indicates the request rate has exceeded limits.</li>
     *         <li>ResourceNotFoundException Indicates the requested resource could not be found.</li>
     *         <li>InternalServerException Indicates an unexpected server-side error occurred.</li>
     *         <li>ConflictException Signals a conflict with the current state of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkspacesInstancesException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample WorkspacesInstancesAsyncClient.AssociateVolume
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-instances-2022-07-26/AssociateVolume"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateVolumeResponse> associateVolume(AssociateVolumeRequest associateVolumeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attaches a volume to a WorkSpace Instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateVolumeRequest.Builder} avoiding the need
     * to create one manually via {@link AssociateVolumeRequest#builder()}
     * </p>
     *
     * @param associateVolumeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesinstances.model.AssociateVolumeRequest.Builder} to create
     *        a request. Specifies volume attachment parameters.
     * @return A Java Future containing the result of the AssociateVolume operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException Indicates invalid input parameters in the request.</li>
     *         <li>AccessDeniedException Indicates insufficient permissions to perform the requested action.</li>
     *         <li>ThrottlingException Indicates the request rate has exceeded limits.</li>
     *         <li>ResourceNotFoundException Indicates the requested resource could not be found.</li>
     *         <li>InternalServerException Indicates an unexpected server-side error occurred.</li>
     *         <li>ConflictException Signals a conflict with the current state of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkspacesInstancesException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample WorkspacesInstancesAsyncClient.AssociateVolume
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-instances-2022-07-26/AssociateVolume"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateVolumeResponse> associateVolume(
            Consumer<AssociateVolumeRequest.Builder> associateVolumeRequest) {
        return associateVolume(AssociateVolumeRequest.builder().applyMutation(associateVolumeRequest).build());
    }

    /**
     * <p>
     * Creates a new volume for WorkSpace Instances.
     * </p>
     *
     * @param createVolumeRequest
     *        Specifies volume creation parameters.
     * @return A Java Future containing the result of the CreateVolume operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException Indicates invalid input parameters in the request.</li>
     *         <li>AccessDeniedException Indicates insufficient permissions to perform the requested action.</li>
     *         <li>ThrottlingException Indicates the request rate has exceeded limits.</li>
     *         <li>InternalServerException Indicates an unexpected server-side error occurred.</li>
     *         <li>ServiceQuotaExceededException Indicates that a service quota has been exceeded.</li>
     *         <li>ConflictException Signals a conflict with the current state of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkspacesInstancesException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample WorkspacesInstancesAsyncClient.CreateVolume
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-instances-2022-07-26/CreateVolume"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateVolumeResponse> createVolume(CreateVolumeRequest createVolumeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new volume for WorkSpace Instances.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateVolumeRequest.Builder} avoiding the need to
     * create one manually via {@link CreateVolumeRequest#builder()}
     * </p>
     *
     * @param createVolumeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesinstances.model.CreateVolumeRequest.Builder} to create a
     *        request. Specifies volume creation parameters.
     * @return A Java Future containing the result of the CreateVolume operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException Indicates invalid input parameters in the request.</li>
     *         <li>AccessDeniedException Indicates insufficient permissions to perform the requested action.</li>
     *         <li>ThrottlingException Indicates the request rate has exceeded limits.</li>
     *         <li>InternalServerException Indicates an unexpected server-side error occurred.</li>
     *         <li>ServiceQuotaExceededException Indicates that a service quota has been exceeded.</li>
     *         <li>ConflictException Signals a conflict with the current state of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkspacesInstancesException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample WorkspacesInstancesAsyncClient.CreateVolume
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-instances-2022-07-26/CreateVolume"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateVolumeResponse> createVolume(Consumer<CreateVolumeRequest.Builder> createVolumeRequest) {
        return createVolume(CreateVolumeRequest.builder().applyMutation(createVolumeRequest).build());
    }

    /**
     * <p>
     * Launches a new WorkSpace Instance with specified configuration parameters, enabling programmatic workspace
     * deployment.
     * </p>
     *
     * @param createWorkspaceInstanceRequest
     *        Defines the configuration parameters for creating a new WorkSpaces Instance.
     * @return A Java Future containing the result of the CreateWorkspaceInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException Indicates invalid input parameters in the request.</li>
     *         <li>AccessDeniedException Indicates insufficient permissions to perform the requested action.</li>
     *         <li>ThrottlingException Indicates the request rate has exceeded limits.</li>
     *         <li>InternalServerException Indicates an unexpected server-side error occurred.</li>
     *         <li>ServiceQuotaExceededException Indicates that a service quota has been exceeded.</li>
     *         <li>ConflictException Signals a conflict with the current state of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkspacesInstancesException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample WorkspacesInstancesAsyncClient.CreateWorkspaceInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-instances-2022-07-26/CreateWorkspaceInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateWorkspaceInstanceResponse> createWorkspaceInstance(
            CreateWorkspaceInstanceRequest createWorkspaceInstanceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Launches a new WorkSpace Instance with specified configuration parameters, enabling programmatic workspace
     * deployment.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateWorkspaceInstanceRequest.Builder} avoiding
     * the need to create one manually via {@link CreateWorkspaceInstanceRequest#builder()}
     * </p>
     *
     * @param createWorkspaceInstanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesinstances.model.CreateWorkspaceInstanceRequest.Builder}
     *        to create a request. Defines the configuration parameters for creating a new WorkSpaces Instance.
     * @return A Java Future containing the result of the CreateWorkspaceInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException Indicates invalid input parameters in the request.</li>
     *         <li>AccessDeniedException Indicates insufficient permissions to perform the requested action.</li>
     *         <li>ThrottlingException Indicates the request rate has exceeded limits.</li>
     *         <li>InternalServerException Indicates an unexpected server-side error occurred.</li>
     *         <li>ServiceQuotaExceededException Indicates that a service quota has been exceeded.</li>
     *         <li>ConflictException Signals a conflict with the current state of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkspacesInstancesException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample WorkspacesInstancesAsyncClient.CreateWorkspaceInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-instances-2022-07-26/CreateWorkspaceInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateWorkspaceInstanceResponse> createWorkspaceInstance(
            Consumer<CreateWorkspaceInstanceRequest.Builder> createWorkspaceInstanceRequest) {
        return createWorkspaceInstance(CreateWorkspaceInstanceRequest.builder().applyMutation(createWorkspaceInstanceRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a specified volume.
     * </p>
     *
     * @param deleteVolumeRequest
     *        Specifies the volume to delete.
     * @return A Java Future containing the result of the DeleteVolume operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException Indicates invalid input parameters in the request.</li>
     *         <li>AccessDeniedException Indicates insufficient permissions to perform the requested action.</li>
     *         <li>ThrottlingException Indicates the request rate has exceeded limits.</li>
     *         <li>ResourceNotFoundException Indicates the requested resource could not be found.</li>
     *         <li>InternalServerException Indicates an unexpected server-side error occurred.</li>
     *         <li>ConflictException Signals a conflict with the current state of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkspacesInstancesException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample WorkspacesInstancesAsyncClient.DeleteVolume
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-instances-2022-07-26/DeleteVolume"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteVolumeResponse> deleteVolume(DeleteVolumeRequest deleteVolumeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a specified volume.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteVolumeRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteVolumeRequest#builder()}
     * </p>
     *
     * @param deleteVolumeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesinstances.model.DeleteVolumeRequest.Builder} to create a
     *        request. Specifies the volume to delete.
     * @return A Java Future containing the result of the DeleteVolume operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException Indicates invalid input parameters in the request.</li>
     *         <li>AccessDeniedException Indicates insufficient permissions to perform the requested action.</li>
     *         <li>ThrottlingException Indicates the request rate has exceeded limits.</li>
     *         <li>ResourceNotFoundException Indicates the requested resource could not be found.</li>
     *         <li>InternalServerException Indicates an unexpected server-side error occurred.</li>
     *         <li>ConflictException Signals a conflict with the current state of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkspacesInstancesException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample WorkspacesInstancesAsyncClient.DeleteVolume
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-instances-2022-07-26/DeleteVolume"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteVolumeResponse> deleteVolume(Consumer<DeleteVolumeRequest.Builder> deleteVolumeRequest) {
        return deleteVolume(DeleteVolumeRequest.builder().applyMutation(deleteVolumeRequest).build());
    }

    /**
     * <p>
     * Deletes the specified WorkSpace
     * </p>
     *
     * @param deleteWorkspaceInstanceRequest
     *        The WorkSpace to delete
     * @return A Java Future containing the result of the DeleteWorkspaceInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException Indicates invalid input parameters in the request.</li>
     *         <li>AccessDeniedException Indicates insufficient permissions to perform the requested action.</li>
     *         <li>ThrottlingException Indicates the request rate has exceeded limits.</li>
     *         <li>ResourceNotFoundException Indicates the requested resource could not be found.</li>
     *         <li>InternalServerException Indicates an unexpected server-side error occurred.</li>
     *         <li>ConflictException Signals a conflict with the current state of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkspacesInstancesException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample WorkspacesInstancesAsyncClient.DeleteWorkspaceInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-instances-2022-07-26/DeleteWorkspaceInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteWorkspaceInstanceResponse> deleteWorkspaceInstance(
            DeleteWorkspaceInstanceRequest deleteWorkspaceInstanceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified WorkSpace
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteWorkspaceInstanceRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteWorkspaceInstanceRequest#builder()}
     * </p>
     *
     * @param deleteWorkspaceInstanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesinstances.model.DeleteWorkspaceInstanceRequest.Builder}
     *        to create a request. The WorkSpace to delete
     * @return A Java Future containing the result of the DeleteWorkspaceInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException Indicates invalid input parameters in the request.</li>
     *         <li>AccessDeniedException Indicates insufficient permissions to perform the requested action.</li>
     *         <li>ThrottlingException Indicates the request rate has exceeded limits.</li>
     *         <li>ResourceNotFoundException Indicates the requested resource could not be found.</li>
     *         <li>InternalServerException Indicates an unexpected server-side error occurred.</li>
     *         <li>ConflictException Signals a conflict with the current state of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkspacesInstancesException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample WorkspacesInstancesAsyncClient.DeleteWorkspaceInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-instances-2022-07-26/DeleteWorkspaceInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteWorkspaceInstanceResponse> deleteWorkspaceInstance(
            Consumer<DeleteWorkspaceInstanceRequest.Builder> deleteWorkspaceInstanceRequest) {
        return deleteWorkspaceInstance(DeleteWorkspaceInstanceRequest.builder().applyMutation(deleteWorkspaceInstanceRequest)
                .build());
    }

    /**
     * <p>
     * Detaches a volume from a WorkSpace Instance.
     * </p>
     *
     * @param disassociateVolumeRequest
     *        Specifies volume detachment parameters.
     * @return A Java Future containing the result of the DisassociateVolume operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException Indicates invalid input parameters in the request.</li>
     *         <li>AccessDeniedException Indicates insufficient permissions to perform the requested action.</li>
     *         <li>ThrottlingException Indicates the request rate has exceeded limits.</li>
     *         <li>ResourceNotFoundException Indicates the requested resource could not be found.</li>
     *         <li>InternalServerException Indicates an unexpected server-side error occurred.</li>
     *         <li>ConflictException Signals a conflict with the current state of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkspacesInstancesException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample WorkspacesInstancesAsyncClient.DisassociateVolume
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-instances-2022-07-26/DisassociateVolume"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateVolumeResponse> disassociateVolume(DisassociateVolumeRequest disassociateVolumeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Detaches a volume from a WorkSpace Instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateVolumeRequest.Builder} avoiding the
     * need to create one manually via {@link DisassociateVolumeRequest#builder()}
     * </p>
     *
     * @param disassociateVolumeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesinstances.model.DisassociateVolumeRequest.Builder} to
     *        create a request. Specifies volume detachment parameters.
     * @return A Java Future containing the result of the DisassociateVolume operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException Indicates invalid input parameters in the request.</li>
     *         <li>AccessDeniedException Indicates insufficient permissions to perform the requested action.</li>
     *         <li>ThrottlingException Indicates the request rate has exceeded limits.</li>
     *         <li>ResourceNotFoundException Indicates the requested resource could not be found.</li>
     *         <li>InternalServerException Indicates an unexpected server-side error occurred.</li>
     *         <li>ConflictException Signals a conflict with the current state of the resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkspacesInstancesException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample WorkspacesInstancesAsyncClient.DisassociateVolume
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-instances-2022-07-26/DisassociateVolume"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateVolumeResponse> disassociateVolume(
            Consumer<DisassociateVolumeRequest.Builder> disassociateVolumeRequest) {
        return disassociateVolume(DisassociateVolumeRequest.builder().applyMutation(disassociateVolumeRequest).build());
    }

    /**
     * <p>
     * Retrieves detailed information about a specific WorkSpace Instance.
     * </p>
     *
     * @param getWorkspaceInstanceRequest
     *        Identifies the WorkSpaces Instance to retrieve detailed information for.
     * @return A Java Future containing the result of the GetWorkspaceInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException Indicates invalid input parameters in the request.</li>
     *         <li>AccessDeniedException Indicates insufficient permissions to perform the requested action.</li>
     *         <li>ThrottlingException Indicates the request rate has exceeded limits.</li>
     *         <li>ResourceNotFoundException Indicates the requested resource could not be found.</li>
     *         <li>InternalServerException Indicates an unexpected server-side error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkspacesInstancesException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample WorkspacesInstancesAsyncClient.GetWorkspaceInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-instances-2022-07-26/GetWorkspaceInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetWorkspaceInstanceResponse> getWorkspaceInstance(
            GetWorkspaceInstanceRequest getWorkspaceInstanceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves detailed information about a specific WorkSpace Instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWorkspaceInstanceRequest.Builder} avoiding the
     * need to create one manually via {@link GetWorkspaceInstanceRequest#builder()}
     * </p>
     *
     * @param getWorkspaceInstanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesinstances.model.GetWorkspaceInstanceRequest.Builder} to
     *        create a request. Identifies the WorkSpaces Instance to retrieve detailed information for.
     * @return A Java Future containing the result of the GetWorkspaceInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException Indicates invalid input parameters in the request.</li>
     *         <li>AccessDeniedException Indicates insufficient permissions to perform the requested action.</li>
     *         <li>ThrottlingException Indicates the request rate has exceeded limits.</li>
     *         <li>ResourceNotFoundException Indicates the requested resource could not be found.</li>
     *         <li>InternalServerException Indicates an unexpected server-side error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkspacesInstancesException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample WorkspacesInstancesAsyncClient.GetWorkspaceInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-instances-2022-07-26/GetWorkspaceInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetWorkspaceInstanceResponse> getWorkspaceInstance(
            Consumer<GetWorkspaceInstanceRequest.Builder> getWorkspaceInstanceRequest) {
        return getWorkspaceInstance(GetWorkspaceInstanceRequest.builder().applyMutation(getWorkspaceInstanceRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of instance types supported by Amazon WorkSpaces Instances, enabling precise workspace
     * infrastructure configuration.
     * </p>
     *
     * @param listInstanceTypesRequest
     *        Defines input parameters for retrieving supported WorkSpaces Instances instance types.
     * @return A Java Future containing the result of the ListInstanceTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException Indicates invalid input parameters in the request.</li>
     *         <li>AccessDeniedException Indicates insufficient permissions to perform the requested action.</li>
     *         <li>ThrottlingException Indicates the request rate has exceeded limits.</li>
     *         <li>InternalServerException Indicates an unexpected server-side error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkspacesInstancesException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample WorkspacesInstancesAsyncClient.ListInstanceTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-instances-2022-07-26/ListInstanceTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListInstanceTypesResponse> listInstanceTypes(ListInstanceTypesRequest listInstanceTypesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of instance types supported by Amazon WorkSpaces Instances, enabling precise workspace
     * infrastructure configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInstanceTypesRequest.Builder} avoiding the need
     * to create one manually via {@link ListInstanceTypesRequest#builder()}
     * </p>
     *
     * @param listInstanceTypesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesinstances.model.ListInstanceTypesRequest.Builder} to
     *        create a request. Defines input parameters for retrieving supported WorkSpaces Instances instance types.
     * @return A Java Future containing the result of the ListInstanceTypes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException Indicates invalid input parameters in the request.</li>
     *         <li>AccessDeniedException Indicates insufficient permissions to perform the requested action.</li>
     *         <li>ThrottlingException Indicates the request rate has exceeded limits.</li>
     *         <li>InternalServerException Indicates an unexpected server-side error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkspacesInstancesException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample WorkspacesInstancesAsyncClient.ListInstanceTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-instances-2022-07-26/ListInstanceTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListInstanceTypesResponse> listInstanceTypes(
            Consumer<ListInstanceTypesRequest.Builder> listInstanceTypesRequest) {
        return listInstanceTypes(ListInstanceTypesRequest.builder().applyMutation(listInstanceTypesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listInstanceTypes(software.amazon.awssdk.services.workspacesinstances.model.ListInstanceTypesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesinstances.paginators.ListInstanceTypesPublisher publisher = client.listInstanceTypesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesinstances.paginators.ListInstanceTypesPublisher publisher = client.listInstanceTypesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workspacesinstances.model.ListInstanceTypesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workspacesinstances.model.ListInstanceTypesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInstanceTypes(software.amazon.awssdk.services.workspacesinstances.model.ListInstanceTypesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listInstanceTypesRequest
     *        Defines input parameters for retrieving supported WorkSpaces Instances instance types.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException Indicates invalid input parameters in the request.</li>
     *         <li>AccessDeniedException Indicates insufficient permissions to perform the requested action.</li>
     *         <li>ThrottlingException Indicates the request rate has exceeded limits.</li>
     *         <li>InternalServerException Indicates an unexpected server-side error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkspacesInstancesException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample WorkspacesInstancesAsyncClient.ListInstanceTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-instances-2022-07-26/ListInstanceTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInstanceTypesPublisher listInstanceTypesPaginator(ListInstanceTypesRequest listInstanceTypesRequest) {
        return new ListInstanceTypesPublisher(this, listInstanceTypesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listInstanceTypes(software.amazon.awssdk.services.workspacesinstances.model.ListInstanceTypesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesinstances.paginators.ListInstanceTypesPublisher publisher = client.listInstanceTypesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesinstances.paginators.ListInstanceTypesPublisher publisher = client.listInstanceTypesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workspacesinstances.model.ListInstanceTypesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workspacesinstances.model.ListInstanceTypesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInstanceTypes(software.amazon.awssdk.services.workspacesinstances.model.ListInstanceTypesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInstanceTypesRequest.Builder} avoiding the need
     * to create one manually via {@link ListInstanceTypesRequest#builder()}
     * </p>
     *
     * @param listInstanceTypesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesinstances.model.ListInstanceTypesRequest.Builder} to
     *        create a request. Defines input parameters for retrieving supported WorkSpaces Instances instance types.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException Indicates invalid input parameters in the request.</li>
     *         <li>AccessDeniedException Indicates insufficient permissions to perform the requested action.</li>
     *         <li>ThrottlingException Indicates the request rate has exceeded limits.</li>
     *         <li>InternalServerException Indicates an unexpected server-side error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkspacesInstancesException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample WorkspacesInstancesAsyncClient.ListInstanceTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-instances-2022-07-26/ListInstanceTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListInstanceTypesPublisher listInstanceTypesPaginator(
            Consumer<ListInstanceTypesRequest.Builder> listInstanceTypesRequest) {
        return listInstanceTypesPaginator(ListInstanceTypesRequest.builder().applyMutation(listInstanceTypesRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of AWS regions supported by Amazon WorkSpaces Instances, enabling region discovery for workspace
     * deployments.
     * </p>
     *
     * @param listRegionsRequest
     *        Defines input parameters for retrieving supported WorkSpaces Instances regions.
     * @return A Java Future containing the result of the ListRegions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException Indicates invalid input parameters in the request.</li>
     *         <li>AccessDeniedException Indicates insufficient permissions to perform the requested action.</li>
     *         <li>ThrottlingException Indicates the request rate has exceeded limits.</li>
     *         <li>InternalServerException Indicates an unexpected server-side error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkspacesInstancesException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample WorkspacesInstancesAsyncClient.ListRegions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-instances-2022-07-26/ListRegions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListRegionsResponse> listRegions(ListRegionsRequest listRegionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of AWS regions supported by Amazon WorkSpaces Instances, enabling region discovery for workspace
     * deployments.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRegionsRequest.Builder} avoiding the need to
     * create one manually via {@link ListRegionsRequest#builder()}
     * </p>
     *
     * @param listRegionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesinstances.model.ListRegionsRequest.Builder} to create a
     *        request. Defines input parameters for retrieving supported WorkSpaces Instances regions.
     * @return A Java Future containing the result of the ListRegions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException Indicates invalid input parameters in the request.</li>
     *         <li>AccessDeniedException Indicates insufficient permissions to perform the requested action.</li>
     *         <li>ThrottlingException Indicates the request rate has exceeded limits.</li>
     *         <li>InternalServerException Indicates an unexpected server-side error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkspacesInstancesException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample WorkspacesInstancesAsyncClient.ListRegions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-instances-2022-07-26/ListRegions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListRegionsResponse> listRegions(Consumer<ListRegionsRequest.Builder> listRegionsRequest) {
        return listRegions(ListRegionsRequest.builder().applyMutation(listRegionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listRegions(software.amazon.awssdk.services.workspacesinstances.model.ListRegionsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesinstances.paginators.ListRegionsPublisher publisher = client.listRegionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesinstances.paginators.ListRegionsPublisher publisher = client.listRegionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workspacesinstances.model.ListRegionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workspacesinstances.model.ListRegionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRegions(software.amazon.awssdk.services.workspacesinstances.model.ListRegionsRequest)} operation.</b>
     * </p>
     *
     * @param listRegionsRequest
     *        Defines input parameters for retrieving supported WorkSpaces Instances regions.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException Indicates invalid input parameters in the request.</li>
     *         <li>AccessDeniedException Indicates insufficient permissions to perform the requested action.</li>
     *         <li>ThrottlingException Indicates the request rate has exceeded limits.</li>
     *         <li>InternalServerException Indicates an unexpected server-side error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkspacesInstancesException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample WorkspacesInstancesAsyncClient.ListRegions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-instances-2022-07-26/ListRegions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRegionsPublisher listRegionsPaginator(ListRegionsRequest listRegionsRequest) {
        return new ListRegionsPublisher(this, listRegionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listRegions(software.amazon.awssdk.services.workspacesinstances.model.ListRegionsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesinstances.paginators.ListRegionsPublisher publisher = client.listRegionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesinstances.paginators.ListRegionsPublisher publisher = client.listRegionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workspacesinstances.model.ListRegionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workspacesinstances.model.ListRegionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRegions(software.amazon.awssdk.services.workspacesinstances.model.ListRegionsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRegionsRequest.Builder} avoiding the need to
     * create one manually via {@link ListRegionsRequest#builder()}
     * </p>
     *
     * @param listRegionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesinstances.model.ListRegionsRequest.Builder} to create a
     *        request. Defines input parameters for retrieving supported WorkSpaces Instances regions.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException Indicates invalid input parameters in the request.</li>
     *         <li>AccessDeniedException Indicates insufficient permissions to perform the requested action.</li>
     *         <li>ThrottlingException Indicates the request rate has exceeded limits.</li>
     *         <li>InternalServerException Indicates an unexpected server-side error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkspacesInstancesException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample WorkspacesInstancesAsyncClient.ListRegions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-instances-2022-07-26/ListRegions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRegionsPublisher listRegionsPaginator(Consumer<ListRegionsRequest.Builder> listRegionsRequest) {
        return listRegionsPaginator(ListRegionsRequest.builder().applyMutation(listRegionsRequest).build());
    }

    /**
     * <p>
     * Retrieves tags for a WorkSpace Instance.
     * </p>
     *
     * @param listTagsForResourceRequest
     *        Specifies the WorkSpace Instance to retrieve tags for.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException Indicates invalid input parameters in the request.</li>
     *         <li>AccessDeniedException Indicates insufficient permissions to perform the requested action.</li>
     *         <li>ResourceNotFoundException Indicates the requested resource could not be found.</li>
     *         <li>ThrottlingException Indicates the request rate has exceeded limits.</li>
     *         <li>InternalServerException Indicates an unexpected server-side error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkspacesInstancesException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample WorkspacesInstancesAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-instances-2022-07-26/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves tags for a WorkSpace Instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesinstances.model.ListTagsForResourceRequest.Builder} to
     *        create a request. Specifies the WorkSpace Instance to retrieve tags for.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException Indicates invalid input parameters in the request.</li>
     *         <li>AccessDeniedException Indicates insufficient permissions to perform the requested action.</li>
     *         <li>ResourceNotFoundException Indicates the requested resource could not be found.</li>
     *         <li>ThrottlingException Indicates the request rate has exceeded limits.</li>
     *         <li>InternalServerException Indicates an unexpected server-side error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkspacesInstancesException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample WorkspacesInstancesAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-instances-2022-07-26/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Retrieves a collection of WorkSpaces Instances based on specified filters.
     * </p>
     *
     * @param listWorkspaceInstancesRequest
     *        Defines filters and pagination parameters for retrieving WorkSpaces Instances.
     * @return A Java Future containing the result of the ListWorkspaceInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException Indicates invalid input parameters in the request.</li>
     *         <li>AccessDeniedException Indicates insufficient permissions to perform the requested action.</li>
     *         <li>ThrottlingException Indicates the request rate has exceeded limits.</li>
     *         <li>InternalServerException Indicates an unexpected server-side error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkspacesInstancesException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample WorkspacesInstancesAsyncClient.ListWorkspaceInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-instances-2022-07-26/ListWorkspaceInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListWorkspaceInstancesResponse> listWorkspaceInstances(
            ListWorkspaceInstancesRequest listWorkspaceInstancesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a collection of WorkSpaces Instances based on specified filters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkspaceInstancesRequest.Builder} avoiding the
     * need to create one manually via {@link ListWorkspaceInstancesRequest#builder()}
     * </p>
     *
     * @param listWorkspaceInstancesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesinstances.model.ListWorkspaceInstancesRequest.Builder} to
     *        create a request. Defines filters and pagination parameters for retrieving WorkSpaces Instances.
     * @return A Java Future containing the result of the ListWorkspaceInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException Indicates invalid input parameters in the request.</li>
     *         <li>AccessDeniedException Indicates insufficient permissions to perform the requested action.</li>
     *         <li>ThrottlingException Indicates the request rate has exceeded limits.</li>
     *         <li>InternalServerException Indicates an unexpected server-side error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkspacesInstancesException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample WorkspacesInstancesAsyncClient.ListWorkspaceInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-instances-2022-07-26/ListWorkspaceInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListWorkspaceInstancesResponse> listWorkspaceInstances(
            Consumer<ListWorkspaceInstancesRequest.Builder> listWorkspaceInstancesRequest) {
        return listWorkspaceInstances(ListWorkspaceInstancesRequest.builder().applyMutation(listWorkspaceInstancesRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listWorkspaceInstances(software.amazon.awssdk.services.workspacesinstances.model.ListWorkspaceInstancesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesinstances.paginators.ListWorkspaceInstancesPublisher publisher = client.listWorkspaceInstancesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesinstances.paginators.ListWorkspaceInstancesPublisher publisher = client.listWorkspaceInstancesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workspacesinstances.model.ListWorkspaceInstancesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workspacesinstances.model.ListWorkspaceInstancesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkspaceInstances(software.amazon.awssdk.services.workspacesinstances.model.ListWorkspaceInstancesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listWorkspaceInstancesRequest
     *        Defines filters and pagination parameters for retrieving WorkSpaces Instances.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException Indicates invalid input parameters in the request.</li>
     *         <li>AccessDeniedException Indicates insufficient permissions to perform the requested action.</li>
     *         <li>ThrottlingException Indicates the request rate has exceeded limits.</li>
     *         <li>InternalServerException Indicates an unexpected server-side error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkspacesInstancesException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample WorkspacesInstancesAsyncClient.ListWorkspaceInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-instances-2022-07-26/ListWorkspaceInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWorkspaceInstancesPublisher listWorkspaceInstancesPaginator(
            ListWorkspaceInstancesRequest listWorkspaceInstancesRequest) {
        return new ListWorkspaceInstancesPublisher(this, listWorkspaceInstancesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listWorkspaceInstances(software.amazon.awssdk.services.workspacesinstances.model.ListWorkspaceInstancesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesinstances.paginators.ListWorkspaceInstancesPublisher publisher = client.listWorkspaceInstancesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesinstances.paginators.ListWorkspaceInstancesPublisher publisher = client.listWorkspaceInstancesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workspacesinstances.model.ListWorkspaceInstancesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workspacesinstances.model.ListWorkspaceInstancesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkspaceInstances(software.amazon.awssdk.services.workspacesinstances.model.ListWorkspaceInstancesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkspaceInstancesRequest.Builder} avoiding the
     * need to create one manually via {@link ListWorkspaceInstancesRequest#builder()}
     * </p>
     *
     * @param listWorkspaceInstancesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesinstances.model.ListWorkspaceInstancesRequest.Builder} to
     *        create a request. Defines filters and pagination parameters for retrieving WorkSpaces Instances.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException Indicates invalid input parameters in the request.</li>
     *         <li>AccessDeniedException Indicates insufficient permissions to perform the requested action.</li>
     *         <li>ThrottlingException Indicates the request rate has exceeded limits.</li>
     *         <li>InternalServerException Indicates an unexpected server-side error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkspacesInstancesException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample WorkspacesInstancesAsyncClient.ListWorkspaceInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-instances-2022-07-26/ListWorkspaceInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWorkspaceInstancesPublisher listWorkspaceInstancesPaginator(
            Consumer<ListWorkspaceInstancesRequest.Builder> listWorkspaceInstancesRequest) {
        return listWorkspaceInstancesPaginator(ListWorkspaceInstancesRequest.builder()
                .applyMutation(listWorkspaceInstancesRequest).build());
    }

    /**
     * <p>
     * Adds tags to a WorkSpace Instance.
     * </p>
     *
     * @param tagResourceRequest
     *        Specifies tags to add to a WorkSpace Instance.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException Indicates invalid input parameters in the request.</li>
     *         <li>AccessDeniedException Indicates insufficient permissions to perform the requested action.</li>
     *         <li>ResourceNotFoundException Indicates the requested resource could not be found.</li>
     *         <li>ThrottlingException Indicates the request rate has exceeded limits.</li>
     *         <li>InternalServerException Indicates an unexpected server-side error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkspacesInstancesException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample WorkspacesInstancesAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-instances-2022-07-26/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds tags to a WorkSpace Instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesinstances.model.TagResourceRequest.Builder} to create a
     *        request. Specifies tags to add to a WorkSpace Instance.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException Indicates invalid input parameters in the request.</li>
     *         <li>AccessDeniedException Indicates insufficient permissions to perform the requested action.</li>
     *         <li>ResourceNotFoundException Indicates the requested resource could not be found.</li>
     *         <li>ThrottlingException Indicates the request rate has exceeded limits.</li>
     *         <li>InternalServerException Indicates an unexpected server-side error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkspacesInstancesException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample WorkspacesInstancesAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-instances-2022-07-26/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes tags from a WorkSpace Instance.
     * </p>
     *
     * @param untagResourceRequest
     *        Specifies tags to remove from a WorkSpace Instance.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException Indicates invalid input parameters in the request.</li>
     *         <li>AccessDeniedException Indicates insufficient permissions to perform the requested action.</li>
     *         <li>ResourceNotFoundException Indicates the requested resource could not be found.</li>
     *         <li>ThrottlingException Indicates the request rate has exceeded limits.</li>
     *         <li>InternalServerException Indicates an unexpected server-side error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkspacesInstancesException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample WorkspacesInstancesAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-instances-2022-07-26/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes tags from a WorkSpace Instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesinstances.model.UntagResourceRequest.Builder} to create a
     *        request. Specifies tags to remove from a WorkSpace Instance.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ValidationException Indicates invalid input parameters in the request.</li>
     *         <li>AccessDeniedException Indicates insufficient permissions to perform the requested action.</li>
     *         <li>ResourceNotFoundException Indicates the requested resource could not be found.</li>
     *         <li>ThrottlingException Indicates the request rate has exceeded limits.</li>
     *         <li>InternalServerException Indicates an unexpected server-side error occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkspacesInstancesException Base class for all service exceptions. Unknown exceptions will be thrown
     *         as an instance of this type.</li>
     *         </ul>
     * @sample WorkspacesInstancesAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-instances-2022-07-26/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    @Override
    default WorkspacesInstancesServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link WorkspacesInstancesAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static WorkspacesInstancesAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link WorkspacesInstancesAsyncClient}.
     */
    static WorkspacesInstancesAsyncClientBuilder builder() {
        return new DefaultWorkspacesInstancesAsyncClientBuilder();
    }
}
