/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspacesinstances.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configures CPU-specific settings for WorkSpace Instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CpuOptionsRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<CpuOptionsRequest.Builder, CpuOptionsRequest> {
    private static final SdkField<String> AMD_SEV_SNP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AmdSevSnp").getter(getter(CpuOptionsRequest::amdSevSnpAsString)).setter(setter(Builder::amdSevSnp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmdSevSnp").build()).build();

    private static final SdkField<Integer> CORE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("CoreCount").getter(getter(CpuOptionsRequest::coreCount)).setter(setter(Builder::coreCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoreCount").build()).build();

    private static final SdkField<Integer> THREADS_PER_CORE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ThreadsPerCore").getter(getter(CpuOptionsRequest::threadsPerCore))
            .setter(setter(Builder::threadsPerCore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThreadsPerCore").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AMD_SEV_SNP_FIELD,
            CORE_COUNT_FIELD, THREADS_PER_CORE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String amdSevSnp;

    private final Integer coreCount;

    private final Integer threadsPerCore;

    private CpuOptionsRequest(BuilderImpl builder) {
        this.amdSevSnp = builder.amdSevSnp;
        this.coreCount = builder.coreCount;
        this.threadsPerCore = builder.threadsPerCore;
    }

    /**
     * <p>
     * AMD Secure Encrypted Virtualization configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #amdSevSnp} will
     * return {@link AmdSevSnpEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #amdSevSnpAsString}.
     * </p>
     * 
     * @return AMD Secure Encrypted Virtualization configuration.
     * @see AmdSevSnpEnum
     */
    public final AmdSevSnpEnum amdSevSnp() {
        return AmdSevSnpEnum.fromValue(amdSevSnp);
    }

    /**
     * <p>
     * AMD Secure Encrypted Virtualization configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #amdSevSnp} will
     * return {@link AmdSevSnpEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #amdSevSnpAsString}.
     * </p>
     * 
     * @return AMD Secure Encrypted Virtualization configuration.
     * @see AmdSevSnpEnum
     */
    public final String amdSevSnpAsString() {
        return amdSevSnp;
    }

    /**
     * <p>
     * Number of CPU cores to allocate.
     * </p>
     * 
     * @return Number of CPU cores to allocate.
     */
    public final Integer coreCount() {
        return coreCount;
    }

    /**
     * <p>
     * Number of threads per CPU core.
     * </p>
     * 
     * @return Number of threads per CPU core.
     */
    public final Integer threadsPerCore() {
        return threadsPerCore;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(amdSevSnpAsString());
        hashCode = 31 * hashCode + Objects.hashCode(coreCount());
        hashCode = 31 * hashCode + Objects.hashCode(threadsPerCore());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CpuOptionsRequest)) {
            return false;
        }
        CpuOptionsRequest other = (CpuOptionsRequest) obj;
        return Objects.equals(amdSevSnpAsString(), other.amdSevSnpAsString()) && Objects.equals(coreCount(), other.coreCount())
                && Objects.equals(threadsPerCore(), other.threadsPerCore());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CpuOptionsRequest").add("AmdSevSnp", amdSevSnpAsString()).add("CoreCount", coreCount())
                .add("ThreadsPerCore", threadsPerCore()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AmdSevSnp":
            return Optional.ofNullable(clazz.cast(amdSevSnpAsString()));
        case "CoreCount":
            return Optional.ofNullable(clazz.cast(coreCount()));
        case "ThreadsPerCore":
            return Optional.ofNullable(clazz.cast(threadsPerCore()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AmdSevSnp", AMD_SEV_SNP_FIELD);
        map.put("CoreCount", CORE_COUNT_FIELD);
        map.put("ThreadsPerCore", THREADS_PER_CORE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CpuOptionsRequest, T> g) {
        return obj -> g.apply((CpuOptionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CpuOptionsRequest> {
        /**
         * <p>
         * AMD Secure Encrypted Virtualization configuration.
         * </p>
         * 
         * @param amdSevSnp
         *        AMD Secure Encrypted Virtualization configuration.
         * @see AmdSevSnpEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AmdSevSnpEnum
         */
        Builder amdSevSnp(String amdSevSnp);

        /**
         * <p>
         * AMD Secure Encrypted Virtualization configuration.
         * </p>
         * 
         * @param amdSevSnp
         *        AMD Secure Encrypted Virtualization configuration.
         * @see AmdSevSnpEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AmdSevSnpEnum
         */
        Builder amdSevSnp(AmdSevSnpEnum amdSevSnp);

        /**
         * <p>
         * Number of CPU cores to allocate.
         * </p>
         * 
         * @param coreCount
         *        Number of CPU cores to allocate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coreCount(Integer coreCount);

        /**
         * <p>
         * Number of threads per CPU core.
         * </p>
         * 
         * @param threadsPerCore
         *        Number of threads per CPU core.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder threadsPerCore(Integer threadsPerCore);
    }

    static final class BuilderImpl implements Builder {
        private String amdSevSnp;

        private Integer coreCount;

        private Integer threadsPerCore;

        private BuilderImpl() {
        }

        private BuilderImpl(CpuOptionsRequest model) {
            amdSevSnp(model.amdSevSnp);
            coreCount(model.coreCount);
            threadsPerCore(model.threadsPerCore);
        }

        public final String getAmdSevSnp() {
            return amdSevSnp;
        }

        public final void setAmdSevSnp(String amdSevSnp) {
            this.amdSevSnp = amdSevSnp;
        }

        @Override
        public final Builder amdSevSnp(String amdSevSnp) {
            this.amdSevSnp = amdSevSnp;
            return this;
        }

        @Override
        public final Builder amdSevSnp(AmdSevSnpEnum amdSevSnp) {
            this.amdSevSnp(amdSevSnp == null ? null : amdSevSnp.toString());
            return this;
        }

        public final Integer getCoreCount() {
            return coreCount;
        }

        public final void setCoreCount(Integer coreCount) {
            this.coreCount = coreCount;
        }

        @Override
        public final Builder coreCount(Integer coreCount) {
            this.coreCount = coreCount;
            return this;
        }

        public final Integer getThreadsPerCore() {
            return threadsPerCore;
        }

        public final void setThreadsPerCore(Integer threadsPerCore) {
            this.threadsPerCore = threadsPerCore;
        }

        @Override
        public final Builder threadsPerCore(Integer threadsPerCore) {
            this.threadsPerCore = threadsPerCore;
            return this;
        }

        @Override
        public CpuOptionsRequest build() {
            return new CpuOptionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
