/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspacesinstances.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Captures detailed error information for EC2 instance operations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EC2InstanceError implements SdkPojo, Serializable,
        ToCopyableBuilder<EC2InstanceError.Builder, EC2InstanceError> {
    private static final SdkField<String> EC2_ERROR_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EC2ErrorCode").getter(getter(EC2InstanceError::ec2ErrorCode)).setter(setter(Builder::ec2ErrorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EC2ErrorCode").build()).build();

    private static final SdkField<String> EC2_EXCEPTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EC2ExceptionType").getter(getter(EC2InstanceError::ec2ExceptionType))
            .setter(setter(Builder::ec2ExceptionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EC2ExceptionType").build()).build();

    private static final SdkField<String> EC2_ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EC2ErrorMessage").getter(getter(EC2InstanceError::ec2ErrorMessage))
            .setter(setter(Builder::ec2ErrorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EC2ErrorMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EC2_ERROR_CODE_FIELD,
            EC2_EXCEPTION_TYPE_FIELD, EC2_ERROR_MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String ec2ErrorCode;

    private final String ec2ExceptionType;

    private final String ec2ErrorMessage;

    private EC2InstanceError(BuilderImpl builder) {
        this.ec2ErrorCode = builder.ec2ErrorCode;
        this.ec2ExceptionType = builder.ec2ExceptionType;
        this.ec2ErrorMessage = builder.ec2ErrorMessage;
    }

    /**
     * <p>
     * Unique error code identifying the specific EC2 instance error.
     * </p>
     * 
     * @return Unique error code identifying the specific EC2 instance error.
     */
    public final String ec2ErrorCode() {
        return ec2ErrorCode;
    }

    /**
     * <p>
     * Type of exception encountered during EC2 instance operation.
     * </p>
     * 
     * @return Type of exception encountered during EC2 instance operation.
     */
    public final String ec2ExceptionType() {
        return ec2ExceptionType;
    }

    /**
     * <p>
     * Detailed description of the EC2 instance error.
     * </p>
     * 
     * @return Detailed description of the EC2 instance error.
     */
    public final String ec2ErrorMessage() {
        return ec2ErrorMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ec2ErrorCode());
        hashCode = 31 * hashCode + Objects.hashCode(ec2ExceptionType());
        hashCode = 31 * hashCode + Objects.hashCode(ec2ErrorMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EC2InstanceError)) {
            return false;
        }
        EC2InstanceError other = (EC2InstanceError) obj;
        return Objects.equals(ec2ErrorCode(), other.ec2ErrorCode())
                && Objects.equals(ec2ExceptionType(), other.ec2ExceptionType())
                && Objects.equals(ec2ErrorMessage(), other.ec2ErrorMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EC2InstanceError").add("EC2ErrorCode", ec2ErrorCode())
                .add("EC2ExceptionType", ec2ExceptionType()).add("EC2ErrorMessage", ec2ErrorMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EC2ErrorCode":
            return Optional.ofNullable(clazz.cast(ec2ErrorCode()));
        case "EC2ExceptionType":
            return Optional.ofNullable(clazz.cast(ec2ExceptionType()));
        case "EC2ErrorMessage":
            return Optional.ofNullable(clazz.cast(ec2ErrorMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EC2ErrorCode", EC2_ERROR_CODE_FIELD);
        map.put("EC2ExceptionType", EC2_EXCEPTION_TYPE_FIELD);
        map.put("EC2ErrorMessage", EC2_ERROR_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EC2InstanceError, T> g) {
        return obj -> g.apply((EC2InstanceError) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EC2InstanceError> {
        /**
         * <p>
         * Unique error code identifying the specific EC2 instance error.
         * </p>
         * 
         * @param ec2ErrorCode
         *        Unique error code identifying the specific EC2 instance error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2ErrorCode(String ec2ErrorCode);

        /**
         * <p>
         * Type of exception encountered during EC2 instance operation.
         * </p>
         * 
         * @param ec2ExceptionType
         *        Type of exception encountered during EC2 instance operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2ExceptionType(String ec2ExceptionType);

        /**
         * <p>
         * Detailed description of the EC2 instance error.
         * </p>
         * 
         * @param ec2ErrorMessage
         *        Detailed description of the EC2 instance error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2ErrorMessage(String ec2ErrorMessage);
    }

    static final class BuilderImpl implements Builder {
        private String ec2ErrorCode;

        private String ec2ExceptionType;

        private String ec2ErrorMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(EC2InstanceError model) {
            ec2ErrorCode(model.ec2ErrorCode);
            ec2ExceptionType(model.ec2ExceptionType);
            ec2ErrorMessage(model.ec2ErrorMessage);
        }

        public final String getEc2ErrorCode() {
            return ec2ErrorCode;
        }

        public final void setEc2ErrorCode(String ec2ErrorCode) {
            this.ec2ErrorCode = ec2ErrorCode;
        }

        @Override
        public final Builder ec2ErrorCode(String ec2ErrorCode) {
            this.ec2ErrorCode = ec2ErrorCode;
            return this;
        }

        public final String getEc2ExceptionType() {
            return ec2ExceptionType;
        }

        public final void setEc2ExceptionType(String ec2ExceptionType) {
            this.ec2ExceptionType = ec2ExceptionType;
        }

        @Override
        public final Builder ec2ExceptionType(String ec2ExceptionType) {
            this.ec2ExceptionType = ec2ExceptionType;
            return this;
        }

        public final String getEc2ErrorMessage() {
            return ec2ErrorMessage;
        }

        public final void setEc2ErrorMessage(String ec2ErrorMessage) {
            this.ec2ErrorMessage = ec2ErrorMessage;
        }

        @Override
        public final Builder ec2ErrorMessage(String ec2ErrorMessage) {
            this.ec2ErrorMessage = ec2ErrorMessage;
            return this;
        }

        @Override
        public EC2InstanceError build() {
            return new EC2InstanceError(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
