/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspacesthinclient.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The resource and internal ID of a resource to tag.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EmbeddedTag implements SdkPojo, Serializable, ToCopyableBuilder<EmbeddedTag.Builder, EmbeddedTag> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceArn").getter(getter(EmbeddedTag::resourceArn)).setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArn").build()).build();

    private static final SdkField<String> INTERNAL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("internalId").getter(getter(EmbeddedTag::internalId)).setter(setter(Builder::internalId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("internalId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD,
            INTERNAL_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String resourceArn;

    private final String internalId;

    private EmbeddedTag(BuilderImpl builder) {
        this.resourceArn = builder.resourceArn;
        this.internalId = builder.internalId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a resource to tag.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a resource to tag.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * The internal ID of a resource to tag.
     * </p>
     * 
     * @return The internal ID of a resource to tag.
     */
    public final String internalId() {
        return internalId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(internalId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EmbeddedTag)) {
            return false;
        }
        EmbeddedTag other = (EmbeddedTag) obj;
        return Objects.equals(resourceArn(), other.resourceArn()) && Objects.equals(internalId(), other.internalId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EmbeddedTag").add("ResourceArn", resourceArn()).add("InternalId", internalId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "internalId":
            return Optional.ofNullable(clazz.cast(internalId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EmbeddedTag, T> g) {
        return obj -> g.apply((EmbeddedTag) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EmbeddedTag> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of a resource to tag.
         * </p>
         * 
         * @param resourceArn
         *        The Amazon Resource Name (ARN) of a resource to tag.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * The internal ID of a resource to tag.
         * </p>
         * 
         * @param internalId
         *        The internal ID of a resource to tag.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder internalId(String internalId);
    }

    static final class BuilderImpl implements Builder {
        private String resourceArn;

        private String internalId;

        private BuilderImpl() {
        }

        private BuilderImpl(EmbeddedTag model) {
            resourceArn(model.resourceArn);
            internalId(model.internalId);
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getInternalId() {
            return internalId;
        }

        public final void setInternalId(String internalId) {
            this.internalId = internalId;
        }

        @Override
        public final Builder internalId(String internalId) {
            this.internalId = internalId;
            return this;
        }

        @Override
        public EmbeddedTag build() {
            return new EmbeddedTag(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
