/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspacesthinclient.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a software set.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SoftwareSet implements SdkPojo, Serializable, ToCopyableBuilder<SoftwareSet.Builder, SoftwareSet> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(SoftwareSet::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("version")
            .getter(getter(SoftwareSet::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final SdkField<Instant> RELEASED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("releasedAt").getter(getter(SoftwareSet::releasedAt)).setter(setter(Builder::releasedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("releasedAt").build()).build();

    private static final SdkField<Instant> SUPPORTED_UNTIL_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("supportedUntil").getter(getter(SoftwareSet::supportedUntil)).setter(setter(Builder::supportedUntil))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportedUntil").build()).build();

    private static final SdkField<String> VALIDATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("validationStatus").getter(getter(SoftwareSet::validationStatusAsString))
            .setter(setter(Builder::validationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validationStatus").build()).build();

    private static final SdkField<List<Software>> SOFTWARE_FIELD = SdkField
            .<List<Software>> builder(MarshallingType.LIST)
            .memberName("software")
            .getter(getter(SoftwareSet::software))
            .setter(setter(Builder::software))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("software").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Software> builder(MarshallingType.SDK_POJO)
                                            .constructor(Software::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(SoftwareSet::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, VERSION_FIELD,
            RELEASED_AT_FIELD, SUPPORTED_UNTIL_FIELD, VALIDATION_STATUS_FIELD, SOFTWARE_FIELD, ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String version;

    private final Instant releasedAt;

    private final Instant supportedUntil;

    private final String validationStatus;

    private final List<Software> software;

    private final String arn;

    private SoftwareSet(BuilderImpl builder) {
        this.id = builder.id;
        this.version = builder.version;
        this.releasedAt = builder.releasedAt;
        this.supportedUntil = builder.supportedUntil;
        this.validationStatus = builder.validationStatus;
        this.software = builder.software;
        this.arn = builder.arn;
    }

    /**
     * <p>
     * The ID of the software set.
     * </p>
     * 
     * @return The ID of the software set.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The version of the software set.
     * </p>
     * 
     * @return The version of the software set.
     */
    public final String version() {
        return version;
    }

    /**
     * <p>
     * The timestamp of when the software set was released.
     * </p>
     * 
     * @return The timestamp of when the software set was released.
     */
    public final Instant releasedAt() {
        return releasedAt;
    }

    /**
     * <p>
     * The timestamp of the end of support for the software set.
     * </p>
     * 
     * @return The timestamp of the end of support for the software set.
     */
    public final Instant supportedUntil() {
        return supportedUntil;
    }

    /**
     * <p>
     * An option to define if the software set has been validated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #validationStatus}
     * will return {@link SoftwareSetValidationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #validationStatusAsString}.
     * </p>
     * 
     * @return An option to define if the software set has been validated.
     * @see SoftwareSetValidationStatus
     */
    public final SoftwareSetValidationStatus validationStatus() {
        return SoftwareSetValidationStatus.fromValue(validationStatus);
    }

    /**
     * <p>
     * An option to define if the software set has been validated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #validationStatus}
     * will return {@link SoftwareSetValidationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #validationStatusAsString}.
     * </p>
     * 
     * @return An option to define if the software set has been validated.
     * @see SoftwareSetValidationStatus
     */
    public final String validationStatusAsString() {
        return validationStatus;
    }

    /**
     * For responses, this returns true if the service returned a value for the Software property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSoftware() {
        return software != null && !(software instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the software components in the software set.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSoftware} method.
     * </p>
     * 
     * @return A list of the software components in the software set.
     */
    public final List<Software> software() {
        return software;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the software set.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the software set.
     */
    public final String arn() {
        return arn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(releasedAt());
        hashCode = 31 * hashCode + Objects.hashCode(supportedUntil());
        hashCode = 31 * hashCode + Objects.hashCode(validationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasSoftware() ? software() : null);
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SoftwareSet)) {
            return false;
        }
        SoftwareSet other = (SoftwareSet) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(version(), other.version())
                && Objects.equals(releasedAt(), other.releasedAt()) && Objects.equals(supportedUntil(), other.supportedUntil())
                && Objects.equals(validationStatusAsString(), other.validationStatusAsString())
                && hasSoftware() == other.hasSoftware() && Objects.equals(software(), other.software())
                && Objects.equals(arn(), other.arn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SoftwareSet").add("Id", id()).add("Version", version()).add("ReleasedAt", releasedAt())
                .add("SupportedUntil", supportedUntil()).add("ValidationStatus", validationStatusAsString())
                .add("Software", hasSoftware() ? software() : null).add("Arn", arn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        case "releasedAt":
            return Optional.ofNullable(clazz.cast(releasedAt()));
        case "supportedUntil":
            return Optional.ofNullable(clazz.cast(supportedUntil()));
        case "validationStatus":
            return Optional.ofNullable(clazz.cast(validationStatusAsString()));
        case "software":
            return Optional.ofNullable(clazz.cast(software()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SoftwareSet, T> g) {
        return obj -> g.apply((SoftwareSet) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SoftwareSet> {
        /**
         * <p>
         * The ID of the software set.
         * </p>
         * 
         * @param id
         *        The ID of the software set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The version of the software set.
         * </p>
         * 
         * @param version
         *        The version of the software set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * The timestamp of when the software set was released.
         * </p>
         * 
         * @param releasedAt
         *        The timestamp of when the software set was released.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder releasedAt(Instant releasedAt);

        /**
         * <p>
         * The timestamp of the end of support for the software set.
         * </p>
         * 
         * @param supportedUntil
         *        The timestamp of the end of support for the software set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedUntil(Instant supportedUntil);

        /**
         * <p>
         * An option to define if the software set has been validated.
         * </p>
         * 
         * @param validationStatus
         *        An option to define if the software set has been validated.
         * @see SoftwareSetValidationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SoftwareSetValidationStatus
         */
        Builder validationStatus(String validationStatus);

        /**
         * <p>
         * An option to define if the software set has been validated.
         * </p>
         * 
         * @param validationStatus
         *        An option to define if the software set has been validated.
         * @see SoftwareSetValidationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SoftwareSetValidationStatus
         */
        Builder validationStatus(SoftwareSetValidationStatus validationStatus);

        /**
         * <p>
         * A list of the software components in the software set.
         * </p>
         * 
         * @param software
         *        A list of the software components in the software set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder software(Collection<Software> software);

        /**
         * <p>
         * A list of the software components in the software set.
         * </p>
         * 
         * @param software
         *        A list of the software components in the software set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder software(Software... software);

        /**
         * <p>
         * A list of the software components in the software set.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.workspacesthinclient.model.Software.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.workspacesthinclient.model.Software#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.workspacesthinclient.model.Software.Builder#build()} is called
         * immediately and its result is passed to {@link #software(List<Software>)}.
         * 
         * @param software
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.workspacesthinclient.model.Software.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #software(java.util.Collection<Software>)
         */
        Builder software(Consumer<Software.Builder>... software);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the software set.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the software set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String version;

        private Instant releasedAt;

        private Instant supportedUntil;

        private String validationStatus;

        private List<Software> software = DefaultSdkAutoConstructList.getInstance();

        private String arn;

        private BuilderImpl() {
        }

        private BuilderImpl(SoftwareSet model) {
            id(model.id);
            version(model.version);
            releasedAt(model.releasedAt);
            supportedUntil(model.supportedUntil);
            validationStatus(model.validationStatus);
            software(model.software);
            arn(model.arn);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final Instant getReleasedAt() {
            return releasedAt;
        }

        public final void setReleasedAt(Instant releasedAt) {
            this.releasedAt = releasedAt;
        }

        @Override
        public final Builder releasedAt(Instant releasedAt) {
            this.releasedAt = releasedAt;
            return this;
        }

        public final Instant getSupportedUntil() {
            return supportedUntil;
        }

        public final void setSupportedUntil(Instant supportedUntil) {
            this.supportedUntil = supportedUntil;
        }

        @Override
        public final Builder supportedUntil(Instant supportedUntil) {
            this.supportedUntil = supportedUntil;
            return this;
        }

        public final String getValidationStatus() {
            return validationStatus;
        }

        public final void setValidationStatus(String validationStatus) {
            this.validationStatus = validationStatus;
        }

        @Override
        public final Builder validationStatus(String validationStatus) {
            this.validationStatus = validationStatus;
            return this;
        }

        @Override
        public final Builder validationStatus(SoftwareSetValidationStatus validationStatus) {
            this.validationStatus(validationStatus == null ? null : validationStatus.toString());
            return this;
        }

        public final List<Software.Builder> getSoftware() {
            List<Software.Builder> result = SoftwareListCopier.copyToBuilder(this.software);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSoftware(Collection<Software.BuilderImpl> software) {
            this.software = SoftwareListCopier.copyFromBuilder(software);
        }

        @Override
        public final Builder software(Collection<Software> software) {
            this.software = SoftwareListCopier.copy(software);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder software(Software... software) {
            software(Arrays.asList(software));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder software(Consumer<Software.Builder>... software) {
            software(Stream.of(software).map(c -> Software.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        @Override
        public SoftwareSet build() {
            return new SoftwareSet(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
