/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspacesthinclient.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the maintenance window for a thin client device.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MaintenanceWindow implements SdkPojo, Serializable,
        ToCopyableBuilder<MaintenanceWindow.Builder, MaintenanceWindow> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(MaintenanceWindow::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<Integer> START_TIME_HOUR_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("startTimeHour").getter(getter(MaintenanceWindow::startTimeHour)).setter(setter(Builder::startTimeHour))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTimeHour").build()).build();

    private static final SdkField<Integer> START_TIME_MINUTE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("startTimeMinute").getter(getter(MaintenanceWindow::startTimeMinute))
            .setter(setter(Builder::startTimeMinute))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTimeMinute").build()).build();

    private static final SdkField<Integer> END_TIME_HOUR_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("endTimeHour").getter(getter(MaintenanceWindow::endTimeHour)).setter(setter(Builder::endTimeHour))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTimeHour").build()).build();

    private static final SdkField<Integer> END_TIME_MINUTE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("endTimeMinute").getter(getter(MaintenanceWindow::endTimeMinute)).setter(setter(Builder::endTimeMinute))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTimeMinute").build()).build();

    private static final SdkField<List<String>> DAYS_OF_THE_WEEK_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("daysOfTheWeek")
            .getter(getter(MaintenanceWindow::daysOfTheWeekAsStrings))
            .setter(setter(Builder::daysOfTheWeekWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("daysOfTheWeek").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> APPLY_TIME_OF_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applyTimeOf").getter(getter(MaintenanceWindow::applyTimeOfAsString))
            .setter(setter(Builder::applyTimeOf))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applyTimeOf").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD,
            START_TIME_HOUR_FIELD, START_TIME_MINUTE_FIELD, END_TIME_HOUR_FIELD, END_TIME_MINUTE_FIELD, DAYS_OF_THE_WEEK_FIELD,
            APPLY_TIME_OF_FIELD));

    private static final long serialVersionUID = 1L;

    private final String type;

    private final Integer startTimeHour;

    private final Integer startTimeMinute;

    private final Integer endTimeHour;

    private final Integer endTimeMinute;

    private final List<String> daysOfTheWeek;

    private final String applyTimeOf;

    private MaintenanceWindow(BuilderImpl builder) {
        this.type = builder.type;
        this.startTimeHour = builder.startTimeHour;
        this.startTimeMinute = builder.startTimeMinute;
        this.endTimeHour = builder.endTimeHour;
        this.endTimeMinute = builder.endTimeMinute;
        this.daysOfTheWeek = builder.daysOfTheWeek;
        this.applyTimeOf = builder.applyTimeOf;
    }

    /**
     * <p>
     * An option to select the default or custom maintenance window.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link MaintenanceWindowType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return An option to select the default or custom maintenance window.
     * @see MaintenanceWindowType
     */
    public final MaintenanceWindowType type() {
        return MaintenanceWindowType.fromValue(type);
    }

    /**
     * <p>
     * An option to select the default or custom maintenance window.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link MaintenanceWindowType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return An option to select the default or custom maintenance window.
     * @see MaintenanceWindowType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The hour for the maintenance window start (<code>00</code>-<code>23</code>).
     * </p>
     * 
     * @return The hour for the maintenance window start (<code>00</code>-<code>23</code>).
     */
    public final Integer startTimeHour() {
        return startTimeHour;
    }

    /**
     * <p>
     * The minutes past the hour for the maintenance window start (<code>00</code>-<code>59</code>).
     * </p>
     * 
     * @return The minutes past the hour for the maintenance window start (<code>00</code>-<code>59</code>).
     */
    public final Integer startTimeMinute() {
        return startTimeMinute;
    }

    /**
     * <p>
     * The hour for the maintenance window end (<code>00</code>-<code>23</code>).
     * </p>
     * 
     * @return The hour for the maintenance window end (<code>00</code>-<code>23</code>).
     */
    public final Integer endTimeHour() {
        return endTimeHour;
    }

    /**
     * <p>
     * The minutes for the maintenance window end (<code>00</code>-<code>59</code>).
     * </p>
     * 
     * @return The minutes for the maintenance window end (<code>00</code>-<code>59</code>).
     */
    public final Integer endTimeMinute() {
        return endTimeMinute;
    }

    /**
     * <p>
     * The days of the week during which the maintenance window is open.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDaysOfTheWeek} method.
     * </p>
     * 
     * @return The days of the week during which the maintenance window is open.
     */
    public final List<DayOfWeek> daysOfTheWeek() {
        return DayOfWeekListCopier.copyStringToEnum(daysOfTheWeek);
    }

    /**
     * For responses, this returns true if the service returned a value for the DaysOfTheWeek property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDaysOfTheWeek() {
        return daysOfTheWeek != null && !(daysOfTheWeek instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The days of the week during which the maintenance window is open.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDaysOfTheWeek} method.
     * </p>
     * 
     * @return The days of the week during which the maintenance window is open.
     */
    public final List<String> daysOfTheWeekAsStrings() {
        return daysOfTheWeek;
    }

    /**
     * <p>
     * The option to set the maintenance window during the device local time or Universal Coordinated Time (UTC).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #applyTimeOf} will
     * return {@link ApplyTimeOf#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #applyTimeOfAsString}.
     * </p>
     * 
     * @return The option to set the maintenance window during the device local time or Universal Coordinated Time
     *         (UTC).
     * @see ApplyTimeOf
     */
    public final ApplyTimeOf applyTimeOf() {
        return ApplyTimeOf.fromValue(applyTimeOf);
    }

    /**
     * <p>
     * The option to set the maintenance window during the device local time or Universal Coordinated Time (UTC).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #applyTimeOf} will
     * return {@link ApplyTimeOf#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #applyTimeOfAsString}.
     * </p>
     * 
     * @return The option to set the maintenance window during the device local time or Universal Coordinated Time
     *         (UTC).
     * @see ApplyTimeOf
     */
    public final String applyTimeOfAsString() {
        return applyTimeOf;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(startTimeHour());
        hashCode = 31 * hashCode + Objects.hashCode(startTimeMinute());
        hashCode = 31 * hashCode + Objects.hashCode(endTimeHour());
        hashCode = 31 * hashCode + Objects.hashCode(endTimeMinute());
        hashCode = 31 * hashCode + Objects.hashCode(hasDaysOfTheWeek() ? daysOfTheWeekAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(applyTimeOfAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MaintenanceWindow)) {
            return false;
        }
        MaintenanceWindow other = (MaintenanceWindow) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(startTimeHour(), other.startTimeHour())
                && Objects.equals(startTimeMinute(), other.startTimeMinute())
                && Objects.equals(endTimeHour(), other.endTimeHour()) && Objects.equals(endTimeMinute(), other.endTimeMinute())
                && hasDaysOfTheWeek() == other.hasDaysOfTheWeek()
                && Objects.equals(daysOfTheWeekAsStrings(), other.daysOfTheWeekAsStrings())
                && Objects.equals(applyTimeOfAsString(), other.applyTimeOfAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MaintenanceWindow").add("Type", typeAsString()).add("StartTimeHour", startTimeHour())
                .add("StartTimeMinute", startTimeMinute()).add("EndTimeHour", endTimeHour())
                .add("EndTimeMinute", endTimeMinute()).add("DaysOfTheWeek", hasDaysOfTheWeek() ? daysOfTheWeekAsStrings() : null)
                .add("ApplyTimeOf", applyTimeOfAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "startTimeHour":
            return Optional.ofNullable(clazz.cast(startTimeHour()));
        case "startTimeMinute":
            return Optional.ofNullable(clazz.cast(startTimeMinute()));
        case "endTimeHour":
            return Optional.ofNullable(clazz.cast(endTimeHour()));
        case "endTimeMinute":
            return Optional.ofNullable(clazz.cast(endTimeMinute()));
        case "daysOfTheWeek":
            return Optional.ofNullable(clazz.cast(daysOfTheWeekAsStrings()));
        case "applyTimeOf":
            return Optional.ofNullable(clazz.cast(applyTimeOfAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MaintenanceWindow, T> g) {
        return obj -> g.apply((MaintenanceWindow) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MaintenanceWindow> {
        /**
         * <p>
         * An option to select the default or custom maintenance window.
         * </p>
         * 
         * @param type
         *        An option to select the default or custom maintenance window.
         * @see MaintenanceWindowType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MaintenanceWindowType
         */
        Builder type(String type);

        /**
         * <p>
         * An option to select the default or custom maintenance window.
         * </p>
         * 
         * @param type
         *        An option to select the default or custom maintenance window.
         * @see MaintenanceWindowType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MaintenanceWindowType
         */
        Builder type(MaintenanceWindowType type);

        /**
         * <p>
         * The hour for the maintenance window start (<code>00</code>-<code>23</code>).
         * </p>
         * 
         * @param startTimeHour
         *        The hour for the maintenance window start (<code>00</code>-<code>23</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTimeHour(Integer startTimeHour);

        /**
         * <p>
         * The minutes past the hour for the maintenance window start (<code>00</code>-<code>59</code>).
         * </p>
         * 
         * @param startTimeMinute
         *        The minutes past the hour for the maintenance window start (<code>00</code>-<code>59</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTimeMinute(Integer startTimeMinute);

        /**
         * <p>
         * The hour for the maintenance window end (<code>00</code>-<code>23</code>).
         * </p>
         * 
         * @param endTimeHour
         *        The hour for the maintenance window end (<code>00</code>-<code>23</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTimeHour(Integer endTimeHour);

        /**
         * <p>
         * The minutes for the maintenance window end (<code>00</code>-<code>59</code>).
         * </p>
         * 
         * @param endTimeMinute
         *        The minutes for the maintenance window end (<code>00</code>-<code>59</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTimeMinute(Integer endTimeMinute);

        /**
         * <p>
         * The days of the week during which the maintenance window is open.
         * </p>
         * 
         * @param daysOfTheWeek
         *        The days of the week during which the maintenance window is open.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder daysOfTheWeekWithStrings(Collection<String> daysOfTheWeek);

        /**
         * <p>
         * The days of the week during which the maintenance window is open.
         * </p>
         * 
         * @param daysOfTheWeek
         *        The days of the week during which the maintenance window is open.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder daysOfTheWeekWithStrings(String... daysOfTheWeek);

        /**
         * <p>
         * The days of the week during which the maintenance window is open.
         * </p>
         * 
         * @param daysOfTheWeek
         *        The days of the week during which the maintenance window is open.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder daysOfTheWeek(Collection<DayOfWeek> daysOfTheWeek);

        /**
         * <p>
         * The days of the week during which the maintenance window is open.
         * </p>
         * 
         * @param daysOfTheWeek
         *        The days of the week during which the maintenance window is open.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder daysOfTheWeek(DayOfWeek... daysOfTheWeek);

        /**
         * <p>
         * The option to set the maintenance window during the device local time or Universal Coordinated Time (UTC).
         * </p>
         * 
         * @param applyTimeOf
         *        The option to set the maintenance window during the device local time or Universal Coordinated Time
         *        (UTC).
         * @see ApplyTimeOf
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplyTimeOf
         */
        Builder applyTimeOf(String applyTimeOf);

        /**
         * <p>
         * The option to set the maintenance window during the device local time or Universal Coordinated Time (UTC).
         * </p>
         * 
         * @param applyTimeOf
         *        The option to set the maintenance window during the device local time or Universal Coordinated Time
         *        (UTC).
         * @see ApplyTimeOf
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ApplyTimeOf
         */
        Builder applyTimeOf(ApplyTimeOf applyTimeOf);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private Integer startTimeHour;

        private Integer startTimeMinute;

        private Integer endTimeHour;

        private Integer endTimeMinute;

        private List<String> daysOfTheWeek = DefaultSdkAutoConstructList.getInstance();

        private String applyTimeOf;

        private BuilderImpl() {
        }

        private BuilderImpl(MaintenanceWindow model) {
            type(model.type);
            startTimeHour(model.startTimeHour);
            startTimeMinute(model.startTimeMinute);
            endTimeHour(model.endTimeHour);
            endTimeMinute(model.endTimeMinute);
            daysOfTheWeekWithStrings(model.daysOfTheWeek);
            applyTimeOf(model.applyTimeOf);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(MaintenanceWindowType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Integer getStartTimeHour() {
            return startTimeHour;
        }

        public final void setStartTimeHour(Integer startTimeHour) {
            this.startTimeHour = startTimeHour;
        }

        @Override
        public final Builder startTimeHour(Integer startTimeHour) {
            this.startTimeHour = startTimeHour;
            return this;
        }

        public final Integer getStartTimeMinute() {
            return startTimeMinute;
        }

        public final void setStartTimeMinute(Integer startTimeMinute) {
            this.startTimeMinute = startTimeMinute;
        }

        @Override
        public final Builder startTimeMinute(Integer startTimeMinute) {
            this.startTimeMinute = startTimeMinute;
            return this;
        }

        public final Integer getEndTimeHour() {
            return endTimeHour;
        }

        public final void setEndTimeHour(Integer endTimeHour) {
            this.endTimeHour = endTimeHour;
        }

        @Override
        public final Builder endTimeHour(Integer endTimeHour) {
            this.endTimeHour = endTimeHour;
            return this;
        }

        public final Integer getEndTimeMinute() {
            return endTimeMinute;
        }

        public final void setEndTimeMinute(Integer endTimeMinute) {
            this.endTimeMinute = endTimeMinute;
        }

        @Override
        public final Builder endTimeMinute(Integer endTimeMinute) {
            this.endTimeMinute = endTimeMinute;
            return this;
        }

        public final Collection<String> getDaysOfTheWeek() {
            if (daysOfTheWeek instanceof SdkAutoConstructList) {
                return null;
            }
            return daysOfTheWeek;
        }

        public final void setDaysOfTheWeek(Collection<String> daysOfTheWeek) {
            this.daysOfTheWeek = DayOfWeekListCopier.copy(daysOfTheWeek);
        }

        @Override
        public final Builder daysOfTheWeekWithStrings(Collection<String> daysOfTheWeek) {
            this.daysOfTheWeek = DayOfWeekListCopier.copy(daysOfTheWeek);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder daysOfTheWeekWithStrings(String... daysOfTheWeek) {
            daysOfTheWeekWithStrings(Arrays.asList(daysOfTheWeek));
            return this;
        }

        @Override
        public final Builder daysOfTheWeek(Collection<DayOfWeek> daysOfTheWeek) {
            this.daysOfTheWeek = DayOfWeekListCopier.copyEnumToString(daysOfTheWeek);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder daysOfTheWeek(DayOfWeek... daysOfTheWeek) {
            daysOfTheWeek(Arrays.asList(daysOfTheWeek));
            return this;
        }

        public final String getApplyTimeOf() {
            return applyTimeOf;
        }

        public final void setApplyTimeOf(String applyTimeOf) {
            this.applyTimeOf = applyTimeOf;
        }

        @Override
        public final Builder applyTimeOf(String applyTimeOf) {
            this.applyTimeOf = applyTimeOf;
            return this;
        }

        @Override
        public final Builder applyTimeOf(ApplyTimeOf applyTimeOf) {
            this.applyTimeOf(applyTimeOf == null ? null : applyTimeOf.toString());
            return this;
        }

        @Override
        public MaintenanceWindow build() {
            return new MaintenanceWindow(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
