/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspacesthinclient.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateSoftwareSetRequest extends WorkSpacesThinClientRequest implements
        ToCopyableBuilder<UpdateSoftwareSetRequest.Builder, UpdateSoftwareSetRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(UpdateSoftwareSetRequest::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("id").build()).build();

    private static final SdkField<String> VALIDATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("validationStatus").getter(getter(UpdateSoftwareSetRequest::validationStatusAsString))
            .setter(setter(Builder::validationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validationStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD,
            VALIDATION_STATUS_FIELD));

    private final String id;

    private final String validationStatus;

    private UpdateSoftwareSetRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.validationStatus = builder.validationStatus;
    }

    /**
     * <p>
     * The ID of the software set to update.
     * </p>
     * 
     * @return The ID of the software set to update.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * An option to define if the software set has been validated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #validationStatus}
     * will return {@link SoftwareSetValidationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #validationStatusAsString}.
     * </p>
     * 
     * @return An option to define if the software set has been validated.
     * @see SoftwareSetValidationStatus
     */
    public final SoftwareSetValidationStatus validationStatus() {
        return SoftwareSetValidationStatus.fromValue(validationStatus);
    }

    /**
     * <p>
     * An option to define if the software set has been validated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #validationStatus}
     * will return {@link SoftwareSetValidationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #validationStatusAsString}.
     * </p>
     * 
     * @return An option to define if the software set has been validated.
     * @see SoftwareSetValidationStatus
     */
    public final String validationStatusAsString() {
        return validationStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(validationStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSoftwareSetRequest)) {
            return false;
        }
        UpdateSoftwareSetRequest other = (UpdateSoftwareSetRequest) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(validationStatusAsString(), other.validationStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateSoftwareSetRequest").add("Id", id()).add("ValidationStatus", validationStatusAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "validationStatus":
            return Optional.ofNullable(clazz.cast(validationStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateSoftwareSetRequest, T> g) {
        return obj -> g.apply((UpdateSoftwareSetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkSpacesThinClientRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateSoftwareSetRequest> {
        /**
         * <p>
         * The ID of the software set to update.
         * </p>
         * 
         * @param id
         *        The ID of the software set to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * An option to define if the software set has been validated.
         * </p>
         * 
         * @param validationStatus
         *        An option to define if the software set has been validated.
         * @see SoftwareSetValidationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SoftwareSetValidationStatus
         */
        Builder validationStatus(String validationStatus);

        /**
         * <p>
         * An option to define if the software set has been validated.
         * </p>
         * 
         * @param validationStatus
         *        An option to define if the software set has been validated.
         * @see SoftwareSetValidationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SoftwareSetValidationStatus
         */
        Builder validationStatus(SoftwareSetValidationStatus validationStatus);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkSpacesThinClientRequest.BuilderImpl implements Builder {
        private String id;

        private String validationStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSoftwareSetRequest model) {
            super(model);
            id(model.id);
            validationStatus(model.validationStatus);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getValidationStatus() {
            return validationStatus;
        }

        public final void setValidationStatus(String validationStatus) {
            this.validationStatus = validationStatus;
        }

        @Override
        public final Builder validationStatus(String validationStatus) {
            this.validationStatus = validationStatus;
            return this;
        }

        @Override
        public final Builder validationStatus(SoftwareSetValidationStatus validationStatus) {
            this.validationStatus(validationStatus == null ? null : validationStatus.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSoftwareSetRequest build() {
            return new UpdateSoftwareSetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
