/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspacesthinclient.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an environment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Environment implements SdkPojo, Serializable, ToCopyableBuilder<Environment.Builder, Environment> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(Environment::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(Environment::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESKTOP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("desktopArn").getter(getter(Environment::desktopArn)).setter(setter(Builder::desktopArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("desktopArn").build()).build();

    private static final SdkField<String> DESKTOP_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("desktopEndpoint").getter(getter(Environment::desktopEndpoint)).setter(setter(Builder::desktopEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("desktopEndpoint").build()).build();

    private static final SdkField<String> DESKTOP_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("desktopType").getter(getter(Environment::desktopTypeAsString)).setter(setter(Builder::desktopType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("desktopType").build()).build();

    private static final SdkField<String> ACTIVATION_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("activationCode").getter(getter(Environment::activationCode)).setter(setter(Builder::activationCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activationCode").build()).build();

    private static final SdkField<Integer> REGISTERED_DEVICES_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("registeredDevicesCount").getter(getter(Environment::registeredDevicesCount))
            .setter(setter(Builder::registeredDevicesCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registeredDevicesCount").build())
            .build();

    private static final SdkField<String> SOFTWARE_SET_UPDATE_SCHEDULE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("softwareSetUpdateSchedule").getter(getter(Environment::softwareSetUpdateScheduleAsString))
            .setter(setter(Builder::softwareSetUpdateSchedule))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("softwareSetUpdateSchedule").build())
            .build();

    private static final SdkField<MaintenanceWindow> MAINTENANCE_WINDOW_FIELD = SdkField
            .<MaintenanceWindow> builder(MarshallingType.SDK_POJO).memberName("maintenanceWindow")
            .getter(getter(Environment::maintenanceWindow)).setter(setter(Builder::maintenanceWindow))
            .constructor(MaintenanceWindow::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maintenanceWindow").build()).build();

    private static final SdkField<String> SOFTWARE_SET_UPDATE_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("softwareSetUpdateMode").getter(getter(Environment::softwareSetUpdateModeAsString))
            .setter(setter(Builder::softwareSetUpdateMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("softwareSetUpdateMode").build())
            .build();

    private static final SdkField<String> DESIRED_SOFTWARE_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("desiredSoftwareSetId").getter(getter(Environment::desiredSoftwareSetId))
            .setter(setter(Builder::desiredSoftwareSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("desiredSoftwareSetId").build())
            .build();

    private static final SdkField<String> PENDING_SOFTWARE_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("pendingSoftwareSetId").getter(getter(Environment::pendingSoftwareSetId))
            .setter(setter(Builder::pendingSoftwareSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pendingSoftwareSetId").build())
            .build();

    private static final SdkField<String> PENDING_SOFTWARE_SET_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("pendingSoftwareSetVersion").getter(getter(Environment::pendingSoftwareSetVersion))
            .setter(setter(Builder::pendingSoftwareSetVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pendingSoftwareSetVersion").build())
            .build();

    private static final SdkField<String> SOFTWARE_SET_COMPLIANCE_STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("softwareSetComplianceStatus")
            .getter(getter(Environment::softwareSetComplianceStatusAsString))
            .setter(setter(Builder::softwareSetComplianceStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("softwareSetComplianceStatus")
                    .build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(Environment::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt").getter(getter(Environment::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(Environment::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kmsKeyArn").getter(getter(Environment::kmsKeyArn)).setter(setter(Builder::kmsKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyArn").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(Environment::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> DEVICE_CREATION_TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("deviceCreationTags")
            .getter(getter(Environment::deviceCreationTags))
            .setter(setter(Builder::deviceCreationTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deviceCreationTags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD,
            DESKTOP_ARN_FIELD, DESKTOP_ENDPOINT_FIELD, DESKTOP_TYPE_FIELD, ACTIVATION_CODE_FIELD, REGISTERED_DEVICES_COUNT_FIELD,
            SOFTWARE_SET_UPDATE_SCHEDULE_FIELD, MAINTENANCE_WINDOW_FIELD, SOFTWARE_SET_UPDATE_MODE_FIELD,
            DESIRED_SOFTWARE_SET_ID_FIELD, PENDING_SOFTWARE_SET_ID_FIELD, PENDING_SOFTWARE_SET_VERSION_FIELD,
            SOFTWARE_SET_COMPLIANCE_STATUS_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, ARN_FIELD, KMS_KEY_ARN_FIELD, TAGS_FIELD,
            DEVICE_CREATION_TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String name;

    private final String desktopArn;

    private final String desktopEndpoint;

    private final String desktopType;

    private final String activationCode;

    private final Integer registeredDevicesCount;

    private final String softwareSetUpdateSchedule;

    private final MaintenanceWindow maintenanceWindow;

    private final String softwareSetUpdateMode;

    private final String desiredSoftwareSetId;

    private final String pendingSoftwareSetId;

    private final String pendingSoftwareSetVersion;

    private final String softwareSetComplianceStatus;

    private final Instant createdAt;

    private final Instant updatedAt;

    private final String arn;

    private final String kmsKeyArn;

    private final Map<String, String> tags;

    private final Map<String, String> deviceCreationTags;

    private Environment(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.desktopArn = builder.desktopArn;
        this.desktopEndpoint = builder.desktopEndpoint;
        this.desktopType = builder.desktopType;
        this.activationCode = builder.activationCode;
        this.registeredDevicesCount = builder.registeredDevicesCount;
        this.softwareSetUpdateSchedule = builder.softwareSetUpdateSchedule;
        this.maintenanceWindow = builder.maintenanceWindow;
        this.softwareSetUpdateMode = builder.softwareSetUpdateMode;
        this.desiredSoftwareSetId = builder.desiredSoftwareSetId;
        this.pendingSoftwareSetId = builder.pendingSoftwareSetId;
        this.pendingSoftwareSetVersion = builder.pendingSoftwareSetVersion;
        this.softwareSetComplianceStatus = builder.softwareSetComplianceStatus;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.arn = builder.arn;
        this.kmsKeyArn = builder.kmsKeyArn;
        this.tags = builder.tags;
        this.deviceCreationTags = builder.deviceCreationTags;
    }

    /**
     * <p>
     * The ID of the environment.
     * </p>
     * 
     * @return The ID of the environment.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the environment.
     * </p>
     * 
     * @return The name of the environment.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the desktop to stream from Amazon WorkSpaces, WorkSpaces Web, or AppStream 2.0.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the desktop to stream from Amazon WorkSpaces, WorkSpaces Web, or
     *         AppStream 2.0.
     */
    public final String desktopArn() {
        return desktopArn;
    }

    /**
     * <p>
     * The URL for the identity provider login (only for environments that use AppStream 2.0).
     * </p>
     * 
     * @return The URL for the identity provider login (only for environments that use AppStream 2.0).
     */
    public final String desktopEndpoint() {
        return desktopEndpoint;
    }

    /**
     * <p>
     * The type of streaming desktop for the environment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #desktopType} will
     * return {@link DesktopType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #desktopTypeAsString}.
     * </p>
     * 
     * @return The type of streaming desktop for the environment.
     * @see DesktopType
     */
    public final DesktopType desktopType() {
        return DesktopType.fromValue(desktopType);
    }

    /**
     * <p>
     * The type of streaming desktop for the environment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #desktopType} will
     * return {@link DesktopType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #desktopTypeAsString}.
     * </p>
     * 
     * @return The type of streaming desktop for the environment.
     * @see DesktopType
     */
    public final String desktopTypeAsString() {
        return desktopType;
    }

    /**
     * <p>
     * The activation code to register a device to the environment.
     * </p>
     * 
     * @return The activation code to register a device to the environment.
     */
    public final String activationCode() {
        return activationCode;
    }

    /**
     * <p>
     * The number of devices registered to the environment.
     * </p>
     * 
     * @return The number of devices registered to the environment.
     */
    public final Integer registeredDevicesCount() {
        return registeredDevicesCount;
    }

    /**
     * <p>
     * An option to define if software updates should be applied within a maintenance window.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #softwareSetUpdateSchedule} will return {@link SoftwareSetUpdateSchedule#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #softwareSetUpdateScheduleAsString}.
     * </p>
     * 
     * @return An option to define if software updates should be applied within a maintenance window.
     * @see SoftwareSetUpdateSchedule
     */
    public final SoftwareSetUpdateSchedule softwareSetUpdateSchedule() {
        return SoftwareSetUpdateSchedule.fromValue(softwareSetUpdateSchedule);
    }

    /**
     * <p>
     * An option to define if software updates should be applied within a maintenance window.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #softwareSetUpdateSchedule} will return {@link SoftwareSetUpdateSchedule#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #softwareSetUpdateScheduleAsString}.
     * </p>
     * 
     * @return An option to define if software updates should be applied within a maintenance window.
     * @see SoftwareSetUpdateSchedule
     */
    public final String softwareSetUpdateScheduleAsString() {
        return softwareSetUpdateSchedule;
    }

    /**
     * <p>
     * A specification for a time window to apply software updates.
     * </p>
     * 
     * @return A specification for a time window to apply software updates.
     */
    public final MaintenanceWindow maintenanceWindow() {
        return maintenanceWindow;
    }

    /**
     * <p>
     * An option to define which software updates to apply.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #softwareSetUpdateMode} will return {@link SoftwareSetUpdateMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #softwareSetUpdateModeAsString}.
     * </p>
     * 
     * @return An option to define which software updates to apply.
     * @see SoftwareSetUpdateMode
     */
    public final SoftwareSetUpdateMode softwareSetUpdateMode() {
        return SoftwareSetUpdateMode.fromValue(softwareSetUpdateMode);
    }

    /**
     * <p>
     * An option to define which software updates to apply.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #softwareSetUpdateMode} will return {@link SoftwareSetUpdateMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #softwareSetUpdateModeAsString}.
     * </p>
     * 
     * @return An option to define which software updates to apply.
     * @see SoftwareSetUpdateMode
     */
    public final String softwareSetUpdateModeAsString() {
        return softwareSetUpdateMode;
    }

    /**
     * <p>
     * The ID of the software set to apply.
     * </p>
     * 
     * @return The ID of the software set to apply.
     */
    public final String desiredSoftwareSetId() {
        return desiredSoftwareSetId;
    }

    /**
     * <p>
     * The ID of the software set that is pending to be installed.
     * </p>
     * 
     * @return The ID of the software set that is pending to be installed.
     */
    public final String pendingSoftwareSetId() {
        return pendingSoftwareSetId;
    }

    /**
     * <p>
     * The version of the software set that is pending to be installed.
     * </p>
     * 
     * @return The version of the software set that is pending to be installed.
     */
    public final String pendingSoftwareSetVersion() {
        return pendingSoftwareSetVersion;
    }

    /**
     * <p>
     * Describes if the software currently installed on all devices in the environment is a supported version.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #softwareSetComplianceStatus} will return
     * {@link EnvironmentSoftwareSetComplianceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #softwareSetComplianceStatusAsString}.
     * </p>
     * 
     * @return Describes if the software currently installed on all devices in the environment is a supported version.
     * @see EnvironmentSoftwareSetComplianceStatus
     */
    public final EnvironmentSoftwareSetComplianceStatus softwareSetComplianceStatus() {
        return EnvironmentSoftwareSetComplianceStatus.fromValue(softwareSetComplianceStatus);
    }

    /**
     * <p>
     * Describes if the software currently installed on all devices in the environment is a supported version.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #softwareSetComplianceStatus} will return
     * {@link EnvironmentSoftwareSetComplianceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #softwareSetComplianceStatusAsString}.
     * </p>
     * 
     * @return Describes if the software currently installed on all devices in the environment is a supported version.
     * @see EnvironmentSoftwareSetComplianceStatus
     */
    public final String softwareSetComplianceStatusAsString() {
        return softwareSetComplianceStatus;
    }

    /**
     * <p>
     * The timestamp of when the environment was created.
     * </p>
     * 
     * @return The timestamp of when the environment was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The timestamp of when the device was updated.
     * </p>
     * 
     * @return The timestamp of when the device was updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the environment.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the environment.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Key Management Service key used to encrypt the environment.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Key Management Service key used to encrypt the environment.
     */
    public final String kmsKeyArn() {
        return kmsKeyArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tag keys and optional values for the resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tag keys and optional values for the resource.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * For responses, this returns true if the service returned a value for the DeviceCreationTags property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDeviceCreationTags() {
        return deviceCreationTags != null && !(deviceCreationTags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * "The tag keys and optional values for the newly created devices for this environment."
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDeviceCreationTags} method.
     * </p>
     * 
     * @return "The tag keys and optional values for the newly created devices for this environment."
     */
    public final Map<String, String> deviceCreationTags() {
        return deviceCreationTags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(desktopArn());
        hashCode = 31 * hashCode + Objects.hashCode(desktopEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(desktopTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(activationCode());
        hashCode = 31 * hashCode + Objects.hashCode(registeredDevicesCount());
        hashCode = 31 * hashCode + Objects.hashCode(softwareSetUpdateScheduleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(softwareSetUpdateModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(desiredSoftwareSetId());
        hashCode = 31 * hashCode + Objects.hashCode(pendingSoftwareSetId());
        hashCode = 31 * hashCode + Objects.hashCode(pendingSoftwareSetVersion());
        hashCode = 31 * hashCode + Objects.hashCode(softwareSetComplianceStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDeviceCreationTags() ? deviceCreationTags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Environment)) {
            return false;
        }
        Environment other = (Environment) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(desktopArn(), other.desktopArn()) && Objects.equals(desktopEndpoint(), other.desktopEndpoint())
                && Objects.equals(desktopTypeAsString(), other.desktopTypeAsString())
                && Objects.equals(activationCode(), other.activationCode())
                && Objects.equals(registeredDevicesCount(), other.registeredDevicesCount())
                && Objects.equals(softwareSetUpdateScheduleAsString(), other.softwareSetUpdateScheduleAsString())
                && Objects.equals(maintenanceWindow(), other.maintenanceWindow())
                && Objects.equals(softwareSetUpdateModeAsString(), other.softwareSetUpdateModeAsString())
                && Objects.equals(desiredSoftwareSetId(), other.desiredSoftwareSetId())
                && Objects.equals(pendingSoftwareSetId(), other.pendingSoftwareSetId())
                && Objects.equals(pendingSoftwareSetVersion(), other.pendingSoftwareSetVersion())
                && Objects.equals(softwareSetComplianceStatusAsString(), other.softwareSetComplianceStatusAsString())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(updatedAt(), other.updatedAt())
                && Objects.equals(arn(), other.arn()) && Objects.equals(kmsKeyArn(), other.kmsKeyArn())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && hasDeviceCreationTags() == other.hasDeviceCreationTags()
                && Objects.equals(deviceCreationTags(), other.deviceCreationTags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Environment").add("Id", id())
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***").add("DesktopArn", desktopArn())
                .add("DesktopEndpoint", desktopEndpoint() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DesktopType", desktopTypeAsString()).add("ActivationCode", activationCode())
                .add("RegisteredDevicesCount", registeredDevicesCount())
                .add("SoftwareSetUpdateSchedule", softwareSetUpdateScheduleAsString())
                .add("MaintenanceWindow", maintenanceWindow()).add("SoftwareSetUpdateMode", softwareSetUpdateModeAsString())
                .add("DesiredSoftwareSetId", desiredSoftwareSetId()).add("PendingSoftwareSetId", pendingSoftwareSetId())
                .add("PendingSoftwareSetVersion", pendingSoftwareSetVersion())
                .add("SoftwareSetComplianceStatus", softwareSetComplianceStatusAsString()).add("CreatedAt", createdAt())
                .add("UpdatedAt", updatedAt()).add("Arn", arn()).add("KmsKeyArn", kmsKeyArn())
                .add("Tags", tags() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DeviceCreationTags", deviceCreationTags() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "desktopArn":
            return Optional.ofNullable(clazz.cast(desktopArn()));
        case "desktopEndpoint":
            return Optional.ofNullable(clazz.cast(desktopEndpoint()));
        case "desktopType":
            return Optional.ofNullable(clazz.cast(desktopTypeAsString()));
        case "activationCode":
            return Optional.ofNullable(clazz.cast(activationCode()));
        case "registeredDevicesCount":
            return Optional.ofNullable(clazz.cast(registeredDevicesCount()));
        case "softwareSetUpdateSchedule":
            return Optional.ofNullable(clazz.cast(softwareSetUpdateScheduleAsString()));
        case "maintenanceWindow":
            return Optional.ofNullable(clazz.cast(maintenanceWindow()));
        case "softwareSetUpdateMode":
            return Optional.ofNullable(clazz.cast(softwareSetUpdateModeAsString()));
        case "desiredSoftwareSetId":
            return Optional.ofNullable(clazz.cast(desiredSoftwareSetId()));
        case "pendingSoftwareSetId":
            return Optional.ofNullable(clazz.cast(pendingSoftwareSetId()));
        case "pendingSoftwareSetVersion":
            return Optional.ofNullable(clazz.cast(pendingSoftwareSetVersion()));
        case "softwareSetComplianceStatus":
            return Optional.ofNullable(clazz.cast(softwareSetComplianceStatusAsString()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "kmsKeyArn":
            return Optional.ofNullable(clazz.cast(kmsKeyArn()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "deviceCreationTags":
            return Optional.ofNullable(clazz.cast(deviceCreationTags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Environment, T> g) {
        return obj -> g.apply((Environment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Environment> {
        /**
         * <p>
         * The ID of the environment.
         * </p>
         * 
         * @param id
         *        The ID of the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the environment.
         * </p>
         * 
         * @param name
         *        The name of the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the desktop to stream from Amazon WorkSpaces, WorkSpaces Web, or AppStream
         * 2.0.
         * </p>
         * 
         * @param desktopArn
         *        The Amazon Resource Name (ARN) of the desktop to stream from Amazon WorkSpaces, WorkSpaces Web, or
         *        AppStream 2.0.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desktopArn(String desktopArn);

        /**
         * <p>
         * The URL for the identity provider login (only for environments that use AppStream 2.0).
         * </p>
         * 
         * @param desktopEndpoint
         *        The URL for the identity provider login (only for environments that use AppStream 2.0).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desktopEndpoint(String desktopEndpoint);

        /**
         * <p>
         * The type of streaming desktop for the environment.
         * </p>
         * 
         * @param desktopType
         *        The type of streaming desktop for the environment.
         * @see DesktopType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DesktopType
         */
        Builder desktopType(String desktopType);

        /**
         * <p>
         * The type of streaming desktop for the environment.
         * </p>
         * 
         * @param desktopType
         *        The type of streaming desktop for the environment.
         * @see DesktopType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DesktopType
         */
        Builder desktopType(DesktopType desktopType);

        /**
         * <p>
         * The activation code to register a device to the environment.
         * </p>
         * 
         * @param activationCode
         *        The activation code to register a device to the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activationCode(String activationCode);

        /**
         * <p>
         * The number of devices registered to the environment.
         * </p>
         * 
         * @param registeredDevicesCount
         *        The number of devices registered to the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registeredDevicesCount(Integer registeredDevicesCount);

        /**
         * <p>
         * An option to define if software updates should be applied within a maintenance window.
         * </p>
         * 
         * @param softwareSetUpdateSchedule
         *        An option to define if software updates should be applied within a maintenance window.
         * @see SoftwareSetUpdateSchedule
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SoftwareSetUpdateSchedule
         */
        Builder softwareSetUpdateSchedule(String softwareSetUpdateSchedule);

        /**
         * <p>
         * An option to define if software updates should be applied within a maintenance window.
         * </p>
         * 
         * @param softwareSetUpdateSchedule
         *        An option to define if software updates should be applied within a maintenance window.
         * @see SoftwareSetUpdateSchedule
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SoftwareSetUpdateSchedule
         */
        Builder softwareSetUpdateSchedule(SoftwareSetUpdateSchedule softwareSetUpdateSchedule);

        /**
         * <p>
         * A specification for a time window to apply software updates.
         * </p>
         * 
         * @param maintenanceWindow
         *        A specification for a time window to apply software updates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maintenanceWindow(MaintenanceWindow maintenanceWindow);

        /**
         * <p>
         * A specification for a time window to apply software updates.
         * </p>
         * This is a convenience method that creates an instance of the {@link MaintenanceWindow.Builder} avoiding the
         * need to create one manually via {@link MaintenanceWindow#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MaintenanceWindow.Builder#build()} is called immediately and its
         * result is passed to {@link #maintenanceWindow(MaintenanceWindow)}.
         * 
         * @param maintenanceWindow
         *        a consumer that will call methods on {@link MaintenanceWindow.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #maintenanceWindow(MaintenanceWindow)
         */
        default Builder maintenanceWindow(Consumer<MaintenanceWindow.Builder> maintenanceWindow) {
            return maintenanceWindow(MaintenanceWindow.builder().applyMutation(maintenanceWindow).build());
        }

        /**
         * <p>
         * An option to define which software updates to apply.
         * </p>
         * 
         * @param softwareSetUpdateMode
         *        An option to define which software updates to apply.
         * @see SoftwareSetUpdateMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SoftwareSetUpdateMode
         */
        Builder softwareSetUpdateMode(String softwareSetUpdateMode);

        /**
         * <p>
         * An option to define which software updates to apply.
         * </p>
         * 
         * @param softwareSetUpdateMode
         *        An option to define which software updates to apply.
         * @see SoftwareSetUpdateMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SoftwareSetUpdateMode
         */
        Builder softwareSetUpdateMode(SoftwareSetUpdateMode softwareSetUpdateMode);

        /**
         * <p>
         * The ID of the software set to apply.
         * </p>
         * 
         * @param desiredSoftwareSetId
         *        The ID of the software set to apply.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredSoftwareSetId(String desiredSoftwareSetId);

        /**
         * <p>
         * The ID of the software set that is pending to be installed.
         * </p>
         * 
         * @param pendingSoftwareSetId
         *        The ID of the software set that is pending to be installed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pendingSoftwareSetId(String pendingSoftwareSetId);

        /**
         * <p>
         * The version of the software set that is pending to be installed.
         * </p>
         * 
         * @param pendingSoftwareSetVersion
         *        The version of the software set that is pending to be installed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pendingSoftwareSetVersion(String pendingSoftwareSetVersion);

        /**
         * <p>
         * Describes if the software currently installed on all devices in the environment is a supported version.
         * </p>
         * 
         * @param softwareSetComplianceStatus
         *        Describes if the software currently installed on all devices in the environment is a supported
         *        version.
         * @see EnvironmentSoftwareSetComplianceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnvironmentSoftwareSetComplianceStatus
         */
        Builder softwareSetComplianceStatus(String softwareSetComplianceStatus);

        /**
         * <p>
         * Describes if the software currently installed on all devices in the environment is a supported version.
         * </p>
         * 
         * @param softwareSetComplianceStatus
         *        Describes if the software currently installed on all devices in the environment is a supported
         *        version.
         * @see EnvironmentSoftwareSetComplianceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnvironmentSoftwareSetComplianceStatus
         */
        Builder softwareSetComplianceStatus(EnvironmentSoftwareSetComplianceStatus softwareSetComplianceStatus);

        /**
         * <p>
         * The timestamp of when the environment was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp of when the environment was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The timestamp of when the device was updated.
         * </p>
         * 
         * @param updatedAt
         *        The timestamp of when the device was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the environment.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Key Management Service key used to encrypt the environment.
         * </p>
         * 
         * @param kmsKeyArn
         *        The Amazon Resource Name (ARN) of the Key Management Service key used to encrypt the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyArn(String kmsKeyArn);

        /**
         * <p>
         * The tag keys and optional values for the resource.
         * </p>
         * 
         * @param tags
         *        The tag keys and optional values for the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * "The tag keys and optional values for the newly created devices for this environment."
         * </p>
         * 
         * @param deviceCreationTags
         *        "The tag keys and optional values for the newly created devices for this environment."
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceCreationTags(Map<String, String> deviceCreationTags);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String name;

        private String desktopArn;

        private String desktopEndpoint;

        private String desktopType;

        private String activationCode;

        private Integer registeredDevicesCount;

        private String softwareSetUpdateSchedule;

        private MaintenanceWindow maintenanceWindow;

        private String softwareSetUpdateMode;

        private String desiredSoftwareSetId;

        private String pendingSoftwareSetId;

        private String pendingSoftwareSetVersion;

        private String softwareSetComplianceStatus;

        private Instant createdAt;

        private Instant updatedAt;

        private String arn;

        private String kmsKeyArn;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> deviceCreationTags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Environment model) {
            id(model.id);
            name(model.name);
            desktopArn(model.desktopArn);
            desktopEndpoint(model.desktopEndpoint);
            desktopType(model.desktopType);
            activationCode(model.activationCode);
            registeredDevicesCount(model.registeredDevicesCount);
            softwareSetUpdateSchedule(model.softwareSetUpdateSchedule);
            maintenanceWindow(model.maintenanceWindow);
            softwareSetUpdateMode(model.softwareSetUpdateMode);
            desiredSoftwareSetId(model.desiredSoftwareSetId);
            pendingSoftwareSetId(model.pendingSoftwareSetId);
            pendingSoftwareSetVersion(model.pendingSoftwareSetVersion);
            softwareSetComplianceStatus(model.softwareSetComplianceStatus);
            createdAt(model.createdAt);
            updatedAt(model.updatedAt);
            arn(model.arn);
            kmsKeyArn(model.kmsKeyArn);
            tags(model.tags);
            deviceCreationTags(model.deviceCreationTags);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDesktopArn() {
            return desktopArn;
        }

        public final void setDesktopArn(String desktopArn) {
            this.desktopArn = desktopArn;
        }

        @Override
        public final Builder desktopArn(String desktopArn) {
            this.desktopArn = desktopArn;
            return this;
        }

        public final String getDesktopEndpoint() {
            return desktopEndpoint;
        }

        public final void setDesktopEndpoint(String desktopEndpoint) {
            this.desktopEndpoint = desktopEndpoint;
        }

        @Override
        public final Builder desktopEndpoint(String desktopEndpoint) {
            this.desktopEndpoint = desktopEndpoint;
            return this;
        }

        public final String getDesktopType() {
            return desktopType;
        }

        public final void setDesktopType(String desktopType) {
            this.desktopType = desktopType;
        }

        @Override
        public final Builder desktopType(String desktopType) {
            this.desktopType = desktopType;
            return this;
        }

        @Override
        public final Builder desktopType(DesktopType desktopType) {
            this.desktopType(desktopType == null ? null : desktopType.toString());
            return this;
        }

        public final String getActivationCode() {
            return activationCode;
        }

        public final void setActivationCode(String activationCode) {
            this.activationCode = activationCode;
        }

        @Override
        public final Builder activationCode(String activationCode) {
            this.activationCode = activationCode;
            return this;
        }

        public final Integer getRegisteredDevicesCount() {
            return registeredDevicesCount;
        }

        public final void setRegisteredDevicesCount(Integer registeredDevicesCount) {
            this.registeredDevicesCount = registeredDevicesCount;
        }

        @Override
        public final Builder registeredDevicesCount(Integer registeredDevicesCount) {
            this.registeredDevicesCount = registeredDevicesCount;
            return this;
        }

        public final String getSoftwareSetUpdateSchedule() {
            return softwareSetUpdateSchedule;
        }

        public final void setSoftwareSetUpdateSchedule(String softwareSetUpdateSchedule) {
            this.softwareSetUpdateSchedule = softwareSetUpdateSchedule;
        }

        @Override
        public final Builder softwareSetUpdateSchedule(String softwareSetUpdateSchedule) {
            this.softwareSetUpdateSchedule = softwareSetUpdateSchedule;
            return this;
        }

        @Override
        public final Builder softwareSetUpdateSchedule(SoftwareSetUpdateSchedule softwareSetUpdateSchedule) {
            this.softwareSetUpdateSchedule(softwareSetUpdateSchedule == null ? null : softwareSetUpdateSchedule.toString());
            return this;
        }

        public final MaintenanceWindow.Builder getMaintenanceWindow() {
            return maintenanceWindow != null ? maintenanceWindow.toBuilder() : null;
        }

        public final void setMaintenanceWindow(MaintenanceWindow.BuilderImpl maintenanceWindow) {
            this.maintenanceWindow = maintenanceWindow != null ? maintenanceWindow.build() : null;
        }

        @Override
        public final Builder maintenanceWindow(MaintenanceWindow maintenanceWindow) {
            this.maintenanceWindow = maintenanceWindow;
            return this;
        }

        public final String getSoftwareSetUpdateMode() {
            return softwareSetUpdateMode;
        }

        public final void setSoftwareSetUpdateMode(String softwareSetUpdateMode) {
            this.softwareSetUpdateMode = softwareSetUpdateMode;
        }

        @Override
        public final Builder softwareSetUpdateMode(String softwareSetUpdateMode) {
            this.softwareSetUpdateMode = softwareSetUpdateMode;
            return this;
        }

        @Override
        public final Builder softwareSetUpdateMode(SoftwareSetUpdateMode softwareSetUpdateMode) {
            this.softwareSetUpdateMode(softwareSetUpdateMode == null ? null : softwareSetUpdateMode.toString());
            return this;
        }

        public final String getDesiredSoftwareSetId() {
            return desiredSoftwareSetId;
        }

        public final void setDesiredSoftwareSetId(String desiredSoftwareSetId) {
            this.desiredSoftwareSetId = desiredSoftwareSetId;
        }

        @Override
        public final Builder desiredSoftwareSetId(String desiredSoftwareSetId) {
            this.desiredSoftwareSetId = desiredSoftwareSetId;
            return this;
        }

        public final String getPendingSoftwareSetId() {
            return pendingSoftwareSetId;
        }

        public final void setPendingSoftwareSetId(String pendingSoftwareSetId) {
            this.pendingSoftwareSetId = pendingSoftwareSetId;
        }

        @Override
        public final Builder pendingSoftwareSetId(String pendingSoftwareSetId) {
            this.pendingSoftwareSetId = pendingSoftwareSetId;
            return this;
        }

        public final String getPendingSoftwareSetVersion() {
            return pendingSoftwareSetVersion;
        }

        public final void setPendingSoftwareSetVersion(String pendingSoftwareSetVersion) {
            this.pendingSoftwareSetVersion = pendingSoftwareSetVersion;
        }

        @Override
        public final Builder pendingSoftwareSetVersion(String pendingSoftwareSetVersion) {
            this.pendingSoftwareSetVersion = pendingSoftwareSetVersion;
            return this;
        }

        public final String getSoftwareSetComplianceStatus() {
            return softwareSetComplianceStatus;
        }

        public final void setSoftwareSetComplianceStatus(String softwareSetComplianceStatus) {
            this.softwareSetComplianceStatus = softwareSetComplianceStatus;
        }

        @Override
        public final Builder softwareSetComplianceStatus(String softwareSetComplianceStatus) {
            this.softwareSetComplianceStatus = softwareSetComplianceStatus;
            return this;
        }

        @Override
        public final Builder softwareSetComplianceStatus(EnvironmentSoftwareSetComplianceStatus softwareSetComplianceStatus) {
            this.softwareSetComplianceStatus(softwareSetComplianceStatus == null ? null : softwareSetComplianceStatus.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getKmsKeyArn() {
            return kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        public final Map<String, String> getDeviceCreationTags() {
            if (deviceCreationTags instanceof SdkAutoConstructMap) {
                return null;
            }
            return deviceCreationTags;
        }

        public final void setDeviceCreationTags(Map<String, String> deviceCreationTags) {
            this.deviceCreationTags = DeviceCreationTagsMapCopier.copy(deviceCreationTags);
        }

        @Override
        public final Builder deviceCreationTags(Map<String, String> deviceCreationTags) {
            this.deviceCreationTags = DeviceCreationTagsMapCopier.copy(deviceCreationTags);
            return this;
        }

        @Override
        public Environment build() {
            return new Environment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
