/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspacesthinclient.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an environment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnvironmentSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<EnvironmentSummary.Builder, EnvironmentSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(EnvironmentSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(EnvironmentSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESKTOP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("desktopArn").getter(getter(EnvironmentSummary::desktopArn)).setter(setter(Builder::desktopArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("desktopArn").build()).build();

    private static final SdkField<String> DESKTOP_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("desktopEndpoint").getter(getter(EnvironmentSummary::desktopEndpoint))
            .setter(setter(Builder::desktopEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("desktopEndpoint").build()).build();

    private static final SdkField<String> DESKTOP_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("desktopType").getter(getter(EnvironmentSummary::desktopTypeAsString))
            .setter(setter(Builder::desktopType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("desktopType").build()).build();

    private static final SdkField<String> ACTIVATION_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("activationCode").getter(getter(EnvironmentSummary::activationCode))
            .setter(setter(Builder::activationCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activationCode").build()).build();

    private static final SdkField<String> SOFTWARE_SET_UPDATE_SCHEDULE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("softwareSetUpdateSchedule").getter(getter(EnvironmentSummary::softwareSetUpdateScheduleAsString))
            .setter(setter(Builder::softwareSetUpdateSchedule))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("softwareSetUpdateSchedule").build())
            .build();

    private static final SdkField<MaintenanceWindow> MAINTENANCE_WINDOW_FIELD = SdkField
            .<MaintenanceWindow> builder(MarshallingType.SDK_POJO).memberName("maintenanceWindow")
            .getter(getter(EnvironmentSummary::maintenanceWindow)).setter(setter(Builder::maintenanceWindow))
            .constructor(MaintenanceWindow::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maintenanceWindow").build()).build();

    private static final SdkField<String> SOFTWARE_SET_UPDATE_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("softwareSetUpdateMode").getter(getter(EnvironmentSummary::softwareSetUpdateModeAsString))
            .setter(setter(Builder::softwareSetUpdateMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("softwareSetUpdateMode").build())
            .build();

    private static final SdkField<String> DESIRED_SOFTWARE_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("desiredSoftwareSetId").getter(getter(EnvironmentSummary::desiredSoftwareSetId))
            .setter(setter(Builder::desiredSoftwareSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("desiredSoftwareSetId").build())
            .build();

    private static final SdkField<String> PENDING_SOFTWARE_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("pendingSoftwareSetId").getter(getter(EnvironmentSummary::pendingSoftwareSetId))
            .setter(setter(Builder::pendingSoftwareSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pendingSoftwareSetId").build())
            .build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(EnvironmentSummary::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt").getter(getter(EnvironmentSummary::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(EnvironmentSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD,
            DESKTOP_ARN_FIELD, DESKTOP_ENDPOINT_FIELD, DESKTOP_TYPE_FIELD, ACTIVATION_CODE_FIELD,
            SOFTWARE_SET_UPDATE_SCHEDULE_FIELD, MAINTENANCE_WINDOW_FIELD, SOFTWARE_SET_UPDATE_MODE_FIELD,
            DESIRED_SOFTWARE_SET_ID_FIELD, PENDING_SOFTWARE_SET_ID_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String name;

    private final String desktopArn;

    private final String desktopEndpoint;

    private final String desktopType;

    private final String activationCode;

    private final String softwareSetUpdateSchedule;

    private final MaintenanceWindow maintenanceWindow;

    private final String softwareSetUpdateMode;

    private final String desiredSoftwareSetId;

    private final String pendingSoftwareSetId;

    private final Instant createdAt;

    private final Instant updatedAt;

    private final String arn;

    private EnvironmentSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.desktopArn = builder.desktopArn;
        this.desktopEndpoint = builder.desktopEndpoint;
        this.desktopType = builder.desktopType;
        this.activationCode = builder.activationCode;
        this.softwareSetUpdateSchedule = builder.softwareSetUpdateSchedule;
        this.maintenanceWindow = builder.maintenanceWindow;
        this.softwareSetUpdateMode = builder.softwareSetUpdateMode;
        this.desiredSoftwareSetId = builder.desiredSoftwareSetId;
        this.pendingSoftwareSetId = builder.pendingSoftwareSetId;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.arn = builder.arn;
    }

    /**
     * <p>
     * The ID of the environment.
     * </p>
     * 
     * @return The ID of the environment.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the environment.
     * </p>
     * 
     * @return The name of the environment.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the desktop to stream from Amazon WorkSpaces, WorkSpaces Web, or AppStream 2.0.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the desktop to stream from Amazon WorkSpaces, WorkSpaces Web, or
     *         AppStream 2.0.
     */
    public final String desktopArn() {
        return desktopArn;
    }

    /**
     * <p>
     * The URL for the identity provider login (only for environments that use AppStream 2.0).
     * </p>
     * 
     * @return The URL for the identity provider login (only for environments that use AppStream 2.0).
     */
    public final String desktopEndpoint() {
        return desktopEndpoint;
    }

    /**
     * <p>
     * The type of streaming desktop for the environment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #desktopType} will
     * return {@link DesktopType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #desktopTypeAsString}.
     * </p>
     * 
     * @return The type of streaming desktop for the environment.
     * @see DesktopType
     */
    public final DesktopType desktopType() {
        return DesktopType.fromValue(desktopType);
    }

    /**
     * <p>
     * The type of streaming desktop for the environment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #desktopType} will
     * return {@link DesktopType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #desktopTypeAsString}.
     * </p>
     * 
     * @return The type of streaming desktop for the environment.
     * @see DesktopType
     */
    public final String desktopTypeAsString() {
        return desktopType;
    }

    /**
     * <p>
     * The activation code to register a device to the environment.
     * </p>
     * 
     * @return The activation code to register a device to the environment.
     */
    public final String activationCode() {
        return activationCode;
    }

    /**
     * <p>
     * An option to define if software updates should be applied within a maintenance window.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #softwareSetUpdateSchedule} will return {@link SoftwareSetUpdateSchedule#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #softwareSetUpdateScheduleAsString}.
     * </p>
     * 
     * @return An option to define if software updates should be applied within a maintenance window.
     * @see SoftwareSetUpdateSchedule
     */
    public final SoftwareSetUpdateSchedule softwareSetUpdateSchedule() {
        return SoftwareSetUpdateSchedule.fromValue(softwareSetUpdateSchedule);
    }

    /**
     * <p>
     * An option to define if software updates should be applied within a maintenance window.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #softwareSetUpdateSchedule} will return {@link SoftwareSetUpdateSchedule#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #softwareSetUpdateScheduleAsString}.
     * </p>
     * 
     * @return An option to define if software updates should be applied within a maintenance window.
     * @see SoftwareSetUpdateSchedule
     */
    public final String softwareSetUpdateScheduleAsString() {
        return softwareSetUpdateSchedule;
    }

    /**
     * <p>
     * A specification for a time window to apply software updates.
     * </p>
     * 
     * @return A specification for a time window to apply software updates.
     */
    public final MaintenanceWindow maintenanceWindow() {
        return maintenanceWindow;
    }

    /**
     * <p>
     * An option to define which software updates to apply.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #softwareSetUpdateMode} will return {@link SoftwareSetUpdateMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #softwareSetUpdateModeAsString}.
     * </p>
     * 
     * @return An option to define which software updates to apply.
     * @see SoftwareSetUpdateMode
     */
    public final SoftwareSetUpdateMode softwareSetUpdateMode() {
        return SoftwareSetUpdateMode.fromValue(softwareSetUpdateMode);
    }

    /**
     * <p>
     * An option to define which software updates to apply.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #softwareSetUpdateMode} will return {@link SoftwareSetUpdateMode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #softwareSetUpdateModeAsString}.
     * </p>
     * 
     * @return An option to define which software updates to apply.
     * @see SoftwareSetUpdateMode
     */
    public final String softwareSetUpdateModeAsString() {
        return softwareSetUpdateMode;
    }

    /**
     * <p>
     * The ID of the software set to apply.
     * </p>
     * 
     * @return The ID of the software set to apply.
     */
    public final String desiredSoftwareSetId() {
        return desiredSoftwareSetId;
    }

    /**
     * <p>
     * The ID of the software set that is pending to be installed.
     * </p>
     * 
     * @return The ID of the software set that is pending to be installed.
     */
    public final String pendingSoftwareSetId() {
        return pendingSoftwareSetId;
    }

    /**
     * <p>
     * The timestamp of when the environment was created.
     * </p>
     * 
     * @return The timestamp of when the environment was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The timestamp of when the device was updated.
     * </p>
     * 
     * @return The timestamp of when the device was updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the environment.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the environment.
     */
    public final String arn() {
        return arn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(desktopArn());
        hashCode = 31 * hashCode + Objects.hashCode(desktopEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(desktopTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(activationCode());
        hashCode = 31 * hashCode + Objects.hashCode(softwareSetUpdateScheduleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(softwareSetUpdateModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(desiredSoftwareSetId());
        hashCode = 31 * hashCode + Objects.hashCode(pendingSoftwareSetId());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnvironmentSummary)) {
            return false;
        }
        EnvironmentSummary other = (EnvironmentSummary) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(desktopArn(), other.desktopArn()) && Objects.equals(desktopEndpoint(), other.desktopEndpoint())
                && Objects.equals(desktopTypeAsString(), other.desktopTypeAsString())
                && Objects.equals(activationCode(), other.activationCode())
                && Objects.equals(softwareSetUpdateScheduleAsString(), other.softwareSetUpdateScheduleAsString())
                && Objects.equals(maintenanceWindow(), other.maintenanceWindow())
                && Objects.equals(softwareSetUpdateModeAsString(), other.softwareSetUpdateModeAsString())
                && Objects.equals(desiredSoftwareSetId(), other.desiredSoftwareSetId())
                && Objects.equals(pendingSoftwareSetId(), other.pendingSoftwareSetId())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(updatedAt(), other.updatedAt())
                && Objects.equals(arn(), other.arn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EnvironmentSummary").add("Id", id())
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***").add("DesktopArn", desktopArn())
                .add("DesktopEndpoint", desktopEndpoint() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DesktopType", desktopTypeAsString()).add("ActivationCode", activationCode())
                .add("SoftwareSetUpdateSchedule", softwareSetUpdateScheduleAsString())
                .add("MaintenanceWindow", maintenanceWindow()).add("SoftwareSetUpdateMode", softwareSetUpdateModeAsString())
                .add("DesiredSoftwareSetId", desiredSoftwareSetId()).add("PendingSoftwareSetId", pendingSoftwareSetId())
                .add("CreatedAt", createdAt()).add("UpdatedAt", updatedAt()).add("Arn", arn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "desktopArn":
            return Optional.ofNullable(clazz.cast(desktopArn()));
        case "desktopEndpoint":
            return Optional.ofNullable(clazz.cast(desktopEndpoint()));
        case "desktopType":
            return Optional.ofNullable(clazz.cast(desktopTypeAsString()));
        case "activationCode":
            return Optional.ofNullable(clazz.cast(activationCode()));
        case "softwareSetUpdateSchedule":
            return Optional.ofNullable(clazz.cast(softwareSetUpdateScheduleAsString()));
        case "maintenanceWindow":
            return Optional.ofNullable(clazz.cast(maintenanceWindow()));
        case "softwareSetUpdateMode":
            return Optional.ofNullable(clazz.cast(softwareSetUpdateModeAsString()));
        case "desiredSoftwareSetId":
            return Optional.ofNullable(clazz.cast(desiredSoftwareSetId()));
        case "pendingSoftwareSetId":
            return Optional.ofNullable(clazz.cast(pendingSoftwareSetId()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EnvironmentSummary, T> g) {
        return obj -> g.apply((EnvironmentSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EnvironmentSummary> {
        /**
         * <p>
         * The ID of the environment.
         * </p>
         * 
         * @param id
         *        The ID of the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the environment.
         * </p>
         * 
         * @param name
         *        The name of the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the desktop to stream from Amazon WorkSpaces, WorkSpaces Web, or AppStream
         * 2.0.
         * </p>
         * 
         * @param desktopArn
         *        The Amazon Resource Name (ARN) of the desktop to stream from Amazon WorkSpaces, WorkSpaces Web, or
         *        AppStream 2.0.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desktopArn(String desktopArn);

        /**
         * <p>
         * The URL for the identity provider login (only for environments that use AppStream 2.0).
         * </p>
         * 
         * @param desktopEndpoint
         *        The URL for the identity provider login (only for environments that use AppStream 2.0).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desktopEndpoint(String desktopEndpoint);

        /**
         * <p>
         * The type of streaming desktop for the environment.
         * </p>
         * 
         * @param desktopType
         *        The type of streaming desktop for the environment.
         * @see DesktopType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DesktopType
         */
        Builder desktopType(String desktopType);

        /**
         * <p>
         * The type of streaming desktop for the environment.
         * </p>
         * 
         * @param desktopType
         *        The type of streaming desktop for the environment.
         * @see DesktopType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DesktopType
         */
        Builder desktopType(DesktopType desktopType);

        /**
         * <p>
         * The activation code to register a device to the environment.
         * </p>
         * 
         * @param activationCode
         *        The activation code to register a device to the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activationCode(String activationCode);

        /**
         * <p>
         * An option to define if software updates should be applied within a maintenance window.
         * </p>
         * 
         * @param softwareSetUpdateSchedule
         *        An option to define if software updates should be applied within a maintenance window.
         * @see SoftwareSetUpdateSchedule
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SoftwareSetUpdateSchedule
         */
        Builder softwareSetUpdateSchedule(String softwareSetUpdateSchedule);

        /**
         * <p>
         * An option to define if software updates should be applied within a maintenance window.
         * </p>
         * 
         * @param softwareSetUpdateSchedule
         *        An option to define if software updates should be applied within a maintenance window.
         * @see SoftwareSetUpdateSchedule
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SoftwareSetUpdateSchedule
         */
        Builder softwareSetUpdateSchedule(SoftwareSetUpdateSchedule softwareSetUpdateSchedule);

        /**
         * <p>
         * A specification for a time window to apply software updates.
         * </p>
         * 
         * @param maintenanceWindow
         *        A specification for a time window to apply software updates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maintenanceWindow(MaintenanceWindow maintenanceWindow);

        /**
         * <p>
         * A specification for a time window to apply software updates.
         * </p>
         * This is a convenience method that creates an instance of the {@link MaintenanceWindow.Builder} avoiding the
         * need to create one manually via {@link MaintenanceWindow#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MaintenanceWindow.Builder#build()} is called immediately and its
         * result is passed to {@link #maintenanceWindow(MaintenanceWindow)}.
         * 
         * @param maintenanceWindow
         *        a consumer that will call methods on {@link MaintenanceWindow.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #maintenanceWindow(MaintenanceWindow)
         */
        default Builder maintenanceWindow(Consumer<MaintenanceWindow.Builder> maintenanceWindow) {
            return maintenanceWindow(MaintenanceWindow.builder().applyMutation(maintenanceWindow).build());
        }

        /**
         * <p>
         * An option to define which software updates to apply.
         * </p>
         * 
         * @param softwareSetUpdateMode
         *        An option to define which software updates to apply.
         * @see SoftwareSetUpdateMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SoftwareSetUpdateMode
         */
        Builder softwareSetUpdateMode(String softwareSetUpdateMode);

        /**
         * <p>
         * An option to define which software updates to apply.
         * </p>
         * 
         * @param softwareSetUpdateMode
         *        An option to define which software updates to apply.
         * @see SoftwareSetUpdateMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SoftwareSetUpdateMode
         */
        Builder softwareSetUpdateMode(SoftwareSetUpdateMode softwareSetUpdateMode);

        /**
         * <p>
         * The ID of the software set to apply.
         * </p>
         * 
         * @param desiredSoftwareSetId
         *        The ID of the software set to apply.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredSoftwareSetId(String desiredSoftwareSetId);

        /**
         * <p>
         * The ID of the software set that is pending to be installed.
         * </p>
         * 
         * @param pendingSoftwareSetId
         *        The ID of the software set that is pending to be installed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pendingSoftwareSetId(String pendingSoftwareSetId);

        /**
         * <p>
         * The timestamp of when the environment was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp of when the environment was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The timestamp of when the device was updated.
         * </p>
         * 
         * @param updatedAt
         *        The timestamp of when the device was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the environment.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String name;

        private String desktopArn;

        private String desktopEndpoint;

        private String desktopType;

        private String activationCode;

        private String softwareSetUpdateSchedule;

        private MaintenanceWindow maintenanceWindow;

        private String softwareSetUpdateMode;

        private String desiredSoftwareSetId;

        private String pendingSoftwareSetId;

        private Instant createdAt;

        private Instant updatedAt;

        private String arn;

        private BuilderImpl() {
        }

        private BuilderImpl(EnvironmentSummary model) {
            id(model.id);
            name(model.name);
            desktopArn(model.desktopArn);
            desktopEndpoint(model.desktopEndpoint);
            desktopType(model.desktopType);
            activationCode(model.activationCode);
            softwareSetUpdateSchedule(model.softwareSetUpdateSchedule);
            maintenanceWindow(model.maintenanceWindow);
            softwareSetUpdateMode(model.softwareSetUpdateMode);
            desiredSoftwareSetId(model.desiredSoftwareSetId);
            pendingSoftwareSetId(model.pendingSoftwareSetId);
            createdAt(model.createdAt);
            updatedAt(model.updatedAt);
            arn(model.arn);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDesktopArn() {
            return desktopArn;
        }

        public final void setDesktopArn(String desktopArn) {
            this.desktopArn = desktopArn;
        }

        @Override
        public final Builder desktopArn(String desktopArn) {
            this.desktopArn = desktopArn;
            return this;
        }

        public final String getDesktopEndpoint() {
            return desktopEndpoint;
        }

        public final void setDesktopEndpoint(String desktopEndpoint) {
            this.desktopEndpoint = desktopEndpoint;
        }

        @Override
        public final Builder desktopEndpoint(String desktopEndpoint) {
            this.desktopEndpoint = desktopEndpoint;
            return this;
        }

        public final String getDesktopType() {
            return desktopType;
        }

        public final void setDesktopType(String desktopType) {
            this.desktopType = desktopType;
        }

        @Override
        public final Builder desktopType(String desktopType) {
            this.desktopType = desktopType;
            return this;
        }

        @Override
        public final Builder desktopType(DesktopType desktopType) {
            this.desktopType(desktopType == null ? null : desktopType.toString());
            return this;
        }

        public final String getActivationCode() {
            return activationCode;
        }

        public final void setActivationCode(String activationCode) {
            this.activationCode = activationCode;
        }

        @Override
        public final Builder activationCode(String activationCode) {
            this.activationCode = activationCode;
            return this;
        }

        public final String getSoftwareSetUpdateSchedule() {
            return softwareSetUpdateSchedule;
        }

        public final void setSoftwareSetUpdateSchedule(String softwareSetUpdateSchedule) {
            this.softwareSetUpdateSchedule = softwareSetUpdateSchedule;
        }

        @Override
        public final Builder softwareSetUpdateSchedule(String softwareSetUpdateSchedule) {
            this.softwareSetUpdateSchedule = softwareSetUpdateSchedule;
            return this;
        }

        @Override
        public final Builder softwareSetUpdateSchedule(SoftwareSetUpdateSchedule softwareSetUpdateSchedule) {
            this.softwareSetUpdateSchedule(softwareSetUpdateSchedule == null ? null : softwareSetUpdateSchedule.toString());
            return this;
        }

        public final MaintenanceWindow.Builder getMaintenanceWindow() {
            return maintenanceWindow != null ? maintenanceWindow.toBuilder() : null;
        }

        public final void setMaintenanceWindow(MaintenanceWindow.BuilderImpl maintenanceWindow) {
            this.maintenanceWindow = maintenanceWindow != null ? maintenanceWindow.build() : null;
        }

        @Override
        public final Builder maintenanceWindow(MaintenanceWindow maintenanceWindow) {
            this.maintenanceWindow = maintenanceWindow;
            return this;
        }

        public final String getSoftwareSetUpdateMode() {
            return softwareSetUpdateMode;
        }

        public final void setSoftwareSetUpdateMode(String softwareSetUpdateMode) {
            this.softwareSetUpdateMode = softwareSetUpdateMode;
        }

        @Override
        public final Builder softwareSetUpdateMode(String softwareSetUpdateMode) {
            this.softwareSetUpdateMode = softwareSetUpdateMode;
            return this;
        }

        @Override
        public final Builder softwareSetUpdateMode(SoftwareSetUpdateMode softwareSetUpdateMode) {
            this.softwareSetUpdateMode(softwareSetUpdateMode == null ? null : softwareSetUpdateMode.toString());
            return this;
        }

        public final String getDesiredSoftwareSetId() {
            return desiredSoftwareSetId;
        }

        public final void setDesiredSoftwareSetId(String desiredSoftwareSetId) {
            this.desiredSoftwareSetId = desiredSoftwareSetId;
        }

        @Override
        public final Builder desiredSoftwareSetId(String desiredSoftwareSetId) {
            this.desiredSoftwareSetId = desiredSoftwareSetId;
            return this;
        }

        public final String getPendingSoftwareSetId() {
            return pendingSoftwareSetId;
        }

        public final void setPendingSoftwareSetId(String pendingSoftwareSetId) {
            this.pendingSoftwareSetId = pendingSoftwareSetId;
        }

        @Override
        public final Builder pendingSoftwareSetId(String pendingSoftwareSetId) {
            this.pendingSoftwareSetId = pendingSoftwareSetId;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        @Override
        public EnvironmentSummary build() {
            return new EnvironmentSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
