/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspacesthinclient.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSoftwareSetsResponse extends WorkSpacesThinClientResponse implements
        ToCopyableBuilder<ListSoftwareSetsResponse.Builder, ListSoftwareSetsResponse> {
    private static final SdkField<List<SoftwareSetSummary>> SOFTWARE_SETS_FIELD = SdkField
            .<List<SoftwareSetSummary>> builder(MarshallingType.LIST)
            .memberName("softwareSets")
            .getter(getter(ListSoftwareSetsResponse::softwareSets))
            .setter(setter(Builder::softwareSets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("softwareSets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SoftwareSetSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(SoftwareSetSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListSoftwareSetsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOFTWARE_SETS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<SoftwareSetSummary> softwareSets;

    private final String nextToken;

    private ListSoftwareSetsResponse(BuilderImpl builder) {
        super(builder);
        this.softwareSets = builder.softwareSets;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the SoftwareSets property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSoftwareSets() {
        return softwareSets != null && !(softwareSets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Describes software sets.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSoftwareSets} method.
     * </p>
     * 
     * @return Describes software sets.
     */
    public final List<SoftwareSetSummary> softwareSets() {
        return softwareSets;
    }

    /**
     * <p>
     * If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is a
     * unique pagination token for each page. Make the call again using the returned token to retrieve the next page.
     * Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired pagination
     * token will return an <i>HTTP 400 InvalidToken error</i>.
     * </p>
     * 
     * @return If <code>nextToken</code> is returned, there are more results available. The value of
     *         <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned
     *         token to retrieve the next page. Keep all other arguments unchanged. Each pagination token expires after
     *         24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken error</i>.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSoftwareSets() ? softwareSets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSoftwareSetsResponse)) {
            return false;
        }
        ListSoftwareSetsResponse other = (ListSoftwareSetsResponse) obj;
        return hasSoftwareSets() == other.hasSoftwareSets() && Objects.equals(softwareSets(), other.softwareSets())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListSoftwareSetsResponse").add("SoftwareSets", hasSoftwareSets() ? softwareSets() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "softwareSets":
            return Optional.ofNullable(clazz.cast(softwareSets()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSoftwareSetsResponse, T> g) {
        return obj -> g.apply((ListSoftwareSetsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkSpacesThinClientResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListSoftwareSetsResponse> {
        /**
         * <p>
         * Describes software sets.
         * </p>
         * 
         * @param softwareSets
         *        Describes software sets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder softwareSets(Collection<SoftwareSetSummary> softwareSets);

        /**
         * <p>
         * Describes software sets.
         * </p>
         * 
         * @param softwareSets
         *        Describes software sets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder softwareSets(SoftwareSetSummary... softwareSets);

        /**
         * <p>
         * Describes software sets.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.workspacesthinclient.model.SoftwareSetSummary.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.workspacesthinclient.model.SoftwareSetSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.workspacesthinclient.model.SoftwareSetSummary.Builder#build()} is
         * called immediately and its result is passed to {@link #softwareSets(List<SoftwareSetSummary>)}.
         * 
         * @param softwareSets
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.workspacesthinclient.model.SoftwareSetSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #softwareSets(java.util.Collection<SoftwareSetSummary>)
         */
        Builder softwareSets(Consumer<SoftwareSetSummary.Builder>... softwareSets);

        /**
         * <p>
         * If <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code>
         * is a unique pagination token for each page. Make the call again using the returned token to retrieve the next
         * page. Keep all other arguments unchanged. Each pagination token expires after 24 hours. Using an expired
         * pagination token will return an <i>HTTP 400 InvalidToken error</i>.
         * </p>
         * 
         * @param nextToken
         *        If <code>nextToken</code> is returned, there are more results available. The value of
         *        <code>nextToken</code> is a unique pagination token for each page. Make the call again using the
         *        returned token to retrieve the next page. Keep all other arguments unchanged. Each pagination token
         *        expires after 24 hours. Using an expired pagination token will return an <i>HTTP 400 InvalidToken
         *        error</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends WorkSpacesThinClientResponse.BuilderImpl implements Builder {
        private List<SoftwareSetSummary> softwareSets = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSoftwareSetsResponse model) {
            super(model);
            softwareSets(model.softwareSets);
            nextToken(model.nextToken);
        }

        public final List<SoftwareSetSummary.Builder> getSoftwareSets() {
            List<SoftwareSetSummary.Builder> result = SoftwareSetListCopier.copyToBuilder(this.softwareSets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSoftwareSets(Collection<SoftwareSetSummary.BuilderImpl> softwareSets) {
            this.softwareSets = SoftwareSetListCopier.copyFromBuilder(softwareSets);
        }

        @Override
        public final Builder softwareSets(Collection<SoftwareSetSummary> softwareSets) {
            this.softwareSets = SoftwareSetListCopier.copy(softwareSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder softwareSets(SoftwareSetSummary... softwareSets) {
            softwareSets(Arrays.asList(softwareSets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder softwareSets(Consumer<SoftwareSetSummary.Builder>... softwareSets) {
            softwareSets(Stream.of(softwareSets).map(c -> SoftwareSetSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListSoftwareSetsResponse build() {
            return new ListSoftwareSetsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
