/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspacesthinclient.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateEnvironmentResponse extends WorkSpacesThinClientResponse implements
        ToCopyableBuilder<CreateEnvironmentResponse.Builder, CreateEnvironmentResponse> {
    private static final SdkField<EnvironmentSummary> ENVIRONMENT_FIELD = SdkField
            .<EnvironmentSummary> builder(MarshallingType.SDK_POJO).memberName("environment")
            .getter(getter(CreateEnvironmentResponse::environment)).setter(setter(Builder::environment))
            .constructor(EnvironmentSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environment").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENVIRONMENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("environment", ENVIRONMENT_FIELD);
                }
            });

    private final EnvironmentSummary environment;

    private CreateEnvironmentResponse(BuilderImpl builder) {
        super(builder);
        this.environment = builder.environment;
    }

    /**
     * <p>
     * Describes an environment.
     * </p>
     * 
     * @return Describes an environment.
     */
    public final EnvironmentSummary environment() {
        return environment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(environment());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEnvironmentResponse)) {
            return false;
        }
        CreateEnvironmentResponse other = (CreateEnvironmentResponse) obj;
        return Objects.equals(environment(), other.environment());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateEnvironmentResponse").add("Environment", environment()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "environment":
            return Optional.ofNullable(clazz.cast(environment()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateEnvironmentResponse, T> g) {
        return obj -> g.apply((CreateEnvironmentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkSpacesThinClientResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateEnvironmentResponse> {
        /**
         * <p>
         * Describes an environment.
         * </p>
         * 
         * @param environment
         *        Describes an environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environment(EnvironmentSummary environment);

        /**
         * <p>
         * Describes an environment.
         * </p>
         * This is a convenience method that creates an instance of the {@link EnvironmentSummary.Builder} avoiding the
         * need to create one manually via {@link EnvironmentSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EnvironmentSummary.Builder#build()} is called immediately and its
         * result is passed to {@link #environment(EnvironmentSummary)}.
         * 
         * @param environment
         *        a consumer that will call methods on {@link EnvironmentSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #environment(EnvironmentSummary)
         */
        default Builder environment(Consumer<EnvironmentSummary.Builder> environment) {
            return environment(EnvironmentSummary.builder().applyMutation(environment).build());
        }
    }

    static final class BuilderImpl extends WorkSpacesThinClientResponse.BuilderImpl implements Builder {
        private EnvironmentSummary environment;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEnvironmentResponse model) {
            super(model);
            environment(model.environment);
        }

        public final EnvironmentSummary.Builder getEnvironment() {
            return environment != null ? environment.toBuilder() : null;
        }

        public final void setEnvironment(EnvironmentSummary.BuilderImpl environment) {
            this.environment = environment != null ? environment.build() : null;
        }

        @Override
        public final Builder environment(EnvironmentSummary environment) {
            this.environment = environment;
            return this;
        }

        @Override
        public CreateEnvironmentResponse build() {
            return new CreateEnvironmentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
