/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspacesthinclient.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a thin client device.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeviceSummary implements SdkPojo, Serializable, ToCopyableBuilder<DeviceSummary.Builder, DeviceSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(DeviceSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> SERIAL_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serialNumber").getter(getter(DeviceSummary::serialNumber)).setter(setter(Builder::serialNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serialNumber").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(DeviceSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> MODEL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("model")
            .getter(getter(DeviceSummary::model)).setter(setter(Builder::model))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("model").build()).build();

    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("environmentId").getter(getter(DeviceSummary::environmentId)).setter(setter(Builder::environmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(DeviceSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> CURRENT_SOFTWARE_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("currentSoftwareSetId").getter(getter(DeviceSummary::currentSoftwareSetId))
            .setter(setter(Builder::currentSoftwareSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentSoftwareSetId").build())
            .build();

    private static final SdkField<String> DESIRED_SOFTWARE_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("desiredSoftwareSetId").getter(getter(DeviceSummary::desiredSoftwareSetId))
            .setter(setter(Builder::desiredSoftwareSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("desiredSoftwareSetId").build())
            .build();

    private static final SdkField<String> PENDING_SOFTWARE_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("pendingSoftwareSetId").getter(getter(DeviceSummary::pendingSoftwareSetId))
            .setter(setter(Builder::pendingSoftwareSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pendingSoftwareSetId").build())
            .build();

    private static final SdkField<String> SOFTWARE_SET_UPDATE_SCHEDULE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("softwareSetUpdateSchedule").getter(getter(DeviceSummary::softwareSetUpdateScheduleAsString))
            .setter(setter(Builder::softwareSetUpdateSchedule))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("softwareSetUpdateSchedule").build())
            .build();

    private static final SdkField<Instant> LAST_CONNECTED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastConnectedAt").getter(getter(DeviceSummary::lastConnectedAt))
            .setter(setter(Builder::lastConnectedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastConnectedAt").build()).build();

    private static final SdkField<Instant> LAST_POSTURE_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastPostureAt").getter(getter(DeviceSummary::lastPostureAt)).setter(setter(Builder::lastPostureAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastPostureAt").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(DeviceSummary::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt").getter(getter(DeviceSummary::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(DeviceSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, SERIAL_NUMBER_FIELD,
            NAME_FIELD, MODEL_FIELD, ENVIRONMENT_ID_FIELD, STATUS_FIELD, CURRENT_SOFTWARE_SET_ID_FIELD,
            DESIRED_SOFTWARE_SET_ID_FIELD, PENDING_SOFTWARE_SET_ID_FIELD, SOFTWARE_SET_UPDATE_SCHEDULE_FIELD,
            LAST_CONNECTED_AT_FIELD, LAST_POSTURE_AT_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD, ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String serialNumber;

    private final String name;

    private final String model;

    private final String environmentId;

    private final String status;

    private final String currentSoftwareSetId;

    private final String desiredSoftwareSetId;

    private final String pendingSoftwareSetId;

    private final String softwareSetUpdateSchedule;

    private final Instant lastConnectedAt;

    private final Instant lastPostureAt;

    private final Instant createdAt;

    private final Instant updatedAt;

    private final String arn;

    private DeviceSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.serialNumber = builder.serialNumber;
        this.name = builder.name;
        this.model = builder.model;
        this.environmentId = builder.environmentId;
        this.status = builder.status;
        this.currentSoftwareSetId = builder.currentSoftwareSetId;
        this.desiredSoftwareSetId = builder.desiredSoftwareSetId;
        this.pendingSoftwareSetId = builder.pendingSoftwareSetId;
        this.softwareSetUpdateSchedule = builder.softwareSetUpdateSchedule;
        this.lastConnectedAt = builder.lastConnectedAt;
        this.lastPostureAt = builder.lastPostureAt;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
        this.arn = builder.arn;
    }

    /**
     * <p>
     * The ID of the device.
     * </p>
     * 
     * @return The ID of the device.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The hardware serial number of the device.
     * </p>
     * 
     * @return The hardware serial number of the device.
     */
    public final String serialNumber() {
        return serialNumber;
    }

    /**
     * <p>
     * The name of the device.
     * </p>
     * 
     * @return The name of the device.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The model number of the device.
     * </p>
     * 
     * @return The model number of the device.
     */
    public final String model() {
        return model;
    }

    /**
     * <p>
     * The ID of the environment the device is associated with.
     * </p>
     * 
     * @return The ID of the environment the device is associated with.
     */
    public final String environmentId() {
        return environmentId;
    }

    /**
     * <p>
     * The status of the device.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DeviceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the device.
     * @see DeviceStatus
     */
    public final DeviceStatus status() {
        return DeviceStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the device.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DeviceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the device.
     * @see DeviceStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The ID of the software set currently installed on the device.
     * </p>
     * 
     * @return The ID of the software set currently installed on the device.
     */
    public final String currentSoftwareSetId() {
        return currentSoftwareSetId;
    }

    /**
     * <p>
     * The ID of the software set which the device has been set to.
     * </p>
     * 
     * @return The ID of the software set which the device has been set to.
     */
    public final String desiredSoftwareSetId() {
        return desiredSoftwareSetId;
    }

    /**
     * <p>
     * The ID of the software set that is pending to be installed on the device.
     * </p>
     * 
     * @return The ID of the software set that is pending to be installed on the device.
     */
    public final String pendingSoftwareSetId() {
        return pendingSoftwareSetId;
    }

    /**
     * <p>
     * An option to define if software updates should be applied within a maintenance window.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #softwareSetUpdateSchedule} will return {@link SoftwareSetUpdateSchedule#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #softwareSetUpdateScheduleAsString}.
     * </p>
     * 
     * @return An option to define if software updates should be applied within a maintenance window.
     * @see SoftwareSetUpdateSchedule
     */
    public final SoftwareSetUpdateSchedule softwareSetUpdateSchedule() {
        return SoftwareSetUpdateSchedule.fromValue(softwareSetUpdateSchedule);
    }

    /**
     * <p>
     * An option to define if software updates should be applied within a maintenance window.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #softwareSetUpdateSchedule} will return {@link SoftwareSetUpdateSchedule#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #softwareSetUpdateScheduleAsString}.
     * </p>
     * 
     * @return An option to define if software updates should be applied within a maintenance window.
     * @see SoftwareSetUpdateSchedule
     */
    public final String softwareSetUpdateScheduleAsString() {
        return softwareSetUpdateSchedule;
    }

    /**
     * <p>
     * The timestamp of the most recent session on the device.
     * </p>
     * 
     * @return The timestamp of the most recent session on the device.
     */
    public final Instant lastConnectedAt() {
        return lastConnectedAt;
    }

    /**
     * <p>
     * The timestamp of the most recent check-in of the device.
     * </p>
     * 
     * @return The timestamp of the most recent check-in of the device.
     */
    public final Instant lastPostureAt() {
        return lastPostureAt;
    }

    /**
     * <p>
     * The timestamp of when the device was created.
     * </p>
     * 
     * @return The timestamp of when the device was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The timestamp of when the device was updated.
     * </p>
     * 
     * @return The timestamp of when the device was updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the device.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the device.
     */
    public final String arn() {
        return arn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(serialNumber());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(model());
        hashCode = 31 * hashCode + Objects.hashCode(environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(currentSoftwareSetId());
        hashCode = 31 * hashCode + Objects.hashCode(desiredSoftwareSetId());
        hashCode = 31 * hashCode + Objects.hashCode(pendingSoftwareSetId());
        hashCode = 31 * hashCode + Objects.hashCode(softwareSetUpdateScheduleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastConnectedAt());
        hashCode = 31 * hashCode + Objects.hashCode(lastPostureAt());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeviceSummary)) {
            return false;
        }
        DeviceSummary other = (DeviceSummary) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(serialNumber(), other.serialNumber())
                && Objects.equals(name(), other.name()) && Objects.equals(model(), other.model())
                && Objects.equals(environmentId(), other.environmentId())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(currentSoftwareSetId(), other.currentSoftwareSetId())
                && Objects.equals(desiredSoftwareSetId(), other.desiredSoftwareSetId())
                && Objects.equals(pendingSoftwareSetId(), other.pendingSoftwareSetId())
                && Objects.equals(softwareSetUpdateScheduleAsString(), other.softwareSetUpdateScheduleAsString())
                && Objects.equals(lastConnectedAt(), other.lastConnectedAt())
                && Objects.equals(lastPostureAt(), other.lastPostureAt()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(updatedAt(), other.updatedAt()) && Objects.equals(arn(), other.arn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeviceSummary").add("Id", id()).add("SerialNumber", serialNumber())
                .add("Name", name() == null ? null : "*** Sensitive Data Redacted ***").add("Model", model())
                .add("EnvironmentId", environmentId()).add("Status", statusAsString())
                .add("CurrentSoftwareSetId", currentSoftwareSetId()).add("DesiredSoftwareSetId", desiredSoftwareSetId())
                .add("PendingSoftwareSetId", pendingSoftwareSetId())
                .add("SoftwareSetUpdateSchedule", softwareSetUpdateScheduleAsString()).add("LastConnectedAt", lastConnectedAt())
                .add("LastPostureAt", lastPostureAt()).add("CreatedAt", createdAt()).add("UpdatedAt", updatedAt())
                .add("Arn", arn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "serialNumber":
            return Optional.ofNullable(clazz.cast(serialNumber()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "model":
            return Optional.ofNullable(clazz.cast(model()));
        case "environmentId":
            return Optional.ofNullable(clazz.cast(environmentId()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "currentSoftwareSetId":
            return Optional.ofNullable(clazz.cast(currentSoftwareSetId()));
        case "desiredSoftwareSetId":
            return Optional.ofNullable(clazz.cast(desiredSoftwareSetId()));
        case "pendingSoftwareSetId":
            return Optional.ofNullable(clazz.cast(pendingSoftwareSetId()));
        case "softwareSetUpdateSchedule":
            return Optional.ofNullable(clazz.cast(softwareSetUpdateScheduleAsString()));
        case "lastConnectedAt":
            return Optional.ofNullable(clazz.cast(lastConnectedAt()));
        case "lastPostureAt":
            return Optional.ofNullable(clazz.cast(lastPostureAt()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("serialNumber", SERIAL_NUMBER_FIELD);
        map.put("name", NAME_FIELD);
        map.put("model", MODEL_FIELD);
        map.put("environmentId", ENVIRONMENT_ID_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("currentSoftwareSetId", CURRENT_SOFTWARE_SET_ID_FIELD);
        map.put("desiredSoftwareSetId", DESIRED_SOFTWARE_SET_ID_FIELD);
        map.put("pendingSoftwareSetId", PENDING_SOFTWARE_SET_ID_FIELD);
        map.put("softwareSetUpdateSchedule", SOFTWARE_SET_UPDATE_SCHEDULE_FIELD);
        map.put("lastConnectedAt", LAST_CONNECTED_AT_FIELD);
        map.put("lastPostureAt", LAST_POSTURE_AT_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("arn", ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeviceSummary, T> g) {
        return obj -> g.apply((DeviceSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeviceSummary> {
        /**
         * <p>
         * The ID of the device.
         * </p>
         * 
         * @param id
         *        The ID of the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The hardware serial number of the device.
         * </p>
         * 
         * @param serialNumber
         *        The hardware serial number of the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serialNumber(String serialNumber);

        /**
         * <p>
         * The name of the device.
         * </p>
         * 
         * @param name
         *        The name of the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The model number of the device.
         * </p>
         * 
         * @param model
         *        The model number of the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder model(String model);

        /**
         * <p>
         * The ID of the environment the device is associated with.
         * </p>
         * 
         * @param environmentId
         *        The ID of the environment the device is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environmentId(String environmentId);

        /**
         * <p>
         * The status of the device.
         * </p>
         * 
         * @param status
         *        The status of the device.
         * @see DeviceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the device.
         * </p>
         * 
         * @param status
         *        The status of the device.
         * @see DeviceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceStatus
         */
        Builder status(DeviceStatus status);

        /**
         * <p>
         * The ID of the software set currently installed on the device.
         * </p>
         * 
         * @param currentSoftwareSetId
         *        The ID of the software set currently installed on the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentSoftwareSetId(String currentSoftwareSetId);

        /**
         * <p>
         * The ID of the software set which the device has been set to.
         * </p>
         * 
         * @param desiredSoftwareSetId
         *        The ID of the software set which the device has been set to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredSoftwareSetId(String desiredSoftwareSetId);

        /**
         * <p>
         * The ID of the software set that is pending to be installed on the device.
         * </p>
         * 
         * @param pendingSoftwareSetId
         *        The ID of the software set that is pending to be installed on the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pendingSoftwareSetId(String pendingSoftwareSetId);

        /**
         * <p>
         * An option to define if software updates should be applied within a maintenance window.
         * </p>
         * 
         * @param softwareSetUpdateSchedule
         *        An option to define if software updates should be applied within a maintenance window.
         * @see SoftwareSetUpdateSchedule
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SoftwareSetUpdateSchedule
         */
        Builder softwareSetUpdateSchedule(String softwareSetUpdateSchedule);

        /**
         * <p>
         * An option to define if software updates should be applied within a maintenance window.
         * </p>
         * 
         * @param softwareSetUpdateSchedule
         *        An option to define if software updates should be applied within a maintenance window.
         * @see SoftwareSetUpdateSchedule
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SoftwareSetUpdateSchedule
         */
        Builder softwareSetUpdateSchedule(SoftwareSetUpdateSchedule softwareSetUpdateSchedule);

        /**
         * <p>
         * The timestamp of the most recent session on the device.
         * </p>
         * 
         * @param lastConnectedAt
         *        The timestamp of the most recent session on the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastConnectedAt(Instant lastConnectedAt);

        /**
         * <p>
         * The timestamp of the most recent check-in of the device.
         * </p>
         * 
         * @param lastPostureAt
         *        The timestamp of the most recent check-in of the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastPostureAt(Instant lastPostureAt);

        /**
         * <p>
         * The timestamp of when the device was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp of when the device was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The timestamp of when the device was updated.
         * </p>
         * 
         * @param updatedAt
         *        The timestamp of when the device was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the device.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String serialNumber;

        private String name;

        private String model;

        private String environmentId;

        private String status;

        private String currentSoftwareSetId;

        private String desiredSoftwareSetId;

        private String pendingSoftwareSetId;

        private String softwareSetUpdateSchedule;

        private Instant lastConnectedAt;

        private Instant lastPostureAt;

        private Instant createdAt;

        private Instant updatedAt;

        private String arn;

        private BuilderImpl() {
        }

        private BuilderImpl(DeviceSummary model) {
            id(model.id);
            serialNumber(model.serialNumber);
            name(model.name);
            model(model.model);
            environmentId(model.environmentId);
            status(model.status);
            currentSoftwareSetId(model.currentSoftwareSetId);
            desiredSoftwareSetId(model.desiredSoftwareSetId);
            pendingSoftwareSetId(model.pendingSoftwareSetId);
            softwareSetUpdateSchedule(model.softwareSetUpdateSchedule);
            lastConnectedAt(model.lastConnectedAt);
            lastPostureAt(model.lastPostureAt);
            createdAt(model.createdAt);
            updatedAt(model.updatedAt);
            arn(model.arn);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getSerialNumber() {
            return serialNumber;
        }

        public final void setSerialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
        }

        @Override
        public final Builder serialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getModel() {
            return model;
        }

        public final void setModel(String model) {
            this.model = model;
        }

        @Override
        public final Builder model(String model) {
            this.model = model;
            return this;
        }

        public final String getEnvironmentId() {
            return environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DeviceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getCurrentSoftwareSetId() {
            return currentSoftwareSetId;
        }

        public final void setCurrentSoftwareSetId(String currentSoftwareSetId) {
            this.currentSoftwareSetId = currentSoftwareSetId;
        }

        @Override
        public final Builder currentSoftwareSetId(String currentSoftwareSetId) {
            this.currentSoftwareSetId = currentSoftwareSetId;
            return this;
        }

        public final String getDesiredSoftwareSetId() {
            return desiredSoftwareSetId;
        }

        public final void setDesiredSoftwareSetId(String desiredSoftwareSetId) {
            this.desiredSoftwareSetId = desiredSoftwareSetId;
        }

        @Override
        public final Builder desiredSoftwareSetId(String desiredSoftwareSetId) {
            this.desiredSoftwareSetId = desiredSoftwareSetId;
            return this;
        }

        public final String getPendingSoftwareSetId() {
            return pendingSoftwareSetId;
        }

        public final void setPendingSoftwareSetId(String pendingSoftwareSetId) {
            this.pendingSoftwareSetId = pendingSoftwareSetId;
        }

        @Override
        public final Builder pendingSoftwareSetId(String pendingSoftwareSetId) {
            this.pendingSoftwareSetId = pendingSoftwareSetId;
            return this;
        }

        public final String getSoftwareSetUpdateSchedule() {
            return softwareSetUpdateSchedule;
        }

        public final void setSoftwareSetUpdateSchedule(String softwareSetUpdateSchedule) {
            this.softwareSetUpdateSchedule = softwareSetUpdateSchedule;
        }

        @Override
        public final Builder softwareSetUpdateSchedule(String softwareSetUpdateSchedule) {
            this.softwareSetUpdateSchedule = softwareSetUpdateSchedule;
            return this;
        }

        @Override
        public final Builder softwareSetUpdateSchedule(SoftwareSetUpdateSchedule softwareSetUpdateSchedule) {
            this.softwareSetUpdateSchedule(softwareSetUpdateSchedule == null ? null : softwareSetUpdateSchedule.toString());
            return this;
        }

        public final Instant getLastConnectedAt() {
            return lastConnectedAt;
        }

        public final void setLastConnectedAt(Instant lastConnectedAt) {
            this.lastConnectedAt = lastConnectedAt;
        }

        @Override
        public final Builder lastConnectedAt(Instant lastConnectedAt) {
            this.lastConnectedAt = lastConnectedAt;
            return this;
        }

        public final Instant getLastPostureAt() {
            return lastPostureAt;
        }

        public final void setLastPostureAt(Instant lastPostureAt) {
            this.lastPostureAt = lastPostureAt;
        }

        @Override
        public final Builder lastPostureAt(Instant lastPostureAt) {
            this.lastPostureAt = lastPostureAt;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        @Override
        public DeviceSummary build() {
            return new DeviceSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
