/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesthinclient.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.workspacesthinclient.model.SoftwareSetValidationStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SoftwareSetSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SoftwareSetSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(SoftwareSetSummary.getter(SoftwareSetSummary::id)).setter(SoftwareSetSummary.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("version").getter(SoftwareSetSummary.getter(SoftwareSetSummary::version)).setter(SoftwareSetSummary.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final SdkField<Instant> RELEASED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("releasedAt").getter(SoftwareSetSummary.getter(SoftwareSetSummary::releasedAt)).setter(SoftwareSetSummary.setter(Builder::releasedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("releasedAt").build()}).build();
    private static final SdkField<Instant> SUPPORTED_UNTIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("supportedUntil").getter(SoftwareSetSummary.getter(SoftwareSetSummary::supportedUntil)).setter(SoftwareSetSummary.setter(Builder::supportedUntil)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportedUntil").build()}).build();
    private static final SdkField<String> VALIDATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("validationStatus").getter(SoftwareSetSummary.getter(SoftwareSetSummary::validationStatusAsString)).setter(SoftwareSetSummary.setter(Builder::validationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validationStatus").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(SoftwareSetSummary.getter(SoftwareSetSummary::arn)).setter(SoftwareSetSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, VERSION_FIELD, RELEASED_AT_FIELD, SUPPORTED_UNTIL_FIELD, VALIDATION_STATUS_FIELD, ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SoftwareSetSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String version;
    private final Instant releasedAt;
    private final Instant supportedUntil;
    private final String validationStatus;
    private final String arn;

    private SoftwareSetSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.version = builder.version;
        this.releasedAt = builder.releasedAt;
        this.supportedUntil = builder.supportedUntil;
        this.validationStatus = builder.validationStatus;
        this.arn = builder.arn;
    }

    public final String id() {
        return this.id;
    }

    public final String version() {
        return this.version;
    }

    public final Instant releasedAt() {
        return this.releasedAt;
    }

    public final Instant supportedUntil() {
        return this.supportedUntil;
    }

    public final SoftwareSetValidationStatus validationStatus() {
        return SoftwareSetValidationStatus.fromValue(this.validationStatus);
    }

    public final String validationStatusAsString() {
        return this.validationStatus;
    }

    public final String arn() {
        return this.arn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.releasedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.supportedUntil());
        hashCode = 31 * hashCode + Objects.hashCode(this.validationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SoftwareSetSummary)) {
            return false;
        }
        SoftwareSetSummary other = (SoftwareSetSummary)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.releasedAt(), other.releasedAt()) && Objects.equals(this.supportedUntil(), other.supportedUntil()) && Objects.equals(this.validationStatusAsString(), other.validationStatusAsString()) && Objects.equals(this.arn(), other.arn());
    }

    public final String toString() {
        return ToString.builder((String)"SoftwareSetSummary").add("Id", (Object)this.id()).add("Version", (Object)this.version()).add("ReleasedAt", (Object)this.releasedAt()).add("SupportedUntil", (Object)this.supportedUntil()).add("ValidationStatus", (Object)this.validationStatusAsString()).add("Arn", (Object)this.arn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "releasedAt": {
                return Optional.ofNullable(clazz.cast(this.releasedAt()));
            }
            case "supportedUntil": {
                return Optional.ofNullable(clazz.cast(this.supportedUntil()));
            }
            case "validationStatus": {
                return Optional.ofNullable(clazz.cast(this.validationStatusAsString()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", ID_FIELD);
        map.put("version", VERSION_FIELD);
        map.put("releasedAt", RELEASED_AT_FIELD);
        map.put("supportedUntil", SUPPORTED_UNTIL_FIELD);
        map.put("validationStatus", VALIDATION_STATUS_FIELD);
        map.put("arn", ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SoftwareSetSummary, T> g) {
        return obj -> g.apply((SoftwareSetSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String version;
        private Instant releasedAt;
        private Instant supportedUntil;
        private String validationStatus;
        private String arn;

        private BuilderImpl() {
        }

        private BuilderImpl(SoftwareSetSummary model) {
            this.id(model.id);
            this.version(model.version);
            this.releasedAt(model.releasedAt);
            this.supportedUntil(model.supportedUntil);
            this.validationStatus(model.validationStatus);
            this.arn(model.arn);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final Instant getReleasedAt() {
            return this.releasedAt;
        }

        public final void setReleasedAt(Instant releasedAt) {
            this.releasedAt = releasedAt;
        }

        @Override
        public final Builder releasedAt(Instant releasedAt) {
            this.releasedAt = releasedAt;
            return this;
        }

        public final Instant getSupportedUntil() {
            return this.supportedUntil;
        }

        public final void setSupportedUntil(Instant supportedUntil) {
            this.supportedUntil = supportedUntil;
        }

        @Override
        public final Builder supportedUntil(Instant supportedUntil) {
            this.supportedUntil = supportedUntil;
            return this;
        }

        public final String getValidationStatus() {
            return this.validationStatus;
        }

        public final void setValidationStatus(String validationStatus) {
            this.validationStatus = validationStatus;
        }

        @Override
        public final Builder validationStatus(String validationStatus) {
            this.validationStatus = validationStatus;
            return this;
        }

        @Override
        public final Builder validationStatus(SoftwareSetValidationStatus validationStatus) {
            this.validationStatus(validationStatus == null ? null : validationStatus.toString());
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public SoftwareSetSummary build() {
            return new SoftwareSetSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SoftwareSetSummary> {
        public Builder id(String var1);

        public Builder version(String var1);

        public Builder releasedAt(Instant var1);

        public Builder supportedUntil(Instant var1);

        public Builder validationStatus(String var1);

        public Builder validationStatus(SoftwareSetValidationStatus var1);

        public Builder arn(String var1);
    }
}

