/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesthinclient.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.workspacesthinclient.WorkSpacesThinClientClient;
import software.amazon.awssdk.services.workspacesthinclient.internal.UserAgentUtils;
import software.amazon.awssdk.services.workspacesthinclient.model.ListSoftwareSetsRequest;
import software.amazon.awssdk.services.workspacesthinclient.model.ListSoftwareSetsResponse;
import software.amazon.awssdk.services.workspacesthinclient.model.SoftwareSetSummary;

public class ListSoftwareSetsIterable
implements SdkIterable<ListSoftwareSetsResponse> {
    private final WorkSpacesThinClientClient client;
    private final ListSoftwareSetsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSoftwareSetsIterable(WorkSpacesThinClientClient client, ListSoftwareSetsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListSoftwareSetsResponseFetcher();
    }

    public Iterator<ListSoftwareSetsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SoftwareSetSummary> softwareSets() {
        Function<ListSoftwareSetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.softwareSets() != null) {
                return response.softwareSets().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListSoftwareSetsResponseFetcher
    implements SyncPageFetcher<ListSoftwareSetsResponse> {
        private ListSoftwareSetsResponseFetcher() {
        }

        public boolean hasNextPage(ListSoftwareSetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSoftwareSetsResponse nextPage(ListSoftwareSetsResponse previousPage) {
            if (previousPage == null) {
                return ListSoftwareSetsIterable.this.client.listSoftwareSets(ListSoftwareSetsIterable.this.firstRequest);
            }
            return ListSoftwareSetsIterable.this.client.listSoftwareSets((ListSoftwareSetsRequest)((Object)ListSoftwareSetsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

