/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesthinclient.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.workspacesthinclient.model.SoftwareSetListCopier;
import software.amazon.awssdk.services.workspacesthinclient.model.SoftwareSetSummary;
import software.amazon.awssdk.services.workspacesthinclient.model.WorkSpacesThinClientResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSoftwareSetsResponse
extends WorkSpacesThinClientResponse
implements ToCopyableBuilder<Builder, ListSoftwareSetsResponse> {
    private static final SdkField<List<SoftwareSetSummary>> SOFTWARE_SETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("softwareSets").getter(ListSoftwareSetsResponse.getter(ListSoftwareSetsResponse::softwareSets)).setter(ListSoftwareSetsResponse.setter(Builder::softwareSets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("softwareSets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SoftwareSetSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListSoftwareSetsResponse.getter(ListSoftwareSetsResponse::nextToken)).setter(ListSoftwareSetsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOFTWARE_SETS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListSoftwareSetsResponse.memberNameToFieldInitializer();
    private final List<SoftwareSetSummary> softwareSets;
    private final String nextToken;

    private ListSoftwareSetsResponse(BuilderImpl builder) {
        super(builder);
        this.softwareSets = builder.softwareSets;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasSoftwareSets() {
        return this.softwareSets != null && !(this.softwareSets instanceof SdkAutoConstructList);
    }

    public final List<SoftwareSetSummary> softwareSets() {
        return this.softwareSets;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSoftwareSets() ? this.softwareSets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSoftwareSetsResponse)) {
            return false;
        }
        ListSoftwareSetsResponse other = (ListSoftwareSetsResponse)((Object)obj);
        return this.hasSoftwareSets() == other.hasSoftwareSets() && Objects.equals(this.softwareSets(), other.softwareSets()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListSoftwareSetsResponse").add("SoftwareSets", this.hasSoftwareSets() ? this.softwareSets() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "softwareSets": {
                return Optional.ofNullable(clazz.cast(this.softwareSets()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("softwareSets", SOFTWARE_SETS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSoftwareSetsResponse, T> g) {
        return obj -> g.apply((ListSoftwareSetsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends WorkSpacesThinClientResponse.BuilderImpl
    implements Builder {
        private List<SoftwareSetSummary> softwareSets = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSoftwareSetsResponse model) {
            super(model);
            this.softwareSets(model.softwareSets);
            this.nextToken(model.nextToken);
        }

        public final List<SoftwareSetSummary.Builder> getSoftwareSets() {
            List<SoftwareSetSummary.Builder> result = SoftwareSetListCopier.copyToBuilder(this.softwareSets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSoftwareSets(Collection<SoftwareSetSummary.BuilderImpl> softwareSets) {
            this.softwareSets = SoftwareSetListCopier.copyFromBuilder(softwareSets);
        }

        @Override
        public final Builder softwareSets(Collection<SoftwareSetSummary> softwareSets) {
            this.softwareSets = SoftwareSetListCopier.copy(softwareSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder softwareSets(SoftwareSetSummary ... softwareSets) {
            this.softwareSets(Arrays.asList(softwareSets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder softwareSets(Consumer<SoftwareSetSummary.Builder> ... softwareSets) {
            this.softwareSets(Stream.of(softwareSets).map(c -> (SoftwareSetSummary)((SoftwareSetSummary.Builder)SoftwareSetSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListSoftwareSetsResponse build() {
            return new ListSoftwareSetsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends WorkSpacesThinClientResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSoftwareSetsResponse> {
        public Builder softwareSets(Collection<SoftwareSetSummary> var1);

        public Builder softwareSets(SoftwareSetSummary ... var1);

        public Builder softwareSets(Consumer<SoftwareSetSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

