/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspacesweb.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreatePortalResponse extends WorkSpacesWebResponse implements
        ToCopyableBuilder<CreatePortalResponse.Builder, CreatePortalResponse> {
    private static final SdkField<String> PORTAL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("portalArn").getter(getter(CreatePortalResponse::portalArn)).setter(setter(Builder::portalArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portalArn").build()).build();

    private static final SdkField<String> PORTAL_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("portalEndpoint").getter(getter(CreatePortalResponse::portalEndpoint))
            .setter(setter(Builder::portalEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portalEndpoint").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PORTAL_ARN_FIELD,
            PORTAL_ENDPOINT_FIELD));

    private final String portalArn;

    private final String portalEndpoint;

    private CreatePortalResponse(BuilderImpl builder) {
        super(builder);
        this.portalArn = builder.portalArn;
        this.portalEndpoint = builder.portalEndpoint;
    }

    /**
     * <p>
     * The ARN of the web portal.
     * </p>
     * 
     * @return The ARN of the web portal.
     */
    public final String portalArn() {
        return portalArn;
    }

    /**
     * <p>
     * The endpoint URL of the web portal that users access in order to start streaming sessions.
     * </p>
     * 
     * @return The endpoint URL of the web portal that users access in order to start streaming sessions.
     */
    public final String portalEndpoint() {
        return portalEndpoint;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(portalArn());
        hashCode = 31 * hashCode + Objects.hashCode(portalEndpoint());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePortalResponse)) {
            return false;
        }
        CreatePortalResponse other = (CreatePortalResponse) obj;
        return Objects.equals(portalArn(), other.portalArn()) && Objects.equals(portalEndpoint(), other.portalEndpoint());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreatePortalResponse").add("PortalArn", portalArn()).add("PortalEndpoint", portalEndpoint())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "portalArn":
            return Optional.ofNullable(clazz.cast(portalArn()));
        case "portalEndpoint":
            return Optional.ofNullable(clazz.cast(portalEndpoint()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreatePortalResponse, T> g) {
        return obj -> g.apply((CreatePortalResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkSpacesWebResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreatePortalResponse> {
        /**
         * <p>
         * The ARN of the web portal.
         * </p>
         * 
         * @param portalArn
         *        The ARN of the web portal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portalArn(String portalArn);

        /**
         * <p>
         * The endpoint URL of the web portal that users access in order to start streaming sessions.
         * </p>
         * 
         * @param portalEndpoint
         *        The endpoint URL of the web portal that users access in order to start streaming sessions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portalEndpoint(String portalEndpoint);
    }

    static final class BuilderImpl extends WorkSpacesWebResponse.BuilderImpl implements Builder {
        private String portalArn;

        private String portalEndpoint;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePortalResponse model) {
            super(model);
            portalArn(model.portalArn);
            portalEndpoint(model.portalEndpoint);
        }

        public final String getPortalArn() {
            return portalArn;
        }

        public final void setPortalArn(String portalArn) {
            this.portalArn = portalArn;
        }

        @Override
        @Transient
        public final Builder portalArn(String portalArn) {
            this.portalArn = portalArn;
            return this;
        }

        public final String getPortalEndpoint() {
            return portalEndpoint;
        }

        public final void setPortalEndpoint(String portalEndpoint) {
            this.portalEndpoint = portalEndpoint;
        }

        @Override
        @Transient
        public final Builder portalEndpoint(String portalEndpoint) {
            this.portalEndpoint = portalEndpoint;
            return this;
        }

        @Override
        public CreatePortalResponse build() {
            return new CreatePortalResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
