/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspacesweb.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The summary of the identity provider.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IdentityProviderSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<IdentityProviderSummary.Builder, IdentityProviderSummary> {
    private static final SdkField<String> IDENTITY_PROVIDER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("identityProviderArn").getter(getter(IdentityProviderSummary::identityProviderArn))
            .setter(setter(Builder::identityProviderArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identityProviderArn").build())
            .build();

    private static final SdkField<String> IDENTITY_PROVIDER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("identityProviderName").getter(getter(IdentityProviderSummary::identityProviderName))
            .setter(setter(Builder::identityProviderName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identityProviderName").build())
            .build();

    private static final SdkField<String> IDENTITY_PROVIDER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("identityProviderType").getter(getter(IdentityProviderSummary::identityProviderTypeAsString))
            .setter(setter(Builder::identityProviderType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identityProviderType").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_PROVIDER_ARN_FIELD,
            IDENTITY_PROVIDER_NAME_FIELD, IDENTITY_PROVIDER_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String identityProviderArn;

    private final String identityProviderName;

    private final String identityProviderType;

    private IdentityProviderSummary(BuilderImpl builder) {
        this.identityProviderArn = builder.identityProviderArn;
        this.identityProviderName = builder.identityProviderName;
        this.identityProviderType = builder.identityProviderType;
    }

    /**
     * <p>
     * The ARN of the identity provider.
     * </p>
     * 
     * @return The ARN of the identity provider.
     */
    public final String identityProviderArn() {
        return identityProviderArn;
    }

    /**
     * <p>
     * The identity provider name.
     * </p>
     * 
     * @return The identity provider name.
     */
    public final String identityProviderName() {
        return identityProviderName;
    }

    /**
     * <p>
     * The identity provider type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #identityProviderType} will return {@link IdentityProviderType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #identityProviderTypeAsString}.
     * </p>
     * 
     * @return The identity provider type.
     * @see IdentityProviderType
     */
    public final IdentityProviderType identityProviderType() {
        return IdentityProviderType.fromValue(identityProviderType);
    }

    /**
     * <p>
     * The identity provider type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #identityProviderType} will return {@link IdentityProviderType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #identityProviderTypeAsString}.
     * </p>
     * 
     * @return The identity provider type.
     * @see IdentityProviderType
     */
    public final String identityProviderTypeAsString() {
        return identityProviderType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(identityProviderArn());
        hashCode = 31 * hashCode + Objects.hashCode(identityProviderName());
        hashCode = 31 * hashCode + Objects.hashCode(identityProviderTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdentityProviderSummary)) {
            return false;
        }
        IdentityProviderSummary other = (IdentityProviderSummary) obj;
        return Objects.equals(identityProviderArn(), other.identityProviderArn())
                && Objects.equals(identityProviderName(), other.identityProviderName())
                && Objects.equals(identityProviderTypeAsString(), other.identityProviderTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IdentityProviderSummary").add("IdentityProviderArn", identityProviderArn())
                .add("IdentityProviderName", identityProviderName()).add("IdentityProviderType", identityProviderTypeAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "identityProviderArn":
            return Optional.ofNullable(clazz.cast(identityProviderArn()));
        case "identityProviderName":
            return Optional.ofNullable(clazz.cast(identityProviderName()));
        case "identityProviderType":
            return Optional.ofNullable(clazz.cast(identityProviderTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IdentityProviderSummary, T> g) {
        return obj -> g.apply((IdentityProviderSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IdentityProviderSummary> {
        /**
         * <p>
         * The ARN of the identity provider.
         * </p>
         * 
         * @param identityProviderArn
         *        The ARN of the identity provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityProviderArn(String identityProviderArn);

        /**
         * <p>
         * The identity provider name.
         * </p>
         * 
         * @param identityProviderName
         *        The identity provider name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityProviderName(String identityProviderName);

        /**
         * <p>
         * The identity provider type.
         * </p>
         * 
         * @param identityProviderType
         *        The identity provider type.
         * @see IdentityProviderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdentityProviderType
         */
        Builder identityProviderType(String identityProviderType);

        /**
         * <p>
         * The identity provider type.
         * </p>
         * 
         * @param identityProviderType
         *        The identity provider type.
         * @see IdentityProviderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdentityProviderType
         */
        Builder identityProviderType(IdentityProviderType identityProviderType);
    }

    static final class BuilderImpl implements Builder {
        private String identityProviderArn;

        private String identityProviderName;

        private String identityProviderType;

        private BuilderImpl() {
        }

        private BuilderImpl(IdentityProviderSummary model) {
            identityProviderArn(model.identityProviderArn);
            identityProviderName(model.identityProviderName);
            identityProviderType(model.identityProviderType);
        }

        public final String getIdentityProviderArn() {
            return identityProviderArn;
        }

        public final void setIdentityProviderArn(String identityProviderArn) {
            this.identityProviderArn = identityProviderArn;
        }

        @Override
        @Transient
        public final Builder identityProviderArn(String identityProviderArn) {
            this.identityProviderArn = identityProviderArn;
            return this;
        }

        public final String getIdentityProviderName() {
            return identityProviderName;
        }

        public final void setIdentityProviderName(String identityProviderName) {
            this.identityProviderName = identityProviderName;
        }

        @Override
        @Transient
        public final Builder identityProviderName(String identityProviderName) {
            this.identityProviderName = identityProviderName;
            return this;
        }

        public final String getIdentityProviderType() {
            return identityProviderType;
        }

        public final void setIdentityProviderType(String identityProviderType) {
            this.identityProviderType = identityProviderType;
        }

        @Override
        @Transient
        public final Builder identityProviderType(String identityProviderType) {
            this.identityProviderType = identityProviderType;
            return this;
        }

        @Override
        @Transient
        public final Builder identityProviderType(IdentityProviderType identityProviderType) {
            this.identityProviderType(identityProviderType == null ? null : identityProviderType.toString());
            return this;
        }

        @Override
        public IdentityProviderSummary build() {
            return new IdentityProviderSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
