/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspacesweb.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListNetworkSettingsResponse extends WorkSpacesWebResponse implements
        ToCopyableBuilder<ListNetworkSettingsResponse.Builder, ListNetworkSettingsResponse> {
    private static final SdkField<List<NetworkSettingsSummary>> NETWORK_SETTINGS_FIELD = SdkField
            .<List<NetworkSettingsSummary>> builder(MarshallingType.LIST)
            .memberName("networkSettings")
            .getter(getter(ListNetworkSettingsResponse::networkSettings))
            .setter(setter(Builder::networkSettings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkSettings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<NetworkSettingsSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(NetworkSettingsSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListNetworkSettingsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_SETTINGS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<NetworkSettingsSummary> networkSettings;

    private final String nextToken;

    private ListNetworkSettingsResponse(BuilderImpl builder) {
        super(builder);
        this.networkSettings = builder.networkSettings;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the NetworkSettings property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasNetworkSettings() {
        return networkSettings != null && !(networkSettings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The network settings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNetworkSettings} method.
     * </p>
     * 
     * @return The network settings.
     */
    public final List<NetworkSettingsSummary> networkSettings() {
        return networkSettings;
    }

    /**
     * <p>
     * The pagination token used to retrieve the next page of results for this operation.
     * </p>
     * 
     * @return The pagination token used to retrieve the next page of results for this operation.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasNetworkSettings() ? networkSettings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListNetworkSettingsResponse)) {
            return false;
        }
        ListNetworkSettingsResponse other = (ListNetworkSettingsResponse) obj;
        return hasNetworkSettings() == other.hasNetworkSettings() && Objects.equals(networkSettings(), other.networkSettings())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListNetworkSettingsResponse")
                .add("NetworkSettings", hasNetworkSettings() ? networkSettings() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "networkSettings":
            return Optional.ofNullable(clazz.cast(networkSettings()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListNetworkSettingsResponse, T> g) {
        return obj -> g.apply((ListNetworkSettingsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkSpacesWebResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListNetworkSettingsResponse> {
        /**
         * <p>
         * The network settings.
         * </p>
         * 
         * @param networkSettings
         *        The network settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkSettings(Collection<NetworkSettingsSummary> networkSettings);

        /**
         * <p>
         * The network settings.
         * </p>
         * 
         * @param networkSettings
         *        The network settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkSettings(NetworkSettingsSummary... networkSettings);

        /**
         * <p>
         * The network settings.
         * </p>
         * This is a convenience that creates an instance of the {@link List<NetworkSettingsSummary>.Builder} avoiding
         * the need to create one manually via {@link List<NetworkSettingsSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<NetworkSettingsSummary>.Builder#build()} is called
         * immediately and its result is passed to {@link #networkSettings(List<NetworkSettingsSummary>)}.
         * 
         * @param networkSettings
         *        a consumer that will call methods on {@link List<NetworkSettingsSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkSettings(List<NetworkSettingsSummary>)
         */
        Builder networkSettings(Consumer<NetworkSettingsSummary.Builder>... networkSettings);

        /**
         * <p>
         * The pagination token used to retrieve the next page of results for this operation.
         * </p>
         * 
         * @param nextToken
         *        The pagination token used to retrieve the next page of results for this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends WorkSpacesWebResponse.BuilderImpl implements Builder {
        private List<NetworkSettingsSummary> networkSettings = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListNetworkSettingsResponse model) {
            super(model);
            networkSettings(model.networkSettings);
            nextToken(model.nextToken);
        }

        public final List<NetworkSettingsSummary.Builder> getNetworkSettings() {
            List<NetworkSettingsSummary.Builder> result = NetworkSettingsListCopier.copyToBuilder(this.networkSettings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNetworkSettings(Collection<NetworkSettingsSummary.BuilderImpl> networkSettings) {
            this.networkSettings = NetworkSettingsListCopier.copyFromBuilder(networkSettings);
        }

        @Override
        @Transient
        public final Builder networkSettings(Collection<NetworkSettingsSummary> networkSettings) {
            this.networkSettings = NetworkSettingsListCopier.copy(networkSettings);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder networkSettings(NetworkSettingsSummary... networkSettings) {
            networkSettings(Arrays.asList(networkSettings));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder networkSettings(Consumer<NetworkSettingsSummary.Builder>... networkSettings) {
            networkSettings(Stream.of(networkSettings).map(c -> NetworkSettingsSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListNetworkSettingsResponse build() {
            return new ListNetworkSettingsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
