/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspacesweb.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateBrowserSettingsRequest extends WorkSpacesWebRequest implements
        ToCopyableBuilder<UpdateBrowserSettingsRequest.Builder, UpdateBrowserSettingsRequest> {
    private static final SdkField<String> BROWSER_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("browserPolicy").getter(getter(UpdateBrowserSettingsRequest::browserPolicy))
            .setter(setter(Builder::browserPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("browserPolicy").build()).build();

    private static final SdkField<String> BROWSER_SETTINGS_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("browserSettingsArn").getter(getter(UpdateBrowserSettingsRequest::browserSettingsArn))
            .setter(setter(Builder::browserSettingsArn))
            .traits(LocationTrait.builder().location(MarshallLocation.GREEDY_PATH).locationName("browserSettingsArn").build())
            .build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(UpdateBrowserSettingsRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BROWSER_POLICY_FIELD,
            BROWSER_SETTINGS_ARN_FIELD, CLIENT_TOKEN_FIELD));

    private final String browserPolicy;

    private final String browserSettingsArn;

    private final String clientToken;

    private UpdateBrowserSettingsRequest(BuilderImpl builder) {
        super(builder);
        this.browserPolicy = builder.browserPolicy;
        this.browserSettingsArn = builder.browserSettingsArn;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * A JSON string containing Chrome Enterprise policies that will be applied to all streaming sessions.
     * </p>
     * 
     * @return A JSON string containing Chrome Enterprise policies that will be applied to all streaming sessions.
     */
    public final String browserPolicy() {
        return browserPolicy;
    }

    /**
     * <p>
     * The ARN of the browser settings.
     * </p>
     * 
     * @return The ARN of the browser settings.
     */
    public final String browserSettingsArn() {
        return browserSettingsArn;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency
     * ensures that an API request completes only once. With an idempotent request, if the original request completes
     * successfully, subsequent retries with the same client token return the result from the original successful
     * request.
     * </p>
     * <p>
     * If you do not specify a client token, one is automatically generated by the AWS SDK.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     *         Idempotency ensures that an API request completes only once. With an idempotent request, if the original
     *         request completes successfully, subsequent retries with the same client token return the result from the
     *         original successful request. </p>
     *         <p>
     *         If you do not specify a client token, one is automatically generated by the AWS SDK.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(browserPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(browserSettingsArn());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBrowserSettingsRequest)) {
            return false;
        }
        UpdateBrowserSettingsRequest other = (UpdateBrowserSettingsRequest) obj;
        return Objects.equals(browserPolicy(), other.browserPolicy())
                && Objects.equals(browserSettingsArn(), other.browserSettingsArn())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateBrowserSettingsRequest").add("BrowserPolicy", browserPolicy())
                .add("BrowserSettingsArn", browserSettingsArn()).add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "browserPolicy":
            return Optional.ofNullable(clazz.cast(browserPolicy()));
        case "browserSettingsArn":
            return Optional.ofNullable(clazz.cast(browserSettingsArn()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateBrowserSettingsRequest, T> g) {
        return obj -> g.apply((UpdateBrowserSettingsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkSpacesWebRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateBrowserSettingsRequest> {
        /**
         * <p>
         * A JSON string containing Chrome Enterprise policies that will be applied to all streaming sessions.
         * </p>
         * 
         * @param browserPolicy
         *        A JSON string containing Chrome Enterprise policies that will be applied to all streaming sessions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder browserPolicy(String browserPolicy);

        /**
         * <p>
         * The ARN of the browser settings.
         * </p>
         * 
         * @param browserSettingsArn
         *        The ARN of the browser settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder browserSettingsArn(String browserSettingsArn);

        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency
         * ensures that an API request completes only once. With an idempotent request, if the original request
         * completes successfully, subsequent retries with the same client token return the result from the original
         * successful request.
         * </p>
         * <p>
         * If you do not specify a client token, one is automatically generated by the AWS SDK.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         *        Idempotency ensures that an API request completes only once. With an idempotent request, if the
         *        original request completes successfully, subsequent retries with the same client token return the
         *        result from the original successful request. </p>
         *        <p>
         *        If you do not specify a client token, one is automatically generated by the AWS SDK.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkSpacesWebRequest.BuilderImpl implements Builder {
        private String browserPolicy;

        private String browserSettingsArn;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateBrowserSettingsRequest model) {
            super(model);
            browserPolicy(model.browserPolicy);
            browserSettingsArn(model.browserSettingsArn);
            clientToken(model.clientToken);
        }

        public final String getBrowserPolicy() {
            return browserPolicy;
        }

        public final void setBrowserPolicy(String browserPolicy) {
            this.browserPolicy = browserPolicy;
        }

        @Override
        @Transient
        public final Builder browserPolicy(String browserPolicy) {
            this.browserPolicy = browserPolicy;
            return this;
        }

        public final String getBrowserSettingsArn() {
            return browserSettingsArn;
        }

        public final void setBrowserSettingsArn(String browserSettingsArn) {
            this.browserSettingsArn = browserSettingsArn;
        }

        @Override
        @Transient
        public final Builder browserSettingsArn(String browserSettingsArn) {
            this.browserSettingsArn = browserSettingsArn;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        @Transient
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateBrowserSettingsRequest build() {
            return new UpdateBrowserSettingsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
