/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspacesweb.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateBrowserSettingsRequest extends WorkSpacesWebRequest implements
        ToCopyableBuilder<CreateBrowserSettingsRequest.Builder, CreateBrowserSettingsRequest> {
    private static final SdkField<Map<String, String>> ADDITIONAL_ENCRYPTION_CONTEXT_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("additionalEncryptionContext")
            .getter(getter(CreateBrowserSettingsRequest::additionalEncryptionContext))
            .setter(setter(Builder::additionalEncryptionContext))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalEncryptionContext")
                    .build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> BROWSER_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("browserPolicy").getter(getter(CreateBrowserSettingsRequest::browserPolicy))
            .setter(setter(Builder::browserPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("browserPolicy").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateBrowserSettingsRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> CUSTOMER_MANAGED_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("customerManagedKey").getter(getter(CreateBrowserSettingsRequest::customerManagedKey))
            .setter(setter(Builder::customerManagedKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerManagedKey").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(CreateBrowserSettingsRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ADDITIONAL_ENCRYPTION_CONTEXT_FIELD, BROWSER_POLICY_FIELD, CLIENT_TOKEN_FIELD, CUSTOMER_MANAGED_KEY_FIELD,
                    TAGS_FIELD));

    private final Map<String, String> additionalEncryptionContext;

    private final String browserPolicy;

    private final String clientToken;

    private final String customerManagedKey;

    private final List<Tag> tags;

    private CreateBrowserSettingsRequest(BuilderImpl builder) {
        super(builder);
        this.additionalEncryptionContext = builder.additionalEncryptionContext;
        this.browserPolicy = builder.browserPolicy;
        this.clientToken = builder.clientToken;
        this.customerManagedKey = builder.customerManagedKey;
        this.tags = builder.tags;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdditionalEncryptionContext property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAdditionalEncryptionContext() {
        return additionalEncryptionContext != null && !(additionalEncryptionContext instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Additional encryption context of the browser settings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdditionalEncryptionContext} method.
     * </p>
     * 
     * @return Additional encryption context of the browser settings.
     */
    public final Map<String, String> additionalEncryptionContext() {
        return additionalEncryptionContext;
    }

    /**
     * <p>
     * A JSON string containing Chrome Enterprise policies that will be applied to all streaming sessions.
     * </p>
     * 
     * @return A JSON string containing Chrome Enterprise policies that will be applied to all streaming sessions.
     */
    public final String browserPolicy() {
        return browserPolicy;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency
     * ensures that an API request completes only once. With an idempotent request, if the original request completes
     * successfully, subsequent retries with the same client token returns the result from the original successful
     * request.
     * </p>
     * <p>
     * If you do not specify a client token, one is automatically generated by the AWS SDK.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     *         Idempotency ensures that an API request completes only once. With an idempotent request, if the original
     *         request completes successfully, subsequent retries with the same client token returns the result from the
     *         original successful request.</p>
     *         <p>
     *         If you do not specify a client token, one is automatically generated by the AWS SDK.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The custom managed key of the browser settings.
     * </p>
     * 
     * @return The custom managed key of the browser settings.
     */
    public final String customerManagedKey() {
        return customerManagedKey;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags to add to the browser settings resource. A tag is a key-value pair.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags to add to the browser settings resource. A tag is a key-value pair.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAdditionalEncryptionContext() ? additionalEncryptionContext() : null);
        hashCode = 31 * hashCode + Objects.hashCode(browserPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(customerManagedKey());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBrowserSettingsRequest)) {
            return false;
        }
        CreateBrowserSettingsRequest other = (CreateBrowserSettingsRequest) obj;
        return hasAdditionalEncryptionContext() == other.hasAdditionalEncryptionContext()
                && Objects.equals(additionalEncryptionContext(), other.additionalEncryptionContext())
                && Objects.equals(browserPolicy(), other.browserPolicy()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(customerManagedKey(), other.customerManagedKey()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateBrowserSettingsRequest")
                .add("AdditionalEncryptionContext", hasAdditionalEncryptionContext() ? additionalEncryptionContext() : null)
                .add("BrowserPolicy", browserPolicy()).add("ClientToken", clientToken())
                .add("CustomerManagedKey", customerManagedKey()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "additionalEncryptionContext":
            return Optional.ofNullable(clazz.cast(additionalEncryptionContext()));
        case "browserPolicy":
            return Optional.ofNullable(clazz.cast(browserPolicy()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "customerManagedKey":
            return Optional.ofNullable(clazz.cast(customerManagedKey()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateBrowserSettingsRequest, T> g) {
        return obj -> g.apply((CreateBrowserSettingsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkSpacesWebRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateBrowserSettingsRequest> {
        /**
         * <p>
         * Additional encryption context of the browser settings.
         * </p>
         * 
         * @param additionalEncryptionContext
         *        Additional encryption context of the browser settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalEncryptionContext(Map<String, String> additionalEncryptionContext);

        /**
         * <p>
         * A JSON string containing Chrome Enterprise policies that will be applied to all streaming sessions.
         * </p>
         * 
         * @param browserPolicy
         *        A JSON string containing Chrome Enterprise policies that will be applied to all streaming sessions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder browserPolicy(String browserPolicy);

        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency
         * ensures that an API request completes only once. With an idempotent request, if the original request
         * completes successfully, subsequent retries with the same client token returns the result from the original
         * successful request.
         * </p>
         * <p>
         * If you do not specify a client token, one is automatically generated by the AWS SDK.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         *        Idempotency ensures that an API request completes only once. With an idempotent request, if the
         *        original request completes successfully, subsequent retries with the same client token returns the
         *        result from the original successful request.</p>
         *        <p>
         *        If you do not specify a client token, one is automatically generated by the AWS SDK.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The custom managed key of the browser settings.
         * </p>
         * 
         * @param customerManagedKey
         *        The custom managed key of the browser settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerManagedKey(String customerManagedKey);

        /**
         * <p>
         * The tags to add to the browser settings resource. A tag is a key-value pair.
         * </p>
         * 
         * @param tags
         *        The tags to add to the browser settings resource. A tag is a key-value pair.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags to add to the browser settings resource. A tag is a key-value pair.
         * </p>
         * 
         * @param tags
         *        The tags to add to the browser settings resource. A tag is a key-value pair.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags to add to the browser settings resource. A tag is a key-value pair.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkSpacesWebRequest.BuilderImpl implements Builder {
        private Map<String, String> additionalEncryptionContext = DefaultSdkAutoConstructMap.getInstance();

        private String browserPolicy;

        private String clientToken;

        private String customerManagedKey;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBrowserSettingsRequest model) {
            super(model);
            additionalEncryptionContext(model.additionalEncryptionContext);
            browserPolicy(model.browserPolicy);
            clientToken(model.clientToken);
            customerManagedKey(model.customerManagedKey);
            tags(model.tags);
        }

        public final Map<String, String> getAdditionalEncryptionContext() {
            if (additionalEncryptionContext instanceof SdkAutoConstructMap) {
                return null;
            }
            return additionalEncryptionContext;
        }

        public final void setAdditionalEncryptionContext(Map<String, String> additionalEncryptionContext) {
            this.additionalEncryptionContext = EncryptionContextMapCopier.copy(additionalEncryptionContext);
        }

        @Override
        @Transient
        public final Builder additionalEncryptionContext(Map<String, String> additionalEncryptionContext) {
            this.additionalEncryptionContext = EncryptionContextMapCopier.copy(additionalEncryptionContext);
            return this;
        }

        public final String getBrowserPolicy() {
            return browserPolicy;
        }

        public final void setBrowserPolicy(String browserPolicy) {
            this.browserPolicy = browserPolicy;
        }

        @Override
        @Transient
        public final Builder browserPolicy(String browserPolicy) {
            this.browserPolicy = browserPolicy;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        @Transient
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getCustomerManagedKey() {
            return customerManagedKey;
        }

        public final void setCustomerManagedKey(String customerManagedKey) {
            this.customerManagedKey = customerManagedKey;
        }

        @Override
        @Transient
        public final Builder customerManagedKey(String customerManagedKey) {
            this.customerManagedKey = customerManagedKey;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateBrowserSettingsRequest build() {
            return new CreateBrowserSettingsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
