/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspacesweb;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.util.VersionInfo;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.workspacesweb.model.AccessDeniedException;
import software.amazon.awssdk.services.workspacesweb.model.AssociateBrowserSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.AssociateBrowserSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.AssociateNetworkSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.AssociateNetworkSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.AssociateTrustStoreRequest;
import software.amazon.awssdk.services.workspacesweb.model.AssociateTrustStoreResponse;
import software.amazon.awssdk.services.workspacesweb.model.AssociateUserSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.AssociateUserSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.ConflictException;
import software.amazon.awssdk.services.workspacesweb.model.CreateBrowserSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.CreateBrowserSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.CreateIdentityProviderRequest;
import software.amazon.awssdk.services.workspacesweb.model.CreateIdentityProviderResponse;
import software.amazon.awssdk.services.workspacesweb.model.CreateNetworkSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.CreateNetworkSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.CreatePortalRequest;
import software.amazon.awssdk.services.workspacesweb.model.CreatePortalResponse;
import software.amazon.awssdk.services.workspacesweb.model.CreateTrustStoreRequest;
import software.amazon.awssdk.services.workspacesweb.model.CreateTrustStoreResponse;
import software.amazon.awssdk.services.workspacesweb.model.CreateUserSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.CreateUserSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.DeleteBrowserSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.DeleteBrowserSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.DeleteIdentityProviderRequest;
import software.amazon.awssdk.services.workspacesweb.model.DeleteIdentityProviderResponse;
import software.amazon.awssdk.services.workspacesweb.model.DeleteNetworkSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.DeleteNetworkSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.DeletePortalRequest;
import software.amazon.awssdk.services.workspacesweb.model.DeletePortalResponse;
import software.amazon.awssdk.services.workspacesweb.model.DeleteTrustStoreRequest;
import software.amazon.awssdk.services.workspacesweb.model.DeleteTrustStoreResponse;
import software.amazon.awssdk.services.workspacesweb.model.DeleteUserSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.DeleteUserSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.DisassociateBrowserSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.DisassociateBrowserSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.DisassociateNetworkSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.DisassociateNetworkSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.DisassociateTrustStoreRequest;
import software.amazon.awssdk.services.workspacesweb.model.DisassociateTrustStoreResponse;
import software.amazon.awssdk.services.workspacesweb.model.DisassociateUserSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.DisassociateUserSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.GetBrowserSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.GetBrowserSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.GetIdentityProviderRequest;
import software.amazon.awssdk.services.workspacesweb.model.GetIdentityProviderResponse;
import software.amazon.awssdk.services.workspacesweb.model.GetNetworkSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.GetNetworkSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.GetPortalRequest;
import software.amazon.awssdk.services.workspacesweb.model.GetPortalResponse;
import software.amazon.awssdk.services.workspacesweb.model.GetPortalServiceProviderMetadataRequest;
import software.amazon.awssdk.services.workspacesweb.model.GetPortalServiceProviderMetadataResponse;
import software.amazon.awssdk.services.workspacesweb.model.GetTrustStoreCertificateRequest;
import software.amazon.awssdk.services.workspacesweb.model.GetTrustStoreCertificateResponse;
import software.amazon.awssdk.services.workspacesweb.model.GetTrustStoreRequest;
import software.amazon.awssdk.services.workspacesweb.model.GetTrustStoreResponse;
import software.amazon.awssdk.services.workspacesweb.model.GetUserSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.GetUserSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.InternalServerException;
import software.amazon.awssdk.services.workspacesweb.model.ListBrowserSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.ListBrowserSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.ListIdentityProvidersRequest;
import software.amazon.awssdk.services.workspacesweb.model.ListIdentityProvidersResponse;
import software.amazon.awssdk.services.workspacesweb.model.ListNetworkSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.ListNetworkSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.ListPortalsRequest;
import software.amazon.awssdk.services.workspacesweb.model.ListPortalsResponse;
import software.amazon.awssdk.services.workspacesweb.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.workspacesweb.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.workspacesweb.model.ListTrustStoreCertificatesRequest;
import software.amazon.awssdk.services.workspacesweb.model.ListTrustStoreCertificatesResponse;
import software.amazon.awssdk.services.workspacesweb.model.ListTrustStoresRequest;
import software.amazon.awssdk.services.workspacesweb.model.ListTrustStoresResponse;
import software.amazon.awssdk.services.workspacesweb.model.ListUserSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.ListUserSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.ResourceNotFoundException;
import software.amazon.awssdk.services.workspacesweb.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.workspacesweb.model.TagResourceRequest;
import software.amazon.awssdk.services.workspacesweb.model.TagResourceResponse;
import software.amazon.awssdk.services.workspacesweb.model.ThrottlingException;
import software.amazon.awssdk.services.workspacesweb.model.TooManyTagsException;
import software.amazon.awssdk.services.workspacesweb.model.UntagResourceRequest;
import software.amazon.awssdk.services.workspacesweb.model.UntagResourceResponse;
import software.amazon.awssdk.services.workspacesweb.model.UpdateBrowserSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.UpdateBrowserSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.UpdateIdentityProviderRequest;
import software.amazon.awssdk.services.workspacesweb.model.UpdateIdentityProviderResponse;
import software.amazon.awssdk.services.workspacesweb.model.UpdateNetworkSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.UpdateNetworkSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.UpdatePortalRequest;
import software.amazon.awssdk.services.workspacesweb.model.UpdatePortalResponse;
import software.amazon.awssdk.services.workspacesweb.model.UpdateTrustStoreRequest;
import software.amazon.awssdk.services.workspacesweb.model.UpdateTrustStoreResponse;
import software.amazon.awssdk.services.workspacesweb.model.UpdateUserSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.UpdateUserSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.ValidationException;
import software.amazon.awssdk.services.workspacesweb.model.WorkSpacesWebException;
import software.amazon.awssdk.services.workspacesweb.model.WorkSpacesWebRequest;
import software.amazon.awssdk.services.workspacesweb.paginators.ListBrowserSettingsIterable;
import software.amazon.awssdk.services.workspacesweb.paginators.ListIdentityProvidersIterable;
import software.amazon.awssdk.services.workspacesweb.paginators.ListNetworkSettingsIterable;
import software.amazon.awssdk.services.workspacesweb.paginators.ListPortalsIterable;
import software.amazon.awssdk.services.workspacesweb.paginators.ListTrustStoreCertificatesIterable;
import software.amazon.awssdk.services.workspacesweb.paginators.ListTrustStoresIterable;
import software.amazon.awssdk.services.workspacesweb.paginators.ListUserSettingsIterable;
import software.amazon.awssdk.services.workspacesweb.transform.AssociateBrowserSettingsRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.AssociateNetworkSettingsRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.AssociateTrustStoreRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.AssociateUserSettingsRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.CreateBrowserSettingsRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.CreateIdentityProviderRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.CreateNetworkSettingsRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.CreatePortalRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.CreateTrustStoreRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.CreateUserSettingsRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.DeleteBrowserSettingsRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.DeleteIdentityProviderRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.DeleteNetworkSettingsRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.DeletePortalRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.DeleteTrustStoreRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.DeleteUserSettingsRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.DisassociateBrowserSettingsRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.DisassociateNetworkSettingsRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.DisassociateTrustStoreRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.DisassociateUserSettingsRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.GetBrowserSettingsRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.GetIdentityProviderRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.GetNetworkSettingsRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.GetPortalRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.GetPortalServiceProviderMetadataRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.GetTrustStoreCertificateRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.GetTrustStoreRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.GetUserSettingsRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.ListBrowserSettingsRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.ListIdentityProvidersRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.ListNetworkSettingsRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.ListPortalsRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.ListTrustStoreCertificatesRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.ListTrustStoresRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.ListUserSettingsRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.UpdateBrowserSettingsRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.UpdateIdentityProviderRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.UpdateNetworkSettingsRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.UpdatePortalRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.UpdateTrustStoreRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.UpdateUserSettingsRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

/**
 * Internal implementation of {@link WorkSpacesWebClient}.
 *
 * @see WorkSpacesWebClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultWorkSpacesWebClient implements WorkSpacesWebClient {
    private static final Logger log = Logger.loggerFor(DefaultWorkSpacesWebClient.class);

    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultWorkSpacesWebClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    /**
     * <p>
     * Associates a browser settings resource with a web portal.
     * </p>
     *
     * @param associateBrowserSettingsRequest
     * @return Result of the AssociateBrowserSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.AssociateBrowserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/AssociateBrowserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AssociateBrowserSettingsResponse associateBrowserSettings(
            AssociateBrowserSettingsRequest associateBrowserSettingsRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, ConflictException,
            AwsServiceException, SdkClientException, WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociateBrowserSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AssociateBrowserSettingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateBrowserSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateBrowserSettings");

            return clientHandler
                    .execute(new ClientExecutionParams<AssociateBrowserSettingsRequest, AssociateBrowserSettingsResponse>()
                            .withOperationName("AssociateBrowserSettings").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(associateBrowserSettingsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AssociateBrowserSettingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Associates a network settings resource with a web portal.
     * </p>
     *
     * @param associateNetworkSettingsRequest
     * @return Result of the AssociateNetworkSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.AssociateNetworkSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/AssociateNetworkSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AssociateNetworkSettingsResponse associateNetworkSettings(
            AssociateNetworkSettingsRequest associateNetworkSettingsRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, ConflictException,
            AwsServiceException, SdkClientException, WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociateNetworkSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AssociateNetworkSettingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateNetworkSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateNetworkSettings");

            return clientHandler
                    .execute(new ClientExecutionParams<AssociateNetworkSettingsRequest, AssociateNetworkSettingsResponse>()
                            .withOperationName("AssociateNetworkSettings").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(associateNetworkSettingsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AssociateNetworkSettingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Associates a trust store with a web portal.
     * </p>
     *
     * @param associateTrustStoreRequest
     * @return Result of the AssociateTrustStore operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.AssociateTrustStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/AssociateTrustStore"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AssociateTrustStoreResponse associateTrustStore(AssociateTrustStoreRequest associateTrustStoreRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociateTrustStoreResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AssociateTrustStoreResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateTrustStoreRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateTrustStore");

            return clientHandler.execute(new ClientExecutionParams<AssociateTrustStoreRequest, AssociateTrustStoreResponse>()
                    .withOperationName("AssociateTrustStore").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(associateTrustStoreRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AssociateTrustStoreRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Associates a user settings resource with a web portal.
     * </p>
     *
     * @param associateUserSettingsRequest
     * @return Result of the AssociateUserSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.AssociateUserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/AssociateUserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AssociateUserSettingsResponse associateUserSettings(AssociateUserSettingsRequest associateUserSettingsRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, ConflictException, AwsServiceException, SdkClientException, WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociateUserSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AssociateUserSettingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateUserSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateUserSettings");

            return clientHandler.execute(new ClientExecutionParams<AssociateUserSettingsRequest, AssociateUserSettingsResponse>()
                    .withOperationName("AssociateUserSettings").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(associateUserSettingsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AssociateUserSettingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a browser settings resource that can be associated with a web portal. Once associated with a web portal,
     * browser settings control how the browser will behave once a user starts a streaming session for the web portal.
     * </p>
     *
     * @param createBrowserSettingsRequest
     * @return Result of the CreateBrowserSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.CreateBrowserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/CreateBrowserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateBrowserSettingsResponse createBrowserSettings(CreateBrowserSettingsRequest createBrowserSettingsRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ServiceQuotaExceededException, ValidationException, ConflictException, AwsServiceException, SdkClientException,
            WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateBrowserSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateBrowserSettingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createBrowserSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateBrowserSettings");

            return clientHandler.execute(new ClientExecutionParams<CreateBrowserSettingsRequest, CreateBrowserSettingsResponse>()
                    .withOperationName("CreateBrowserSettings").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createBrowserSettingsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateBrowserSettingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an identity provider resource that is then associated with a web portal.
     * </p>
     *
     * @param createIdentityProviderRequest
     * @return Result of the CreateIdentityProvider operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.CreateIdentityProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/CreateIdentityProvider"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateIdentityProviderResponse createIdentityProvider(CreateIdentityProviderRequest createIdentityProviderRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, ConflictException, AwsServiceException, SdkClientException, WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateIdentityProviderResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateIdentityProviderResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createIdentityProviderRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateIdentityProvider");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateIdentityProviderRequest, CreateIdentityProviderResponse>()
                            .withOperationName("CreateIdentityProvider").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(createIdentityProviderRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateIdentityProviderRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a network settings resource that can be associated with a web portal. Once associated with a web portal,
     * network settings define how streaming instances will connect with your specified VPC.
     * </p>
     *
     * @param createNetworkSettingsRequest
     * @return Result of the CreateNetworkSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.CreateNetworkSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/CreateNetworkSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateNetworkSettingsResponse createNetworkSettings(CreateNetworkSettingsRequest createNetworkSettingsRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ServiceQuotaExceededException,
            ValidationException, ConflictException, AwsServiceException, SdkClientException, WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateNetworkSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateNetworkSettingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createNetworkSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateNetworkSettings");

            return clientHandler.execute(new ClientExecutionParams<CreateNetworkSettingsRequest, CreateNetworkSettingsResponse>()
                    .withOperationName("CreateNetworkSettings").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createNetworkSettingsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateNetworkSettingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a web portal.
     * </p>
     *
     * @param createPortalRequest
     * @return Result of the CreatePortal operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.CreatePortal
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/CreatePortal" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreatePortalResponse createPortal(CreatePortalRequest createPortalRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ServiceQuotaExceededException,
            ValidationException, ConflictException, AwsServiceException, SdkClientException, WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreatePortalResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreatePortalResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createPortalRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreatePortal");

            return clientHandler.execute(new ClientExecutionParams<CreatePortalRequest, CreatePortalResponse>()
                    .withOperationName("CreatePortal").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createPortalRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreatePortalRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a trust store that can be associated with a web portal. A trust store contains certificate authority (CA)
     * certificates. Once associated with a web portal, the browser in a streaming session will recognize certificates
     * that have been issued using any of the CAs in the trust store. If your organization has internal websites that
     * use certificates issued by private CAs, you should add the private CA certificate to the trust store.
     * </p>
     *
     * @param createTrustStoreRequest
     * @return Result of the CreateTrustStore operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.CreateTrustStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/CreateTrustStore"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateTrustStoreResponse createTrustStore(CreateTrustStoreRequest createTrustStoreRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ServiceQuotaExceededException,
            ValidationException, ConflictException, AwsServiceException, SdkClientException, WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateTrustStoreResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateTrustStoreResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createTrustStoreRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTrustStore");

            return clientHandler.execute(new ClientExecutionParams<CreateTrustStoreRequest, CreateTrustStoreResponse>()
                    .withOperationName("CreateTrustStore").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createTrustStoreRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateTrustStoreRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a user settings resource that can be associated with a web portal. Once associated with a web portal,
     * user settings control how users can transfer data between a streaming session and the their local devices.
     * </p>
     *
     * @param createUserSettingsRequest
     * @return Result of the CreateUserSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.CreateUserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/CreateUserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateUserSettingsResponse createUserSettings(CreateUserSettingsRequest createUserSettingsRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ServiceQuotaExceededException,
            ValidationException, ConflictException, AwsServiceException, SdkClientException, WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateUserSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateUserSettingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createUserSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateUserSettings");

            return clientHandler.execute(new ClientExecutionParams<CreateUserSettingsRequest, CreateUserSettingsResponse>()
                    .withOperationName("CreateUserSettings").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createUserSettingsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateUserSettingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes browser settings.
     * </p>
     *
     * @param deleteBrowserSettingsRequest
     * @return Result of the DeleteBrowserSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.DeleteBrowserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DeleteBrowserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteBrowserSettingsResponse deleteBrowserSettings(DeleteBrowserSettingsRequest deleteBrowserSettingsRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, ConflictException,
            AwsServiceException, SdkClientException, WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteBrowserSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteBrowserSettingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteBrowserSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteBrowserSettings");

            return clientHandler.execute(new ClientExecutionParams<DeleteBrowserSettingsRequest, DeleteBrowserSettingsResponse>()
                    .withOperationName("DeleteBrowserSettings").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteBrowserSettingsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteBrowserSettingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the identity provider.
     * </p>
     *
     * @param deleteIdentityProviderRequest
     * @return Result of the DeleteIdentityProvider operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.DeleteIdentityProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DeleteIdentityProvider"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteIdentityProviderResponse deleteIdentityProvider(DeleteIdentityProviderRequest deleteIdentityProviderRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, ConflictException,
            AwsServiceException, SdkClientException, WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteIdentityProviderResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteIdentityProviderResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteIdentityProviderRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteIdentityProvider");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteIdentityProviderRequest, DeleteIdentityProviderResponse>()
                            .withOperationName("DeleteIdentityProvider").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deleteIdentityProviderRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteIdentityProviderRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes network settings.
     * </p>
     *
     * @param deleteNetworkSettingsRequest
     * @return Result of the DeleteNetworkSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.DeleteNetworkSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DeleteNetworkSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteNetworkSettingsResponse deleteNetworkSettings(DeleteNetworkSettingsRequest deleteNetworkSettingsRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, ConflictException,
            AwsServiceException, SdkClientException, WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteNetworkSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteNetworkSettingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteNetworkSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteNetworkSettings");

            return clientHandler.execute(new ClientExecutionParams<DeleteNetworkSettingsRequest, DeleteNetworkSettingsResponse>()
                    .withOperationName("DeleteNetworkSettings").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteNetworkSettingsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteNetworkSettingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a web portal.
     * </p>
     *
     * @param deletePortalRequest
     * @return Result of the DeletePortal operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.DeletePortal
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DeletePortal" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeletePortalResponse deletePortal(DeletePortalRequest deletePortalRequest) throws InternalServerException,
            AccessDeniedException, ThrottlingException, ValidationException, ConflictException, AwsServiceException,
            SdkClientException, WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeletePortalResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeletePortalResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deletePortalRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeletePortal");

            return clientHandler.execute(new ClientExecutionParams<DeletePortalRequest, DeletePortalResponse>()
                    .withOperationName("DeletePortal").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deletePortalRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeletePortalRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the trust store.
     * </p>
     *
     * @param deleteTrustStoreRequest
     * @return Result of the DeleteTrustStore operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.DeleteTrustStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DeleteTrustStore"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteTrustStoreResponse deleteTrustStore(DeleteTrustStoreRequest deleteTrustStoreRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, ConflictException,
            AwsServiceException, SdkClientException, WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteTrustStoreResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteTrustStoreResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteTrustStoreRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTrustStore");

            return clientHandler.execute(new ClientExecutionParams<DeleteTrustStoreRequest, DeleteTrustStoreResponse>()
                    .withOperationName("DeleteTrustStore").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteTrustStoreRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteTrustStoreRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes user settings.
     * </p>
     *
     * @param deleteUserSettingsRequest
     * @return Result of the DeleteUserSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.DeleteUserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DeleteUserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteUserSettingsResponse deleteUserSettings(DeleteUserSettingsRequest deleteUserSettingsRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, ConflictException,
            AwsServiceException, SdkClientException, WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteUserSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteUserSettingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteUserSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteUserSettings");

            return clientHandler.execute(new ClientExecutionParams<DeleteUserSettingsRequest, DeleteUserSettingsResponse>()
                    .withOperationName("DeleteUserSettings").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteUserSettingsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteUserSettingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Disassociates browser settings from a web portal.
     * </p>
     *
     * @param disassociateBrowserSettingsRequest
     * @return Result of the DisassociateBrowserSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.DisassociateBrowserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DisassociateBrowserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DisassociateBrowserSettingsResponse disassociateBrowserSettings(
            DisassociateBrowserSettingsRequest disassociateBrowserSettingsRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DisassociateBrowserSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DisassociateBrowserSettingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disassociateBrowserSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateBrowserSettings");

            return clientHandler
                    .execute(new ClientExecutionParams<DisassociateBrowserSettingsRequest, DisassociateBrowserSettingsResponse>()
                            .withOperationName("DisassociateBrowserSettings").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(disassociateBrowserSettingsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DisassociateBrowserSettingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Disassociates network settings from a web portal.
     * </p>
     *
     * @param disassociateNetworkSettingsRequest
     * @return Result of the DisassociateNetworkSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.DisassociateNetworkSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DisassociateNetworkSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DisassociateNetworkSettingsResponse disassociateNetworkSettings(
            DisassociateNetworkSettingsRequest disassociateNetworkSettingsRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DisassociateNetworkSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DisassociateNetworkSettingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disassociateNetworkSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateNetworkSettings");

            return clientHandler
                    .execute(new ClientExecutionParams<DisassociateNetworkSettingsRequest, DisassociateNetworkSettingsResponse>()
                            .withOperationName("DisassociateNetworkSettings").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(disassociateNetworkSettingsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DisassociateNetworkSettingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Disassociates a trust store from a web portal.
     * </p>
     *
     * @param disassociateTrustStoreRequest
     * @return Result of the DisassociateTrustStore operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.DisassociateTrustStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DisassociateTrustStore"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DisassociateTrustStoreResponse disassociateTrustStore(DisassociateTrustStoreRequest disassociateTrustStoreRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DisassociateTrustStoreResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DisassociateTrustStoreResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disassociateTrustStoreRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateTrustStore");

            return clientHandler
                    .execute(new ClientExecutionParams<DisassociateTrustStoreRequest, DisassociateTrustStoreResponse>()
                            .withOperationName("DisassociateTrustStore").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(disassociateTrustStoreRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DisassociateTrustStoreRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Disassociates user settings from a web portal.
     * </p>
     *
     * @param disassociateUserSettingsRequest
     * @return Result of the DisassociateUserSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.DisassociateUserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DisassociateUserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DisassociateUserSettingsResponse disassociateUserSettings(
            DisassociateUserSettingsRequest disassociateUserSettingsRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DisassociateUserSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DisassociateUserSettingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disassociateUserSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateUserSettings");

            return clientHandler
                    .execute(new ClientExecutionParams<DisassociateUserSettingsRequest, DisassociateUserSettingsResponse>()
                            .withOperationName("DisassociateUserSettings").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(disassociateUserSettingsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DisassociateUserSettingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets browser settings.
     * </p>
     *
     * @param getBrowserSettingsRequest
     * @return Result of the GetBrowserSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.GetBrowserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/GetBrowserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetBrowserSettingsResponse getBrowserSettings(GetBrowserSettingsRequest getBrowserSettingsRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetBrowserSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetBrowserSettingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getBrowserSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetBrowserSettings");

            return clientHandler.execute(new ClientExecutionParams<GetBrowserSettingsRequest, GetBrowserSettingsResponse>()
                    .withOperationName("GetBrowserSettings").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getBrowserSettingsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetBrowserSettingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets the identity provider.
     * </p>
     *
     * @param getIdentityProviderRequest
     * @return Result of the GetIdentityProvider operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.GetIdentityProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/GetIdentityProvider"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetIdentityProviderResponse getIdentityProvider(GetIdentityProviderRequest getIdentityProviderRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetIdentityProviderResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetIdentityProviderResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getIdentityProviderRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetIdentityProvider");

            return clientHandler.execute(new ClientExecutionParams<GetIdentityProviderRequest, GetIdentityProviderResponse>()
                    .withOperationName("GetIdentityProvider").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getIdentityProviderRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetIdentityProviderRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets the network settings.
     * </p>
     *
     * @param getNetworkSettingsRequest
     * @return Result of the GetNetworkSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.GetNetworkSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/GetNetworkSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetNetworkSettingsResponse getNetworkSettings(GetNetworkSettingsRequest getNetworkSettingsRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetNetworkSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetNetworkSettingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getNetworkSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetNetworkSettings");

            return clientHandler.execute(new ClientExecutionParams<GetNetworkSettingsRequest, GetNetworkSettingsResponse>()
                    .withOperationName("GetNetworkSettings").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getNetworkSettingsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetNetworkSettingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets the web portal.
     * </p>
     *
     * @param getPortalRequest
     * @return Result of the GetPortal operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.GetPortal
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/GetPortal" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetPortalResponse getPortal(GetPortalRequest getPortalRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetPortalResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetPortalResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getPortalRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetPortal");

            return clientHandler.execute(new ClientExecutionParams<GetPortalRequest, GetPortalResponse>()
                    .withOperationName("GetPortal").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getPortalRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new GetPortalRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets the service provider metadata.
     * </p>
     *
     * @param getPortalServiceProviderMetadataRequest
     * @return Result of the GetPortalServiceProviderMetadata operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.GetPortalServiceProviderMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/GetPortalServiceProviderMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetPortalServiceProviderMetadataResponse getPortalServiceProviderMetadata(
            GetPortalServiceProviderMetadataRequest getPortalServiceProviderMetadataRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetPortalServiceProviderMetadataResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetPortalServiceProviderMetadataResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getPortalServiceProviderMetadataRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetPortalServiceProviderMetadata");

            return clientHandler
                    .execute(new ClientExecutionParams<GetPortalServiceProviderMetadataRequest, GetPortalServiceProviderMetadataResponse>()
                            .withOperationName("GetPortalServiceProviderMetadata").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(getPortalServiceProviderMetadataRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetPortalServiceProviderMetadataRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets the trust store.
     * </p>
     *
     * @param getTrustStoreRequest
     * @return Result of the GetTrustStore operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.GetTrustStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/GetTrustStore" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetTrustStoreResponse getTrustStore(GetTrustStoreRequest getTrustStoreRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetTrustStoreResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetTrustStoreResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getTrustStoreRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetTrustStore");

            return clientHandler.execute(new ClientExecutionParams<GetTrustStoreRequest, GetTrustStoreResponse>()
                    .withOperationName("GetTrustStore").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getTrustStoreRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetTrustStoreRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets the trust store certificate.
     * </p>
     *
     * @param getTrustStoreCertificateRequest
     * @return Result of the GetTrustStoreCertificate operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.GetTrustStoreCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/GetTrustStoreCertificate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetTrustStoreCertificateResponse getTrustStoreCertificate(
            GetTrustStoreCertificateRequest getTrustStoreCertificateRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetTrustStoreCertificateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetTrustStoreCertificateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getTrustStoreCertificateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetTrustStoreCertificate");

            return clientHandler
                    .execute(new ClientExecutionParams<GetTrustStoreCertificateRequest, GetTrustStoreCertificateResponse>()
                            .withOperationName("GetTrustStoreCertificate").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(getTrustStoreCertificateRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetTrustStoreCertificateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets user settings.
     * </p>
     *
     * @param getUserSettingsRequest
     * @return Result of the GetUserSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.GetUserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/GetUserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetUserSettingsResponse getUserSettings(GetUserSettingsRequest getUserSettingsRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetUserSettingsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetUserSettingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getUserSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetUserSettings");

            return clientHandler.execute(new ClientExecutionParams<GetUserSettingsRequest, GetUserSettingsResponse>()
                    .withOperationName("GetUserSettings").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getUserSettingsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetUserSettingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list of browser settings.
     * </p>
     *
     * @param listBrowserSettingsRequest
     * @return Result of the ListBrowserSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.ListBrowserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListBrowserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListBrowserSettingsResponse listBrowserSettings(ListBrowserSettingsRequest listBrowserSettingsRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListBrowserSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListBrowserSettingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listBrowserSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListBrowserSettings");

            return clientHandler.execute(new ClientExecutionParams<ListBrowserSettingsRequest, ListBrowserSettingsResponse>()
                    .withOperationName("ListBrowserSettings").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listBrowserSettingsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListBrowserSettingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list of browser settings.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBrowserSettings(software.amazon.awssdk.services.workspacesweb.model.ListBrowserSettingsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListBrowserSettingsIterable responses = client.listBrowserSettingsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workspacesweb.paginators.ListBrowserSettingsIterable responses = client
     *             .listBrowserSettingsPaginator(request);
     *     for (software.amazon.awssdk.services.workspacesweb.model.ListBrowserSettingsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListBrowserSettingsIterable responses = client.listBrowserSettingsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBrowserSettings(software.amazon.awssdk.services.workspacesweb.model.ListBrowserSettingsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listBrowserSettingsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.ListBrowserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListBrowserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListBrowserSettingsIterable listBrowserSettingsPaginator(ListBrowserSettingsRequest listBrowserSettingsRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, WorkSpacesWebException {
        return new ListBrowserSettingsIterable(this, applyPaginatorUserAgent(listBrowserSettingsRequest));
    }

    /**
     * <p>
     * Retrieves a list of identity providers for a specific web portal.
     * </p>
     *
     * @param listIdentityProvidersRequest
     * @return Result of the ListIdentityProviders operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.ListIdentityProviders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListIdentityProviders"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListIdentityProvidersResponse listIdentityProviders(ListIdentityProvidersRequest listIdentityProvidersRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListIdentityProvidersResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListIdentityProvidersResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listIdentityProvidersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListIdentityProviders");

            return clientHandler.execute(new ClientExecutionParams<ListIdentityProvidersRequest, ListIdentityProvidersResponse>()
                    .withOperationName("ListIdentityProviders").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listIdentityProvidersRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListIdentityProvidersRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list of identity providers for a specific web portal.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listIdentityProviders(software.amazon.awssdk.services.workspacesweb.model.ListIdentityProvidersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListIdentityProvidersIterable responses = client.listIdentityProvidersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workspacesweb.paginators.ListIdentityProvidersIterable responses = client
     *             .listIdentityProvidersPaginator(request);
     *     for (software.amazon.awssdk.services.workspacesweb.model.ListIdentityProvidersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListIdentityProvidersIterable responses = client.listIdentityProvidersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIdentityProviders(software.amazon.awssdk.services.workspacesweb.model.ListIdentityProvidersRequest)}
     * operation.</b>
     * </p>
     *
     * @param listIdentityProvidersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.ListIdentityProviders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListIdentityProviders"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListIdentityProvidersIterable listIdentityProvidersPaginator(ListIdentityProvidersRequest listIdentityProvidersRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, WorkSpacesWebException {
        return new ListIdentityProvidersIterable(this, applyPaginatorUserAgent(listIdentityProvidersRequest));
    }

    /**
     * <p>
     * Retrieves a list of network settings.
     * </p>
     *
     * @param listNetworkSettingsRequest
     * @return Result of the ListNetworkSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.ListNetworkSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListNetworkSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListNetworkSettingsResponse listNetworkSettings(ListNetworkSettingsRequest listNetworkSettingsRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListNetworkSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListNetworkSettingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listNetworkSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListNetworkSettings");

            return clientHandler.execute(new ClientExecutionParams<ListNetworkSettingsRequest, ListNetworkSettingsResponse>()
                    .withOperationName("ListNetworkSettings").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listNetworkSettingsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListNetworkSettingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list of network settings.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listNetworkSettings(software.amazon.awssdk.services.workspacesweb.model.ListNetworkSettingsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListNetworkSettingsIterable responses = client.listNetworkSettingsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workspacesweb.paginators.ListNetworkSettingsIterable responses = client
     *             .listNetworkSettingsPaginator(request);
     *     for (software.amazon.awssdk.services.workspacesweb.model.ListNetworkSettingsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListNetworkSettingsIterable responses = client.listNetworkSettingsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNetworkSettings(software.amazon.awssdk.services.workspacesweb.model.ListNetworkSettingsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listNetworkSettingsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.ListNetworkSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListNetworkSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListNetworkSettingsIterable listNetworkSettingsPaginator(ListNetworkSettingsRequest listNetworkSettingsRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, WorkSpacesWebException {
        return new ListNetworkSettingsIterable(this, applyPaginatorUserAgent(listNetworkSettingsRequest));
    }

    /**
     * <p>
     * Retrieves a list or web portals.
     * </p>
     *
     * @param listPortalsRequest
     * @return Result of the ListPortals operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.ListPortals
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListPortals" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListPortalsResponse listPortals(ListPortalsRequest listPortalsRequest) throws InternalServerException,
            AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListPortalsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListPortalsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listPortalsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListPortals");

            return clientHandler.execute(new ClientExecutionParams<ListPortalsRequest, ListPortalsResponse>()
                    .withOperationName("ListPortals").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listPortalsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListPortalsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list or web portals.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listPortals(software.amazon.awssdk.services.workspacesweb.model.ListPortalsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListPortalsIterable responses = client.listPortalsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workspacesweb.paginators.ListPortalsIterable responses = client.listPortalsPaginator(request);
     *     for (software.amazon.awssdk.services.workspacesweb.model.ListPortalsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListPortalsIterable responses = client.listPortalsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPortals(software.amazon.awssdk.services.workspacesweb.model.ListPortalsRequest)} operation.</b>
     * </p>
     *
     * @param listPortalsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.ListPortals
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListPortals" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListPortalsIterable listPortalsPaginator(ListPortalsRequest listPortalsRequest) throws InternalServerException,
            AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            WorkSpacesWebException {
        return new ListPortalsIterable(this, applyPaginatorUserAgent(listPortalsRequest));
    }

    /**
     * <p>
     * Retrieves a list of tags for a resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListTagsForResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");

            return clientHandler.execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                    .withOperationName("ListTagsForResource").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listTagsForResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list of trust store certificates.
     * </p>
     *
     * @param listTrustStoreCertificatesRequest
     * @return Result of the ListTrustStoreCertificates operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.ListTrustStoreCertificates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListTrustStoreCertificates"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListTrustStoreCertificatesResponse listTrustStoreCertificates(
            ListTrustStoreCertificatesRequest listTrustStoreCertificatesRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTrustStoreCertificatesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListTrustStoreCertificatesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTrustStoreCertificatesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTrustStoreCertificates");

            return clientHandler
                    .execute(new ClientExecutionParams<ListTrustStoreCertificatesRequest, ListTrustStoreCertificatesResponse>()
                            .withOperationName("ListTrustStoreCertificates").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listTrustStoreCertificatesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListTrustStoreCertificatesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list of trust store certificates.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTrustStoreCertificates(software.amazon.awssdk.services.workspacesweb.model.ListTrustStoreCertificatesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListTrustStoreCertificatesIterable responses = client.listTrustStoreCertificatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workspacesweb.paginators.ListTrustStoreCertificatesIterable responses = client
     *             .listTrustStoreCertificatesPaginator(request);
     *     for (software.amazon.awssdk.services.workspacesweb.model.ListTrustStoreCertificatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListTrustStoreCertificatesIterable responses = client.listTrustStoreCertificatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTrustStoreCertificates(software.amazon.awssdk.services.workspacesweb.model.ListTrustStoreCertificatesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTrustStoreCertificatesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.ListTrustStoreCertificates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListTrustStoreCertificates"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListTrustStoreCertificatesIterable listTrustStoreCertificatesPaginator(
            ListTrustStoreCertificatesRequest listTrustStoreCertificatesRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, WorkSpacesWebException {
        return new ListTrustStoreCertificatesIterable(this, applyPaginatorUserAgent(listTrustStoreCertificatesRequest));
    }

    /**
     * <p>
     * Retrieves a list of trust stores.
     * </p>
     *
     * @param listTrustStoresRequest
     * @return Result of the ListTrustStores operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.ListTrustStores
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListTrustStores"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListTrustStoresResponse listTrustStores(ListTrustStoresRequest listTrustStoresRequest) throws InternalServerException,
            AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTrustStoresResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListTrustStoresResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTrustStoresRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTrustStores");

            return clientHandler.execute(new ClientExecutionParams<ListTrustStoresRequest, ListTrustStoresResponse>()
                    .withOperationName("ListTrustStores").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listTrustStoresRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListTrustStoresRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list of trust stores.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTrustStores(software.amazon.awssdk.services.workspacesweb.model.ListTrustStoresRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListTrustStoresIterable responses = client.listTrustStoresPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workspacesweb.paginators.ListTrustStoresIterable responses = client
     *             .listTrustStoresPaginator(request);
     *     for (software.amazon.awssdk.services.workspacesweb.model.ListTrustStoresResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListTrustStoresIterable responses = client.listTrustStoresPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTrustStores(software.amazon.awssdk.services.workspacesweb.model.ListTrustStoresRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTrustStoresRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.ListTrustStores
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListTrustStores"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListTrustStoresIterable listTrustStoresPaginator(ListTrustStoresRequest listTrustStoresRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, WorkSpacesWebException {
        return new ListTrustStoresIterable(this, applyPaginatorUserAgent(listTrustStoresRequest));
    }

    /**
     * <p>
     * Retrieves a list of user settings.
     * </p>
     *
     * @param listUserSettingsRequest
     * @return Result of the ListUserSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.ListUserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListUserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListUserSettingsResponse listUserSettings(ListUserSettingsRequest listUserSettingsRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListUserSettingsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListUserSettingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listUserSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListUserSettings");

            return clientHandler.execute(new ClientExecutionParams<ListUserSettingsRequest, ListUserSettingsResponse>()
                    .withOperationName("ListUserSettings").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listUserSettingsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListUserSettingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list of user settings.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listUserSettings(software.amazon.awssdk.services.workspacesweb.model.ListUserSettingsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListUserSettingsIterable responses = client.listUserSettingsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.workspacesweb.paginators.ListUserSettingsIterable responses = client
     *             .listUserSettingsPaginator(request);
     *     for (software.amazon.awssdk.services.workspacesweb.model.ListUserSettingsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListUserSettingsIterable responses = client.listUserSettingsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUserSettings(software.amazon.awssdk.services.workspacesweb.model.ListUserSettingsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listUserSettingsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.ListUserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListUserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListUserSettingsIterable listUserSettingsPaginator(ListUserSettingsRequest listUserSettingsRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, WorkSpacesWebException {
        return new ListUserSettingsIterable(this, applyPaginatorUserAgent(listUserSettingsRequest));
    }

    /**
     * <p>
     * Adds or overwrites one or more tags for the specified resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws TooManyTagsException
     *         There are too many tags.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, TooManyTagsException,
            AwsServiceException, SdkClientException, WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                TagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");

            return clientHandler.execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                    .withOperationName("TagResource").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(tagResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new TagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes one or more tags from the specified resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UntagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");

            return clientHandler.execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                    .withOperationName("UntagResource").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(untagResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates browser settings.
     * </p>
     *
     * @param updateBrowserSettingsRequest
     * @return Result of the UpdateBrowserSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.UpdateBrowserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/UpdateBrowserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateBrowserSettingsResponse updateBrowserSettings(UpdateBrowserSettingsRequest updateBrowserSettingsRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateBrowserSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateBrowserSettingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateBrowserSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateBrowserSettings");

            return clientHandler.execute(new ClientExecutionParams<UpdateBrowserSettingsRequest, UpdateBrowserSettingsResponse>()
                    .withOperationName("UpdateBrowserSettings").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateBrowserSettingsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateBrowserSettingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the identity provider.
     * </p>
     *
     * @param updateIdentityProviderRequest
     * @return Result of the UpdateIdentityProvider operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.UpdateIdentityProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/UpdateIdentityProvider"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateIdentityProviderResponse updateIdentityProvider(UpdateIdentityProviderRequest updateIdentityProviderRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateIdentityProviderResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateIdentityProviderResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateIdentityProviderRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateIdentityProvider");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateIdentityProviderRequest, UpdateIdentityProviderResponse>()
                            .withOperationName("UpdateIdentityProvider").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(updateIdentityProviderRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateIdentityProviderRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates network settings.
     * </p>
     *
     * @param updateNetworkSettingsRequest
     * @return Result of the UpdateNetworkSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.UpdateNetworkSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/UpdateNetworkSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateNetworkSettingsResponse updateNetworkSettings(UpdateNetworkSettingsRequest updateNetworkSettingsRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateNetworkSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateNetworkSettingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateNetworkSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateNetworkSettings");

            return clientHandler.execute(new ClientExecutionParams<UpdateNetworkSettingsRequest, UpdateNetworkSettingsResponse>()
                    .withOperationName("UpdateNetworkSettings").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateNetworkSettingsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateNetworkSettingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a web portal.
     * </p>
     *
     * @param updatePortalRequest
     * @return Result of the UpdatePortal operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.UpdatePortal
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/UpdatePortal" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdatePortalResponse updatePortal(UpdatePortalRequest updatePortalRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdatePortalResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdatePortalResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updatePortalRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdatePortal");

            return clientHandler.execute(new ClientExecutionParams<UpdatePortalRequest, UpdatePortalResponse>()
                    .withOperationName("UpdatePortal").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updatePortalRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdatePortalRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the trust store.
     * </p>
     *
     * @param updateTrustStoreRequest
     * @return Result of the UpdateTrustStore operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.UpdateTrustStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/UpdateTrustStore"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateTrustStoreResponse updateTrustStore(UpdateTrustStoreRequest updateTrustStoreRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ServiceQuotaExceededException, ValidationException, AwsServiceException, SdkClientException, WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateTrustStoreResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateTrustStoreResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateTrustStoreRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateTrustStore");

            return clientHandler.execute(new ClientExecutionParams<UpdateTrustStoreRequest, UpdateTrustStoreResponse>()
                    .withOperationName("UpdateTrustStore").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateTrustStoreRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateTrustStoreRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the user settings.
     * </p>
     *
     * @param updateUserSettingsRequest
     * @return Result of the UpdateUserSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.UpdateUserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/UpdateUserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateUserSettingsResponse updateUserSettings(UpdateUserSettingsRequest updateUserSettingsRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateUserSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateUserSettingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateUserSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateUserSettings");

            return clientHandler.execute(new ClientExecutionParams<UpdateUserSettingsRequest, UpdateUserSettingsResponse>()
                    .withOperationName("UpdateUserSettings").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateUserSettingsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateUserSettingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(WorkSpacesWebException::builder)
                .protocol(AwsJsonProtocol.REST_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ThrottlingException")
                                .exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(429).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException")
                                .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(402).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalServerException")
                                .exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AccessDeniedException")
                                .exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(403).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConflictException")
                                .exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyTagsException")
                                .exceptionBuilderSupplier(TooManyTagsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundException")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ValidationException")
                                .exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(400).build());
    }

    @Override
    public void close() {
        clientHandler.close();
    }

    private <T extends WorkSpacesWebRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder()
                .version(VersionInfo.SDK_VERSION).name("PAGINATED").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration()
                .map(c -> c.toBuilder().applyMutation(userAgentApplier).build())
                .orElse((AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier).build()));
        return (T) request.toBuilder().overrideConfiguration(overrideConfiguration).build();
    }
}
