/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspacesweb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A user settings resource that can be associated with a web portal. Once associated with a web portal, user settings
 * control how users can transfer data between a streaming session and the their local devices.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UserSettings implements SdkPojo, Serializable, ToCopyableBuilder<UserSettings.Builder, UserSettings> {
    private static final SdkField<List<String>> ASSOCIATED_PORTAL_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("associatedPortalArns")
            .getter(getter(UserSettings::associatedPortalArns))
            .setter(setter(Builder::associatedPortalArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associatedPortalArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> COPY_ALLOWED_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("copyAllowed").getter(getter(UserSettings::copyAllowedAsString)).setter(setter(Builder::copyAllowed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("copyAllowed").build()).build();

    private static final SdkField<String> DOWNLOAD_ALLOWED_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("downloadAllowed").getter(getter(UserSettings::downloadAllowedAsString))
            .setter(setter(Builder::downloadAllowed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("downloadAllowed").build()).build();

    private static final SdkField<String> PASTE_ALLOWED_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("pasteAllowed").getter(getter(UserSettings::pasteAllowedAsString)).setter(setter(Builder::pasteAllowed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pasteAllowed").build()).build();

    private static final SdkField<String> PRINT_ALLOWED_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("printAllowed").getter(getter(UserSettings::printAllowedAsString)).setter(setter(Builder::printAllowed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("printAllowed").build()).build();

    private static final SdkField<String> UPLOAD_ALLOWED_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("uploadAllowed").getter(getter(UserSettings::uploadAllowedAsString))
            .setter(setter(Builder::uploadAllowed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uploadAllowed").build()).build();

    private static final SdkField<String> USER_SETTINGS_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("userSettingsArn").getter(getter(UserSettings::userSettingsArn)).setter(setter(Builder::userSettingsArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userSettingsArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATED_PORTAL_ARNS_FIELD,
            COPY_ALLOWED_FIELD, DOWNLOAD_ALLOWED_FIELD, PASTE_ALLOWED_FIELD, PRINT_ALLOWED_FIELD, UPLOAD_ALLOWED_FIELD,
            USER_SETTINGS_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> associatedPortalArns;

    private final String copyAllowed;

    private final String downloadAllowed;

    private final String pasteAllowed;

    private final String printAllowed;

    private final String uploadAllowed;

    private final String userSettingsArn;

    private UserSettings(BuilderImpl builder) {
        this.associatedPortalArns = builder.associatedPortalArns;
        this.copyAllowed = builder.copyAllowed;
        this.downloadAllowed = builder.downloadAllowed;
        this.pasteAllowed = builder.pasteAllowed;
        this.printAllowed = builder.printAllowed;
        this.uploadAllowed = builder.uploadAllowed;
        this.userSettingsArn = builder.userSettingsArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the AssociatedPortalArns property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAssociatedPortalArns() {
        return associatedPortalArns != null && !(associatedPortalArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of web portal ARNs that this user settings is associated with.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssociatedPortalArns} method.
     * </p>
     * 
     * @return A list of web portal ARNs that this user settings is associated with.
     */
    public final List<String> associatedPortalArns() {
        return associatedPortalArns;
    }

    /**
     * <p>
     * Specifies whether the user can copy text from the streaming session to the local device.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #copyAllowed} will
     * return {@link EnabledType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #copyAllowedAsString}.
     * </p>
     * 
     * @return Specifies whether the user can copy text from the streaming session to the local device.
     * @see EnabledType
     */
    public final EnabledType copyAllowed() {
        return EnabledType.fromValue(copyAllowed);
    }

    /**
     * <p>
     * Specifies whether the user can copy text from the streaming session to the local device.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #copyAllowed} will
     * return {@link EnabledType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #copyAllowedAsString}.
     * </p>
     * 
     * @return Specifies whether the user can copy text from the streaming session to the local device.
     * @see EnabledType
     */
    public final String copyAllowedAsString() {
        return copyAllowed;
    }

    /**
     * <p>
     * Specifies whether the user can download files from the streaming session to the local device.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #downloadAllowed}
     * will return {@link EnabledType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #downloadAllowedAsString}.
     * </p>
     * 
     * @return Specifies whether the user can download files from the streaming session to the local device.
     * @see EnabledType
     */
    public final EnabledType downloadAllowed() {
        return EnabledType.fromValue(downloadAllowed);
    }

    /**
     * <p>
     * Specifies whether the user can download files from the streaming session to the local device.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #downloadAllowed}
     * will return {@link EnabledType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #downloadAllowedAsString}.
     * </p>
     * 
     * @return Specifies whether the user can download files from the streaming session to the local device.
     * @see EnabledType
     */
    public final String downloadAllowedAsString() {
        return downloadAllowed;
    }

    /**
     * <p>
     * Specifies whether the user can paste text from the local device to the streaming session.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pasteAllowed} will
     * return {@link EnabledType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #pasteAllowedAsString}.
     * </p>
     * 
     * @return Specifies whether the user can paste text from the local device to the streaming session.
     * @see EnabledType
     */
    public final EnabledType pasteAllowed() {
        return EnabledType.fromValue(pasteAllowed);
    }

    /**
     * <p>
     * Specifies whether the user can paste text from the local device to the streaming session.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pasteAllowed} will
     * return {@link EnabledType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #pasteAllowedAsString}.
     * </p>
     * 
     * @return Specifies whether the user can paste text from the local device to the streaming session.
     * @see EnabledType
     */
    public final String pasteAllowedAsString() {
        return pasteAllowed;
    }

    /**
     * <p>
     * Specifies whether the user can print to the local device.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #printAllowed} will
     * return {@link EnabledType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #printAllowedAsString}.
     * </p>
     * 
     * @return Specifies whether the user can print to the local device.
     * @see EnabledType
     */
    public final EnabledType printAllowed() {
        return EnabledType.fromValue(printAllowed);
    }

    /**
     * <p>
     * Specifies whether the user can print to the local device.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #printAllowed} will
     * return {@link EnabledType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #printAllowedAsString}.
     * </p>
     * 
     * @return Specifies whether the user can print to the local device.
     * @see EnabledType
     */
    public final String printAllowedAsString() {
        return printAllowed;
    }

    /**
     * <p>
     * Specifies whether the user can upload files from the local device to the streaming session.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #uploadAllowed}
     * will return {@link EnabledType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #uploadAllowedAsString}.
     * </p>
     * 
     * @return Specifies whether the user can upload files from the local device to the streaming session.
     * @see EnabledType
     */
    public final EnabledType uploadAllowed() {
        return EnabledType.fromValue(uploadAllowed);
    }

    /**
     * <p>
     * Specifies whether the user can upload files from the local device to the streaming session.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #uploadAllowed}
     * will return {@link EnabledType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #uploadAllowedAsString}.
     * </p>
     * 
     * @return Specifies whether the user can upload files from the local device to the streaming session.
     * @see EnabledType
     */
    public final String uploadAllowedAsString() {
        return uploadAllowed;
    }

    /**
     * <p>
     * The ARN of the user settings.
     * </p>
     * 
     * @return The ARN of the user settings.
     */
    public final String userSettingsArn() {
        return userSettingsArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAssociatedPortalArns() ? associatedPortalArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(copyAllowedAsString());
        hashCode = 31 * hashCode + Objects.hashCode(downloadAllowedAsString());
        hashCode = 31 * hashCode + Objects.hashCode(pasteAllowedAsString());
        hashCode = 31 * hashCode + Objects.hashCode(printAllowedAsString());
        hashCode = 31 * hashCode + Objects.hashCode(uploadAllowedAsString());
        hashCode = 31 * hashCode + Objects.hashCode(userSettingsArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserSettings)) {
            return false;
        }
        UserSettings other = (UserSettings) obj;
        return hasAssociatedPortalArns() == other.hasAssociatedPortalArns()
                && Objects.equals(associatedPortalArns(), other.associatedPortalArns())
                && Objects.equals(copyAllowedAsString(), other.copyAllowedAsString())
                && Objects.equals(downloadAllowedAsString(), other.downloadAllowedAsString())
                && Objects.equals(pasteAllowedAsString(), other.pasteAllowedAsString())
                && Objects.equals(printAllowedAsString(), other.printAllowedAsString())
                && Objects.equals(uploadAllowedAsString(), other.uploadAllowedAsString())
                && Objects.equals(userSettingsArn(), other.userSettingsArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UserSettings")
                .add("AssociatedPortalArns", hasAssociatedPortalArns() ? associatedPortalArns() : null)
                .add("CopyAllowed", copyAllowedAsString()).add("DownloadAllowed", downloadAllowedAsString())
                .add("PasteAllowed", pasteAllowedAsString()).add("PrintAllowed", printAllowedAsString())
                .add("UploadAllowed", uploadAllowedAsString()).add("UserSettingsArn", userSettingsArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "associatedPortalArns":
            return Optional.ofNullable(clazz.cast(associatedPortalArns()));
        case "copyAllowed":
            return Optional.ofNullable(clazz.cast(copyAllowedAsString()));
        case "downloadAllowed":
            return Optional.ofNullable(clazz.cast(downloadAllowedAsString()));
        case "pasteAllowed":
            return Optional.ofNullable(clazz.cast(pasteAllowedAsString()));
        case "printAllowed":
            return Optional.ofNullable(clazz.cast(printAllowedAsString()));
        case "uploadAllowed":
            return Optional.ofNullable(clazz.cast(uploadAllowedAsString()));
        case "userSettingsArn":
            return Optional.ofNullable(clazz.cast(userSettingsArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UserSettings, T> g) {
        return obj -> g.apply((UserSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UserSettings> {
        /**
         * <p>
         * A list of web portal ARNs that this user settings is associated with.
         * </p>
         * 
         * @param associatedPortalArns
         *        A list of web portal ARNs that this user settings is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedPortalArns(Collection<String> associatedPortalArns);

        /**
         * <p>
         * A list of web portal ARNs that this user settings is associated with.
         * </p>
         * 
         * @param associatedPortalArns
         *        A list of web portal ARNs that this user settings is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedPortalArns(String... associatedPortalArns);

        /**
         * <p>
         * Specifies whether the user can copy text from the streaming session to the local device.
         * </p>
         * 
         * @param copyAllowed
         *        Specifies whether the user can copy text from the streaming session to the local device.
         * @see EnabledType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnabledType
         */
        Builder copyAllowed(String copyAllowed);

        /**
         * <p>
         * Specifies whether the user can copy text from the streaming session to the local device.
         * </p>
         * 
         * @param copyAllowed
         *        Specifies whether the user can copy text from the streaming session to the local device.
         * @see EnabledType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnabledType
         */
        Builder copyAllowed(EnabledType copyAllowed);

        /**
         * <p>
         * Specifies whether the user can download files from the streaming session to the local device.
         * </p>
         * 
         * @param downloadAllowed
         *        Specifies whether the user can download files from the streaming session to the local device.
         * @see EnabledType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnabledType
         */
        Builder downloadAllowed(String downloadAllowed);

        /**
         * <p>
         * Specifies whether the user can download files from the streaming session to the local device.
         * </p>
         * 
         * @param downloadAllowed
         *        Specifies whether the user can download files from the streaming session to the local device.
         * @see EnabledType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnabledType
         */
        Builder downloadAllowed(EnabledType downloadAllowed);

        /**
         * <p>
         * Specifies whether the user can paste text from the local device to the streaming session.
         * </p>
         * 
         * @param pasteAllowed
         *        Specifies whether the user can paste text from the local device to the streaming session.
         * @see EnabledType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnabledType
         */
        Builder pasteAllowed(String pasteAllowed);

        /**
         * <p>
         * Specifies whether the user can paste text from the local device to the streaming session.
         * </p>
         * 
         * @param pasteAllowed
         *        Specifies whether the user can paste text from the local device to the streaming session.
         * @see EnabledType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnabledType
         */
        Builder pasteAllowed(EnabledType pasteAllowed);

        /**
         * <p>
         * Specifies whether the user can print to the local device.
         * </p>
         * 
         * @param printAllowed
         *        Specifies whether the user can print to the local device.
         * @see EnabledType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnabledType
         */
        Builder printAllowed(String printAllowed);

        /**
         * <p>
         * Specifies whether the user can print to the local device.
         * </p>
         * 
         * @param printAllowed
         *        Specifies whether the user can print to the local device.
         * @see EnabledType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnabledType
         */
        Builder printAllowed(EnabledType printAllowed);

        /**
         * <p>
         * Specifies whether the user can upload files from the local device to the streaming session.
         * </p>
         * 
         * @param uploadAllowed
         *        Specifies whether the user can upload files from the local device to the streaming session.
         * @see EnabledType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnabledType
         */
        Builder uploadAllowed(String uploadAllowed);

        /**
         * <p>
         * Specifies whether the user can upload files from the local device to the streaming session.
         * </p>
         * 
         * @param uploadAllowed
         *        Specifies whether the user can upload files from the local device to the streaming session.
         * @see EnabledType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnabledType
         */
        Builder uploadAllowed(EnabledType uploadAllowed);

        /**
         * <p>
         * The ARN of the user settings.
         * </p>
         * 
         * @param userSettingsArn
         *        The ARN of the user settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userSettingsArn(String userSettingsArn);
    }

    static final class BuilderImpl implements Builder {
        private List<String> associatedPortalArns = DefaultSdkAutoConstructList.getInstance();

        private String copyAllowed;

        private String downloadAllowed;

        private String pasteAllowed;

        private String printAllowed;

        private String uploadAllowed;

        private String userSettingsArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UserSettings model) {
            associatedPortalArns(model.associatedPortalArns);
            copyAllowed(model.copyAllowed);
            downloadAllowed(model.downloadAllowed);
            pasteAllowed(model.pasteAllowed);
            printAllowed(model.printAllowed);
            uploadAllowed(model.uploadAllowed);
            userSettingsArn(model.userSettingsArn);
        }

        public final Collection<String> getAssociatedPortalArns() {
            if (associatedPortalArns instanceof SdkAutoConstructList) {
                return null;
            }
            return associatedPortalArns;
        }

        public final void setAssociatedPortalArns(Collection<String> associatedPortalArns) {
            this.associatedPortalArns = ArnListCopier.copy(associatedPortalArns);
        }

        @Override
        public final Builder associatedPortalArns(Collection<String> associatedPortalArns) {
            this.associatedPortalArns = ArnListCopier.copy(associatedPortalArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedPortalArns(String... associatedPortalArns) {
            associatedPortalArns(Arrays.asList(associatedPortalArns));
            return this;
        }

        public final String getCopyAllowed() {
            return copyAllowed;
        }

        public final void setCopyAllowed(String copyAllowed) {
            this.copyAllowed = copyAllowed;
        }

        @Override
        public final Builder copyAllowed(String copyAllowed) {
            this.copyAllowed = copyAllowed;
            return this;
        }

        @Override
        public final Builder copyAllowed(EnabledType copyAllowed) {
            this.copyAllowed(copyAllowed == null ? null : copyAllowed.toString());
            return this;
        }

        public final String getDownloadAllowed() {
            return downloadAllowed;
        }

        public final void setDownloadAllowed(String downloadAllowed) {
            this.downloadAllowed = downloadAllowed;
        }

        @Override
        public final Builder downloadAllowed(String downloadAllowed) {
            this.downloadAllowed = downloadAllowed;
            return this;
        }

        @Override
        public final Builder downloadAllowed(EnabledType downloadAllowed) {
            this.downloadAllowed(downloadAllowed == null ? null : downloadAllowed.toString());
            return this;
        }

        public final String getPasteAllowed() {
            return pasteAllowed;
        }

        public final void setPasteAllowed(String pasteAllowed) {
            this.pasteAllowed = pasteAllowed;
        }

        @Override
        public final Builder pasteAllowed(String pasteAllowed) {
            this.pasteAllowed = pasteAllowed;
            return this;
        }

        @Override
        public final Builder pasteAllowed(EnabledType pasteAllowed) {
            this.pasteAllowed(pasteAllowed == null ? null : pasteAllowed.toString());
            return this;
        }

        public final String getPrintAllowed() {
            return printAllowed;
        }

        public final void setPrintAllowed(String printAllowed) {
            this.printAllowed = printAllowed;
        }

        @Override
        public final Builder printAllowed(String printAllowed) {
            this.printAllowed = printAllowed;
            return this;
        }

        @Override
        public final Builder printAllowed(EnabledType printAllowed) {
            this.printAllowed(printAllowed == null ? null : printAllowed.toString());
            return this;
        }

        public final String getUploadAllowed() {
            return uploadAllowed;
        }

        public final void setUploadAllowed(String uploadAllowed) {
            this.uploadAllowed = uploadAllowed;
        }

        @Override
        public final Builder uploadAllowed(String uploadAllowed) {
            this.uploadAllowed = uploadAllowed;
            return this;
        }

        @Override
        public final Builder uploadAllowed(EnabledType uploadAllowed) {
            this.uploadAllowed(uploadAllowed == null ? null : uploadAllowed.toString());
            return this;
        }

        public final String getUserSettingsArn() {
            return userSettingsArn;
        }

        public final void setUserSettingsArn(String userSettingsArn) {
            this.userSettingsArn = userSettingsArn;
        }

        @Override
        public final Builder userSettingsArn(String userSettingsArn) {
            this.userSettingsArn = userSettingsArn;
            return this;
        }

        @Override
        public UserSettings build() {
            return new UserSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
