/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspacesweb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The identity provider.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IdentityProvider implements SdkPojo, Serializable,
        ToCopyableBuilder<IdentityProvider.Builder, IdentityProvider> {
    private static final SdkField<String> IDENTITY_PROVIDER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("identityProviderArn").getter(getter(IdentityProvider::identityProviderArn))
            .setter(setter(Builder::identityProviderArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identityProviderArn").build())
            .build();

    private static final SdkField<Map<String, String>> IDENTITY_PROVIDER_DETAILS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("identityProviderDetails")
            .getter(getter(IdentityProvider::identityProviderDetails))
            .setter(setter(Builder::identityProviderDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identityProviderDetails").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> IDENTITY_PROVIDER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("identityProviderName").getter(getter(IdentityProvider::identityProviderName))
            .setter(setter(Builder::identityProviderName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identityProviderName").build())
            .build();

    private static final SdkField<String> IDENTITY_PROVIDER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("identityProviderType").getter(getter(IdentityProvider::identityProviderTypeAsString))
            .setter(setter(Builder::identityProviderType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identityProviderType").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_PROVIDER_ARN_FIELD,
            IDENTITY_PROVIDER_DETAILS_FIELD, IDENTITY_PROVIDER_NAME_FIELD, IDENTITY_PROVIDER_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String identityProviderArn;

    private final Map<String, String> identityProviderDetails;

    private final String identityProviderName;

    private final String identityProviderType;

    private IdentityProvider(BuilderImpl builder) {
        this.identityProviderArn = builder.identityProviderArn;
        this.identityProviderDetails = builder.identityProviderDetails;
        this.identityProviderName = builder.identityProviderName;
        this.identityProviderType = builder.identityProviderType;
    }

    /**
     * <p>
     * The ARN of the identity provider.
     * </p>
     * 
     * @return The ARN of the identity provider.
     */
    public final String identityProviderArn() {
        return identityProviderArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the IdentityProviderDetails property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasIdentityProviderDetails() {
        return identityProviderDetails != null && !(identityProviderDetails instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The identity provider details. The following list describes the provider detail keys for each identity provider
     * type.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For Google and Login with Amazon:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>client_id</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>client_secret</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>authorize_scopes</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * For Facebook:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>client_id</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>client_secret</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>authorize_scopes</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>api_version</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * For Sign in with Apple:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>client_id</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>team_id</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>key_id</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>private_key</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>authorize_scopes</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * For OIDC providers:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>client_id</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>client_secret</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>attributes_request_method</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>oidc_issuer</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>authorize_scopes</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>authorize_url</code> <i>if not available from discovery URL specified by oidc_issuer key</i>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>token_url</code> <i>if not available from discovery URL specified by oidc_issuer key</i>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>attributes_url</code> <i>if not available from discovery URL specified by oidc_issuer key</i>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>jwks_uri</code> <i>if not available from discovery URL specified by oidc_issuer key</i>
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * For SAML providers:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>MetadataFile</code> OR <code>MetadataURL</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IDPSignout</code> <i>optional</i>
     * </p>
     * </li>
     * </ul>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIdentityProviderDetails} method.
     * </p>
     * 
     * @return The identity provider details. The following list describes the provider detail keys for each identity
     *         provider type. </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For Google and Login with Amazon:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>client_id</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>client_secret</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>authorize_scopes</code>
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         For Facebook:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>client_id</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>client_secret</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>authorize_scopes</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>api_version</code>
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         For Sign in with Apple:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>client_id</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>team_id</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>key_id</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>private_key</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>authorize_scopes</code>
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         For OIDC providers:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>client_id</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>client_secret</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>attributes_request_method</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>oidc_issuer</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>authorize_scopes</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>authorize_url</code> <i>if not available from discovery URL specified by oidc_issuer key</i>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>token_url</code> <i>if not available from discovery URL specified by oidc_issuer key</i>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>attributes_url</code> <i>if not available from discovery URL specified by oidc_issuer key</i>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>jwks_uri</code> <i>if not available from discovery URL specified by oidc_issuer key</i>
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         For SAML providers:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>MetadataFile</code> OR <code>MetadataURL</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IDPSignout</code> <i>optional</i>
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     */
    public final Map<String, String> identityProviderDetails() {
        return identityProviderDetails;
    }

    /**
     * <p>
     * The identity provider name.
     * </p>
     * 
     * @return The identity provider name.
     */
    public final String identityProviderName() {
        return identityProviderName;
    }

    /**
     * <p>
     * The identity provider type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #identityProviderType} will return {@link IdentityProviderType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #identityProviderTypeAsString}.
     * </p>
     * 
     * @return The identity provider type.
     * @see IdentityProviderType
     */
    public final IdentityProviderType identityProviderType() {
        return IdentityProviderType.fromValue(identityProviderType);
    }

    /**
     * <p>
     * The identity provider type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #identityProviderType} will return {@link IdentityProviderType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #identityProviderTypeAsString}.
     * </p>
     * 
     * @return The identity provider type.
     * @see IdentityProviderType
     */
    public final String identityProviderTypeAsString() {
        return identityProviderType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(identityProviderArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasIdentityProviderDetails() ? identityProviderDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(identityProviderName());
        hashCode = 31 * hashCode + Objects.hashCode(identityProviderTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IdentityProvider)) {
            return false;
        }
        IdentityProvider other = (IdentityProvider) obj;
        return Objects.equals(identityProviderArn(), other.identityProviderArn())
                && hasIdentityProviderDetails() == other.hasIdentityProviderDetails()
                && Objects.equals(identityProviderDetails(), other.identityProviderDetails())
                && Objects.equals(identityProviderName(), other.identityProviderName())
                && Objects.equals(identityProviderTypeAsString(), other.identityProviderTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IdentityProvider").add("IdentityProviderArn", identityProviderArn())
                .add("IdentityProviderDetails", hasIdentityProviderDetails() ? identityProviderDetails() : null)
                .add("IdentityProviderName", identityProviderName()).add("IdentityProviderType", identityProviderTypeAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "identityProviderArn":
            return Optional.ofNullable(clazz.cast(identityProviderArn()));
        case "identityProviderDetails":
            return Optional.ofNullable(clazz.cast(identityProviderDetails()));
        case "identityProviderName":
            return Optional.ofNullable(clazz.cast(identityProviderName()));
        case "identityProviderType":
            return Optional.ofNullable(clazz.cast(identityProviderTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IdentityProvider, T> g) {
        return obj -> g.apply((IdentityProvider) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IdentityProvider> {
        /**
         * <p>
         * The ARN of the identity provider.
         * </p>
         * 
         * @param identityProviderArn
         *        The ARN of the identity provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityProviderArn(String identityProviderArn);

        /**
         * <p>
         * The identity provider details. The following list describes the provider detail keys for each identity
         * provider type.
         * </p>
         * <ul>
         * <li>
         * <p>
         * For Google and Login with Amazon:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>client_id</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>client_secret</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>authorize_scopes</code>
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * For Facebook:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>client_id</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>client_secret</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>authorize_scopes</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>api_version</code>
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * For Sign in with Apple:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>client_id</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>team_id</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>key_id</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>private_key</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>authorize_scopes</code>
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * For OIDC providers:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>client_id</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>client_secret</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>attributes_request_method</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>oidc_issuer</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>authorize_scopes</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>authorize_url</code> <i>if not available from discovery URL specified by oidc_issuer key</i>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>token_url</code> <i>if not available from discovery URL specified by oidc_issuer key</i>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>attributes_url</code> <i>if not available from discovery URL specified by oidc_issuer key</i>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>jwks_uri</code> <i>if not available from discovery URL specified by oidc_issuer key</i>
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * For SAML providers:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>MetadataFile</code> OR <code>MetadataURL</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IDPSignout</code> <i>optional</i>
         * </p>
         * </li>
         * </ul>
         * </li>
         * </ul>
         * 
         * @param identityProviderDetails
         *        The identity provider details. The following list describes the provider detail keys for each identity
         *        provider type. </p>
         *        <ul>
         *        <li>
         *        <p>
         *        For Google and Login with Amazon:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>client_id</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>client_secret</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>authorize_scopes</code>
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        For Facebook:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>client_id</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>client_secret</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>authorize_scopes</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>api_version</code>
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        For Sign in with Apple:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>client_id</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>team_id</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>key_id</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>private_key</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>authorize_scopes</code>
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        For OIDC providers:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>client_id</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>client_secret</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>attributes_request_method</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>oidc_issuer</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>authorize_scopes</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>authorize_url</code> <i>if not available from discovery URL specified by oidc_issuer key</i>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>token_url</code> <i>if not available from discovery URL specified by oidc_issuer key</i>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>attributes_url</code> <i>if not available from discovery URL specified by oidc_issuer key</i>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>jwks_uri</code> <i>if not available from discovery URL specified by oidc_issuer key</i>
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        For SAML providers:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>MetadataFile</code> OR <code>MetadataURL</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IDPSignout</code> <i>optional</i>
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityProviderDetails(Map<String, String> identityProviderDetails);

        /**
         * <p>
         * The identity provider name.
         * </p>
         * 
         * @param identityProviderName
         *        The identity provider name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityProviderName(String identityProviderName);

        /**
         * <p>
         * The identity provider type.
         * </p>
         * 
         * @param identityProviderType
         *        The identity provider type.
         * @see IdentityProviderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdentityProviderType
         */
        Builder identityProviderType(String identityProviderType);

        /**
         * <p>
         * The identity provider type.
         * </p>
         * 
         * @param identityProviderType
         *        The identity provider type.
         * @see IdentityProviderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdentityProviderType
         */
        Builder identityProviderType(IdentityProviderType identityProviderType);
    }

    static final class BuilderImpl implements Builder {
        private String identityProviderArn;

        private Map<String, String> identityProviderDetails = DefaultSdkAutoConstructMap.getInstance();

        private String identityProviderName;

        private String identityProviderType;

        private BuilderImpl() {
        }

        private BuilderImpl(IdentityProvider model) {
            identityProviderArn(model.identityProviderArn);
            identityProviderDetails(model.identityProviderDetails);
            identityProviderName(model.identityProviderName);
            identityProviderType(model.identityProviderType);
        }

        public final String getIdentityProviderArn() {
            return identityProviderArn;
        }

        public final void setIdentityProviderArn(String identityProviderArn) {
            this.identityProviderArn = identityProviderArn;
        }

        @Override
        public final Builder identityProviderArn(String identityProviderArn) {
            this.identityProviderArn = identityProviderArn;
            return this;
        }

        public final Map<String, String> getIdentityProviderDetails() {
            if (identityProviderDetails instanceof SdkAutoConstructMap) {
                return null;
            }
            return identityProviderDetails;
        }

        public final void setIdentityProviderDetails(Map<String, String> identityProviderDetails) {
            this.identityProviderDetails = IdentityProviderDetailsCopier.copy(identityProviderDetails);
        }

        @Override
        public final Builder identityProviderDetails(Map<String, String> identityProviderDetails) {
            this.identityProviderDetails = IdentityProviderDetailsCopier.copy(identityProviderDetails);
            return this;
        }

        public final String getIdentityProviderName() {
            return identityProviderName;
        }

        public final void setIdentityProviderName(String identityProviderName) {
            this.identityProviderName = identityProviderName;
        }

        @Override
        public final Builder identityProviderName(String identityProviderName) {
            this.identityProviderName = identityProviderName;
            return this;
        }

        public final String getIdentityProviderType() {
            return identityProviderType;
        }

        public final void setIdentityProviderType(String identityProviderType) {
            this.identityProviderType = identityProviderType;
        }

        @Override
        public final Builder identityProviderType(String identityProviderType) {
            this.identityProviderType = identityProviderType;
            return this;
        }

        @Override
        public final Builder identityProviderType(IdentityProviderType identityProviderType) {
            this.identityProviderType(identityProviderType == null ? null : identityProviderType.toString());
            return this;
        }

        @Override
        public IdentityProvider build() {
            return new IdentityProvider(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
