/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspacesweb.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The web portal.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Portal implements SdkPojo, Serializable, ToCopyableBuilder<Portal.Builder, Portal> {
    private static final SdkField<String> BROWSER_SETTINGS_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("browserSettingsArn").getter(getter(Portal::browserSettingsArn))
            .setter(setter(Builder::browserSettingsArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("browserSettingsArn").build())
            .build();

    private static final SdkField<String> BROWSER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("browserType").getter(getter(Portal::browserTypeAsString)).setter(setter(Builder::browserType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("browserType").build()).build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDate").getter(getter(Portal::creationDate)).setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(Portal::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<String> NETWORK_SETTINGS_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("networkSettingsArn").getter(getter(Portal::networkSettingsArn))
            .setter(setter(Builder::networkSettingsArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkSettingsArn").build())
            .build();

    private static final SdkField<String> PORTAL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("portalArn").getter(getter(Portal::portalArn)).setter(setter(Builder::portalArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portalArn").build()).build();

    private static final SdkField<String> PORTAL_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("portalEndpoint").getter(getter(Portal::portalEndpoint)).setter(setter(Builder::portalEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portalEndpoint").build()).build();

    private static final SdkField<String> PORTAL_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("portalStatus").getter(getter(Portal::portalStatusAsString)).setter(setter(Builder::portalStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portalStatus").build()).build();

    private static final SdkField<String> RENDERER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("rendererType").getter(getter(Portal::rendererTypeAsString)).setter(setter(Builder::rendererType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rendererType").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusReason").getter(getter(Portal::statusReason)).setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()).build();

    private static final SdkField<String> TRUST_STORE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("trustStoreArn").getter(getter(Portal::trustStoreArn)).setter(setter(Builder::trustStoreArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trustStoreArn").build()).build();

    private static final SdkField<String> USER_ACCESS_LOGGING_SETTINGS_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("userAccessLoggingSettingsArn")
            .getter(getter(Portal::userAccessLoggingSettingsArn))
            .setter(setter(Builder::userAccessLoggingSettingsArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userAccessLoggingSettingsArn")
                    .build()).build();

    private static final SdkField<String> USER_SETTINGS_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("userSettingsArn").getter(getter(Portal::userSettingsArn)).setter(setter(Builder::userSettingsArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userSettingsArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BROWSER_SETTINGS_ARN_FIELD,
            BROWSER_TYPE_FIELD, CREATION_DATE_FIELD, DISPLAY_NAME_FIELD, NETWORK_SETTINGS_ARN_FIELD, PORTAL_ARN_FIELD,
            PORTAL_ENDPOINT_FIELD, PORTAL_STATUS_FIELD, RENDERER_TYPE_FIELD, STATUS_REASON_FIELD, TRUST_STORE_ARN_FIELD,
            USER_ACCESS_LOGGING_SETTINGS_ARN_FIELD, USER_SETTINGS_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String browserSettingsArn;

    private final String browserType;

    private final Instant creationDate;

    private final String displayName;

    private final String networkSettingsArn;

    private final String portalArn;

    private final String portalEndpoint;

    private final String portalStatus;

    private final String rendererType;

    private final String statusReason;

    private final String trustStoreArn;

    private final String userAccessLoggingSettingsArn;

    private final String userSettingsArn;

    private Portal(BuilderImpl builder) {
        this.browserSettingsArn = builder.browserSettingsArn;
        this.browserType = builder.browserType;
        this.creationDate = builder.creationDate;
        this.displayName = builder.displayName;
        this.networkSettingsArn = builder.networkSettingsArn;
        this.portalArn = builder.portalArn;
        this.portalEndpoint = builder.portalEndpoint;
        this.portalStatus = builder.portalStatus;
        this.rendererType = builder.rendererType;
        this.statusReason = builder.statusReason;
        this.trustStoreArn = builder.trustStoreArn;
        this.userAccessLoggingSettingsArn = builder.userAccessLoggingSettingsArn;
        this.userSettingsArn = builder.userSettingsArn;
    }

    /**
     * <p>
     * The ARN of the browser settings that is associated with this web portal.
     * </p>
     * 
     * @return The ARN of the browser settings that is associated with this web portal.
     */
    public final String browserSettingsArn() {
        return browserSettingsArn;
    }

    /**
     * <p>
     * The browser that users see when using a streaming session.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #browserType} will
     * return {@link BrowserType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #browserTypeAsString}.
     * </p>
     * 
     * @return The browser that users see when using a streaming session.
     * @see BrowserType
     */
    public final BrowserType browserType() {
        return BrowserType.fromValue(browserType);
    }

    /**
     * <p>
     * The browser that users see when using a streaming session.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #browserType} will
     * return {@link BrowserType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #browserTypeAsString}.
     * </p>
     * 
     * @return The browser that users see when using a streaming session.
     * @see BrowserType
     */
    public final String browserTypeAsString() {
        return browserType;
    }

    /**
     * <p>
     * The creation date of the web portal.
     * </p>
     * 
     * @return The creation date of the web portal.
     */
    public final Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * The name of the web portal.
     * </p>
     * 
     * @return The name of the web portal.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The ARN of the network settings that is associated with the web portal.
     * </p>
     * 
     * @return The ARN of the network settings that is associated with the web portal.
     */
    public final String networkSettingsArn() {
        return networkSettingsArn;
    }

    /**
     * <p>
     * The ARN of the web portal.
     * </p>
     * 
     * @return The ARN of the web portal.
     */
    public final String portalArn() {
        return portalArn;
    }

    /**
     * <p>
     * The endpoint URL of the web portal that users access in order to start streaming sessions.
     * </p>
     * 
     * @return The endpoint URL of the web portal that users access in order to start streaming sessions.
     */
    public final String portalEndpoint() {
        return portalEndpoint;
    }

    /**
     * <p>
     * The status of the web portal.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #portalStatus} will
     * return {@link PortalStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #portalStatusAsString}.
     * </p>
     * 
     * @return The status of the web portal.
     * @see PortalStatus
     */
    public final PortalStatus portalStatus() {
        return PortalStatus.fromValue(portalStatus);
    }

    /**
     * <p>
     * The status of the web portal.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #portalStatus} will
     * return {@link PortalStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #portalStatusAsString}.
     * </p>
     * 
     * @return The status of the web portal.
     * @see PortalStatus
     */
    public final String portalStatusAsString() {
        return portalStatus;
    }

    /**
     * <p>
     * The renderer that is used in streaming sessions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rendererType} will
     * return {@link RendererType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #rendererTypeAsString}.
     * </p>
     * 
     * @return The renderer that is used in streaming sessions.
     * @see RendererType
     */
    public final RendererType rendererType() {
        return RendererType.fromValue(rendererType);
    }

    /**
     * <p>
     * The renderer that is used in streaming sessions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rendererType} will
     * return {@link RendererType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #rendererTypeAsString}.
     * </p>
     * 
     * @return The renderer that is used in streaming sessions.
     * @see RendererType
     */
    public final String rendererTypeAsString() {
        return rendererType;
    }

    /**
     * <p>
     * A message that explains why the web portal is in its current status.
     * </p>
     * 
     * @return A message that explains why the web portal is in its current status.
     */
    public final String statusReason() {
        return statusReason;
    }

    /**
     * <p>
     * The ARN of the trust store that is associated with the web portal.
     * </p>
     * 
     * @return The ARN of the trust store that is associated with the web portal.
     */
    public final String trustStoreArn() {
        return trustStoreArn;
    }

    /**
     * <p>
     * The ARN of the user access logging settings that is associated with the web portal.
     * </p>
     * 
     * @return The ARN of the user access logging settings that is associated with the web portal.
     */
    public final String userAccessLoggingSettingsArn() {
        return userAccessLoggingSettingsArn;
    }

    /**
     * <p>
     * The ARN of the user settings that is associated with the web portal.
     * </p>
     * 
     * @return The ARN of the user settings that is associated with the web portal.
     */
    public final String userSettingsArn() {
        return userSettingsArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(browserSettingsArn());
        hashCode = 31 * hashCode + Objects.hashCode(browserTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(networkSettingsArn());
        hashCode = 31 * hashCode + Objects.hashCode(portalArn());
        hashCode = 31 * hashCode + Objects.hashCode(portalEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(portalStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(rendererTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(trustStoreArn());
        hashCode = 31 * hashCode + Objects.hashCode(userAccessLoggingSettingsArn());
        hashCode = 31 * hashCode + Objects.hashCode(userSettingsArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Portal)) {
            return false;
        }
        Portal other = (Portal) obj;
        return Objects.equals(browserSettingsArn(), other.browserSettingsArn())
                && Objects.equals(browserTypeAsString(), other.browserTypeAsString())
                && Objects.equals(creationDate(), other.creationDate()) && Objects.equals(displayName(), other.displayName())
                && Objects.equals(networkSettingsArn(), other.networkSettingsArn())
                && Objects.equals(portalArn(), other.portalArn()) && Objects.equals(portalEndpoint(), other.portalEndpoint())
                && Objects.equals(portalStatusAsString(), other.portalStatusAsString())
                && Objects.equals(rendererTypeAsString(), other.rendererTypeAsString())
                && Objects.equals(statusReason(), other.statusReason()) && Objects.equals(trustStoreArn(), other.trustStoreArn())
                && Objects.equals(userAccessLoggingSettingsArn(), other.userAccessLoggingSettingsArn())
                && Objects.equals(userSettingsArn(), other.userSettingsArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Portal").add("BrowserSettingsArn", browserSettingsArn())
                .add("BrowserType", browserTypeAsString()).add("CreationDate", creationDate())
                .add("DisplayName", displayName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("NetworkSettingsArn", networkSettingsArn()).add("PortalArn", portalArn())
                .add("PortalEndpoint", portalEndpoint()).add("PortalStatus", portalStatusAsString())
                .add("RendererType", rendererTypeAsString()).add("StatusReason", statusReason())
                .add("TrustStoreArn", trustStoreArn()).add("UserAccessLoggingSettingsArn", userAccessLoggingSettingsArn())
                .add("UserSettingsArn", userSettingsArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "browserSettingsArn":
            return Optional.ofNullable(clazz.cast(browserSettingsArn()));
        case "browserType":
            return Optional.ofNullable(clazz.cast(browserTypeAsString()));
        case "creationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "networkSettingsArn":
            return Optional.ofNullable(clazz.cast(networkSettingsArn()));
        case "portalArn":
            return Optional.ofNullable(clazz.cast(portalArn()));
        case "portalEndpoint":
            return Optional.ofNullable(clazz.cast(portalEndpoint()));
        case "portalStatus":
            return Optional.ofNullable(clazz.cast(portalStatusAsString()));
        case "rendererType":
            return Optional.ofNullable(clazz.cast(rendererTypeAsString()));
        case "statusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        case "trustStoreArn":
            return Optional.ofNullable(clazz.cast(trustStoreArn()));
        case "userAccessLoggingSettingsArn":
            return Optional.ofNullable(clazz.cast(userAccessLoggingSettingsArn()));
        case "userSettingsArn":
            return Optional.ofNullable(clazz.cast(userSettingsArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Portal, T> g) {
        return obj -> g.apply((Portal) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Portal> {
        /**
         * <p>
         * The ARN of the browser settings that is associated with this web portal.
         * </p>
         * 
         * @param browserSettingsArn
         *        The ARN of the browser settings that is associated with this web portal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder browserSettingsArn(String browserSettingsArn);

        /**
         * <p>
         * The browser that users see when using a streaming session.
         * </p>
         * 
         * @param browserType
         *        The browser that users see when using a streaming session.
         * @see BrowserType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BrowserType
         */
        Builder browserType(String browserType);

        /**
         * <p>
         * The browser that users see when using a streaming session.
         * </p>
         * 
         * @param browserType
         *        The browser that users see when using a streaming session.
         * @see BrowserType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BrowserType
         */
        Builder browserType(BrowserType browserType);

        /**
         * <p>
         * The creation date of the web portal.
         * </p>
         * 
         * @param creationDate
         *        The creation date of the web portal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * The name of the web portal.
         * </p>
         * 
         * @param displayName
         *        The name of the web portal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The ARN of the network settings that is associated with the web portal.
         * </p>
         * 
         * @param networkSettingsArn
         *        The ARN of the network settings that is associated with the web portal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkSettingsArn(String networkSettingsArn);

        /**
         * <p>
         * The ARN of the web portal.
         * </p>
         * 
         * @param portalArn
         *        The ARN of the web portal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portalArn(String portalArn);

        /**
         * <p>
         * The endpoint URL of the web portal that users access in order to start streaming sessions.
         * </p>
         * 
         * @param portalEndpoint
         *        The endpoint URL of the web portal that users access in order to start streaming sessions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portalEndpoint(String portalEndpoint);

        /**
         * <p>
         * The status of the web portal.
         * </p>
         * 
         * @param portalStatus
         *        The status of the web portal.
         * @see PortalStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PortalStatus
         */
        Builder portalStatus(String portalStatus);

        /**
         * <p>
         * The status of the web portal.
         * </p>
         * 
         * @param portalStatus
         *        The status of the web portal.
         * @see PortalStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PortalStatus
         */
        Builder portalStatus(PortalStatus portalStatus);

        /**
         * <p>
         * The renderer that is used in streaming sessions.
         * </p>
         * 
         * @param rendererType
         *        The renderer that is used in streaming sessions.
         * @see RendererType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RendererType
         */
        Builder rendererType(String rendererType);

        /**
         * <p>
         * The renderer that is used in streaming sessions.
         * </p>
         * 
         * @param rendererType
         *        The renderer that is used in streaming sessions.
         * @see RendererType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RendererType
         */
        Builder rendererType(RendererType rendererType);

        /**
         * <p>
         * A message that explains why the web portal is in its current status.
         * </p>
         * 
         * @param statusReason
         *        A message that explains why the web portal is in its current status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);

        /**
         * <p>
         * The ARN of the trust store that is associated with the web portal.
         * </p>
         * 
         * @param trustStoreArn
         *        The ARN of the trust store that is associated with the web portal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trustStoreArn(String trustStoreArn);

        /**
         * <p>
         * The ARN of the user access logging settings that is associated with the web portal.
         * </p>
         * 
         * @param userAccessLoggingSettingsArn
         *        The ARN of the user access logging settings that is associated with the web portal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userAccessLoggingSettingsArn(String userAccessLoggingSettingsArn);

        /**
         * <p>
         * The ARN of the user settings that is associated with the web portal.
         * </p>
         * 
         * @param userSettingsArn
         *        The ARN of the user settings that is associated with the web portal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userSettingsArn(String userSettingsArn);
    }

    static final class BuilderImpl implements Builder {
        private String browserSettingsArn;

        private String browserType;

        private Instant creationDate;

        private String displayName;

        private String networkSettingsArn;

        private String portalArn;

        private String portalEndpoint;

        private String portalStatus;

        private String rendererType;

        private String statusReason;

        private String trustStoreArn;

        private String userAccessLoggingSettingsArn;

        private String userSettingsArn;

        private BuilderImpl() {
        }

        private BuilderImpl(Portal model) {
            browserSettingsArn(model.browserSettingsArn);
            browserType(model.browserType);
            creationDate(model.creationDate);
            displayName(model.displayName);
            networkSettingsArn(model.networkSettingsArn);
            portalArn(model.portalArn);
            portalEndpoint(model.portalEndpoint);
            portalStatus(model.portalStatus);
            rendererType(model.rendererType);
            statusReason(model.statusReason);
            trustStoreArn(model.trustStoreArn);
            userAccessLoggingSettingsArn(model.userAccessLoggingSettingsArn);
            userSettingsArn(model.userSettingsArn);
        }

        public final String getBrowserSettingsArn() {
            return browserSettingsArn;
        }

        public final void setBrowserSettingsArn(String browserSettingsArn) {
            this.browserSettingsArn = browserSettingsArn;
        }

        @Override
        public final Builder browserSettingsArn(String browserSettingsArn) {
            this.browserSettingsArn = browserSettingsArn;
            return this;
        }

        public final String getBrowserType() {
            return browserType;
        }

        public final void setBrowserType(String browserType) {
            this.browserType = browserType;
        }

        @Override
        public final Builder browserType(String browserType) {
            this.browserType = browserType;
            return this;
        }

        @Override
        public final Builder browserType(BrowserType browserType) {
            this.browserType(browserType == null ? null : browserType.toString());
            return this;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getNetworkSettingsArn() {
            return networkSettingsArn;
        }

        public final void setNetworkSettingsArn(String networkSettingsArn) {
            this.networkSettingsArn = networkSettingsArn;
        }

        @Override
        public final Builder networkSettingsArn(String networkSettingsArn) {
            this.networkSettingsArn = networkSettingsArn;
            return this;
        }

        public final String getPortalArn() {
            return portalArn;
        }

        public final void setPortalArn(String portalArn) {
            this.portalArn = portalArn;
        }

        @Override
        public final Builder portalArn(String portalArn) {
            this.portalArn = portalArn;
            return this;
        }

        public final String getPortalEndpoint() {
            return portalEndpoint;
        }

        public final void setPortalEndpoint(String portalEndpoint) {
            this.portalEndpoint = portalEndpoint;
        }

        @Override
        public final Builder portalEndpoint(String portalEndpoint) {
            this.portalEndpoint = portalEndpoint;
            return this;
        }

        public final String getPortalStatus() {
            return portalStatus;
        }

        public final void setPortalStatus(String portalStatus) {
            this.portalStatus = portalStatus;
        }

        @Override
        public final Builder portalStatus(String portalStatus) {
            this.portalStatus = portalStatus;
            return this;
        }

        @Override
        public final Builder portalStatus(PortalStatus portalStatus) {
            this.portalStatus(portalStatus == null ? null : portalStatus.toString());
            return this;
        }

        public final String getRendererType() {
            return rendererType;
        }

        public final void setRendererType(String rendererType) {
            this.rendererType = rendererType;
        }

        @Override
        public final Builder rendererType(String rendererType) {
            this.rendererType = rendererType;
            return this;
        }

        @Override
        public final Builder rendererType(RendererType rendererType) {
            this.rendererType(rendererType == null ? null : rendererType.toString());
            return this;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final String getTrustStoreArn() {
            return trustStoreArn;
        }

        public final void setTrustStoreArn(String trustStoreArn) {
            this.trustStoreArn = trustStoreArn;
        }

        @Override
        public final Builder trustStoreArn(String trustStoreArn) {
            this.trustStoreArn = trustStoreArn;
            return this;
        }

        public final String getUserAccessLoggingSettingsArn() {
            return userAccessLoggingSettingsArn;
        }

        public final void setUserAccessLoggingSettingsArn(String userAccessLoggingSettingsArn) {
            this.userAccessLoggingSettingsArn = userAccessLoggingSettingsArn;
        }

        @Override
        public final Builder userAccessLoggingSettingsArn(String userAccessLoggingSettingsArn) {
            this.userAccessLoggingSettingsArn = userAccessLoggingSettingsArn;
            return this;
        }

        public final String getUserSettingsArn() {
            return userSettingsArn;
        }

        public final void setUserSettingsArn(String userSettingsArn) {
            this.userSettingsArn = userSettingsArn;
        }

        @Override
        public final Builder userSettingsArn(String userSettingsArn) {
            this.userSettingsArn = userSettingsArn;
            return this;
        }

        @Override
        public Portal build() {
            return new Portal(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
