/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspacesweb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The summary for browser settings.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BrowserSettingsSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<BrowserSettingsSummary.Builder, BrowserSettingsSummary> {
    private static final SdkField<String> BROWSER_SETTINGS_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("browserSettingsArn").getter(getter(BrowserSettingsSummary::browserSettingsArn))
            .setter(setter(Builder::browserSettingsArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("browserSettingsArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BROWSER_SETTINGS_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String browserSettingsArn;

    private BrowserSettingsSummary(BuilderImpl builder) {
        this.browserSettingsArn = builder.browserSettingsArn;
    }

    /**
     * <p>
     * The ARN of the browser settings.
     * </p>
     * 
     * @return The ARN of the browser settings.
     */
    public final String browserSettingsArn() {
        return browserSettingsArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(browserSettingsArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BrowserSettingsSummary)) {
            return false;
        }
        BrowserSettingsSummary other = (BrowserSettingsSummary) obj;
        return Objects.equals(browserSettingsArn(), other.browserSettingsArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BrowserSettingsSummary").add("BrowserSettingsArn", browserSettingsArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "browserSettingsArn":
            return Optional.ofNullable(clazz.cast(browserSettingsArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BrowserSettingsSummary, T> g) {
        return obj -> g.apply((BrowserSettingsSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BrowserSettingsSummary> {
        /**
         * <p>
         * The ARN of the browser settings.
         * </p>
         * 
         * @param browserSettingsArn
         *        The ARN of the browser settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder browserSettingsArn(String browserSettingsArn);
    }

    static final class BuilderImpl implements Builder {
        private String browserSettingsArn;

        private BuilderImpl() {
        }

        private BuilderImpl(BrowserSettingsSummary model) {
            browserSettingsArn(model.browserSettingsArn);
        }

        public final String getBrowserSettingsArn() {
            return browserSettingsArn;
        }

        public final void setBrowserSettingsArn(String browserSettingsArn) {
            this.browserSettingsArn = browserSettingsArn;
        }

        @Override
        public final Builder browserSettingsArn(String browserSettingsArn) {
            this.browserSettingsArn = browserSettingsArn;
            return this;
        }

        @Override
        public BrowserSettingsSummary build() {
            return new BrowserSettingsSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
