/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspacesweb;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.util.VersionInfo;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.workspacesweb.model.AccessDeniedException;
import software.amazon.awssdk.services.workspacesweb.model.AssociateBrowserSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.AssociateBrowserSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.AssociateNetworkSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.AssociateNetworkSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.AssociateTrustStoreRequest;
import software.amazon.awssdk.services.workspacesweb.model.AssociateTrustStoreResponse;
import software.amazon.awssdk.services.workspacesweb.model.AssociateUserAccessLoggingSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.AssociateUserAccessLoggingSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.AssociateUserSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.AssociateUserSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.ConflictException;
import software.amazon.awssdk.services.workspacesweb.model.CreateBrowserSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.CreateBrowserSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.CreateIdentityProviderRequest;
import software.amazon.awssdk.services.workspacesweb.model.CreateIdentityProviderResponse;
import software.amazon.awssdk.services.workspacesweb.model.CreateNetworkSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.CreateNetworkSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.CreatePortalRequest;
import software.amazon.awssdk.services.workspacesweb.model.CreatePortalResponse;
import software.amazon.awssdk.services.workspacesweb.model.CreateTrustStoreRequest;
import software.amazon.awssdk.services.workspacesweb.model.CreateTrustStoreResponse;
import software.amazon.awssdk.services.workspacesweb.model.CreateUserAccessLoggingSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.CreateUserAccessLoggingSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.CreateUserSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.CreateUserSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.DeleteBrowserSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.DeleteBrowserSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.DeleteIdentityProviderRequest;
import software.amazon.awssdk.services.workspacesweb.model.DeleteIdentityProviderResponse;
import software.amazon.awssdk.services.workspacesweb.model.DeleteNetworkSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.DeleteNetworkSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.DeletePortalRequest;
import software.amazon.awssdk.services.workspacesweb.model.DeletePortalResponse;
import software.amazon.awssdk.services.workspacesweb.model.DeleteTrustStoreRequest;
import software.amazon.awssdk.services.workspacesweb.model.DeleteTrustStoreResponse;
import software.amazon.awssdk.services.workspacesweb.model.DeleteUserAccessLoggingSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.DeleteUserAccessLoggingSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.DeleteUserSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.DeleteUserSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.DisassociateBrowserSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.DisassociateBrowserSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.DisassociateNetworkSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.DisassociateNetworkSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.DisassociateTrustStoreRequest;
import software.amazon.awssdk.services.workspacesweb.model.DisassociateTrustStoreResponse;
import software.amazon.awssdk.services.workspacesweb.model.DisassociateUserAccessLoggingSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.DisassociateUserAccessLoggingSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.DisassociateUserSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.DisassociateUserSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.GetBrowserSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.GetBrowserSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.GetIdentityProviderRequest;
import software.amazon.awssdk.services.workspacesweb.model.GetIdentityProviderResponse;
import software.amazon.awssdk.services.workspacesweb.model.GetNetworkSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.GetNetworkSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.GetPortalRequest;
import software.amazon.awssdk.services.workspacesweb.model.GetPortalResponse;
import software.amazon.awssdk.services.workspacesweb.model.GetPortalServiceProviderMetadataRequest;
import software.amazon.awssdk.services.workspacesweb.model.GetPortalServiceProviderMetadataResponse;
import software.amazon.awssdk.services.workspacesweb.model.GetTrustStoreCertificateRequest;
import software.amazon.awssdk.services.workspacesweb.model.GetTrustStoreCertificateResponse;
import software.amazon.awssdk.services.workspacesweb.model.GetTrustStoreRequest;
import software.amazon.awssdk.services.workspacesweb.model.GetTrustStoreResponse;
import software.amazon.awssdk.services.workspacesweb.model.GetUserAccessLoggingSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.GetUserAccessLoggingSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.GetUserSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.GetUserSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.InternalServerException;
import software.amazon.awssdk.services.workspacesweb.model.ListBrowserSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.ListBrowserSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.ListIdentityProvidersRequest;
import software.amazon.awssdk.services.workspacesweb.model.ListIdentityProvidersResponse;
import software.amazon.awssdk.services.workspacesweb.model.ListNetworkSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.ListNetworkSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.ListPortalsRequest;
import software.amazon.awssdk.services.workspacesweb.model.ListPortalsResponse;
import software.amazon.awssdk.services.workspacesweb.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.workspacesweb.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.workspacesweb.model.ListTrustStoreCertificatesRequest;
import software.amazon.awssdk.services.workspacesweb.model.ListTrustStoreCertificatesResponse;
import software.amazon.awssdk.services.workspacesweb.model.ListTrustStoresRequest;
import software.amazon.awssdk.services.workspacesweb.model.ListTrustStoresResponse;
import software.amazon.awssdk.services.workspacesweb.model.ListUserAccessLoggingSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.ListUserAccessLoggingSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.ListUserSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.ListUserSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.ResourceNotFoundException;
import software.amazon.awssdk.services.workspacesweb.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.workspacesweb.model.TagResourceRequest;
import software.amazon.awssdk.services.workspacesweb.model.TagResourceResponse;
import software.amazon.awssdk.services.workspacesweb.model.ThrottlingException;
import software.amazon.awssdk.services.workspacesweb.model.TooManyTagsException;
import software.amazon.awssdk.services.workspacesweb.model.UntagResourceRequest;
import software.amazon.awssdk.services.workspacesweb.model.UntagResourceResponse;
import software.amazon.awssdk.services.workspacesweb.model.UpdateBrowserSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.UpdateBrowserSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.UpdateIdentityProviderRequest;
import software.amazon.awssdk.services.workspacesweb.model.UpdateIdentityProviderResponse;
import software.amazon.awssdk.services.workspacesweb.model.UpdateNetworkSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.UpdateNetworkSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.UpdatePortalRequest;
import software.amazon.awssdk.services.workspacesweb.model.UpdatePortalResponse;
import software.amazon.awssdk.services.workspacesweb.model.UpdateTrustStoreRequest;
import software.amazon.awssdk.services.workspacesweb.model.UpdateTrustStoreResponse;
import software.amazon.awssdk.services.workspacesweb.model.UpdateUserAccessLoggingSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.UpdateUserAccessLoggingSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.UpdateUserSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.UpdateUserSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.ValidationException;
import software.amazon.awssdk.services.workspacesweb.model.WorkSpacesWebException;
import software.amazon.awssdk.services.workspacesweb.model.WorkSpacesWebRequest;
import software.amazon.awssdk.services.workspacesweb.paginators.ListBrowserSettingsPublisher;
import software.amazon.awssdk.services.workspacesweb.paginators.ListIdentityProvidersPublisher;
import software.amazon.awssdk.services.workspacesweb.paginators.ListNetworkSettingsPublisher;
import software.amazon.awssdk.services.workspacesweb.paginators.ListPortalsPublisher;
import software.amazon.awssdk.services.workspacesweb.paginators.ListTrustStoreCertificatesPublisher;
import software.amazon.awssdk.services.workspacesweb.paginators.ListTrustStoresPublisher;
import software.amazon.awssdk.services.workspacesweb.paginators.ListUserAccessLoggingSettingsPublisher;
import software.amazon.awssdk.services.workspacesweb.paginators.ListUserSettingsPublisher;
import software.amazon.awssdk.services.workspacesweb.transform.AssociateBrowserSettingsRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.AssociateNetworkSettingsRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.AssociateTrustStoreRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.AssociateUserAccessLoggingSettingsRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.AssociateUserSettingsRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.CreateBrowserSettingsRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.CreateIdentityProviderRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.CreateNetworkSettingsRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.CreatePortalRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.CreateTrustStoreRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.CreateUserAccessLoggingSettingsRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.CreateUserSettingsRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.DeleteBrowserSettingsRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.DeleteIdentityProviderRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.DeleteNetworkSettingsRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.DeletePortalRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.DeleteTrustStoreRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.DeleteUserAccessLoggingSettingsRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.DeleteUserSettingsRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.DisassociateBrowserSettingsRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.DisassociateNetworkSettingsRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.DisassociateTrustStoreRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.DisassociateUserAccessLoggingSettingsRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.DisassociateUserSettingsRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.GetBrowserSettingsRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.GetIdentityProviderRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.GetNetworkSettingsRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.GetPortalRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.GetPortalServiceProviderMetadataRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.GetTrustStoreCertificateRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.GetTrustStoreRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.GetUserAccessLoggingSettingsRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.GetUserSettingsRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.ListBrowserSettingsRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.ListIdentityProvidersRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.ListNetworkSettingsRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.ListPortalsRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.ListTrustStoreCertificatesRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.ListTrustStoresRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.ListUserAccessLoggingSettingsRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.ListUserSettingsRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.UpdateBrowserSettingsRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.UpdateIdentityProviderRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.UpdateNetworkSettingsRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.UpdatePortalRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.UpdateTrustStoreRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.UpdateUserAccessLoggingSettingsRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.UpdateUserSettingsRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link WorkSpacesWebAsyncClient}.
 *
 * @see WorkSpacesWebAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultWorkSpacesWebAsyncClient implements WorkSpacesWebAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultWorkSpacesWebAsyncClient.class);

    private final AsyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultWorkSpacesWebAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Associates a browser settings resource with a web portal.
     * </p>
     *
     * @param associateBrowserSettingsRequest
     * @return A Java Future containing the result of the AssociateBrowserSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>ConflictException There is a conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.AssociateBrowserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/AssociateBrowserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateBrowserSettingsResponse> associateBrowserSettings(
            AssociateBrowserSettingsRequest associateBrowserSettingsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateBrowserSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateBrowserSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AssociateBrowserSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AssociateBrowserSettingsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AssociateBrowserSettingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateBrowserSettingsRequest, AssociateBrowserSettingsResponse>()
                            .withOperationName("AssociateBrowserSettings")
                            .withMarshaller(new AssociateBrowserSettingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(associateBrowserSettingsRequest));
            CompletableFuture<AssociateBrowserSettingsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Associates a network settings resource with a web portal.
     * </p>
     *
     * @param associateNetworkSettingsRequest
     * @return A Java Future containing the result of the AssociateNetworkSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>ConflictException There is a conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.AssociateNetworkSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/AssociateNetworkSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateNetworkSettingsResponse> associateNetworkSettings(
            AssociateNetworkSettingsRequest associateNetworkSettingsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateNetworkSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateNetworkSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AssociateNetworkSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AssociateNetworkSettingsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AssociateNetworkSettingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateNetworkSettingsRequest, AssociateNetworkSettingsResponse>()
                            .withOperationName("AssociateNetworkSettings")
                            .withMarshaller(new AssociateNetworkSettingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(associateNetworkSettingsRequest));
            CompletableFuture<AssociateNetworkSettingsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Associates a trust store with a web portal.
     * </p>
     *
     * @param associateTrustStoreRequest
     * @return A Java Future containing the result of the AssociateTrustStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.AssociateTrustStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/AssociateTrustStore"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateTrustStoreResponse> associateTrustStore(
            AssociateTrustStoreRequest associateTrustStoreRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateTrustStoreRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateTrustStore");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AssociateTrustStoreResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AssociateTrustStoreResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AssociateTrustStoreResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateTrustStoreRequest, AssociateTrustStoreResponse>()
                            .withOperationName("AssociateTrustStore")
                            .withMarshaller(new AssociateTrustStoreRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(associateTrustStoreRequest));
            CompletableFuture<AssociateTrustStoreResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Associates a user access logging settings resource with a web portal.
     * </p>
     *
     * @param associateUserAccessLoggingSettingsRequest
     * @return A Java Future containing the result of the AssociateUserAccessLoggingSettings operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>ConflictException There is a conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.AssociateUserAccessLoggingSettings
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/AssociateUserAccessLoggingSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateUserAccessLoggingSettingsResponse> associateUserAccessLoggingSettings(
            AssociateUserAccessLoggingSettingsRequest associateUserAccessLoggingSettingsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                associateUserAccessLoggingSettingsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateUserAccessLoggingSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AssociateUserAccessLoggingSettingsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, AssociateUserAccessLoggingSettingsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AssociateUserAccessLoggingSettingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateUserAccessLoggingSettingsRequest, AssociateUserAccessLoggingSettingsResponse>()
                            .withOperationName("AssociateUserAccessLoggingSettings")
                            .withMarshaller(new AssociateUserAccessLoggingSettingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(associateUserAccessLoggingSettingsRequest));
            CompletableFuture<AssociateUserAccessLoggingSettingsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Associates a user settings resource with a web portal.
     * </p>
     *
     * @param associateUserSettingsRequest
     * @return A Java Future containing the result of the AssociateUserSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>ConflictException There is a conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.AssociateUserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/AssociateUserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateUserSettingsResponse> associateUserSettings(
            AssociateUserSettingsRequest associateUserSettingsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateUserSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateUserSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AssociateUserSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AssociateUserSettingsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AssociateUserSettingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateUserSettingsRequest, AssociateUserSettingsResponse>()
                            .withOperationName("AssociateUserSettings")
                            .withMarshaller(new AssociateUserSettingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(associateUserSettingsRequest));
            CompletableFuture<AssociateUserSettingsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a browser settings resource that can be associated with a web portal. Once associated with a web portal,
     * browser settings control how the browser will behave once a user starts a streaming session for the web portal.
     * </p>
     *
     * @param createBrowserSettingsRequest
     * @return A Java Future containing the result of the CreateBrowserSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>ConflictException There is a conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.CreateBrowserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/CreateBrowserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateBrowserSettingsResponse> createBrowserSettings(
            CreateBrowserSettingsRequest createBrowserSettingsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createBrowserSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateBrowserSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateBrowserSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateBrowserSettingsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateBrowserSettingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateBrowserSettingsRequest, CreateBrowserSettingsResponse>()
                            .withOperationName("CreateBrowserSettings")
                            .withMarshaller(new CreateBrowserSettingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createBrowserSettingsRequest));
            CompletableFuture<CreateBrowserSettingsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an identity provider resource that is then associated with a web portal.
     * </p>
     *
     * @param createIdentityProviderRequest
     * @return A Java Future containing the result of the CreateIdentityProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>ConflictException There is a conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.CreateIdentityProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/CreateIdentityProvider"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateIdentityProviderResponse> createIdentityProvider(
            CreateIdentityProviderRequest createIdentityProviderRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createIdentityProviderRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateIdentityProvider");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateIdentityProviderResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateIdentityProviderResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateIdentityProviderResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateIdentityProviderRequest, CreateIdentityProviderResponse>()
                            .withOperationName("CreateIdentityProvider")
                            .withMarshaller(new CreateIdentityProviderRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createIdentityProviderRequest));
            CompletableFuture<CreateIdentityProviderResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a network settings resource that can be associated with a web portal. Once associated with a web portal,
     * network settings define how streaming instances will connect with your specified VPC.
     * </p>
     *
     * @param createNetworkSettingsRequest
     * @return A Java Future containing the result of the CreateNetworkSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>ConflictException There is a conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.CreateNetworkSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/CreateNetworkSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateNetworkSettingsResponse> createNetworkSettings(
            CreateNetworkSettingsRequest createNetworkSettingsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createNetworkSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateNetworkSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateNetworkSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateNetworkSettingsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateNetworkSettingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateNetworkSettingsRequest, CreateNetworkSettingsResponse>()
                            .withOperationName("CreateNetworkSettings")
                            .withMarshaller(new CreateNetworkSettingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createNetworkSettingsRequest));
            CompletableFuture<CreateNetworkSettingsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a web portal.
     * </p>
     *
     * @param createPortalRequest
     * @return A Java Future containing the result of the CreatePortal operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>ConflictException There is a conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.CreatePortal
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/CreatePortal" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreatePortalResponse> createPortal(CreatePortalRequest createPortalRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createPortalRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreatePortal");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreatePortalResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreatePortalResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreatePortalResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreatePortalRequest, CreatePortalResponse>()
                            .withOperationName("CreatePortal").withMarshaller(new CreatePortalRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createPortalRequest));
            CompletableFuture<CreatePortalResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a trust store that can be associated with a web portal. A trust store contains certificate authority (CA)
     * certificates. Once associated with a web portal, the browser in a streaming session will recognize certificates
     * that have been issued using any of the CAs in the trust store. If your organization has internal websites that
     * use certificates issued by private CAs, you should add the private CA certificate to the trust store.
     * </p>
     *
     * @param createTrustStoreRequest
     * @return A Java Future containing the result of the CreateTrustStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>ConflictException There is a conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.CreateTrustStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/CreateTrustStore"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateTrustStoreResponse> createTrustStore(CreateTrustStoreRequest createTrustStoreRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createTrustStoreRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTrustStore");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateTrustStoreResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateTrustStoreResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateTrustStoreResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateTrustStoreRequest, CreateTrustStoreResponse>()
                            .withOperationName("CreateTrustStore")
                            .withMarshaller(new CreateTrustStoreRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createTrustStoreRequest));
            CompletableFuture<CreateTrustStoreResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a user access logging settings resource that can be associated with a web portal.
     * </p>
     *
     * @param createUserAccessLoggingSettingsRequest
     * @return A Java Future containing the result of the CreateUserAccessLoggingSettings operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>ConflictException There is a conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.CreateUserAccessLoggingSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/CreateUserAccessLoggingSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateUserAccessLoggingSettingsResponse> createUserAccessLoggingSettings(
            CreateUserAccessLoggingSettingsRequest createUserAccessLoggingSettingsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createUserAccessLoggingSettingsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateUserAccessLoggingSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateUserAccessLoggingSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateUserAccessLoggingSettingsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateUserAccessLoggingSettingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateUserAccessLoggingSettingsRequest, CreateUserAccessLoggingSettingsResponse>()
                            .withOperationName("CreateUserAccessLoggingSettings")
                            .withMarshaller(new CreateUserAccessLoggingSettingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createUserAccessLoggingSettingsRequest));
            CompletableFuture<CreateUserAccessLoggingSettingsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a user settings resource that can be associated with a web portal. Once associated with a web portal,
     * user settings control how users can transfer data between a streaming session and the their local devices.
     * </p>
     *
     * @param createUserSettingsRequest
     * @return A Java Future containing the result of the CreateUserSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>ConflictException There is a conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.CreateUserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/CreateUserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateUserSettingsResponse> createUserSettings(CreateUserSettingsRequest createUserSettingsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createUserSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateUserSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateUserSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateUserSettingsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateUserSettingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateUserSettingsRequest, CreateUserSettingsResponse>()
                            .withOperationName("CreateUserSettings")
                            .withMarshaller(new CreateUserSettingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createUserSettingsRequest));
            CompletableFuture<CreateUserSettingsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes browser settings.
     * </p>
     *
     * @param deleteBrowserSettingsRequest
     * @return A Java Future containing the result of the DeleteBrowserSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>ConflictException There is a conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.DeleteBrowserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DeleteBrowserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteBrowserSettingsResponse> deleteBrowserSettings(
            DeleteBrowserSettingsRequest deleteBrowserSettingsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteBrowserSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteBrowserSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteBrowserSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteBrowserSettingsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteBrowserSettingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteBrowserSettingsRequest, DeleteBrowserSettingsResponse>()
                            .withOperationName("DeleteBrowserSettings")
                            .withMarshaller(new DeleteBrowserSettingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteBrowserSettingsRequest));
            CompletableFuture<DeleteBrowserSettingsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the identity provider.
     * </p>
     *
     * @param deleteIdentityProviderRequest
     * @return A Java Future containing the result of the DeleteIdentityProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>ConflictException There is a conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.DeleteIdentityProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DeleteIdentityProvider"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteIdentityProviderResponse> deleteIdentityProvider(
            DeleteIdentityProviderRequest deleteIdentityProviderRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteIdentityProviderRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteIdentityProvider");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteIdentityProviderResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteIdentityProviderResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteIdentityProviderResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteIdentityProviderRequest, DeleteIdentityProviderResponse>()
                            .withOperationName("DeleteIdentityProvider")
                            .withMarshaller(new DeleteIdentityProviderRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteIdentityProviderRequest));
            CompletableFuture<DeleteIdentityProviderResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes network settings.
     * </p>
     *
     * @param deleteNetworkSettingsRequest
     * @return A Java Future containing the result of the DeleteNetworkSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>ConflictException There is a conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.DeleteNetworkSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DeleteNetworkSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteNetworkSettingsResponse> deleteNetworkSettings(
            DeleteNetworkSettingsRequest deleteNetworkSettingsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteNetworkSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteNetworkSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteNetworkSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteNetworkSettingsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteNetworkSettingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteNetworkSettingsRequest, DeleteNetworkSettingsResponse>()
                            .withOperationName("DeleteNetworkSettings")
                            .withMarshaller(new DeleteNetworkSettingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteNetworkSettingsRequest));
            CompletableFuture<DeleteNetworkSettingsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a web portal.
     * </p>
     *
     * @param deletePortalRequest
     * @return A Java Future containing the result of the DeletePortal operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>ConflictException There is a conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.DeletePortal
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DeletePortal" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeletePortalResponse> deletePortal(DeletePortalRequest deletePortalRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deletePortalRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeletePortal");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeletePortalResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeletePortalResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeletePortalResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeletePortalRequest, DeletePortalResponse>()
                            .withOperationName("DeletePortal").withMarshaller(new DeletePortalRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deletePortalRequest));
            CompletableFuture<DeletePortalResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the trust store.
     * </p>
     *
     * @param deleteTrustStoreRequest
     * @return A Java Future containing the result of the DeleteTrustStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>ConflictException There is a conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.DeleteTrustStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DeleteTrustStore"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteTrustStoreResponse> deleteTrustStore(DeleteTrustStoreRequest deleteTrustStoreRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteTrustStoreRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTrustStore");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteTrustStoreResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteTrustStoreResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteTrustStoreResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteTrustStoreRequest, DeleteTrustStoreResponse>()
                            .withOperationName("DeleteTrustStore")
                            .withMarshaller(new DeleteTrustStoreRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteTrustStoreRequest));
            CompletableFuture<DeleteTrustStoreResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes user access logging settings.
     * </p>
     *
     * @param deleteUserAccessLoggingSettingsRequest
     * @return A Java Future containing the result of the DeleteUserAccessLoggingSettings operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>ConflictException There is a conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.DeleteUserAccessLoggingSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DeleteUserAccessLoggingSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteUserAccessLoggingSettingsResponse> deleteUserAccessLoggingSettings(
            DeleteUserAccessLoggingSettingsRequest deleteUserAccessLoggingSettingsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteUserAccessLoggingSettingsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteUserAccessLoggingSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteUserAccessLoggingSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteUserAccessLoggingSettingsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteUserAccessLoggingSettingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteUserAccessLoggingSettingsRequest, DeleteUserAccessLoggingSettingsResponse>()
                            .withOperationName("DeleteUserAccessLoggingSettings")
                            .withMarshaller(new DeleteUserAccessLoggingSettingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteUserAccessLoggingSettingsRequest));
            CompletableFuture<DeleteUserAccessLoggingSettingsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes user settings.
     * </p>
     *
     * @param deleteUserSettingsRequest
     * @return A Java Future containing the result of the DeleteUserSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>ConflictException There is a conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.DeleteUserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DeleteUserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteUserSettingsResponse> deleteUserSettings(DeleteUserSettingsRequest deleteUserSettingsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteUserSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteUserSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteUserSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteUserSettingsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteUserSettingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteUserSettingsRequest, DeleteUserSettingsResponse>()
                            .withOperationName("DeleteUserSettings")
                            .withMarshaller(new DeleteUserSettingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteUserSettingsRequest));
            CompletableFuture<DeleteUserSettingsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disassociates browser settings from a web portal.
     * </p>
     *
     * @param disassociateBrowserSettingsRequest
     * @return A Java Future containing the result of the DisassociateBrowserSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.DisassociateBrowserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DisassociateBrowserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DisassociateBrowserSettingsResponse> disassociateBrowserSettings(
            DisassociateBrowserSettingsRequest disassociateBrowserSettingsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disassociateBrowserSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateBrowserSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisassociateBrowserSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DisassociateBrowserSettingsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DisassociateBrowserSettingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisassociateBrowserSettingsRequest, DisassociateBrowserSettingsResponse>()
                            .withOperationName("DisassociateBrowserSettings")
                            .withMarshaller(new DisassociateBrowserSettingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(disassociateBrowserSettingsRequest));
            CompletableFuture<DisassociateBrowserSettingsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disassociates network settings from a web portal.
     * </p>
     *
     * @param disassociateNetworkSettingsRequest
     * @return A Java Future containing the result of the DisassociateNetworkSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.DisassociateNetworkSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DisassociateNetworkSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DisassociateNetworkSettingsResponse> disassociateNetworkSettings(
            DisassociateNetworkSettingsRequest disassociateNetworkSettingsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disassociateNetworkSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateNetworkSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisassociateNetworkSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DisassociateNetworkSettingsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DisassociateNetworkSettingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisassociateNetworkSettingsRequest, DisassociateNetworkSettingsResponse>()
                            .withOperationName("DisassociateNetworkSettings")
                            .withMarshaller(new DisassociateNetworkSettingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(disassociateNetworkSettingsRequest));
            CompletableFuture<DisassociateNetworkSettingsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disassociates a trust store from a web portal.
     * </p>
     *
     * @param disassociateTrustStoreRequest
     * @return A Java Future containing the result of the DisassociateTrustStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.DisassociateTrustStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DisassociateTrustStore"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DisassociateTrustStoreResponse> disassociateTrustStore(
            DisassociateTrustStoreRequest disassociateTrustStoreRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disassociateTrustStoreRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateTrustStore");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisassociateTrustStoreResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DisassociateTrustStoreResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DisassociateTrustStoreResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisassociateTrustStoreRequest, DisassociateTrustStoreResponse>()
                            .withOperationName("DisassociateTrustStore")
                            .withMarshaller(new DisassociateTrustStoreRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(disassociateTrustStoreRequest));
            CompletableFuture<DisassociateTrustStoreResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disassociates user access logging settings from a web portal.
     * </p>
     *
     * @param disassociateUserAccessLoggingSettingsRequest
     * @return A Java Future containing the result of the DisassociateUserAccessLoggingSettings operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.DisassociateUserAccessLoggingSettings
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DisassociateUserAccessLoggingSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DisassociateUserAccessLoggingSettingsResponse> disassociateUserAccessLoggingSettings(
            DisassociateUserAccessLoggingSettingsRequest disassociateUserAccessLoggingSettingsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                disassociateUserAccessLoggingSettingsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateUserAccessLoggingSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisassociateUserAccessLoggingSettingsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DisassociateUserAccessLoggingSettingsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DisassociateUserAccessLoggingSettingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisassociateUserAccessLoggingSettingsRequest, DisassociateUserAccessLoggingSettingsResponse>()
                            .withOperationName("DisassociateUserAccessLoggingSettings")
                            .withMarshaller(new DisassociateUserAccessLoggingSettingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(disassociateUserAccessLoggingSettingsRequest));
            CompletableFuture<DisassociateUserAccessLoggingSettingsResponse> whenCompleted = executeFuture
                    .whenComplete((r, e) -> {
                        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                    });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Disassociates user settings from a web portal.
     * </p>
     *
     * @param disassociateUserSettingsRequest
     * @return A Java Future containing the result of the DisassociateUserSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.DisassociateUserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DisassociateUserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DisassociateUserSettingsResponse> disassociateUserSettings(
            DisassociateUserSettingsRequest disassociateUserSettingsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disassociateUserSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateUserSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DisassociateUserSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DisassociateUserSettingsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DisassociateUserSettingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DisassociateUserSettingsRequest, DisassociateUserSettingsResponse>()
                            .withOperationName("DisassociateUserSettings")
                            .withMarshaller(new DisassociateUserSettingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(disassociateUserSettingsRequest));
            CompletableFuture<DisassociateUserSettingsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets browser settings.
     * </p>
     *
     * @param getBrowserSettingsRequest
     * @return A Java Future containing the result of the GetBrowserSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.GetBrowserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/GetBrowserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetBrowserSettingsResponse> getBrowserSettings(GetBrowserSettingsRequest getBrowserSettingsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getBrowserSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetBrowserSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetBrowserSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetBrowserSettingsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetBrowserSettingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetBrowserSettingsRequest, GetBrowserSettingsResponse>()
                            .withOperationName("GetBrowserSettings")
                            .withMarshaller(new GetBrowserSettingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getBrowserSettingsRequest));
            CompletableFuture<GetBrowserSettingsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the identity provider.
     * </p>
     *
     * @param getIdentityProviderRequest
     * @return A Java Future containing the result of the GetIdentityProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.GetIdentityProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/GetIdentityProvider"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetIdentityProviderResponse> getIdentityProvider(
            GetIdentityProviderRequest getIdentityProviderRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getIdentityProviderRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetIdentityProvider");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetIdentityProviderResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetIdentityProviderResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetIdentityProviderResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetIdentityProviderRequest, GetIdentityProviderResponse>()
                            .withOperationName("GetIdentityProvider")
                            .withMarshaller(new GetIdentityProviderRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getIdentityProviderRequest));
            CompletableFuture<GetIdentityProviderResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the network settings.
     * </p>
     *
     * @param getNetworkSettingsRequest
     * @return A Java Future containing the result of the GetNetworkSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.GetNetworkSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/GetNetworkSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetNetworkSettingsResponse> getNetworkSettings(GetNetworkSettingsRequest getNetworkSettingsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getNetworkSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetNetworkSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetNetworkSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetNetworkSettingsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetNetworkSettingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetNetworkSettingsRequest, GetNetworkSettingsResponse>()
                            .withOperationName("GetNetworkSettings")
                            .withMarshaller(new GetNetworkSettingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getNetworkSettingsRequest));
            CompletableFuture<GetNetworkSettingsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the web portal.
     * </p>
     *
     * @param getPortalRequest
     * @return A Java Future containing the result of the GetPortal operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.GetPortal
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/GetPortal" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetPortalResponse> getPortal(GetPortalRequest getPortalRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getPortalRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetPortal");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetPortalResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetPortalResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetPortalResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetPortalRequest, GetPortalResponse>().withOperationName("GetPortal")
                            .withMarshaller(new GetPortalRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(getPortalRequest));
            CompletableFuture<GetPortalResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the service provider metadata.
     * </p>
     *
     * @param getPortalServiceProviderMetadataRequest
     * @return A Java Future containing the result of the GetPortalServiceProviderMetadata operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.GetPortalServiceProviderMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/GetPortalServiceProviderMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetPortalServiceProviderMetadataResponse> getPortalServiceProviderMetadata(
            GetPortalServiceProviderMetadataRequest getPortalServiceProviderMetadataRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getPortalServiceProviderMetadataRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetPortalServiceProviderMetadata");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetPortalServiceProviderMetadataResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, GetPortalServiceProviderMetadataResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetPortalServiceProviderMetadataResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetPortalServiceProviderMetadataRequest, GetPortalServiceProviderMetadataResponse>()
                            .withOperationName("GetPortalServiceProviderMetadata")
                            .withMarshaller(new GetPortalServiceProviderMetadataRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getPortalServiceProviderMetadataRequest));
            CompletableFuture<GetPortalServiceProviderMetadataResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the trust store.
     * </p>
     *
     * @param getTrustStoreRequest
     * @return A Java Future containing the result of the GetTrustStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.GetTrustStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/GetTrustStore" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetTrustStoreResponse> getTrustStore(GetTrustStoreRequest getTrustStoreRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getTrustStoreRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetTrustStore");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetTrustStoreResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetTrustStoreResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetTrustStoreResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetTrustStoreRequest, GetTrustStoreResponse>()
                            .withOperationName("GetTrustStore")
                            .withMarshaller(new GetTrustStoreRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getTrustStoreRequest));
            CompletableFuture<GetTrustStoreResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the trust store certificate.
     * </p>
     *
     * @param getTrustStoreCertificateRequest
     * @return A Java Future containing the result of the GetTrustStoreCertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.GetTrustStoreCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/GetTrustStoreCertificate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetTrustStoreCertificateResponse> getTrustStoreCertificate(
            GetTrustStoreCertificateRequest getTrustStoreCertificateRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getTrustStoreCertificateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetTrustStoreCertificate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetTrustStoreCertificateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetTrustStoreCertificateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetTrustStoreCertificateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetTrustStoreCertificateRequest, GetTrustStoreCertificateResponse>()
                            .withOperationName("GetTrustStoreCertificate")
                            .withMarshaller(new GetTrustStoreCertificateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getTrustStoreCertificateRequest));
            CompletableFuture<GetTrustStoreCertificateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets user access logging settings.
     * </p>
     *
     * @param getUserAccessLoggingSettingsRequest
     * @return A Java Future containing the result of the GetUserAccessLoggingSettings operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.GetUserAccessLoggingSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/GetUserAccessLoggingSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetUserAccessLoggingSettingsResponse> getUserAccessLoggingSettings(
            GetUserAccessLoggingSettingsRequest getUserAccessLoggingSettingsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getUserAccessLoggingSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetUserAccessLoggingSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetUserAccessLoggingSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetUserAccessLoggingSettingsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetUserAccessLoggingSettingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetUserAccessLoggingSettingsRequest, GetUserAccessLoggingSettingsResponse>()
                            .withOperationName("GetUserAccessLoggingSettings")
                            .withMarshaller(new GetUserAccessLoggingSettingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getUserAccessLoggingSettingsRequest));
            CompletableFuture<GetUserAccessLoggingSettingsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets user settings.
     * </p>
     *
     * @param getUserSettingsRequest
     * @return A Java Future containing the result of the GetUserSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.GetUserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/GetUserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetUserSettingsResponse> getUserSettings(GetUserSettingsRequest getUserSettingsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getUserSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetUserSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetUserSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetUserSettingsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetUserSettingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetUserSettingsRequest, GetUserSettingsResponse>()
                            .withOperationName("GetUserSettings")
                            .withMarshaller(new GetUserSettingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getUserSettingsRequest));
            CompletableFuture<GetUserSettingsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves a list of browser settings.
     * </p>
     *
     * @param listBrowserSettingsRequest
     * @return A Java Future containing the result of the ListBrowserSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.ListBrowserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListBrowserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListBrowserSettingsResponse> listBrowserSettings(
            ListBrowserSettingsRequest listBrowserSettingsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listBrowserSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListBrowserSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListBrowserSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListBrowserSettingsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListBrowserSettingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListBrowserSettingsRequest, ListBrowserSettingsResponse>()
                            .withOperationName("ListBrowserSettings")
                            .withMarshaller(new ListBrowserSettingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listBrowserSettingsRequest));
            CompletableFuture<ListBrowserSettingsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves a list of browser settings.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listBrowserSettings(software.amazon.awssdk.services.workspacesweb.model.ListBrowserSettingsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListBrowserSettingsPublisher publisher = client.listBrowserSettingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListBrowserSettingsPublisher publisher = client.listBrowserSettingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workspacesweb.model.ListBrowserSettingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workspacesweb.model.ListBrowserSettingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBrowserSettings(software.amazon.awssdk.services.workspacesweb.model.ListBrowserSettingsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listBrowserSettingsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.ListBrowserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListBrowserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    public ListBrowserSettingsPublisher listBrowserSettingsPaginator(ListBrowserSettingsRequest listBrowserSettingsRequest) {
        return new ListBrowserSettingsPublisher(this, applyPaginatorUserAgent(listBrowserSettingsRequest));
    }

    /**
     * <p>
     * Retrieves a list of identity providers for a specific web portal.
     * </p>
     *
     * @param listIdentityProvidersRequest
     * @return A Java Future containing the result of the ListIdentityProviders operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.ListIdentityProviders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListIdentityProviders"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListIdentityProvidersResponse> listIdentityProviders(
            ListIdentityProvidersRequest listIdentityProvidersRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listIdentityProvidersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListIdentityProviders");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListIdentityProvidersResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListIdentityProvidersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListIdentityProvidersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListIdentityProvidersRequest, ListIdentityProvidersResponse>()
                            .withOperationName("ListIdentityProviders")
                            .withMarshaller(new ListIdentityProvidersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listIdentityProvidersRequest));
            CompletableFuture<ListIdentityProvidersResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves a list of identity providers for a specific web portal.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listIdentityProviders(software.amazon.awssdk.services.workspacesweb.model.ListIdentityProvidersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListIdentityProvidersPublisher publisher = client.listIdentityProvidersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListIdentityProvidersPublisher publisher = client.listIdentityProvidersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workspacesweb.model.ListIdentityProvidersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workspacesweb.model.ListIdentityProvidersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIdentityProviders(software.amazon.awssdk.services.workspacesweb.model.ListIdentityProvidersRequest)}
     * operation.</b>
     * </p>
     *
     * @param listIdentityProvidersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.ListIdentityProviders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListIdentityProviders"
     *      target="_top">AWS API Documentation</a>
     */
    public ListIdentityProvidersPublisher listIdentityProvidersPaginator(ListIdentityProvidersRequest listIdentityProvidersRequest) {
        return new ListIdentityProvidersPublisher(this, applyPaginatorUserAgent(listIdentityProvidersRequest));
    }

    /**
     * <p>
     * Retrieves a list of network settings.
     * </p>
     *
     * @param listNetworkSettingsRequest
     * @return A Java Future containing the result of the ListNetworkSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.ListNetworkSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListNetworkSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListNetworkSettingsResponse> listNetworkSettings(
            ListNetworkSettingsRequest listNetworkSettingsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listNetworkSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListNetworkSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListNetworkSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListNetworkSettingsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListNetworkSettingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListNetworkSettingsRequest, ListNetworkSettingsResponse>()
                            .withOperationName("ListNetworkSettings")
                            .withMarshaller(new ListNetworkSettingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listNetworkSettingsRequest));
            CompletableFuture<ListNetworkSettingsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves a list of network settings.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listNetworkSettings(software.amazon.awssdk.services.workspacesweb.model.ListNetworkSettingsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListNetworkSettingsPublisher publisher = client.listNetworkSettingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListNetworkSettingsPublisher publisher = client.listNetworkSettingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workspacesweb.model.ListNetworkSettingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workspacesweb.model.ListNetworkSettingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNetworkSettings(software.amazon.awssdk.services.workspacesweb.model.ListNetworkSettingsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listNetworkSettingsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.ListNetworkSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListNetworkSettings"
     *      target="_top">AWS API Documentation</a>
     */
    public ListNetworkSettingsPublisher listNetworkSettingsPaginator(ListNetworkSettingsRequest listNetworkSettingsRequest) {
        return new ListNetworkSettingsPublisher(this, applyPaginatorUserAgent(listNetworkSettingsRequest));
    }

    /**
     * <p>
     * Retrieves a list or web portals.
     * </p>
     *
     * @param listPortalsRequest
     * @return A Java Future containing the result of the ListPortals operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.ListPortals
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListPortals" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListPortalsResponse> listPortals(ListPortalsRequest listPortalsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listPortalsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListPortals");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListPortalsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListPortalsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListPortalsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListPortalsRequest, ListPortalsResponse>()
                            .withOperationName("ListPortals").withMarshaller(new ListPortalsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listPortalsRequest));
            CompletableFuture<ListPortalsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves a list or web portals.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listPortals(software.amazon.awssdk.services.workspacesweb.model.ListPortalsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListPortalsPublisher publisher = client.listPortalsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListPortalsPublisher publisher = client.listPortalsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workspacesweb.model.ListPortalsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workspacesweb.model.ListPortalsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPortals(software.amazon.awssdk.services.workspacesweb.model.ListPortalsRequest)} operation.</b>
     * </p>
     *
     * @param listPortalsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.ListPortals
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListPortals" target="_top">AWS
     *      API Documentation</a>
     */
    public ListPortalsPublisher listPortalsPaginator(ListPortalsRequest listPortalsRequest) {
        return new ListPortalsPublisher(this, applyPaginatorUserAgent(listPortalsRequest));
    }

    /**
     * <p>
     * Retrieves a list of tags for a resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListTagsForResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListTagsForResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                            .withOperationName("ListTagsForResource")
                            .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listTagsForResourceRequest));
            CompletableFuture<ListTagsForResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves a list of trust store certificates.
     * </p>
     *
     * @param listTrustStoreCertificatesRequest
     * @return A Java Future containing the result of the ListTrustStoreCertificates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.ListTrustStoreCertificates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListTrustStoreCertificates"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTrustStoreCertificatesResponse> listTrustStoreCertificates(
            ListTrustStoreCertificatesRequest listTrustStoreCertificatesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTrustStoreCertificatesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTrustStoreCertificates");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTrustStoreCertificatesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListTrustStoreCertificatesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListTrustStoreCertificatesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTrustStoreCertificatesRequest, ListTrustStoreCertificatesResponse>()
                            .withOperationName("ListTrustStoreCertificates")
                            .withMarshaller(new ListTrustStoreCertificatesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listTrustStoreCertificatesRequest));
            CompletableFuture<ListTrustStoreCertificatesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves a list of trust store certificates.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTrustStoreCertificates(software.amazon.awssdk.services.workspacesweb.model.ListTrustStoreCertificatesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListTrustStoreCertificatesPublisher publisher = client.listTrustStoreCertificatesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListTrustStoreCertificatesPublisher publisher = client.listTrustStoreCertificatesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workspacesweb.model.ListTrustStoreCertificatesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workspacesweb.model.ListTrustStoreCertificatesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTrustStoreCertificates(software.amazon.awssdk.services.workspacesweb.model.ListTrustStoreCertificatesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTrustStoreCertificatesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.ListTrustStoreCertificates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListTrustStoreCertificates"
     *      target="_top">AWS API Documentation</a>
     */
    public ListTrustStoreCertificatesPublisher listTrustStoreCertificatesPaginator(
            ListTrustStoreCertificatesRequest listTrustStoreCertificatesRequest) {
        return new ListTrustStoreCertificatesPublisher(this, applyPaginatorUserAgent(listTrustStoreCertificatesRequest));
    }

    /**
     * <p>
     * Retrieves a list of trust stores.
     * </p>
     *
     * @param listTrustStoresRequest
     * @return A Java Future containing the result of the ListTrustStores operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.ListTrustStores
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListTrustStores"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTrustStoresResponse> listTrustStores(ListTrustStoresRequest listTrustStoresRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTrustStoresRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTrustStores");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTrustStoresResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListTrustStoresResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListTrustStoresResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTrustStoresRequest, ListTrustStoresResponse>()
                            .withOperationName("ListTrustStores")
                            .withMarshaller(new ListTrustStoresRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listTrustStoresRequest));
            CompletableFuture<ListTrustStoresResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves a list of trust stores.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTrustStores(software.amazon.awssdk.services.workspacesweb.model.ListTrustStoresRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListTrustStoresPublisher publisher = client.listTrustStoresPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListTrustStoresPublisher publisher = client.listTrustStoresPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workspacesweb.model.ListTrustStoresResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workspacesweb.model.ListTrustStoresResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTrustStores(software.amazon.awssdk.services.workspacesweb.model.ListTrustStoresRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTrustStoresRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.ListTrustStores
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListTrustStores"
     *      target="_top">AWS API Documentation</a>
     */
    public ListTrustStoresPublisher listTrustStoresPaginator(ListTrustStoresRequest listTrustStoresRequest) {
        return new ListTrustStoresPublisher(this, applyPaginatorUserAgent(listTrustStoresRequest));
    }

    /**
     * <p>
     * Retrieves a list of user access logging settings.
     * </p>
     *
     * @param listUserAccessLoggingSettingsRequest
     * @return A Java Future containing the result of the ListUserAccessLoggingSettings operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.ListUserAccessLoggingSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListUserAccessLoggingSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListUserAccessLoggingSettingsResponse> listUserAccessLoggingSettings(
            ListUserAccessLoggingSettingsRequest listUserAccessLoggingSettingsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listUserAccessLoggingSettingsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListUserAccessLoggingSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListUserAccessLoggingSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListUserAccessLoggingSettingsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListUserAccessLoggingSettingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListUserAccessLoggingSettingsRequest, ListUserAccessLoggingSettingsResponse>()
                            .withOperationName("ListUserAccessLoggingSettings")
                            .withMarshaller(new ListUserAccessLoggingSettingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listUserAccessLoggingSettingsRequest));
            CompletableFuture<ListUserAccessLoggingSettingsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves a list of user access logging settings.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listUserAccessLoggingSettings(software.amazon.awssdk.services.workspacesweb.model.ListUserAccessLoggingSettingsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListUserAccessLoggingSettingsPublisher publisher = client.listUserAccessLoggingSettingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListUserAccessLoggingSettingsPublisher publisher = client.listUserAccessLoggingSettingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workspacesweb.model.ListUserAccessLoggingSettingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workspacesweb.model.ListUserAccessLoggingSettingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUserAccessLoggingSettings(software.amazon.awssdk.services.workspacesweb.model.ListUserAccessLoggingSettingsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listUserAccessLoggingSettingsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.ListUserAccessLoggingSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListUserAccessLoggingSettings"
     *      target="_top">AWS API Documentation</a>
     */
    public ListUserAccessLoggingSettingsPublisher listUserAccessLoggingSettingsPaginator(
            ListUserAccessLoggingSettingsRequest listUserAccessLoggingSettingsRequest) {
        return new ListUserAccessLoggingSettingsPublisher(this, applyPaginatorUserAgent(listUserAccessLoggingSettingsRequest));
    }

    /**
     * <p>
     * Retrieves a list of user settings.
     * </p>
     *
     * @param listUserSettingsRequest
     * @return A Java Future containing the result of the ListUserSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.ListUserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListUserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListUserSettingsResponse> listUserSettings(ListUserSettingsRequest listUserSettingsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listUserSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListUserSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListUserSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListUserSettingsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListUserSettingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListUserSettingsRequest, ListUserSettingsResponse>()
                            .withOperationName("ListUserSettings")
                            .withMarshaller(new ListUserSettingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listUserSettingsRequest));
            CompletableFuture<ListUserSettingsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves a list of user settings.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listUserSettings(software.amazon.awssdk.services.workspacesweb.model.ListUserSettingsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListUserSettingsPublisher publisher = client.listUserSettingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListUserSettingsPublisher publisher = client.listUserSettingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workspacesweb.model.ListUserSettingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workspacesweb.model.ListUserSettingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUserSettings(software.amazon.awssdk.services.workspacesweb.model.ListUserSettingsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listUserSettingsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.ListUserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListUserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    public ListUserSettingsPublisher listUserSettingsPaginator(ListUserSettingsRequest listUserSettingsRequest) {
        return new ListUserSettingsPublisher(this, applyPaginatorUserAgent(listUserSettingsRequest));
    }

    /**
     * <p>
     * Adds or overwrites one or more tags for the specified resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>TooManyTagsException There are too many tags.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    TagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<TagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                            .withOperationName("TagResource").withMarshaller(new TagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(tagResourceRequest));
            CompletableFuture<TagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes one or more tags from the specified resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UntagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UntagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                            .withOperationName("UntagResource")
                            .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(untagResourceRequest));
            CompletableFuture<UntagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates browser settings.
     * </p>
     *
     * @param updateBrowserSettingsRequest
     * @return A Java Future containing the result of the UpdateBrowserSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.UpdateBrowserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/UpdateBrowserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateBrowserSettingsResponse> updateBrowserSettings(
            UpdateBrowserSettingsRequest updateBrowserSettingsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateBrowserSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateBrowserSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateBrowserSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateBrowserSettingsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateBrowserSettingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateBrowserSettingsRequest, UpdateBrowserSettingsResponse>()
                            .withOperationName("UpdateBrowserSettings")
                            .withMarshaller(new UpdateBrowserSettingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateBrowserSettingsRequest));
            CompletableFuture<UpdateBrowserSettingsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the identity provider.
     * </p>
     *
     * @param updateIdentityProviderRequest
     * @return A Java Future containing the result of the UpdateIdentityProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.UpdateIdentityProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/UpdateIdentityProvider"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateIdentityProviderResponse> updateIdentityProvider(
            UpdateIdentityProviderRequest updateIdentityProviderRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateIdentityProviderRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateIdentityProvider");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateIdentityProviderResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateIdentityProviderResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateIdentityProviderResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateIdentityProviderRequest, UpdateIdentityProviderResponse>()
                            .withOperationName("UpdateIdentityProvider")
                            .withMarshaller(new UpdateIdentityProviderRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateIdentityProviderRequest));
            CompletableFuture<UpdateIdentityProviderResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates network settings.
     * </p>
     *
     * @param updateNetworkSettingsRequest
     * @return A Java Future containing the result of the UpdateNetworkSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.UpdateNetworkSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/UpdateNetworkSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateNetworkSettingsResponse> updateNetworkSettings(
            UpdateNetworkSettingsRequest updateNetworkSettingsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateNetworkSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateNetworkSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateNetworkSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateNetworkSettingsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateNetworkSettingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateNetworkSettingsRequest, UpdateNetworkSettingsResponse>()
                            .withOperationName("UpdateNetworkSettings")
                            .withMarshaller(new UpdateNetworkSettingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateNetworkSettingsRequest));
            CompletableFuture<UpdateNetworkSettingsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a web portal.
     * </p>
     *
     * @param updatePortalRequest
     * @return A Java Future containing the result of the UpdatePortal operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.UpdatePortal
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/UpdatePortal" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdatePortalResponse> updatePortal(UpdatePortalRequest updatePortalRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updatePortalRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdatePortal");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdatePortalResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdatePortalResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdatePortalResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdatePortalRequest, UpdatePortalResponse>()
                            .withOperationName("UpdatePortal").withMarshaller(new UpdatePortalRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updatePortalRequest));
            CompletableFuture<UpdatePortalResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the trust store.
     * </p>
     *
     * @param updateTrustStoreRequest
     * @return A Java Future containing the result of the UpdateTrustStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.UpdateTrustStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/UpdateTrustStore"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateTrustStoreResponse> updateTrustStore(UpdateTrustStoreRequest updateTrustStoreRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateTrustStoreRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateTrustStore");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateTrustStoreResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateTrustStoreResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateTrustStoreResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateTrustStoreRequest, UpdateTrustStoreResponse>()
                            .withOperationName("UpdateTrustStore")
                            .withMarshaller(new UpdateTrustStoreRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateTrustStoreRequest));
            CompletableFuture<UpdateTrustStoreResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the user access logging settings.
     * </p>
     *
     * @param updateUserAccessLoggingSettingsRequest
     * @return A Java Future containing the result of the UpdateUserAccessLoggingSettings operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.UpdateUserAccessLoggingSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/UpdateUserAccessLoggingSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateUserAccessLoggingSettingsResponse> updateUserAccessLoggingSettings(
            UpdateUserAccessLoggingSettingsRequest updateUserAccessLoggingSettingsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateUserAccessLoggingSettingsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateUserAccessLoggingSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateUserAccessLoggingSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateUserAccessLoggingSettingsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateUserAccessLoggingSettingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateUserAccessLoggingSettingsRequest, UpdateUserAccessLoggingSettingsResponse>()
                            .withOperationName("UpdateUserAccessLoggingSettings")
                            .withMarshaller(new UpdateUserAccessLoggingSettingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateUserAccessLoggingSettingsRequest));
            CompletableFuture<UpdateUserAccessLoggingSettingsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the user settings.
     * </p>
     *
     * @param updateUserSettingsRequest
     * @return A Java Future containing the result of the UpdateUserSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.UpdateUserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/UpdateUserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateUserSettingsResponse> updateUserSettings(UpdateUserSettingsRequest updateUserSettingsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateUserSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateUserSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateUserSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateUserSettingsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateUserSettingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateUserSettingsRequest, UpdateUserSettingsResponse>()
                            .withOperationName("UpdateUserSettings")
                            .withMarshaller(new UpdateUserSettingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateUserSettingsRequest));
            CompletableFuture<UpdateUserSettingsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(WorkSpacesWebException::builder)
                .protocol(AwsJsonProtocol.REST_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ThrottlingException")
                                .exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(429).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException")
                                .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(402).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalServerException")
                                .exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AccessDeniedException")
                                .exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(403).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConflictException")
                                .exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyTagsException")
                                .exceptionBuilderSupplier(TooManyTagsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundException")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ValidationException")
                                .exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(400).build());
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private <T extends WorkSpacesWebRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder()
                .version(VersionInfo.SDK_VERSION).name("PAGINATED").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration()
                .map(c -> c.toBuilder().applyMutation(userAgentApplier).build())
                .orElse((AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier).build()));
        return (T) request.toBuilder().overrideConfiguration(overrideConfiguration).build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
