/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.workspacesweb.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.workspacesweb.WorkSpacesWebAsyncClient;
import software.amazon.awssdk.services.workspacesweb.model.ListUserAccessLoggingSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.ListUserAccessLoggingSettingsResponse;

public class ListUserAccessLoggingSettingsPublisher
implements SdkPublisher<ListUserAccessLoggingSettingsResponse> {
    private final WorkSpacesWebAsyncClient client;
    private final ListUserAccessLoggingSettingsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListUserAccessLoggingSettingsPublisher(WorkSpacesWebAsyncClient client, ListUserAccessLoggingSettingsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListUserAccessLoggingSettingsPublisher(WorkSpacesWebAsyncClient client, ListUserAccessLoggingSettingsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListUserAccessLoggingSettingsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListUserAccessLoggingSettingsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListUserAccessLoggingSettingsResponseFetcher
    implements AsyncPageFetcher<ListUserAccessLoggingSettingsResponse> {
        private ListUserAccessLoggingSettingsResponseFetcher() {
        }

        public boolean hasNextPage(ListUserAccessLoggingSettingsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListUserAccessLoggingSettingsResponse> nextPage(ListUserAccessLoggingSettingsResponse previousPage) {
            if (previousPage == null) {
                return ListUserAccessLoggingSettingsPublisher.this.client.listUserAccessLoggingSettings(ListUserAccessLoggingSettingsPublisher.this.firstRequest);
            }
            return ListUserAccessLoggingSettingsPublisher.this.client.listUserAccessLoggingSettings((ListUserAccessLoggingSettingsRequest)((Object)ListUserAccessLoggingSettingsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

