/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspacesweb.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The IP access settings resource that can be associated with a web portal.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IpAccessSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<IpAccessSettings.Builder, IpAccessSettings> {
    private static final SdkField<List<String>> ASSOCIATED_PORTAL_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("associatedPortalArns")
            .getter(getter(IpAccessSettings::associatedPortalArns))
            .setter(setter(Builder::associatedPortalArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associatedPortalArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDate").getter(getter(IpAccessSettings::creationDate)).setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(IpAccessSettings::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(IpAccessSettings::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<String> IP_ACCESS_SETTINGS_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ipAccessSettingsArn").getter(getter(IpAccessSettings::ipAccessSettingsArn))
            .setter(setter(Builder::ipAccessSettingsArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipAccessSettingsArn").build())
            .build();

    private static final SdkField<List<IpRule>> IP_RULES_FIELD = SdkField
            .<List<IpRule>> builder(MarshallingType.LIST)
            .memberName("ipRules")
            .getter(getter(IpAccessSettings::ipRules))
            .setter(setter(Builder::ipRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipRules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IpRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(IpRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATED_PORTAL_ARNS_FIELD,
            CREATION_DATE_FIELD, DESCRIPTION_FIELD, DISPLAY_NAME_FIELD, IP_ACCESS_SETTINGS_ARN_FIELD, IP_RULES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> associatedPortalArns;

    private final Instant creationDate;

    private final String description;

    private final String displayName;

    private final String ipAccessSettingsArn;

    private final List<IpRule> ipRules;

    private IpAccessSettings(BuilderImpl builder) {
        this.associatedPortalArns = builder.associatedPortalArns;
        this.creationDate = builder.creationDate;
        this.description = builder.description;
        this.displayName = builder.displayName;
        this.ipAccessSettingsArn = builder.ipAccessSettingsArn;
        this.ipRules = builder.ipRules;
    }

    /**
     * For responses, this returns true if the service returned a value for the AssociatedPortalArns property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAssociatedPortalArns() {
        return associatedPortalArns != null && !(associatedPortalArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of web portal ARNs that this IP access settings resource is associated with.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssociatedPortalArns} method.
     * </p>
     * 
     * @return A list of web portal ARNs that this IP access settings resource is associated with.
     */
    public final List<String> associatedPortalArns() {
        return associatedPortalArns;
    }

    /**
     * <p>
     * The creation date timestamp of the IP access settings.
     * </p>
     * 
     * @return The creation date timestamp of the IP access settings.
     */
    public final Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * The description of the IP access settings.
     * </p>
     * 
     * @return The description of the IP access settings.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The display name of the IP access settings.
     * </p>
     * 
     * @return The display name of the IP access settings.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The ARN of the IP access settings resource.
     * </p>
     * 
     * @return The ARN of the IP access settings resource.
     */
    public final String ipAccessSettingsArn() {
        return ipAccessSettingsArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the IpRules property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasIpRules() {
        return ipRules != null && !(ipRules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IP rules of the IP access settings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIpRules} method.
     * </p>
     * 
     * @return The IP rules of the IP access settings.
     */
    public final List<IpRule> ipRules() {
        return ipRules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAssociatedPortalArns() ? associatedPortalArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(ipAccessSettingsArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasIpRules() ? ipRules() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IpAccessSettings)) {
            return false;
        }
        IpAccessSettings other = (IpAccessSettings) obj;
        return hasAssociatedPortalArns() == other.hasAssociatedPortalArns()
                && Objects.equals(associatedPortalArns(), other.associatedPortalArns())
                && Objects.equals(creationDate(), other.creationDate()) && Objects.equals(description(), other.description())
                && Objects.equals(displayName(), other.displayName())
                && Objects.equals(ipAccessSettingsArn(), other.ipAccessSettingsArn()) && hasIpRules() == other.hasIpRules()
                && Objects.equals(ipRules(), other.ipRules());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IpAccessSettings")
                .add("AssociatedPortalArns", hasAssociatedPortalArns() ? associatedPortalArns() : null)
                .add("CreationDate", creationDate())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("DisplayName", displayName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("IpAccessSettingsArn", ipAccessSettingsArn())
                .add("IpRules", ipRules() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "associatedPortalArns":
            return Optional.ofNullable(clazz.cast(associatedPortalArns()));
        case "creationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "ipAccessSettingsArn":
            return Optional.ofNullable(clazz.cast(ipAccessSettingsArn()));
        case "ipRules":
            return Optional.ofNullable(clazz.cast(ipRules()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IpAccessSettings, T> g) {
        return obj -> g.apply((IpAccessSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IpAccessSettings> {
        /**
         * <p>
         * A list of web portal ARNs that this IP access settings resource is associated with.
         * </p>
         * 
         * @param associatedPortalArns
         *        A list of web portal ARNs that this IP access settings resource is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedPortalArns(Collection<String> associatedPortalArns);

        /**
         * <p>
         * A list of web portal ARNs that this IP access settings resource is associated with.
         * </p>
         * 
         * @param associatedPortalArns
         *        A list of web portal ARNs that this IP access settings resource is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedPortalArns(String... associatedPortalArns);

        /**
         * <p>
         * The creation date timestamp of the IP access settings.
         * </p>
         * 
         * @param creationDate
         *        The creation date timestamp of the IP access settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * The description of the IP access settings.
         * </p>
         * 
         * @param description
         *        The description of the IP access settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The display name of the IP access settings.
         * </p>
         * 
         * @param displayName
         *        The display name of the IP access settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The ARN of the IP access settings resource.
         * </p>
         * 
         * @param ipAccessSettingsArn
         *        The ARN of the IP access settings resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipAccessSettingsArn(String ipAccessSettingsArn);

        /**
         * <p>
         * The IP rules of the IP access settings.
         * </p>
         * 
         * @param ipRules
         *        The IP rules of the IP access settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipRules(Collection<IpRule> ipRules);

        /**
         * <p>
         * The IP rules of the IP access settings.
         * </p>
         * 
         * @param ipRules
         *        The IP rules of the IP access settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipRules(IpRule... ipRules);

        /**
         * <p>
         * The IP rules of the IP access settings.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.workspacesweb.model.IpRule.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.workspacesweb.model.IpRule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.workspacesweb.model.IpRule.Builder#build()} is called immediately and
         * its result is passed to {@link #ipRules(List<IpRule>)}.
         * 
         * @param ipRules
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.workspacesweb.model.IpRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ipRules(java.util.Collection<IpRule>)
         */
        Builder ipRules(Consumer<IpRule.Builder>... ipRules);
    }

    static final class BuilderImpl implements Builder {
        private List<String> associatedPortalArns = DefaultSdkAutoConstructList.getInstance();

        private Instant creationDate;

        private String description;

        private String displayName;

        private String ipAccessSettingsArn;

        private List<IpRule> ipRules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(IpAccessSettings model) {
            associatedPortalArns(model.associatedPortalArns);
            creationDate(model.creationDate);
            description(model.description);
            displayName(model.displayName);
            ipAccessSettingsArn(model.ipAccessSettingsArn);
            ipRules(model.ipRules);
        }

        public final Collection<String> getAssociatedPortalArns() {
            if (associatedPortalArns instanceof SdkAutoConstructList) {
                return null;
            }
            return associatedPortalArns;
        }

        public final void setAssociatedPortalArns(Collection<String> associatedPortalArns) {
            this.associatedPortalArns = ArnListCopier.copy(associatedPortalArns);
        }

        @Override
        public final Builder associatedPortalArns(Collection<String> associatedPortalArns) {
            this.associatedPortalArns = ArnListCopier.copy(associatedPortalArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedPortalArns(String... associatedPortalArns) {
            associatedPortalArns(Arrays.asList(associatedPortalArns));
            return this;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getIpAccessSettingsArn() {
            return ipAccessSettingsArn;
        }

        public final void setIpAccessSettingsArn(String ipAccessSettingsArn) {
            this.ipAccessSettingsArn = ipAccessSettingsArn;
        }

        @Override
        public final Builder ipAccessSettingsArn(String ipAccessSettingsArn) {
            this.ipAccessSettingsArn = ipAccessSettingsArn;
            return this;
        }

        public final List<IpRule.Builder> getIpRules() {
            List<IpRule.Builder> result = IpRuleListCopier.copyToBuilder(this.ipRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpRules(Collection<IpRule.BuilderImpl> ipRules) {
            this.ipRules = IpRuleListCopier.copyFromBuilder(ipRules);
        }

        @Override
        public final Builder ipRules(Collection<IpRule> ipRules) {
            this.ipRules = IpRuleListCopier.copy(ipRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipRules(IpRule... ipRules) {
            ipRules(Arrays.asList(ipRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipRules(Consumer<IpRule.Builder>... ipRules) {
            ipRules(Stream.of(ipRules).map(c -> IpRule.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public IpAccessSettings build() {
            return new IpAccessSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
