/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspacesweb;

import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.workspacesweb.internal.WorkSpacesWebServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.workspacesweb.model.AccessDeniedException;
import software.amazon.awssdk.services.workspacesweb.model.AssociateBrowserSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.AssociateBrowserSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.AssociateIpAccessSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.AssociateIpAccessSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.AssociateNetworkSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.AssociateNetworkSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.AssociateTrustStoreRequest;
import software.amazon.awssdk.services.workspacesweb.model.AssociateTrustStoreResponse;
import software.amazon.awssdk.services.workspacesweb.model.AssociateUserAccessLoggingSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.AssociateUserAccessLoggingSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.AssociateUserSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.AssociateUserSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.ConflictException;
import software.amazon.awssdk.services.workspacesweb.model.CreateBrowserSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.CreateBrowserSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.CreateIdentityProviderRequest;
import software.amazon.awssdk.services.workspacesweb.model.CreateIdentityProviderResponse;
import software.amazon.awssdk.services.workspacesweb.model.CreateIpAccessSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.CreateIpAccessSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.CreateNetworkSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.CreateNetworkSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.CreatePortalRequest;
import software.amazon.awssdk.services.workspacesweb.model.CreatePortalResponse;
import software.amazon.awssdk.services.workspacesweb.model.CreateTrustStoreRequest;
import software.amazon.awssdk.services.workspacesweb.model.CreateTrustStoreResponse;
import software.amazon.awssdk.services.workspacesweb.model.CreateUserAccessLoggingSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.CreateUserAccessLoggingSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.CreateUserSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.CreateUserSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.DeleteBrowserSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.DeleteBrowserSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.DeleteIdentityProviderRequest;
import software.amazon.awssdk.services.workspacesweb.model.DeleteIdentityProviderResponse;
import software.amazon.awssdk.services.workspacesweb.model.DeleteIpAccessSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.DeleteIpAccessSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.DeleteNetworkSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.DeleteNetworkSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.DeletePortalRequest;
import software.amazon.awssdk.services.workspacesweb.model.DeletePortalResponse;
import software.amazon.awssdk.services.workspacesweb.model.DeleteTrustStoreRequest;
import software.amazon.awssdk.services.workspacesweb.model.DeleteTrustStoreResponse;
import software.amazon.awssdk.services.workspacesweb.model.DeleteUserAccessLoggingSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.DeleteUserAccessLoggingSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.DeleteUserSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.DeleteUserSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.DisassociateBrowserSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.DisassociateBrowserSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.DisassociateIpAccessSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.DisassociateIpAccessSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.DisassociateNetworkSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.DisassociateNetworkSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.DisassociateTrustStoreRequest;
import software.amazon.awssdk.services.workspacesweb.model.DisassociateTrustStoreResponse;
import software.amazon.awssdk.services.workspacesweb.model.DisassociateUserAccessLoggingSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.DisassociateUserAccessLoggingSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.DisassociateUserSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.DisassociateUserSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.GetBrowserSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.GetBrowserSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.GetIdentityProviderRequest;
import software.amazon.awssdk.services.workspacesweb.model.GetIdentityProviderResponse;
import software.amazon.awssdk.services.workspacesweb.model.GetIpAccessSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.GetIpAccessSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.GetNetworkSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.GetNetworkSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.GetPortalRequest;
import software.amazon.awssdk.services.workspacesweb.model.GetPortalResponse;
import software.amazon.awssdk.services.workspacesweb.model.GetPortalServiceProviderMetadataRequest;
import software.amazon.awssdk.services.workspacesweb.model.GetPortalServiceProviderMetadataResponse;
import software.amazon.awssdk.services.workspacesweb.model.GetTrustStoreCertificateRequest;
import software.amazon.awssdk.services.workspacesweb.model.GetTrustStoreCertificateResponse;
import software.amazon.awssdk.services.workspacesweb.model.GetTrustStoreRequest;
import software.amazon.awssdk.services.workspacesweb.model.GetTrustStoreResponse;
import software.amazon.awssdk.services.workspacesweb.model.GetUserAccessLoggingSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.GetUserAccessLoggingSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.GetUserSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.GetUserSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.InternalServerException;
import software.amazon.awssdk.services.workspacesweb.model.ListBrowserSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.ListBrowserSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.ListIdentityProvidersRequest;
import software.amazon.awssdk.services.workspacesweb.model.ListIdentityProvidersResponse;
import software.amazon.awssdk.services.workspacesweb.model.ListIpAccessSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.ListIpAccessSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.ListNetworkSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.ListNetworkSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.ListPortalsRequest;
import software.amazon.awssdk.services.workspacesweb.model.ListPortalsResponse;
import software.amazon.awssdk.services.workspacesweb.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.workspacesweb.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.workspacesweb.model.ListTrustStoreCertificatesRequest;
import software.amazon.awssdk.services.workspacesweb.model.ListTrustStoreCertificatesResponse;
import software.amazon.awssdk.services.workspacesweb.model.ListTrustStoresRequest;
import software.amazon.awssdk.services.workspacesweb.model.ListTrustStoresResponse;
import software.amazon.awssdk.services.workspacesweb.model.ListUserAccessLoggingSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.ListUserAccessLoggingSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.ListUserSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.ListUserSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.ResourceNotFoundException;
import software.amazon.awssdk.services.workspacesweb.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.workspacesweb.model.TagResourceRequest;
import software.amazon.awssdk.services.workspacesweb.model.TagResourceResponse;
import software.amazon.awssdk.services.workspacesweb.model.ThrottlingException;
import software.amazon.awssdk.services.workspacesweb.model.TooManyTagsException;
import software.amazon.awssdk.services.workspacesweb.model.UntagResourceRequest;
import software.amazon.awssdk.services.workspacesweb.model.UntagResourceResponse;
import software.amazon.awssdk.services.workspacesweb.model.UpdateBrowserSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.UpdateBrowserSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.UpdateIdentityProviderRequest;
import software.amazon.awssdk.services.workspacesweb.model.UpdateIdentityProviderResponse;
import software.amazon.awssdk.services.workspacesweb.model.UpdateIpAccessSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.UpdateIpAccessSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.UpdateNetworkSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.UpdateNetworkSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.UpdatePortalRequest;
import software.amazon.awssdk.services.workspacesweb.model.UpdatePortalResponse;
import software.amazon.awssdk.services.workspacesweb.model.UpdateTrustStoreRequest;
import software.amazon.awssdk.services.workspacesweb.model.UpdateTrustStoreResponse;
import software.amazon.awssdk.services.workspacesweb.model.UpdateUserAccessLoggingSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.UpdateUserAccessLoggingSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.UpdateUserSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.UpdateUserSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.ValidationException;
import software.amazon.awssdk.services.workspacesweb.model.WorkSpacesWebException;
import software.amazon.awssdk.services.workspacesweb.transform.AssociateBrowserSettingsRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.AssociateIpAccessSettingsRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.AssociateNetworkSettingsRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.AssociateTrustStoreRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.AssociateUserAccessLoggingSettingsRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.AssociateUserSettingsRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.CreateBrowserSettingsRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.CreateIdentityProviderRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.CreateIpAccessSettingsRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.CreateNetworkSettingsRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.CreatePortalRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.CreateTrustStoreRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.CreateUserAccessLoggingSettingsRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.CreateUserSettingsRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.DeleteBrowserSettingsRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.DeleteIdentityProviderRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.DeleteIpAccessSettingsRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.DeleteNetworkSettingsRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.DeletePortalRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.DeleteTrustStoreRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.DeleteUserAccessLoggingSettingsRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.DeleteUserSettingsRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.DisassociateBrowserSettingsRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.DisassociateIpAccessSettingsRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.DisassociateNetworkSettingsRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.DisassociateTrustStoreRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.DisassociateUserAccessLoggingSettingsRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.DisassociateUserSettingsRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.GetBrowserSettingsRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.GetIdentityProviderRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.GetIpAccessSettingsRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.GetNetworkSettingsRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.GetPortalRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.GetPortalServiceProviderMetadataRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.GetTrustStoreCertificateRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.GetTrustStoreRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.GetUserAccessLoggingSettingsRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.GetUserSettingsRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.ListBrowserSettingsRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.ListIdentityProvidersRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.ListIpAccessSettingsRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.ListNetworkSettingsRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.ListPortalsRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.ListTrustStoreCertificatesRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.ListTrustStoresRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.ListUserAccessLoggingSettingsRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.ListUserSettingsRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.UpdateBrowserSettingsRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.UpdateIdentityProviderRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.UpdateIpAccessSettingsRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.UpdateNetworkSettingsRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.UpdatePortalRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.UpdateTrustStoreRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.UpdateUserAccessLoggingSettingsRequestMarshaller;
import software.amazon.awssdk.services.workspacesweb.transform.UpdateUserSettingsRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

/**
 * Internal implementation of {@link WorkSpacesWebClient}.
 *
 * @see WorkSpacesWebClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultWorkSpacesWebClient implements WorkSpacesWebClient {
    private static final Logger log = Logger.loggerFor(DefaultWorkSpacesWebClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.REST_JSON).build();

    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultWorkSpacesWebClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Associates a browser settings resource with a web portal.
     * </p>
     *
     * @param associateBrowserSettingsRequest
     * @return Result of the AssociateBrowserSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.AssociateBrowserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/AssociateBrowserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AssociateBrowserSettingsResponse associateBrowserSettings(
            AssociateBrowserSettingsRequest associateBrowserSettingsRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, ConflictException,
            AwsServiceException, SdkClientException, WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociateBrowserSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AssociateBrowserSettingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateBrowserSettingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateBrowserSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateBrowserSettings");

            return clientHandler
                    .execute(new ClientExecutionParams<AssociateBrowserSettingsRequest, AssociateBrowserSettingsResponse>()
                            .withOperationName("AssociateBrowserSettings").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(associateBrowserSettingsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AssociateBrowserSettingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Associates an IP access settings resource with a web portal.
     * </p>
     *
     * @param associateIpAccessSettingsRequest
     * @return Result of the AssociateIpAccessSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.AssociateIpAccessSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/AssociateIpAccessSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AssociateIpAccessSettingsResponse associateIpAccessSettings(
            AssociateIpAccessSettingsRequest associateIpAccessSettingsRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, ConflictException,
            AwsServiceException, SdkClientException, WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociateIpAccessSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AssociateIpAccessSettingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateIpAccessSettingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateIpAccessSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateIpAccessSettings");

            return clientHandler
                    .execute(new ClientExecutionParams<AssociateIpAccessSettingsRequest, AssociateIpAccessSettingsResponse>()
                            .withOperationName("AssociateIpAccessSettings").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(associateIpAccessSettingsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AssociateIpAccessSettingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Associates a network settings resource with a web portal.
     * </p>
     *
     * @param associateNetworkSettingsRequest
     * @return Result of the AssociateNetworkSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.AssociateNetworkSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/AssociateNetworkSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AssociateNetworkSettingsResponse associateNetworkSettings(
            AssociateNetworkSettingsRequest associateNetworkSettingsRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, ConflictException,
            AwsServiceException, SdkClientException, WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociateNetworkSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AssociateNetworkSettingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateNetworkSettingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateNetworkSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateNetworkSettings");

            return clientHandler
                    .execute(new ClientExecutionParams<AssociateNetworkSettingsRequest, AssociateNetworkSettingsResponse>()
                            .withOperationName("AssociateNetworkSettings").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(associateNetworkSettingsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AssociateNetworkSettingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Associates a trust store with a web portal.
     * </p>
     *
     * @param associateTrustStoreRequest
     * @return Result of the AssociateTrustStore operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.AssociateTrustStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/AssociateTrustStore"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AssociateTrustStoreResponse associateTrustStore(AssociateTrustStoreRequest associateTrustStoreRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociateTrustStoreResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AssociateTrustStoreResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateTrustStoreRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateTrustStoreRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateTrustStore");

            return clientHandler.execute(new ClientExecutionParams<AssociateTrustStoreRequest, AssociateTrustStoreResponse>()
                    .withOperationName("AssociateTrustStore").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(associateTrustStoreRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AssociateTrustStoreRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Associates a user access logging settings resource with a web portal.
     * </p>
     *
     * @param associateUserAccessLoggingSettingsRequest
     * @return Result of the AssociateUserAccessLoggingSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.AssociateUserAccessLoggingSettings
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/AssociateUserAccessLoggingSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AssociateUserAccessLoggingSettingsResponse associateUserAccessLoggingSettings(
            AssociateUserAccessLoggingSettingsRequest associateUserAccessLoggingSettingsRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, ConflictException,
            AwsServiceException, SdkClientException, WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociateUserAccessLoggingSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AssociateUserAccessLoggingSettingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateUserAccessLoggingSettingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                associateUserAccessLoggingSettingsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateUserAccessLoggingSettings");

            return clientHandler
                    .execute(new ClientExecutionParams<AssociateUserAccessLoggingSettingsRequest, AssociateUserAccessLoggingSettingsResponse>()
                            .withOperationName("AssociateUserAccessLoggingSettings").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(associateUserAccessLoggingSettingsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AssociateUserAccessLoggingSettingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Associates a user settings resource with a web portal.
     * </p>
     *
     * @param associateUserSettingsRequest
     * @return Result of the AssociateUserSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.AssociateUserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/AssociateUserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AssociateUserSettingsResponse associateUserSettings(AssociateUserSettingsRequest associateUserSettingsRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, ConflictException, AwsServiceException, SdkClientException, WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociateUserSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AssociateUserSettingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateUserSettingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateUserSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateUserSettings");

            return clientHandler.execute(new ClientExecutionParams<AssociateUserSettingsRequest, AssociateUserSettingsResponse>()
                    .withOperationName("AssociateUserSettings").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(associateUserSettingsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AssociateUserSettingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a browser settings resource that can be associated with a web portal. Once associated with a web portal,
     * browser settings control how the browser will behave once a user starts a streaming session for the web portal.
     * </p>
     *
     * @param createBrowserSettingsRequest
     * @return Result of the CreateBrowserSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.CreateBrowserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/CreateBrowserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateBrowserSettingsResponse createBrowserSettings(CreateBrowserSettingsRequest createBrowserSettingsRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ServiceQuotaExceededException, ValidationException, ConflictException, AwsServiceException, SdkClientException,
            WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateBrowserSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateBrowserSettingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createBrowserSettingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createBrowserSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateBrowserSettings");

            return clientHandler.execute(new ClientExecutionParams<CreateBrowserSettingsRequest, CreateBrowserSettingsResponse>()
                    .withOperationName("CreateBrowserSettings").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createBrowserSettingsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateBrowserSettingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an identity provider resource that is then associated with a web portal.
     * </p>
     *
     * @param createIdentityProviderRequest
     * @return Result of the CreateIdentityProvider operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.CreateIdentityProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/CreateIdentityProvider"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateIdentityProviderResponse createIdentityProvider(CreateIdentityProviderRequest createIdentityProviderRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ServiceQuotaExceededException, ValidationException, ConflictException, AwsServiceException, SdkClientException,
            WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateIdentityProviderResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateIdentityProviderResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createIdentityProviderRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createIdentityProviderRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateIdentityProvider");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateIdentityProviderRequest, CreateIdentityProviderResponse>()
                            .withOperationName("CreateIdentityProvider").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createIdentityProviderRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateIdentityProviderRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an IP access settings resource that can be associated with a web portal.
     * </p>
     *
     * @param createIpAccessSettingsRequest
     * @return Result of the CreateIpAccessSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.CreateIpAccessSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/CreateIpAccessSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateIpAccessSettingsResponse createIpAccessSettings(CreateIpAccessSettingsRequest createIpAccessSettingsRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ServiceQuotaExceededException,
            ValidationException, ConflictException, AwsServiceException, SdkClientException, WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateIpAccessSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateIpAccessSettingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createIpAccessSettingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createIpAccessSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateIpAccessSettings");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateIpAccessSettingsRequest, CreateIpAccessSettingsResponse>()
                            .withOperationName("CreateIpAccessSettings").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createIpAccessSettingsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateIpAccessSettingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a network settings resource that can be associated with a web portal. Once associated with a web portal,
     * network settings define how streaming instances will connect with your specified VPC.
     * </p>
     *
     * @param createNetworkSettingsRequest
     * @return Result of the CreateNetworkSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.CreateNetworkSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/CreateNetworkSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateNetworkSettingsResponse createNetworkSettings(CreateNetworkSettingsRequest createNetworkSettingsRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ServiceQuotaExceededException,
            ValidationException, ConflictException, AwsServiceException, SdkClientException, WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateNetworkSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateNetworkSettingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createNetworkSettingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createNetworkSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateNetworkSettings");

            return clientHandler.execute(new ClientExecutionParams<CreateNetworkSettingsRequest, CreateNetworkSettingsResponse>()
                    .withOperationName("CreateNetworkSettings").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createNetworkSettingsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateNetworkSettingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a web portal.
     * </p>
     *
     * @param createPortalRequest
     * @return Result of the CreatePortal operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.CreatePortal
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/CreatePortal" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreatePortalResponse createPortal(CreatePortalRequest createPortalRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ServiceQuotaExceededException,
            ValidationException, ConflictException, AwsServiceException, SdkClientException, WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreatePortalResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreatePortalResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createPortalRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createPortalRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreatePortal");

            return clientHandler.execute(new ClientExecutionParams<CreatePortalRequest, CreatePortalResponse>()
                    .withOperationName("CreatePortal").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createPortalRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreatePortalRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a trust store that can be associated with a web portal. A trust store contains certificate authority (CA)
     * certificates. Once associated with a web portal, the browser in a streaming session will recognize certificates
     * that have been issued using any of the CAs in the trust store. If your organization has internal websites that
     * use certificates issued by private CAs, you should add the private CA certificate to the trust store.
     * </p>
     *
     * @param createTrustStoreRequest
     * @return Result of the CreateTrustStore operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.CreateTrustStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/CreateTrustStore"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateTrustStoreResponse createTrustStore(CreateTrustStoreRequest createTrustStoreRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ServiceQuotaExceededException,
            ValidationException, ConflictException, AwsServiceException, SdkClientException, WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateTrustStoreResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateTrustStoreResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createTrustStoreRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createTrustStoreRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTrustStore");

            return clientHandler.execute(new ClientExecutionParams<CreateTrustStoreRequest, CreateTrustStoreResponse>()
                    .withOperationName("CreateTrustStore").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createTrustStoreRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateTrustStoreRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a user access logging settings resource that can be associated with a web portal.
     * </p>
     *
     * @param createUserAccessLoggingSettingsRequest
     * @return Result of the CreateUserAccessLoggingSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.CreateUserAccessLoggingSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/CreateUserAccessLoggingSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateUserAccessLoggingSettingsResponse createUserAccessLoggingSettings(
            CreateUserAccessLoggingSettingsRequest createUserAccessLoggingSettingsRequest) throws InternalServerException,
            AccessDeniedException, ThrottlingException, ServiceQuotaExceededException, ValidationException, ConflictException,
            AwsServiceException, SdkClientException, WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateUserAccessLoggingSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateUserAccessLoggingSettingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createUserAccessLoggingSettingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createUserAccessLoggingSettingsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateUserAccessLoggingSettings");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateUserAccessLoggingSettingsRequest, CreateUserAccessLoggingSettingsResponse>()
                            .withOperationName("CreateUserAccessLoggingSettings").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createUserAccessLoggingSettingsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateUserAccessLoggingSettingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a user settings resource that can be associated with a web portal. Once associated with a web portal,
     * user settings control how users can transfer data between a streaming session and the their local devices.
     * </p>
     *
     * @param createUserSettingsRequest
     * @return Result of the CreateUserSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.CreateUserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/CreateUserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateUserSettingsResponse createUserSettings(CreateUserSettingsRequest createUserSettingsRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ServiceQuotaExceededException,
            ValidationException, ConflictException, AwsServiceException, SdkClientException, WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateUserSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateUserSettingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createUserSettingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createUserSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateUserSettings");

            return clientHandler.execute(new ClientExecutionParams<CreateUserSettingsRequest, CreateUserSettingsResponse>()
                    .withOperationName("CreateUserSettings").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createUserSettingsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateUserSettingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes browser settings.
     * </p>
     *
     * @param deleteBrowserSettingsRequest
     * @return Result of the DeleteBrowserSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.DeleteBrowserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DeleteBrowserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteBrowserSettingsResponse deleteBrowserSettings(DeleteBrowserSettingsRequest deleteBrowserSettingsRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, ConflictException,
            AwsServiceException, SdkClientException, WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteBrowserSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteBrowserSettingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteBrowserSettingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteBrowserSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteBrowserSettings");

            return clientHandler.execute(new ClientExecutionParams<DeleteBrowserSettingsRequest, DeleteBrowserSettingsResponse>()
                    .withOperationName("DeleteBrowserSettings").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteBrowserSettingsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteBrowserSettingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the identity provider.
     * </p>
     *
     * @param deleteIdentityProviderRequest
     * @return Result of the DeleteIdentityProvider operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.DeleteIdentityProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DeleteIdentityProvider"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteIdentityProviderResponse deleteIdentityProvider(DeleteIdentityProviderRequest deleteIdentityProviderRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, ConflictException,
            AwsServiceException, SdkClientException, WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteIdentityProviderResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteIdentityProviderResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteIdentityProviderRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteIdentityProviderRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteIdentityProvider");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteIdentityProviderRequest, DeleteIdentityProviderResponse>()
                            .withOperationName("DeleteIdentityProvider").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteIdentityProviderRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteIdentityProviderRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes IP access settings.
     * </p>
     *
     * @param deleteIpAccessSettingsRequest
     * @return Result of the DeleteIpAccessSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.DeleteIpAccessSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DeleteIpAccessSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteIpAccessSettingsResponse deleteIpAccessSettings(DeleteIpAccessSettingsRequest deleteIpAccessSettingsRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, ConflictException,
            AwsServiceException, SdkClientException, WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteIpAccessSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteIpAccessSettingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteIpAccessSettingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteIpAccessSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteIpAccessSettings");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteIpAccessSettingsRequest, DeleteIpAccessSettingsResponse>()
                            .withOperationName("DeleteIpAccessSettings").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteIpAccessSettingsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteIpAccessSettingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes network settings.
     * </p>
     *
     * @param deleteNetworkSettingsRequest
     * @return Result of the DeleteNetworkSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.DeleteNetworkSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DeleteNetworkSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteNetworkSettingsResponse deleteNetworkSettings(DeleteNetworkSettingsRequest deleteNetworkSettingsRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, ConflictException,
            AwsServiceException, SdkClientException, WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteNetworkSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteNetworkSettingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteNetworkSettingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteNetworkSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteNetworkSettings");

            return clientHandler.execute(new ClientExecutionParams<DeleteNetworkSettingsRequest, DeleteNetworkSettingsResponse>()
                    .withOperationName("DeleteNetworkSettings").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteNetworkSettingsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteNetworkSettingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a web portal.
     * </p>
     *
     * @param deletePortalRequest
     * @return Result of the DeletePortal operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.DeletePortal
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DeletePortal" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeletePortalResponse deletePortal(DeletePortalRequest deletePortalRequest) throws InternalServerException,
            AccessDeniedException, ThrottlingException, ValidationException, ConflictException, AwsServiceException,
            SdkClientException, WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeletePortalResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeletePortalResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deletePortalRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deletePortalRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeletePortal");

            return clientHandler.execute(new ClientExecutionParams<DeletePortalRequest, DeletePortalResponse>()
                    .withOperationName("DeletePortal").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deletePortalRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeletePortalRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the trust store.
     * </p>
     *
     * @param deleteTrustStoreRequest
     * @return Result of the DeleteTrustStore operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.DeleteTrustStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DeleteTrustStore"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteTrustStoreResponse deleteTrustStore(DeleteTrustStoreRequest deleteTrustStoreRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, ConflictException,
            AwsServiceException, SdkClientException, WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteTrustStoreResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteTrustStoreResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteTrustStoreRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteTrustStoreRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTrustStore");

            return clientHandler.execute(new ClientExecutionParams<DeleteTrustStoreRequest, DeleteTrustStoreResponse>()
                    .withOperationName("DeleteTrustStore").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteTrustStoreRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteTrustStoreRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes user access logging settings.
     * </p>
     *
     * @param deleteUserAccessLoggingSettingsRequest
     * @return Result of the DeleteUserAccessLoggingSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.DeleteUserAccessLoggingSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DeleteUserAccessLoggingSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteUserAccessLoggingSettingsResponse deleteUserAccessLoggingSettings(
            DeleteUserAccessLoggingSettingsRequest deleteUserAccessLoggingSettingsRequest) throws InternalServerException,
            AccessDeniedException, ThrottlingException, ValidationException, ConflictException, AwsServiceException,
            SdkClientException, WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteUserAccessLoggingSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteUserAccessLoggingSettingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteUserAccessLoggingSettingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteUserAccessLoggingSettingsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteUserAccessLoggingSettings");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteUserAccessLoggingSettingsRequest, DeleteUserAccessLoggingSettingsResponse>()
                            .withOperationName("DeleteUserAccessLoggingSettings").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteUserAccessLoggingSettingsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteUserAccessLoggingSettingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes user settings.
     * </p>
     *
     * @param deleteUserSettingsRequest
     * @return Result of the DeleteUserSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.DeleteUserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DeleteUserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteUserSettingsResponse deleteUserSettings(DeleteUserSettingsRequest deleteUserSettingsRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, ConflictException,
            AwsServiceException, SdkClientException, WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteUserSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteUserSettingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteUserSettingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteUserSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteUserSettings");

            return clientHandler.execute(new ClientExecutionParams<DeleteUserSettingsRequest, DeleteUserSettingsResponse>()
                    .withOperationName("DeleteUserSettings").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteUserSettingsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteUserSettingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Disassociates browser settings from a web portal.
     * </p>
     *
     * @param disassociateBrowserSettingsRequest
     * @return Result of the DisassociateBrowserSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.DisassociateBrowserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DisassociateBrowserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DisassociateBrowserSettingsResponse disassociateBrowserSettings(
            DisassociateBrowserSettingsRequest disassociateBrowserSettingsRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DisassociateBrowserSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DisassociateBrowserSettingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disassociateBrowserSettingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disassociateBrowserSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateBrowserSettings");

            return clientHandler
                    .execute(new ClientExecutionParams<DisassociateBrowserSettingsRequest, DisassociateBrowserSettingsResponse>()
                            .withOperationName("DisassociateBrowserSettings").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(disassociateBrowserSettingsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DisassociateBrowserSettingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Disassociates IP access settings from a web portal.
     * </p>
     *
     * @param disassociateIpAccessSettingsRequest
     * @return Result of the DisassociateIpAccessSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.DisassociateIpAccessSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DisassociateIpAccessSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DisassociateIpAccessSettingsResponse disassociateIpAccessSettings(
            DisassociateIpAccessSettingsRequest disassociateIpAccessSettingsRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DisassociateIpAccessSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DisassociateIpAccessSettingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disassociateIpAccessSettingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disassociateIpAccessSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateIpAccessSettings");

            return clientHandler
                    .execute(new ClientExecutionParams<DisassociateIpAccessSettingsRequest, DisassociateIpAccessSettingsResponse>()
                            .withOperationName("DisassociateIpAccessSettings").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(disassociateIpAccessSettingsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DisassociateIpAccessSettingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Disassociates network settings from a web portal.
     * </p>
     *
     * @param disassociateNetworkSettingsRequest
     * @return Result of the DisassociateNetworkSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.DisassociateNetworkSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DisassociateNetworkSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DisassociateNetworkSettingsResponse disassociateNetworkSettings(
            DisassociateNetworkSettingsRequest disassociateNetworkSettingsRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DisassociateNetworkSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DisassociateNetworkSettingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disassociateNetworkSettingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disassociateNetworkSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateNetworkSettings");

            return clientHandler
                    .execute(new ClientExecutionParams<DisassociateNetworkSettingsRequest, DisassociateNetworkSettingsResponse>()
                            .withOperationName("DisassociateNetworkSettings").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(disassociateNetworkSettingsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DisassociateNetworkSettingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Disassociates a trust store from a web portal.
     * </p>
     *
     * @param disassociateTrustStoreRequest
     * @return Result of the DisassociateTrustStore operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.DisassociateTrustStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DisassociateTrustStore"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DisassociateTrustStoreResponse disassociateTrustStore(DisassociateTrustStoreRequest disassociateTrustStoreRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DisassociateTrustStoreResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DisassociateTrustStoreResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disassociateTrustStoreRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disassociateTrustStoreRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateTrustStore");

            return clientHandler
                    .execute(new ClientExecutionParams<DisassociateTrustStoreRequest, DisassociateTrustStoreResponse>()
                            .withOperationName("DisassociateTrustStore").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(disassociateTrustStoreRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DisassociateTrustStoreRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Disassociates user access logging settings from a web portal.
     * </p>
     *
     * @param disassociateUserAccessLoggingSettingsRequest
     * @return Result of the DisassociateUserAccessLoggingSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.DisassociateUserAccessLoggingSettings
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DisassociateUserAccessLoggingSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DisassociateUserAccessLoggingSettingsResponse disassociateUserAccessLoggingSettings(
            DisassociateUserAccessLoggingSettingsRequest disassociateUserAccessLoggingSettingsRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DisassociateUserAccessLoggingSettingsResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, DisassociateUserAccessLoggingSettingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disassociateUserAccessLoggingSettingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                disassociateUserAccessLoggingSettingsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateUserAccessLoggingSettings");

            return clientHandler
                    .execute(new ClientExecutionParams<DisassociateUserAccessLoggingSettingsRequest, DisassociateUserAccessLoggingSettingsResponse>()
                            .withOperationName("DisassociateUserAccessLoggingSettings").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration)
                            .withInput(disassociateUserAccessLoggingSettingsRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DisassociateUserAccessLoggingSettingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Disassociates user settings from a web portal.
     * </p>
     *
     * @param disassociateUserSettingsRequest
     * @return Result of the DisassociateUserSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.DisassociateUserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DisassociateUserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DisassociateUserSettingsResponse disassociateUserSettings(
            DisassociateUserSettingsRequest disassociateUserSettingsRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DisassociateUserSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DisassociateUserSettingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disassociateUserSettingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disassociateUserSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateUserSettings");

            return clientHandler
                    .execute(new ClientExecutionParams<DisassociateUserSettingsRequest, DisassociateUserSettingsResponse>()
                            .withOperationName("DisassociateUserSettings").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(disassociateUserSettingsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DisassociateUserSettingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets browser settings.
     * </p>
     *
     * @param getBrowserSettingsRequest
     * @return Result of the GetBrowserSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.GetBrowserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/GetBrowserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetBrowserSettingsResponse getBrowserSettings(GetBrowserSettingsRequest getBrowserSettingsRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetBrowserSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetBrowserSettingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getBrowserSettingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getBrowserSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetBrowserSettings");

            return clientHandler.execute(new ClientExecutionParams<GetBrowserSettingsRequest, GetBrowserSettingsResponse>()
                    .withOperationName("GetBrowserSettings").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getBrowserSettingsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetBrowserSettingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets the identity provider.
     * </p>
     *
     * @param getIdentityProviderRequest
     * @return Result of the GetIdentityProvider operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.GetIdentityProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/GetIdentityProvider"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetIdentityProviderResponse getIdentityProvider(GetIdentityProviderRequest getIdentityProviderRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetIdentityProviderResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetIdentityProviderResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getIdentityProviderRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getIdentityProviderRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetIdentityProvider");

            return clientHandler.execute(new ClientExecutionParams<GetIdentityProviderRequest, GetIdentityProviderResponse>()
                    .withOperationName("GetIdentityProvider").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getIdentityProviderRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetIdentityProviderRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets the IP access settings.
     * </p>
     *
     * @param getIpAccessSettingsRequest
     * @return Result of the GetIpAccessSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.GetIpAccessSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/GetIpAccessSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetIpAccessSettingsResponse getIpAccessSettings(GetIpAccessSettingsRequest getIpAccessSettingsRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetIpAccessSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetIpAccessSettingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getIpAccessSettingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getIpAccessSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetIpAccessSettings");

            return clientHandler.execute(new ClientExecutionParams<GetIpAccessSettingsRequest, GetIpAccessSettingsResponse>()
                    .withOperationName("GetIpAccessSettings").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getIpAccessSettingsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetIpAccessSettingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets the network settings.
     * </p>
     *
     * @param getNetworkSettingsRequest
     * @return Result of the GetNetworkSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.GetNetworkSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/GetNetworkSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetNetworkSettingsResponse getNetworkSettings(GetNetworkSettingsRequest getNetworkSettingsRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetNetworkSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetNetworkSettingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getNetworkSettingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getNetworkSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetNetworkSettings");

            return clientHandler.execute(new ClientExecutionParams<GetNetworkSettingsRequest, GetNetworkSettingsResponse>()
                    .withOperationName("GetNetworkSettings").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getNetworkSettingsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetNetworkSettingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets the web portal.
     * </p>
     *
     * @param getPortalRequest
     * @return Result of the GetPortal operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.GetPortal
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/GetPortal" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetPortalResponse getPortal(GetPortalRequest getPortalRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetPortalResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetPortalResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getPortalRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getPortalRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetPortal");

            return clientHandler.execute(new ClientExecutionParams<GetPortalRequest, GetPortalResponse>()
                    .withOperationName("GetPortal").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getPortalRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetPortalRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets the service provider metadata.
     * </p>
     *
     * @param getPortalServiceProviderMetadataRequest
     * @return Result of the GetPortalServiceProviderMetadata operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.GetPortalServiceProviderMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/GetPortalServiceProviderMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetPortalServiceProviderMetadataResponse getPortalServiceProviderMetadata(
            GetPortalServiceProviderMetadataRequest getPortalServiceProviderMetadataRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetPortalServiceProviderMetadataResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetPortalServiceProviderMetadataResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getPortalServiceProviderMetadataRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getPortalServiceProviderMetadataRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetPortalServiceProviderMetadata");

            return clientHandler
                    .execute(new ClientExecutionParams<GetPortalServiceProviderMetadataRequest, GetPortalServiceProviderMetadataResponse>()
                            .withOperationName("GetPortalServiceProviderMetadata").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getPortalServiceProviderMetadataRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetPortalServiceProviderMetadataRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets the trust store.
     * </p>
     *
     * @param getTrustStoreRequest
     * @return Result of the GetTrustStore operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.GetTrustStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/GetTrustStore" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetTrustStoreResponse getTrustStore(GetTrustStoreRequest getTrustStoreRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetTrustStoreResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetTrustStoreResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getTrustStoreRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getTrustStoreRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetTrustStore");

            return clientHandler.execute(new ClientExecutionParams<GetTrustStoreRequest, GetTrustStoreResponse>()
                    .withOperationName("GetTrustStore").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getTrustStoreRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetTrustStoreRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets the trust store certificate.
     * </p>
     *
     * @param getTrustStoreCertificateRequest
     * @return Result of the GetTrustStoreCertificate operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.GetTrustStoreCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/GetTrustStoreCertificate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetTrustStoreCertificateResponse getTrustStoreCertificate(
            GetTrustStoreCertificateRequest getTrustStoreCertificateRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetTrustStoreCertificateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetTrustStoreCertificateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getTrustStoreCertificateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getTrustStoreCertificateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetTrustStoreCertificate");

            return clientHandler
                    .execute(new ClientExecutionParams<GetTrustStoreCertificateRequest, GetTrustStoreCertificateResponse>()
                            .withOperationName("GetTrustStoreCertificate").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getTrustStoreCertificateRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetTrustStoreCertificateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets user access logging settings.
     * </p>
     *
     * @param getUserAccessLoggingSettingsRequest
     * @return Result of the GetUserAccessLoggingSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.GetUserAccessLoggingSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/GetUserAccessLoggingSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetUserAccessLoggingSettingsResponse getUserAccessLoggingSettings(
            GetUserAccessLoggingSettingsRequest getUserAccessLoggingSettingsRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetUserAccessLoggingSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetUserAccessLoggingSettingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getUserAccessLoggingSettingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getUserAccessLoggingSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetUserAccessLoggingSettings");

            return clientHandler
                    .execute(new ClientExecutionParams<GetUserAccessLoggingSettingsRequest, GetUserAccessLoggingSettingsResponse>()
                            .withOperationName("GetUserAccessLoggingSettings").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getUserAccessLoggingSettingsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetUserAccessLoggingSettingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets user settings.
     * </p>
     *
     * @param getUserSettingsRequest
     * @return Result of the GetUserSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.GetUserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/GetUserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetUserSettingsResponse getUserSettings(GetUserSettingsRequest getUserSettingsRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetUserSettingsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetUserSettingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getUserSettingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getUserSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetUserSettings");

            return clientHandler.execute(new ClientExecutionParams<GetUserSettingsRequest, GetUserSettingsResponse>()
                    .withOperationName("GetUserSettings").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getUserSettingsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetUserSettingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list of browser settings.
     * </p>
     *
     * @param listBrowserSettingsRequest
     * @return Result of the ListBrowserSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.ListBrowserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListBrowserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListBrowserSettingsResponse listBrowserSettings(ListBrowserSettingsRequest listBrowserSettingsRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListBrowserSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListBrowserSettingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listBrowserSettingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listBrowserSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListBrowserSettings");

            return clientHandler.execute(new ClientExecutionParams<ListBrowserSettingsRequest, ListBrowserSettingsResponse>()
                    .withOperationName("ListBrowserSettings").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listBrowserSettingsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListBrowserSettingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list of identity providers for a specific web portal.
     * </p>
     *
     * @param listIdentityProvidersRequest
     * @return Result of the ListIdentityProviders operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.ListIdentityProviders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListIdentityProviders"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListIdentityProvidersResponse listIdentityProviders(ListIdentityProvidersRequest listIdentityProvidersRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListIdentityProvidersResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListIdentityProvidersResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listIdentityProvidersRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listIdentityProvidersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListIdentityProviders");

            return clientHandler.execute(new ClientExecutionParams<ListIdentityProvidersRequest, ListIdentityProvidersResponse>()
                    .withOperationName("ListIdentityProviders").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listIdentityProvidersRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListIdentityProvidersRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list of IP access settings.
     * </p>
     *
     * @param listIpAccessSettingsRequest
     * @return Result of the ListIpAccessSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.ListIpAccessSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListIpAccessSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListIpAccessSettingsResponse listIpAccessSettings(ListIpAccessSettingsRequest listIpAccessSettingsRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListIpAccessSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListIpAccessSettingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listIpAccessSettingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listIpAccessSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListIpAccessSettings");

            return clientHandler.execute(new ClientExecutionParams<ListIpAccessSettingsRequest, ListIpAccessSettingsResponse>()
                    .withOperationName("ListIpAccessSettings").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listIpAccessSettingsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListIpAccessSettingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list of network settings.
     * </p>
     *
     * @param listNetworkSettingsRequest
     * @return Result of the ListNetworkSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.ListNetworkSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListNetworkSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListNetworkSettingsResponse listNetworkSettings(ListNetworkSettingsRequest listNetworkSettingsRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListNetworkSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListNetworkSettingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listNetworkSettingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listNetworkSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListNetworkSettings");

            return clientHandler.execute(new ClientExecutionParams<ListNetworkSettingsRequest, ListNetworkSettingsResponse>()
                    .withOperationName("ListNetworkSettings").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listNetworkSettingsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListNetworkSettingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list or web portals.
     * </p>
     *
     * @param listPortalsRequest
     * @return Result of the ListPortals operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.ListPortals
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListPortals" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListPortalsResponse listPortals(ListPortalsRequest listPortalsRequest) throws InternalServerException,
            AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListPortalsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListPortalsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listPortalsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listPortalsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListPortals");

            return clientHandler.execute(new ClientExecutionParams<ListPortalsRequest, ListPortalsResponse>()
                    .withOperationName("ListPortals").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(listPortalsRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListPortalsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list of tags for a resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListTagsForResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsForResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");

            return clientHandler.execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                    .withOperationName("ListTagsForResource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listTagsForResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list of trust store certificates.
     * </p>
     *
     * @param listTrustStoreCertificatesRequest
     * @return Result of the ListTrustStoreCertificates operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.ListTrustStoreCertificates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListTrustStoreCertificates"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListTrustStoreCertificatesResponse listTrustStoreCertificates(
            ListTrustStoreCertificatesRequest listTrustStoreCertificatesRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTrustStoreCertificatesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListTrustStoreCertificatesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTrustStoreCertificatesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTrustStoreCertificatesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTrustStoreCertificates");

            return clientHandler
                    .execute(new ClientExecutionParams<ListTrustStoreCertificatesRequest, ListTrustStoreCertificatesResponse>()
                            .withOperationName("ListTrustStoreCertificates").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listTrustStoreCertificatesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListTrustStoreCertificatesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list of trust stores.
     * </p>
     *
     * @param listTrustStoresRequest
     * @return Result of the ListTrustStores operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.ListTrustStores
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListTrustStores"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListTrustStoresResponse listTrustStores(ListTrustStoresRequest listTrustStoresRequest) throws InternalServerException,
            AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTrustStoresResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListTrustStoresResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTrustStoresRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTrustStoresRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTrustStores");

            return clientHandler.execute(new ClientExecutionParams<ListTrustStoresRequest, ListTrustStoresResponse>()
                    .withOperationName("ListTrustStores").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listTrustStoresRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListTrustStoresRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list of user access logging settings.
     * </p>
     *
     * @param listUserAccessLoggingSettingsRequest
     * @return Result of the ListUserAccessLoggingSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.ListUserAccessLoggingSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListUserAccessLoggingSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListUserAccessLoggingSettingsResponse listUserAccessLoggingSettings(
            ListUserAccessLoggingSettingsRequest listUserAccessLoggingSettingsRequest) throws InternalServerException,
            AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException, SdkClientException,
            WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListUserAccessLoggingSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListUserAccessLoggingSettingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listUserAccessLoggingSettingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listUserAccessLoggingSettingsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListUserAccessLoggingSettings");

            return clientHandler
                    .execute(new ClientExecutionParams<ListUserAccessLoggingSettingsRequest, ListUserAccessLoggingSettingsResponse>()
                            .withOperationName("ListUserAccessLoggingSettings").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listUserAccessLoggingSettingsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListUserAccessLoggingSettingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list of user settings.
     * </p>
     *
     * @param listUserSettingsRequest
     * @return Result of the ListUserSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.ListUserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListUserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListUserSettingsResponse listUserSettings(ListUserSettingsRequest listUserSettingsRequest)
            throws InternalServerException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListUserSettingsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListUserSettingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listUserSettingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listUserSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListUserSettings");

            return clientHandler.execute(new ClientExecutionParams<ListUserSettingsRequest, ListUserSettingsResponse>()
                    .withOperationName("ListUserSettings").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listUserSettingsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListUserSettingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Adds or overwrites one or more tags for the specified resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws TooManyTagsException
     *         There are too many tags.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, TooManyTagsException,
            AwsServiceException, SdkClientException, WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                TagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");

            return clientHandler.execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                    .withOperationName("TagResource").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(tagResourceRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new TagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes one or more tags from the specified resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UntagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");

            return clientHandler.execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                    .withOperationName("UntagResource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(untagResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates browser settings.
     * </p>
     *
     * @param updateBrowserSettingsRequest
     * @return Result of the UpdateBrowserSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.UpdateBrowserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/UpdateBrowserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateBrowserSettingsResponse updateBrowserSettings(UpdateBrowserSettingsRequest updateBrowserSettingsRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateBrowserSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateBrowserSettingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateBrowserSettingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateBrowserSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateBrowserSettings");

            return clientHandler.execute(new ClientExecutionParams<UpdateBrowserSettingsRequest, UpdateBrowserSettingsResponse>()
                    .withOperationName("UpdateBrowserSettings").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateBrowserSettingsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateBrowserSettingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the identity provider.
     * </p>
     *
     * @param updateIdentityProviderRequest
     * @return Result of the UpdateIdentityProvider operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.UpdateIdentityProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/UpdateIdentityProvider"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateIdentityProviderResponse updateIdentityProvider(UpdateIdentityProviderRequest updateIdentityProviderRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateIdentityProviderResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateIdentityProviderResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateIdentityProviderRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateIdentityProviderRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateIdentityProvider");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateIdentityProviderRequest, UpdateIdentityProviderResponse>()
                            .withOperationName("UpdateIdentityProvider").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(updateIdentityProviderRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateIdentityProviderRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates IP access settings.
     * </p>
     *
     * @param updateIpAccessSettingsRequest
     * @return Result of the UpdateIpAccessSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.UpdateIpAccessSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/UpdateIpAccessSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateIpAccessSettingsResponse updateIpAccessSettings(UpdateIpAccessSettingsRequest updateIpAccessSettingsRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateIpAccessSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateIpAccessSettingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateIpAccessSettingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateIpAccessSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateIpAccessSettings");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateIpAccessSettingsRequest, UpdateIpAccessSettingsResponse>()
                            .withOperationName("UpdateIpAccessSettings").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(updateIpAccessSettingsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateIpAccessSettingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates network settings.
     * </p>
     *
     * @param updateNetworkSettingsRequest
     * @return Result of the UpdateNetworkSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.UpdateNetworkSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/UpdateNetworkSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateNetworkSettingsResponse updateNetworkSettings(UpdateNetworkSettingsRequest updateNetworkSettingsRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateNetworkSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateNetworkSettingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateNetworkSettingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateNetworkSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateNetworkSettings");

            return clientHandler.execute(new ClientExecutionParams<UpdateNetworkSettingsRequest, UpdateNetworkSettingsResponse>()
                    .withOperationName("UpdateNetworkSettings").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateNetworkSettingsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateNetworkSettingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a web portal.
     * </p>
     *
     * @param updatePortalRequest
     * @return Result of the UpdatePortal operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws ConflictException
     *         There is a conflict.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.UpdatePortal
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/UpdatePortal" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdatePortalResponse updatePortal(UpdatePortalRequest updatePortalRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, ConflictException,
            AwsServiceException, SdkClientException, WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdatePortalResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdatePortalResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updatePortalRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updatePortalRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdatePortal");

            return clientHandler.execute(new ClientExecutionParams<UpdatePortalRequest, UpdatePortalResponse>()
                    .withOperationName("UpdatePortal").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updatePortalRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdatePortalRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the trust store.
     * </p>
     *
     * @param updateTrustStoreRequest
     * @return Result of the UpdateTrustStore operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ServiceQuotaExceededException
     *         The service quota has been exceeded.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.UpdateTrustStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/UpdateTrustStore"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateTrustStoreResponse updateTrustStore(UpdateTrustStoreRequest updateTrustStoreRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ServiceQuotaExceededException, ValidationException, AwsServiceException, SdkClientException, WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateTrustStoreResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateTrustStoreResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateTrustStoreRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateTrustStoreRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateTrustStore");

            return clientHandler.execute(new ClientExecutionParams<UpdateTrustStoreRequest, UpdateTrustStoreResponse>()
                    .withOperationName("UpdateTrustStore").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateTrustStoreRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateTrustStoreRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the user access logging settings.
     * </p>
     *
     * @param updateUserAccessLoggingSettingsRequest
     * @return Result of the UpdateUserAccessLoggingSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.UpdateUserAccessLoggingSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/UpdateUserAccessLoggingSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateUserAccessLoggingSettingsResponse updateUserAccessLoggingSettings(
            UpdateUserAccessLoggingSettingsRequest updateUserAccessLoggingSettingsRequest) throws InternalServerException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, ValidationException, AwsServiceException,
            SdkClientException, WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateUserAccessLoggingSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateUserAccessLoggingSettingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateUserAccessLoggingSettingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateUserAccessLoggingSettingsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateUserAccessLoggingSettings");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateUserAccessLoggingSettingsRequest, UpdateUserAccessLoggingSettingsResponse>()
                            .withOperationName("UpdateUserAccessLoggingSettings").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(updateUserAccessLoggingSettingsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateUserAccessLoggingSettingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the user settings.
     * </p>
     *
     * @param updateUserSettingsRequest
     * @return Result of the UpdateUserSettings operation returned by the service.
     * @throws InternalServerException
     *         There is an internal server error.
     * @throws ResourceNotFoundException
     *         The resource cannot be found.
     * @throws AccessDeniedException
     *         Access is denied.
     * @throws ThrottlingException
     *         There is a throttling error.
     * @throws ValidationException
     *         There is a validation error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws WorkSpacesWebException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample WorkSpacesWebClient.UpdateUserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/UpdateUserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateUserSettingsResponse updateUserSettings(UpdateUserSettingsRequest updateUserSettingsRequest)
            throws InternalServerException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            ValidationException, AwsServiceException, SdkClientException, WorkSpacesWebException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateUserSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateUserSettingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateUserSettingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateUserSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "WorkSpaces Web");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateUserSettings");

            return clientHandler.execute(new ClientExecutionParams<UpdateUserSettingsRequest, UpdateUserSettingsResponse>()
                    .withOperationName("UpdateUserSettings").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateUserSettingsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateUserSettingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        WorkSpacesWebServiceClientConfigurationBuilder serviceConfigBuilder = new WorkSpacesWebServiceClientConfigurationBuilder(
                configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(WorkSpacesWebException::builder)
                .protocol(AwsJsonProtocol.REST_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ThrottlingException")
                                .exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(429).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException")
                                .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(402).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalServerException")
                                .exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AccessDeniedException")
                                .exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(403).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConflictException")
                                .exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyTagsException")
                                .exceptionBuilderSupplier(TooManyTagsException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundException")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ValidationException")
                                .exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(400).build());
    }

    @Override
    public final WorkSpacesWebServiceClientConfiguration serviceClientConfiguration() {
        return new WorkSpacesWebServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
