/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspacesweb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateUserSettingsRequest extends WorkSpacesWebRequest implements
        ToCopyableBuilder<UpdateUserSettingsRequest.Builder, UpdateUserSettingsRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(UpdateUserSettingsRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<CookieSynchronizationConfiguration> COOKIE_SYNCHRONIZATION_CONFIGURATION_FIELD = SdkField
            .<CookieSynchronizationConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("cookieSynchronizationConfiguration")
            .getter(getter(UpdateUserSettingsRequest::cookieSynchronizationConfiguration))
            .setter(setter(Builder::cookieSynchronizationConfiguration))
            .constructor(CookieSynchronizationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cookieSynchronizationConfiguration")
                    .build()).build();

    private static final SdkField<String> COPY_ALLOWED_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("copyAllowed").getter(getter(UpdateUserSettingsRequest::copyAllowedAsString))
            .setter(setter(Builder::copyAllowed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("copyAllowed").build()).build();

    private static final SdkField<Integer> DISCONNECT_TIMEOUT_IN_MINUTES_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("disconnectTimeoutInMinutes")
            .getter(getter(UpdateUserSettingsRequest::disconnectTimeoutInMinutes))
            .setter(setter(Builder::disconnectTimeoutInMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("disconnectTimeoutInMinutes").build())
            .build();

    private static final SdkField<String> DOWNLOAD_ALLOWED_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("downloadAllowed").getter(getter(UpdateUserSettingsRequest::downloadAllowedAsString))
            .setter(setter(Builder::downloadAllowed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("downloadAllowed").build()).build();

    private static final SdkField<Integer> IDLE_DISCONNECT_TIMEOUT_IN_MINUTES_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("idleDisconnectTimeoutInMinutes")
            .getter(getter(UpdateUserSettingsRequest::idleDisconnectTimeoutInMinutes))
            .setter(setter(Builder::idleDisconnectTimeoutInMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("idleDisconnectTimeoutInMinutes")
                    .build()).build();

    private static final SdkField<String> PASTE_ALLOWED_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("pasteAllowed").getter(getter(UpdateUserSettingsRequest::pasteAllowedAsString))
            .setter(setter(Builder::pasteAllowed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pasteAllowed").build()).build();

    private static final SdkField<String> PRINT_ALLOWED_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("printAllowed").getter(getter(UpdateUserSettingsRequest::printAllowedAsString))
            .setter(setter(Builder::printAllowed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("printAllowed").build()).build();

    private static final SdkField<String> UPLOAD_ALLOWED_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("uploadAllowed").getter(getter(UpdateUserSettingsRequest::uploadAllowedAsString))
            .setter(setter(Builder::uploadAllowed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uploadAllowed").build()).build();

    private static final SdkField<String> USER_SETTINGS_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("userSettingsArn").getter(getter(UpdateUserSettingsRequest::userSettingsArn))
            .setter(setter(Builder::userSettingsArn))
            .traits(LocationTrait.builder().location(MarshallLocation.GREEDY_PATH).locationName("userSettingsArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            COOKIE_SYNCHRONIZATION_CONFIGURATION_FIELD, COPY_ALLOWED_FIELD, DISCONNECT_TIMEOUT_IN_MINUTES_FIELD,
            DOWNLOAD_ALLOWED_FIELD, IDLE_DISCONNECT_TIMEOUT_IN_MINUTES_FIELD, PASTE_ALLOWED_FIELD, PRINT_ALLOWED_FIELD,
            UPLOAD_ALLOWED_FIELD, USER_SETTINGS_ARN_FIELD));

    private final String clientToken;

    private final CookieSynchronizationConfiguration cookieSynchronizationConfiguration;

    private final String copyAllowed;

    private final Integer disconnectTimeoutInMinutes;

    private final String downloadAllowed;

    private final Integer idleDisconnectTimeoutInMinutes;

    private final String pasteAllowed;

    private final String printAllowed;

    private final String uploadAllowed;

    private final String userSettingsArn;

    private UpdateUserSettingsRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.cookieSynchronizationConfiguration = builder.cookieSynchronizationConfiguration;
        this.copyAllowed = builder.copyAllowed;
        this.disconnectTimeoutInMinutes = builder.disconnectTimeoutInMinutes;
        this.downloadAllowed = builder.downloadAllowed;
        this.idleDisconnectTimeoutInMinutes = builder.idleDisconnectTimeoutInMinutes;
        this.pasteAllowed = builder.pasteAllowed;
        this.printAllowed = builder.printAllowed;
        this.uploadAllowed = builder.uploadAllowed;
        this.userSettingsArn = builder.userSettingsArn;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency
     * ensures that an API request completes only once. With an idempotent request, if the original request completes
     * successfully, subsequent retries with the same client token return the result from the original successful
     * request.
     * </p>
     * <p>
     * If you do not specify a client token, one is automatically generated by the AWS SDK.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     *         Idempotency ensures that an API request completes only once. With an idempotent request, if the original
     *         request completes successfully, subsequent retries with the same client token return the result from the
     *         original successful request. </p>
     *         <p>
     *         If you do not specify a client token, one is automatically generated by the AWS SDK.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The configuration that specifies which cookies should be synchronized from the end user's local browser to the
     * remote browser.
     * </p>
     * <p>
     * If the allowlist and blocklist are empty, the configuration becomes null.
     * </p>
     * 
     * @return The configuration that specifies which cookies should be synchronized from the end user's local browser
     *         to the remote browser.</p>
     *         <p>
     *         If the allowlist and blocklist are empty, the configuration becomes null.
     */
    public final CookieSynchronizationConfiguration cookieSynchronizationConfiguration() {
        return cookieSynchronizationConfiguration;
    }

    /**
     * <p>
     * Specifies whether the user can copy text from the streaming session to the local device.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #copyAllowed} will
     * return {@link EnabledType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #copyAllowedAsString}.
     * </p>
     * 
     * @return Specifies whether the user can copy text from the streaming session to the local device.
     * @see EnabledType
     */
    public final EnabledType copyAllowed() {
        return EnabledType.fromValue(copyAllowed);
    }

    /**
     * <p>
     * Specifies whether the user can copy text from the streaming session to the local device.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #copyAllowed} will
     * return {@link EnabledType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #copyAllowedAsString}.
     * </p>
     * 
     * @return Specifies whether the user can copy text from the streaming session to the local device.
     * @see EnabledType
     */
    public final String copyAllowedAsString() {
        return copyAllowed;
    }

    /**
     * <p>
     * The amount of time that a streaming session remains active after users disconnect.
     * </p>
     * 
     * @return The amount of time that a streaming session remains active after users disconnect.
     */
    public final Integer disconnectTimeoutInMinutes() {
        return disconnectTimeoutInMinutes;
    }

    /**
     * <p>
     * Specifies whether the user can download files from the streaming session to the local device.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #downloadAllowed}
     * will return {@link EnabledType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #downloadAllowedAsString}.
     * </p>
     * 
     * @return Specifies whether the user can download files from the streaming session to the local device.
     * @see EnabledType
     */
    public final EnabledType downloadAllowed() {
        return EnabledType.fromValue(downloadAllowed);
    }

    /**
     * <p>
     * Specifies whether the user can download files from the streaming session to the local device.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #downloadAllowed}
     * will return {@link EnabledType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #downloadAllowedAsString}.
     * </p>
     * 
     * @return Specifies whether the user can download files from the streaming session to the local device.
     * @see EnabledType
     */
    public final String downloadAllowedAsString() {
        return downloadAllowed;
    }

    /**
     * <p>
     * The amount of time that users can be idle (inactive) before they are disconnected from their streaming session
     * and the disconnect timeout interval begins.
     * </p>
     * 
     * @return The amount of time that users can be idle (inactive) before they are disconnected from their streaming
     *         session and the disconnect timeout interval begins.
     */
    public final Integer idleDisconnectTimeoutInMinutes() {
        return idleDisconnectTimeoutInMinutes;
    }

    /**
     * <p>
     * Specifies whether the user can paste text from the local device to the streaming session.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pasteAllowed} will
     * return {@link EnabledType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #pasteAllowedAsString}.
     * </p>
     * 
     * @return Specifies whether the user can paste text from the local device to the streaming session.
     * @see EnabledType
     */
    public final EnabledType pasteAllowed() {
        return EnabledType.fromValue(pasteAllowed);
    }

    /**
     * <p>
     * Specifies whether the user can paste text from the local device to the streaming session.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pasteAllowed} will
     * return {@link EnabledType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #pasteAllowedAsString}.
     * </p>
     * 
     * @return Specifies whether the user can paste text from the local device to the streaming session.
     * @see EnabledType
     */
    public final String pasteAllowedAsString() {
        return pasteAllowed;
    }

    /**
     * <p>
     * Specifies whether the user can print to the local device.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #printAllowed} will
     * return {@link EnabledType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #printAllowedAsString}.
     * </p>
     * 
     * @return Specifies whether the user can print to the local device.
     * @see EnabledType
     */
    public final EnabledType printAllowed() {
        return EnabledType.fromValue(printAllowed);
    }

    /**
     * <p>
     * Specifies whether the user can print to the local device.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #printAllowed} will
     * return {@link EnabledType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #printAllowedAsString}.
     * </p>
     * 
     * @return Specifies whether the user can print to the local device.
     * @see EnabledType
     */
    public final String printAllowedAsString() {
        return printAllowed;
    }

    /**
     * <p>
     * Specifies whether the user can upload files from the local device to the streaming session.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #uploadAllowed}
     * will return {@link EnabledType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #uploadAllowedAsString}.
     * </p>
     * 
     * @return Specifies whether the user can upload files from the local device to the streaming session.
     * @see EnabledType
     */
    public final EnabledType uploadAllowed() {
        return EnabledType.fromValue(uploadAllowed);
    }

    /**
     * <p>
     * Specifies whether the user can upload files from the local device to the streaming session.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #uploadAllowed}
     * will return {@link EnabledType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #uploadAllowedAsString}.
     * </p>
     * 
     * @return Specifies whether the user can upload files from the local device to the streaming session.
     * @see EnabledType
     */
    public final String uploadAllowedAsString() {
        return uploadAllowed;
    }

    /**
     * <p>
     * The ARN of the user settings.
     * </p>
     * 
     * @return The ARN of the user settings.
     */
    public final String userSettingsArn() {
        return userSettingsArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(cookieSynchronizationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(copyAllowedAsString());
        hashCode = 31 * hashCode + Objects.hashCode(disconnectTimeoutInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(downloadAllowedAsString());
        hashCode = 31 * hashCode + Objects.hashCode(idleDisconnectTimeoutInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(pasteAllowedAsString());
        hashCode = 31 * hashCode + Objects.hashCode(printAllowedAsString());
        hashCode = 31 * hashCode + Objects.hashCode(uploadAllowedAsString());
        hashCode = 31 * hashCode + Objects.hashCode(userSettingsArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateUserSettingsRequest)) {
            return false;
        }
        UpdateUserSettingsRequest other = (UpdateUserSettingsRequest) obj;
        return Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(cookieSynchronizationConfiguration(), other.cookieSynchronizationConfiguration())
                && Objects.equals(copyAllowedAsString(), other.copyAllowedAsString())
                && Objects.equals(disconnectTimeoutInMinutes(), other.disconnectTimeoutInMinutes())
                && Objects.equals(downloadAllowedAsString(), other.downloadAllowedAsString())
                && Objects.equals(idleDisconnectTimeoutInMinutes(), other.idleDisconnectTimeoutInMinutes())
                && Objects.equals(pasteAllowedAsString(), other.pasteAllowedAsString())
                && Objects.equals(printAllowedAsString(), other.printAllowedAsString())
                && Objects.equals(uploadAllowedAsString(), other.uploadAllowedAsString())
                && Objects.equals(userSettingsArn(), other.userSettingsArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("UpdateUserSettingsRequest")
                .add("ClientToken", clientToken())
                .add("CookieSynchronizationConfiguration",
                        cookieSynchronizationConfiguration() == null ? null : "*** Sensitive Data Redacted ***")
                .add("CopyAllowed", copyAllowedAsString()).add("DisconnectTimeoutInMinutes", disconnectTimeoutInMinutes())
                .add("DownloadAllowed", downloadAllowedAsString())
                .add("IdleDisconnectTimeoutInMinutes", idleDisconnectTimeoutInMinutes())
                .add("PasteAllowed", pasteAllowedAsString()).add("PrintAllowed", printAllowedAsString())
                .add("UploadAllowed", uploadAllowedAsString()).add("UserSettingsArn", userSettingsArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "cookieSynchronizationConfiguration":
            return Optional.ofNullable(clazz.cast(cookieSynchronizationConfiguration()));
        case "copyAllowed":
            return Optional.ofNullable(clazz.cast(copyAllowedAsString()));
        case "disconnectTimeoutInMinutes":
            return Optional.ofNullable(clazz.cast(disconnectTimeoutInMinutes()));
        case "downloadAllowed":
            return Optional.ofNullable(clazz.cast(downloadAllowedAsString()));
        case "idleDisconnectTimeoutInMinutes":
            return Optional.ofNullable(clazz.cast(idleDisconnectTimeoutInMinutes()));
        case "pasteAllowed":
            return Optional.ofNullable(clazz.cast(pasteAllowedAsString()));
        case "printAllowed":
            return Optional.ofNullable(clazz.cast(printAllowedAsString()));
        case "uploadAllowed":
            return Optional.ofNullable(clazz.cast(uploadAllowedAsString()));
        case "userSettingsArn":
            return Optional.ofNullable(clazz.cast(userSettingsArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateUserSettingsRequest, T> g) {
        return obj -> g.apply((UpdateUserSettingsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkSpacesWebRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateUserSettingsRequest> {
        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency
         * ensures that an API request completes only once. With an idempotent request, if the original request
         * completes successfully, subsequent retries with the same client token return the result from the original
         * successful request.
         * </p>
         * <p>
         * If you do not specify a client token, one is automatically generated by the AWS SDK.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         *        Idempotency ensures that an API request completes only once. With an idempotent request, if the
         *        original request completes successfully, subsequent retries with the same client token return the
         *        result from the original successful request. </p>
         *        <p>
         *        If you do not specify a client token, one is automatically generated by the AWS SDK.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The configuration that specifies which cookies should be synchronized from the end user's local browser to
         * the remote browser.
         * </p>
         * <p>
         * If the allowlist and blocklist are empty, the configuration becomes null.
         * </p>
         * 
         * @param cookieSynchronizationConfiguration
         *        The configuration that specifies which cookies should be synchronized from the end user's local
         *        browser to the remote browser.</p>
         *        <p>
         *        If the allowlist and blocklist are empty, the configuration becomes null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cookieSynchronizationConfiguration(CookieSynchronizationConfiguration cookieSynchronizationConfiguration);

        /**
         * <p>
         * The configuration that specifies which cookies should be synchronized from the end user's local browser to
         * the remote browser.
         * </p>
         * <p>
         * If the allowlist and blocklist are empty, the configuration becomes null.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link CookieSynchronizationConfiguration.Builder} avoiding the need to create one manually via
         * {@link CookieSynchronizationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CookieSynchronizationConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #cookieSynchronizationConfiguration(CookieSynchronizationConfiguration)}.
         * 
         * @param cookieSynchronizationConfiguration
         *        a consumer that will call methods on {@link CookieSynchronizationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cookieSynchronizationConfiguration(CookieSynchronizationConfiguration)
         */
        default Builder cookieSynchronizationConfiguration(
                Consumer<CookieSynchronizationConfiguration.Builder> cookieSynchronizationConfiguration) {
            return cookieSynchronizationConfiguration(CookieSynchronizationConfiguration.builder()
                    .applyMutation(cookieSynchronizationConfiguration).build());
        }

        /**
         * <p>
         * Specifies whether the user can copy text from the streaming session to the local device.
         * </p>
         * 
         * @param copyAllowed
         *        Specifies whether the user can copy text from the streaming session to the local device.
         * @see EnabledType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnabledType
         */
        Builder copyAllowed(String copyAllowed);

        /**
         * <p>
         * Specifies whether the user can copy text from the streaming session to the local device.
         * </p>
         * 
         * @param copyAllowed
         *        Specifies whether the user can copy text from the streaming session to the local device.
         * @see EnabledType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnabledType
         */
        Builder copyAllowed(EnabledType copyAllowed);

        /**
         * <p>
         * The amount of time that a streaming session remains active after users disconnect.
         * </p>
         * 
         * @param disconnectTimeoutInMinutes
         *        The amount of time that a streaming session remains active after users disconnect.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disconnectTimeoutInMinutes(Integer disconnectTimeoutInMinutes);

        /**
         * <p>
         * Specifies whether the user can download files from the streaming session to the local device.
         * </p>
         * 
         * @param downloadAllowed
         *        Specifies whether the user can download files from the streaming session to the local device.
         * @see EnabledType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnabledType
         */
        Builder downloadAllowed(String downloadAllowed);

        /**
         * <p>
         * Specifies whether the user can download files from the streaming session to the local device.
         * </p>
         * 
         * @param downloadAllowed
         *        Specifies whether the user can download files from the streaming session to the local device.
         * @see EnabledType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnabledType
         */
        Builder downloadAllowed(EnabledType downloadAllowed);

        /**
         * <p>
         * The amount of time that users can be idle (inactive) before they are disconnected from their streaming
         * session and the disconnect timeout interval begins.
         * </p>
         * 
         * @param idleDisconnectTimeoutInMinutes
         *        The amount of time that users can be idle (inactive) before they are disconnected from their streaming
         *        session and the disconnect timeout interval begins.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idleDisconnectTimeoutInMinutes(Integer idleDisconnectTimeoutInMinutes);

        /**
         * <p>
         * Specifies whether the user can paste text from the local device to the streaming session.
         * </p>
         * 
         * @param pasteAllowed
         *        Specifies whether the user can paste text from the local device to the streaming session.
         * @see EnabledType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnabledType
         */
        Builder pasteAllowed(String pasteAllowed);

        /**
         * <p>
         * Specifies whether the user can paste text from the local device to the streaming session.
         * </p>
         * 
         * @param pasteAllowed
         *        Specifies whether the user can paste text from the local device to the streaming session.
         * @see EnabledType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnabledType
         */
        Builder pasteAllowed(EnabledType pasteAllowed);

        /**
         * <p>
         * Specifies whether the user can print to the local device.
         * </p>
         * 
         * @param printAllowed
         *        Specifies whether the user can print to the local device.
         * @see EnabledType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnabledType
         */
        Builder printAllowed(String printAllowed);

        /**
         * <p>
         * Specifies whether the user can print to the local device.
         * </p>
         * 
         * @param printAllowed
         *        Specifies whether the user can print to the local device.
         * @see EnabledType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnabledType
         */
        Builder printAllowed(EnabledType printAllowed);

        /**
         * <p>
         * Specifies whether the user can upload files from the local device to the streaming session.
         * </p>
         * 
         * @param uploadAllowed
         *        Specifies whether the user can upload files from the local device to the streaming session.
         * @see EnabledType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnabledType
         */
        Builder uploadAllowed(String uploadAllowed);

        /**
         * <p>
         * Specifies whether the user can upload files from the local device to the streaming session.
         * </p>
         * 
         * @param uploadAllowed
         *        Specifies whether the user can upload files from the local device to the streaming session.
         * @see EnabledType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnabledType
         */
        Builder uploadAllowed(EnabledType uploadAllowed);

        /**
         * <p>
         * The ARN of the user settings.
         * </p>
         * 
         * @param userSettingsArn
         *        The ARN of the user settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userSettingsArn(String userSettingsArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkSpacesWebRequest.BuilderImpl implements Builder {
        private String clientToken;

        private CookieSynchronizationConfiguration cookieSynchronizationConfiguration;

        private String copyAllowed;

        private Integer disconnectTimeoutInMinutes;

        private String downloadAllowed;

        private Integer idleDisconnectTimeoutInMinutes;

        private String pasteAllowed;

        private String printAllowed;

        private String uploadAllowed;

        private String userSettingsArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateUserSettingsRequest model) {
            super(model);
            clientToken(model.clientToken);
            cookieSynchronizationConfiguration(model.cookieSynchronizationConfiguration);
            copyAllowed(model.copyAllowed);
            disconnectTimeoutInMinutes(model.disconnectTimeoutInMinutes);
            downloadAllowed(model.downloadAllowed);
            idleDisconnectTimeoutInMinutes(model.idleDisconnectTimeoutInMinutes);
            pasteAllowed(model.pasteAllowed);
            printAllowed(model.printAllowed);
            uploadAllowed(model.uploadAllowed);
            userSettingsArn(model.userSettingsArn);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final CookieSynchronizationConfiguration.Builder getCookieSynchronizationConfiguration() {
            return cookieSynchronizationConfiguration != null ? cookieSynchronizationConfiguration.toBuilder() : null;
        }

        public final void setCookieSynchronizationConfiguration(
                CookieSynchronizationConfiguration.BuilderImpl cookieSynchronizationConfiguration) {
            this.cookieSynchronizationConfiguration = cookieSynchronizationConfiguration != null ? cookieSynchronizationConfiguration
                    .build() : null;
        }

        @Override
        public final Builder cookieSynchronizationConfiguration(
                CookieSynchronizationConfiguration cookieSynchronizationConfiguration) {
            this.cookieSynchronizationConfiguration = cookieSynchronizationConfiguration;
            return this;
        }

        public final String getCopyAllowed() {
            return copyAllowed;
        }

        public final void setCopyAllowed(String copyAllowed) {
            this.copyAllowed = copyAllowed;
        }

        @Override
        public final Builder copyAllowed(String copyAllowed) {
            this.copyAllowed = copyAllowed;
            return this;
        }

        @Override
        public final Builder copyAllowed(EnabledType copyAllowed) {
            this.copyAllowed(copyAllowed == null ? null : copyAllowed.toString());
            return this;
        }

        public final Integer getDisconnectTimeoutInMinutes() {
            return disconnectTimeoutInMinutes;
        }

        public final void setDisconnectTimeoutInMinutes(Integer disconnectTimeoutInMinutes) {
            this.disconnectTimeoutInMinutes = disconnectTimeoutInMinutes;
        }

        @Override
        public final Builder disconnectTimeoutInMinutes(Integer disconnectTimeoutInMinutes) {
            this.disconnectTimeoutInMinutes = disconnectTimeoutInMinutes;
            return this;
        }

        public final String getDownloadAllowed() {
            return downloadAllowed;
        }

        public final void setDownloadAllowed(String downloadAllowed) {
            this.downloadAllowed = downloadAllowed;
        }

        @Override
        public final Builder downloadAllowed(String downloadAllowed) {
            this.downloadAllowed = downloadAllowed;
            return this;
        }

        @Override
        public final Builder downloadAllowed(EnabledType downloadAllowed) {
            this.downloadAllowed(downloadAllowed == null ? null : downloadAllowed.toString());
            return this;
        }

        public final Integer getIdleDisconnectTimeoutInMinutes() {
            return idleDisconnectTimeoutInMinutes;
        }

        public final void setIdleDisconnectTimeoutInMinutes(Integer idleDisconnectTimeoutInMinutes) {
            this.idleDisconnectTimeoutInMinutes = idleDisconnectTimeoutInMinutes;
        }

        @Override
        public final Builder idleDisconnectTimeoutInMinutes(Integer idleDisconnectTimeoutInMinutes) {
            this.idleDisconnectTimeoutInMinutes = idleDisconnectTimeoutInMinutes;
            return this;
        }

        public final String getPasteAllowed() {
            return pasteAllowed;
        }

        public final void setPasteAllowed(String pasteAllowed) {
            this.pasteAllowed = pasteAllowed;
        }

        @Override
        public final Builder pasteAllowed(String pasteAllowed) {
            this.pasteAllowed = pasteAllowed;
            return this;
        }

        @Override
        public final Builder pasteAllowed(EnabledType pasteAllowed) {
            this.pasteAllowed(pasteAllowed == null ? null : pasteAllowed.toString());
            return this;
        }

        public final String getPrintAllowed() {
            return printAllowed;
        }

        public final void setPrintAllowed(String printAllowed) {
            this.printAllowed = printAllowed;
        }

        @Override
        public final Builder printAllowed(String printAllowed) {
            this.printAllowed = printAllowed;
            return this;
        }

        @Override
        public final Builder printAllowed(EnabledType printAllowed) {
            this.printAllowed(printAllowed == null ? null : printAllowed.toString());
            return this;
        }

        public final String getUploadAllowed() {
            return uploadAllowed;
        }

        public final void setUploadAllowed(String uploadAllowed) {
            this.uploadAllowed = uploadAllowed;
        }

        @Override
        public final Builder uploadAllowed(String uploadAllowed) {
            this.uploadAllowed = uploadAllowed;
            return this;
        }

        @Override
        public final Builder uploadAllowed(EnabledType uploadAllowed) {
            this.uploadAllowed(uploadAllowed == null ? null : uploadAllowed.toString());
            return this;
        }

        public final String getUserSettingsArn() {
            return userSettingsArn;
        }

        public final void setUserSettingsArn(String userSettingsArn) {
            this.userSettingsArn = userSettingsArn;
        }

        @Override
        public final Builder userSettingsArn(String userSettingsArn) {
            this.userSettingsArn = userSettingsArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateUserSettingsRequest build() {
            return new UpdateUserSettingsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
