/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspacesweb;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.workspacesweb.model.AssociateBrowserSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.AssociateBrowserSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.AssociateIpAccessSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.AssociateIpAccessSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.AssociateNetworkSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.AssociateNetworkSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.AssociateTrustStoreRequest;
import software.amazon.awssdk.services.workspacesweb.model.AssociateTrustStoreResponse;
import software.amazon.awssdk.services.workspacesweb.model.AssociateUserAccessLoggingSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.AssociateUserAccessLoggingSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.AssociateUserSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.AssociateUserSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.CreateBrowserSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.CreateBrowserSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.CreateIdentityProviderRequest;
import software.amazon.awssdk.services.workspacesweb.model.CreateIdentityProviderResponse;
import software.amazon.awssdk.services.workspacesweb.model.CreateIpAccessSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.CreateIpAccessSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.CreateNetworkSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.CreateNetworkSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.CreatePortalRequest;
import software.amazon.awssdk.services.workspacesweb.model.CreatePortalResponse;
import software.amazon.awssdk.services.workspacesweb.model.CreateTrustStoreRequest;
import software.amazon.awssdk.services.workspacesweb.model.CreateTrustStoreResponse;
import software.amazon.awssdk.services.workspacesweb.model.CreateUserAccessLoggingSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.CreateUserAccessLoggingSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.CreateUserSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.CreateUserSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.DeleteBrowserSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.DeleteBrowserSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.DeleteIdentityProviderRequest;
import software.amazon.awssdk.services.workspacesweb.model.DeleteIdentityProviderResponse;
import software.amazon.awssdk.services.workspacesweb.model.DeleteIpAccessSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.DeleteIpAccessSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.DeleteNetworkSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.DeleteNetworkSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.DeletePortalRequest;
import software.amazon.awssdk.services.workspacesweb.model.DeletePortalResponse;
import software.amazon.awssdk.services.workspacesweb.model.DeleteTrustStoreRequest;
import software.amazon.awssdk.services.workspacesweb.model.DeleteTrustStoreResponse;
import software.amazon.awssdk.services.workspacesweb.model.DeleteUserAccessLoggingSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.DeleteUserAccessLoggingSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.DeleteUserSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.DeleteUserSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.DisassociateBrowserSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.DisassociateBrowserSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.DisassociateIpAccessSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.DisassociateIpAccessSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.DisassociateNetworkSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.DisassociateNetworkSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.DisassociateTrustStoreRequest;
import software.amazon.awssdk.services.workspacesweb.model.DisassociateTrustStoreResponse;
import software.amazon.awssdk.services.workspacesweb.model.DisassociateUserAccessLoggingSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.DisassociateUserAccessLoggingSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.DisassociateUserSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.DisassociateUserSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.GetBrowserSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.GetBrowserSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.GetIdentityProviderRequest;
import software.amazon.awssdk.services.workspacesweb.model.GetIdentityProviderResponse;
import software.amazon.awssdk.services.workspacesweb.model.GetIpAccessSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.GetIpAccessSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.GetNetworkSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.GetNetworkSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.GetPortalRequest;
import software.amazon.awssdk.services.workspacesweb.model.GetPortalResponse;
import software.amazon.awssdk.services.workspacesweb.model.GetPortalServiceProviderMetadataRequest;
import software.amazon.awssdk.services.workspacesweb.model.GetPortalServiceProviderMetadataResponse;
import software.amazon.awssdk.services.workspacesweb.model.GetTrustStoreCertificateRequest;
import software.amazon.awssdk.services.workspacesweb.model.GetTrustStoreCertificateResponse;
import software.amazon.awssdk.services.workspacesweb.model.GetTrustStoreRequest;
import software.amazon.awssdk.services.workspacesweb.model.GetTrustStoreResponse;
import software.amazon.awssdk.services.workspacesweb.model.GetUserAccessLoggingSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.GetUserAccessLoggingSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.GetUserSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.GetUserSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.ListBrowserSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.ListBrowserSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.ListIdentityProvidersRequest;
import software.amazon.awssdk.services.workspacesweb.model.ListIdentityProvidersResponse;
import software.amazon.awssdk.services.workspacesweb.model.ListIpAccessSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.ListIpAccessSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.ListNetworkSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.ListNetworkSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.ListPortalsRequest;
import software.amazon.awssdk.services.workspacesweb.model.ListPortalsResponse;
import software.amazon.awssdk.services.workspacesweb.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.workspacesweb.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.workspacesweb.model.ListTrustStoreCertificatesRequest;
import software.amazon.awssdk.services.workspacesweb.model.ListTrustStoreCertificatesResponse;
import software.amazon.awssdk.services.workspacesweb.model.ListTrustStoresRequest;
import software.amazon.awssdk.services.workspacesweb.model.ListTrustStoresResponse;
import software.amazon.awssdk.services.workspacesweb.model.ListUserAccessLoggingSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.ListUserAccessLoggingSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.ListUserSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.ListUserSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.TagResourceRequest;
import software.amazon.awssdk.services.workspacesweb.model.TagResourceResponse;
import software.amazon.awssdk.services.workspacesweb.model.UntagResourceRequest;
import software.amazon.awssdk.services.workspacesweb.model.UntagResourceResponse;
import software.amazon.awssdk.services.workspacesweb.model.UpdateBrowserSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.UpdateBrowserSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.UpdateIdentityProviderRequest;
import software.amazon.awssdk.services.workspacesweb.model.UpdateIdentityProviderResponse;
import software.amazon.awssdk.services.workspacesweb.model.UpdateIpAccessSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.UpdateIpAccessSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.UpdateNetworkSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.UpdateNetworkSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.UpdatePortalRequest;
import software.amazon.awssdk.services.workspacesweb.model.UpdatePortalResponse;
import software.amazon.awssdk.services.workspacesweb.model.UpdateTrustStoreRequest;
import software.amazon.awssdk.services.workspacesweb.model.UpdateTrustStoreResponse;
import software.amazon.awssdk.services.workspacesweb.model.UpdateUserAccessLoggingSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.UpdateUserAccessLoggingSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.model.UpdateUserSettingsRequest;
import software.amazon.awssdk.services.workspacesweb.model.UpdateUserSettingsResponse;
import software.amazon.awssdk.services.workspacesweb.paginators.ListBrowserSettingsPublisher;
import software.amazon.awssdk.services.workspacesweb.paginators.ListIdentityProvidersPublisher;
import software.amazon.awssdk.services.workspacesweb.paginators.ListIpAccessSettingsPublisher;
import software.amazon.awssdk.services.workspacesweb.paginators.ListNetworkSettingsPublisher;
import software.amazon.awssdk.services.workspacesweb.paginators.ListPortalsPublisher;
import software.amazon.awssdk.services.workspacesweb.paginators.ListTrustStoreCertificatesPublisher;
import software.amazon.awssdk.services.workspacesweb.paginators.ListTrustStoresPublisher;
import software.amazon.awssdk.services.workspacesweb.paginators.ListUserAccessLoggingSettingsPublisher;
import software.amazon.awssdk.services.workspacesweb.paginators.ListUserSettingsPublisher;

/**
 * Service client for accessing Amazon WorkSpaces Web asynchronously. This can be created using the static
 * {@link #builder()} method.The asynchronous client performs non-blocking I/O when configured with any
 * {@link SdkAsyncHttpClient} supported in the SDK. However, full non-blocking is not guaranteed as the async client may
 * perform blocking calls in some cases such as credentials retrieval and endpoint discovery as part of the async API
 * call.
 *
 * <p>
 * WorkSpaces Web is a low cost, fully managed WorkSpace built specifically to facilitate secure, web-based workloads.
 * WorkSpaces Web makes it easy for customers to safely provide their employees with access to internal websites and
 * SaaS web applications without the administrative burden of appliances or specialized client software. WorkSpaces Web
 * provides simple policy tools tailored for user interactions, while offloading common tasks like capacity management,
 * scaling, and maintaining browser images.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface WorkSpacesWebAsyncClient extends AwsClient {
    String SERVICE_NAME = "workspaces-web";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "workspaces-web";

    /**
     * <p>
     * Associates a browser settings resource with a web portal.
     * </p>
     *
     * @param associateBrowserSettingsRequest
     * @return A Java Future containing the result of the AssociateBrowserSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>ConflictException There is a conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.AssociateBrowserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/AssociateBrowserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateBrowserSettingsResponse> associateBrowserSettings(
            AssociateBrowserSettingsRequest associateBrowserSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a browser settings resource with a web portal.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateBrowserSettingsRequest.Builder} avoiding
     * the need to create one manually via {@link AssociateBrowserSettingsRequest#builder()}
     * </p>
     *
     * @param associateBrowserSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.AssociateBrowserSettingsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the AssociateBrowserSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>ConflictException There is a conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.AssociateBrowserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/AssociateBrowserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateBrowserSettingsResponse> associateBrowserSettings(
            Consumer<AssociateBrowserSettingsRequest.Builder> associateBrowserSettingsRequest) {
        return associateBrowserSettings(AssociateBrowserSettingsRequest.builder().applyMutation(associateBrowserSettingsRequest)
                .build());
    }

    /**
     * <p>
     * Associates an IP access settings resource with a web portal.
     * </p>
     *
     * @param associateIpAccessSettingsRequest
     * @return A Java Future containing the result of the AssociateIpAccessSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>ConflictException There is a conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.AssociateIpAccessSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/AssociateIpAccessSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateIpAccessSettingsResponse> associateIpAccessSettings(
            AssociateIpAccessSettingsRequest associateIpAccessSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates an IP access settings resource with a web portal.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateIpAccessSettingsRequest.Builder} avoiding
     * the need to create one manually via {@link AssociateIpAccessSettingsRequest#builder()}
     * </p>
     *
     * @param associateIpAccessSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.AssociateIpAccessSettingsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the AssociateIpAccessSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>ConflictException There is a conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.AssociateIpAccessSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/AssociateIpAccessSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateIpAccessSettingsResponse> associateIpAccessSettings(
            Consumer<AssociateIpAccessSettingsRequest.Builder> associateIpAccessSettingsRequest) {
        return associateIpAccessSettings(AssociateIpAccessSettingsRequest.builder()
                .applyMutation(associateIpAccessSettingsRequest).build());
    }

    /**
     * <p>
     * Associates a network settings resource with a web portal.
     * </p>
     *
     * @param associateNetworkSettingsRequest
     * @return A Java Future containing the result of the AssociateNetworkSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>ConflictException There is a conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.AssociateNetworkSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/AssociateNetworkSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateNetworkSettingsResponse> associateNetworkSettings(
            AssociateNetworkSettingsRequest associateNetworkSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a network settings resource with a web portal.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateNetworkSettingsRequest.Builder} avoiding
     * the need to create one manually via {@link AssociateNetworkSettingsRequest#builder()}
     * </p>
     *
     * @param associateNetworkSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.AssociateNetworkSettingsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the AssociateNetworkSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>ConflictException There is a conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.AssociateNetworkSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/AssociateNetworkSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateNetworkSettingsResponse> associateNetworkSettings(
            Consumer<AssociateNetworkSettingsRequest.Builder> associateNetworkSettingsRequest) {
        return associateNetworkSettings(AssociateNetworkSettingsRequest.builder().applyMutation(associateNetworkSettingsRequest)
                .build());
    }

    /**
     * <p>
     * Associates a trust store with a web portal.
     * </p>
     *
     * @param associateTrustStoreRequest
     * @return A Java Future containing the result of the AssociateTrustStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.AssociateTrustStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/AssociateTrustStore"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateTrustStoreResponse> associateTrustStore(
            AssociateTrustStoreRequest associateTrustStoreRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a trust store with a web portal.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateTrustStoreRequest.Builder} avoiding the
     * need to create one manually via {@link AssociateTrustStoreRequest#builder()}
     * </p>
     *
     * @param associateTrustStoreRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.AssociateTrustStoreRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AssociateTrustStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.AssociateTrustStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/AssociateTrustStore"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateTrustStoreResponse> associateTrustStore(
            Consumer<AssociateTrustStoreRequest.Builder> associateTrustStoreRequest) {
        return associateTrustStore(AssociateTrustStoreRequest.builder().applyMutation(associateTrustStoreRequest).build());
    }

    /**
     * <p>
     * Associates a user access logging settings resource with a web portal.
     * </p>
     *
     * @param associateUserAccessLoggingSettingsRequest
     * @return A Java Future containing the result of the AssociateUserAccessLoggingSettings operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>ConflictException There is a conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.AssociateUserAccessLoggingSettings
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/AssociateUserAccessLoggingSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateUserAccessLoggingSettingsResponse> associateUserAccessLoggingSettings(
            AssociateUserAccessLoggingSettingsRequest associateUserAccessLoggingSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a user access logging settings resource with a web portal.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateUserAccessLoggingSettingsRequest.Builder}
     * avoiding the need to create one manually via {@link AssociateUserAccessLoggingSettingsRequest#builder()}
     * </p>
     *
     * @param associateUserAccessLoggingSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.AssociateUserAccessLoggingSettingsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the AssociateUserAccessLoggingSettings operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>ConflictException There is a conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.AssociateUserAccessLoggingSettings
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/AssociateUserAccessLoggingSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateUserAccessLoggingSettingsResponse> associateUserAccessLoggingSettings(
            Consumer<AssociateUserAccessLoggingSettingsRequest.Builder> associateUserAccessLoggingSettingsRequest) {
        return associateUserAccessLoggingSettings(AssociateUserAccessLoggingSettingsRequest.builder()
                .applyMutation(associateUserAccessLoggingSettingsRequest).build());
    }

    /**
     * <p>
     * Associates a user settings resource with a web portal.
     * </p>
     *
     * @param associateUserSettingsRequest
     * @return A Java Future containing the result of the AssociateUserSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>ConflictException There is a conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.AssociateUserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/AssociateUserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateUserSettingsResponse> associateUserSettings(
            AssociateUserSettingsRequest associateUserSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a user settings resource with a web portal.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateUserSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link AssociateUserSettingsRequest#builder()}
     * </p>
     *
     * @param associateUserSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.AssociateUserSettingsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the AssociateUserSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>ConflictException There is a conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.AssociateUserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/AssociateUserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateUserSettingsResponse> associateUserSettings(
            Consumer<AssociateUserSettingsRequest.Builder> associateUserSettingsRequest) {
        return associateUserSettings(AssociateUserSettingsRequest.builder().applyMutation(associateUserSettingsRequest).build());
    }

    /**
     * <p>
     * Creates a browser settings resource that can be associated with a web portal. Once associated with a web portal,
     * browser settings control how the browser will behave once a user starts a streaming session for the web portal.
     * </p>
     *
     * @param createBrowserSettingsRequest
     * @return A Java Future containing the result of the CreateBrowserSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>ConflictException There is a conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.CreateBrowserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/CreateBrowserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateBrowserSettingsResponse> createBrowserSettings(
            CreateBrowserSettingsRequest createBrowserSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a browser settings resource that can be associated with a web portal. Once associated with a web portal,
     * browser settings control how the browser will behave once a user starts a streaming session for the web portal.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateBrowserSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link CreateBrowserSettingsRequest#builder()}
     * </p>
     *
     * @param createBrowserSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.CreateBrowserSettingsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the CreateBrowserSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>ConflictException There is a conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.CreateBrowserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/CreateBrowserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateBrowserSettingsResponse> createBrowserSettings(
            Consumer<CreateBrowserSettingsRequest.Builder> createBrowserSettingsRequest) {
        return createBrowserSettings(CreateBrowserSettingsRequest.builder().applyMutation(createBrowserSettingsRequest).build());
    }

    /**
     * <p>
     * Creates an identity provider resource that is then associated with a web portal.
     * </p>
     *
     * @param createIdentityProviderRequest
     * @return A Java Future containing the result of the CreateIdentityProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>ConflictException There is a conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.CreateIdentityProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/CreateIdentityProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateIdentityProviderResponse> createIdentityProvider(
            CreateIdentityProviderRequest createIdentityProviderRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an identity provider resource that is then associated with a web portal.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateIdentityProviderRequest.Builder} avoiding the
     * need to create one manually via {@link CreateIdentityProviderRequest#builder()}
     * </p>
     *
     * @param createIdentityProviderRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.CreateIdentityProviderRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateIdentityProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>ConflictException There is a conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.CreateIdentityProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/CreateIdentityProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateIdentityProviderResponse> createIdentityProvider(
            Consumer<CreateIdentityProviderRequest.Builder> createIdentityProviderRequest) {
        return createIdentityProvider(CreateIdentityProviderRequest.builder().applyMutation(createIdentityProviderRequest)
                .build());
    }

    /**
     * <p>
     * Creates an IP access settings resource that can be associated with a web portal.
     * </p>
     *
     * @param createIpAccessSettingsRequest
     * @return A Java Future containing the result of the CreateIpAccessSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>ConflictException There is a conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.CreateIpAccessSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/CreateIpAccessSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateIpAccessSettingsResponse> createIpAccessSettings(
            CreateIpAccessSettingsRequest createIpAccessSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an IP access settings resource that can be associated with a web portal.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateIpAccessSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link CreateIpAccessSettingsRequest#builder()}
     * </p>
     *
     * @param createIpAccessSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.CreateIpAccessSettingsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateIpAccessSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>ConflictException There is a conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.CreateIpAccessSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/CreateIpAccessSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateIpAccessSettingsResponse> createIpAccessSettings(
            Consumer<CreateIpAccessSettingsRequest.Builder> createIpAccessSettingsRequest) {
        return createIpAccessSettings(CreateIpAccessSettingsRequest.builder().applyMutation(createIpAccessSettingsRequest)
                .build());
    }

    /**
     * <p>
     * Creates a network settings resource that can be associated with a web portal. Once associated with a web portal,
     * network settings define how streaming instances will connect with your specified VPC.
     * </p>
     *
     * @param createNetworkSettingsRequest
     * @return A Java Future containing the result of the CreateNetworkSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>ConflictException There is a conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.CreateNetworkSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/CreateNetworkSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateNetworkSettingsResponse> createNetworkSettings(
            CreateNetworkSettingsRequest createNetworkSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a network settings resource that can be associated with a web portal. Once associated with a web portal,
     * network settings define how streaming instances will connect with your specified VPC.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateNetworkSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link CreateNetworkSettingsRequest#builder()}
     * </p>
     *
     * @param createNetworkSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.CreateNetworkSettingsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the CreateNetworkSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>ConflictException There is a conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.CreateNetworkSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/CreateNetworkSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateNetworkSettingsResponse> createNetworkSettings(
            Consumer<CreateNetworkSettingsRequest.Builder> createNetworkSettingsRequest) {
        return createNetworkSettings(CreateNetworkSettingsRequest.builder().applyMutation(createNetworkSettingsRequest).build());
    }

    /**
     * <p>
     * Creates a web portal.
     * </p>
     *
     * @param createPortalRequest
     * @return A Java Future containing the result of the CreatePortal operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>ConflictException There is a conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.CreatePortal
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/CreatePortal" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreatePortalResponse> createPortal(CreatePortalRequest createPortalRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a web portal.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePortalRequest.Builder} avoiding the need to
     * create one manually via {@link CreatePortalRequest#builder()}
     * </p>
     *
     * @param createPortalRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.CreatePortalRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreatePortal operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>ConflictException There is a conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.CreatePortal
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/CreatePortal" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreatePortalResponse> createPortal(Consumer<CreatePortalRequest.Builder> createPortalRequest) {
        return createPortal(CreatePortalRequest.builder().applyMutation(createPortalRequest).build());
    }

    /**
     * <p>
     * Creates a trust store that can be associated with a web portal. A trust store contains certificate authority (CA)
     * certificates. Once associated with a web portal, the browser in a streaming session will recognize certificates
     * that have been issued using any of the CAs in the trust store. If your organization has internal websites that
     * use certificates issued by private CAs, you should add the private CA certificate to the trust store.
     * </p>
     *
     * @param createTrustStoreRequest
     * @return A Java Future containing the result of the CreateTrustStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>ConflictException There is a conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.CreateTrustStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/CreateTrustStore"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateTrustStoreResponse> createTrustStore(CreateTrustStoreRequest createTrustStoreRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a trust store that can be associated with a web portal. A trust store contains certificate authority (CA)
     * certificates. Once associated with a web portal, the browser in a streaming session will recognize certificates
     * that have been issued using any of the CAs in the trust store. If your organization has internal websites that
     * use certificates issued by private CAs, you should add the private CA certificate to the trust store.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTrustStoreRequest.Builder} avoiding the need
     * to create one manually via {@link CreateTrustStoreRequest#builder()}
     * </p>
     *
     * @param createTrustStoreRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.CreateTrustStoreRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateTrustStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>ConflictException There is a conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.CreateTrustStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/CreateTrustStore"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateTrustStoreResponse> createTrustStore(
            Consumer<CreateTrustStoreRequest.Builder> createTrustStoreRequest) {
        return createTrustStore(CreateTrustStoreRequest.builder().applyMutation(createTrustStoreRequest).build());
    }

    /**
     * <p>
     * Creates a user access logging settings resource that can be associated with a web portal.
     * </p>
     *
     * @param createUserAccessLoggingSettingsRequest
     * @return A Java Future containing the result of the CreateUserAccessLoggingSettings operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>ConflictException There is a conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.CreateUserAccessLoggingSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/CreateUserAccessLoggingSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateUserAccessLoggingSettingsResponse> createUserAccessLoggingSettings(
            CreateUserAccessLoggingSettingsRequest createUserAccessLoggingSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a user access logging settings resource that can be associated with a web portal.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateUserAccessLoggingSettingsRequest.Builder}
     * avoiding the need to create one manually via {@link CreateUserAccessLoggingSettingsRequest#builder()}
     * </p>
     *
     * @param createUserAccessLoggingSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.CreateUserAccessLoggingSettingsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the CreateUserAccessLoggingSettings operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>ConflictException There is a conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.CreateUserAccessLoggingSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/CreateUserAccessLoggingSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateUserAccessLoggingSettingsResponse> createUserAccessLoggingSettings(
            Consumer<CreateUserAccessLoggingSettingsRequest.Builder> createUserAccessLoggingSettingsRequest) {
        return createUserAccessLoggingSettings(CreateUserAccessLoggingSettingsRequest.builder()
                .applyMutation(createUserAccessLoggingSettingsRequest).build());
    }

    /**
     * <p>
     * Creates a user settings resource that can be associated with a web portal. Once associated with a web portal,
     * user settings control how users can transfer data between a streaming session and the their local devices.
     * </p>
     *
     * @param createUserSettingsRequest
     * @return A Java Future containing the result of the CreateUserSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>ConflictException There is a conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.CreateUserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/CreateUserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateUserSettingsResponse> createUserSettings(CreateUserSettingsRequest createUserSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a user settings resource that can be associated with a web portal. Once associated with a web portal,
     * user settings control how users can transfer data between a streaming session and the their local devices.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateUserSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link CreateUserSettingsRequest#builder()}
     * </p>
     *
     * @param createUserSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.CreateUserSettingsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateUserSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>ConflictException There is a conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.CreateUserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/CreateUserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateUserSettingsResponse> createUserSettings(
            Consumer<CreateUserSettingsRequest.Builder> createUserSettingsRequest) {
        return createUserSettings(CreateUserSettingsRequest.builder().applyMutation(createUserSettingsRequest).build());
    }

    /**
     * <p>
     * Deletes browser settings.
     * </p>
     *
     * @param deleteBrowserSettingsRequest
     * @return A Java Future containing the result of the DeleteBrowserSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>ConflictException There is a conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.DeleteBrowserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DeleteBrowserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteBrowserSettingsResponse> deleteBrowserSettings(
            DeleteBrowserSettingsRequest deleteBrowserSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes browser settings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteBrowserSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteBrowserSettingsRequest#builder()}
     * </p>
     *
     * @param deleteBrowserSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.DeleteBrowserSettingsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DeleteBrowserSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>ConflictException There is a conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.DeleteBrowserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DeleteBrowserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteBrowserSettingsResponse> deleteBrowserSettings(
            Consumer<DeleteBrowserSettingsRequest.Builder> deleteBrowserSettingsRequest) {
        return deleteBrowserSettings(DeleteBrowserSettingsRequest.builder().applyMutation(deleteBrowserSettingsRequest).build());
    }

    /**
     * <p>
     * Deletes the identity provider.
     * </p>
     *
     * @param deleteIdentityProviderRequest
     * @return A Java Future containing the result of the DeleteIdentityProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>ConflictException There is a conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.DeleteIdentityProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DeleteIdentityProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteIdentityProviderResponse> deleteIdentityProvider(
            DeleteIdentityProviderRequest deleteIdentityProviderRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the identity provider.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteIdentityProviderRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteIdentityProviderRequest#builder()}
     * </p>
     *
     * @param deleteIdentityProviderRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.DeleteIdentityProviderRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteIdentityProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>ConflictException There is a conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.DeleteIdentityProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DeleteIdentityProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteIdentityProviderResponse> deleteIdentityProvider(
            Consumer<DeleteIdentityProviderRequest.Builder> deleteIdentityProviderRequest) {
        return deleteIdentityProvider(DeleteIdentityProviderRequest.builder().applyMutation(deleteIdentityProviderRequest)
                .build());
    }

    /**
     * <p>
     * Deletes IP access settings.
     * </p>
     *
     * @param deleteIpAccessSettingsRequest
     * @return A Java Future containing the result of the DeleteIpAccessSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>ConflictException There is a conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.DeleteIpAccessSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DeleteIpAccessSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteIpAccessSettingsResponse> deleteIpAccessSettings(
            DeleteIpAccessSettingsRequest deleteIpAccessSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes IP access settings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteIpAccessSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteIpAccessSettingsRequest#builder()}
     * </p>
     *
     * @param deleteIpAccessSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.DeleteIpAccessSettingsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteIpAccessSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>ConflictException There is a conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.DeleteIpAccessSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DeleteIpAccessSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteIpAccessSettingsResponse> deleteIpAccessSettings(
            Consumer<DeleteIpAccessSettingsRequest.Builder> deleteIpAccessSettingsRequest) {
        return deleteIpAccessSettings(DeleteIpAccessSettingsRequest.builder().applyMutation(deleteIpAccessSettingsRequest)
                .build());
    }

    /**
     * <p>
     * Deletes network settings.
     * </p>
     *
     * @param deleteNetworkSettingsRequest
     * @return A Java Future containing the result of the DeleteNetworkSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>ConflictException There is a conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.DeleteNetworkSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DeleteNetworkSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteNetworkSettingsResponse> deleteNetworkSettings(
            DeleteNetworkSettingsRequest deleteNetworkSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes network settings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteNetworkSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteNetworkSettingsRequest#builder()}
     * </p>
     *
     * @param deleteNetworkSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.DeleteNetworkSettingsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DeleteNetworkSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>ConflictException There is a conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.DeleteNetworkSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DeleteNetworkSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteNetworkSettingsResponse> deleteNetworkSettings(
            Consumer<DeleteNetworkSettingsRequest.Builder> deleteNetworkSettingsRequest) {
        return deleteNetworkSettings(DeleteNetworkSettingsRequest.builder().applyMutation(deleteNetworkSettingsRequest).build());
    }

    /**
     * <p>
     * Deletes a web portal.
     * </p>
     *
     * @param deletePortalRequest
     * @return A Java Future containing the result of the DeletePortal operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>ConflictException There is a conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.DeletePortal
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DeletePortal" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeletePortalResponse> deletePortal(DeletePortalRequest deletePortalRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a web portal.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePortalRequest.Builder} avoiding the need to
     * create one manually via {@link DeletePortalRequest#builder()}
     * </p>
     *
     * @param deletePortalRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.DeletePortalRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeletePortal operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>ConflictException There is a conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.DeletePortal
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DeletePortal" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeletePortalResponse> deletePortal(Consumer<DeletePortalRequest.Builder> deletePortalRequest) {
        return deletePortal(DeletePortalRequest.builder().applyMutation(deletePortalRequest).build());
    }

    /**
     * <p>
     * Deletes the trust store.
     * </p>
     *
     * @param deleteTrustStoreRequest
     * @return A Java Future containing the result of the DeleteTrustStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>ConflictException There is a conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.DeleteTrustStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DeleteTrustStore"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteTrustStoreResponse> deleteTrustStore(DeleteTrustStoreRequest deleteTrustStoreRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the trust store.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTrustStoreRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteTrustStoreRequest#builder()}
     * </p>
     *
     * @param deleteTrustStoreRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.DeleteTrustStoreRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteTrustStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>ConflictException There is a conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.DeleteTrustStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DeleteTrustStore"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteTrustStoreResponse> deleteTrustStore(
            Consumer<DeleteTrustStoreRequest.Builder> deleteTrustStoreRequest) {
        return deleteTrustStore(DeleteTrustStoreRequest.builder().applyMutation(deleteTrustStoreRequest).build());
    }

    /**
     * <p>
     * Deletes user access logging settings.
     * </p>
     *
     * @param deleteUserAccessLoggingSettingsRequest
     * @return A Java Future containing the result of the DeleteUserAccessLoggingSettings operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>ConflictException There is a conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.DeleteUserAccessLoggingSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DeleteUserAccessLoggingSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteUserAccessLoggingSettingsResponse> deleteUserAccessLoggingSettings(
            DeleteUserAccessLoggingSettingsRequest deleteUserAccessLoggingSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes user access logging settings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteUserAccessLoggingSettingsRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteUserAccessLoggingSettingsRequest#builder()}
     * </p>
     *
     * @param deleteUserAccessLoggingSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.DeleteUserAccessLoggingSettingsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DeleteUserAccessLoggingSettings operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>ConflictException There is a conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.DeleteUserAccessLoggingSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DeleteUserAccessLoggingSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteUserAccessLoggingSettingsResponse> deleteUserAccessLoggingSettings(
            Consumer<DeleteUserAccessLoggingSettingsRequest.Builder> deleteUserAccessLoggingSettingsRequest) {
        return deleteUserAccessLoggingSettings(DeleteUserAccessLoggingSettingsRequest.builder()
                .applyMutation(deleteUserAccessLoggingSettingsRequest).build());
    }

    /**
     * <p>
     * Deletes user settings.
     * </p>
     *
     * @param deleteUserSettingsRequest
     * @return A Java Future containing the result of the DeleteUserSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>ConflictException There is a conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.DeleteUserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DeleteUserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteUserSettingsResponse> deleteUserSettings(DeleteUserSettingsRequest deleteUserSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes user settings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteUserSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteUserSettingsRequest#builder()}
     * </p>
     *
     * @param deleteUserSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.DeleteUserSettingsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteUserSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>ConflictException There is a conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.DeleteUserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DeleteUserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteUserSettingsResponse> deleteUserSettings(
            Consumer<DeleteUserSettingsRequest.Builder> deleteUserSettingsRequest) {
        return deleteUserSettings(DeleteUserSettingsRequest.builder().applyMutation(deleteUserSettingsRequest).build());
    }

    /**
     * <p>
     * Disassociates browser settings from a web portal.
     * </p>
     *
     * @param disassociateBrowserSettingsRequest
     * @return A Java Future containing the result of the DisassociateBrowserSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.DisassociateBrowserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DisassociateBrowserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateBrowserSettingsResponse> disassociateBrowserSettings(
            DisassociateBrowserSettingsRequest disassociateBrowserSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates browser settings from a web portal.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateBrowserSettingsRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateBrowserSettingsRequest#builder()}
     * </p>
     *
     * @param disassociateBrowserSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.DisassociateBrowserSettingsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DisassociateBrowserSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.DisassociateBrowserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DisassociateBrowserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateBrowserSettingsResponse> disassociateBrowserSettings(
            Consumer<DisassociateBrowserSettingsRequest.Builder> disassociateBrowserSettingsRequest) {
        return disassociateBrowserSettings(DisassociateBrowserSettingsRequest.builder()
                .applyMutation(disassociateBrowserSettingsRequest).build());
    }

    /**
     * <p>
     * Disassociates IP access settings from a web portal.
     * </p>
     *
     * @param disassociateIpAccessSettingsRequest
     * @return A Java Future containing the result of the DisassociateIpAccessSettings operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.DisassociateIpAccessSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DisassociateIpAccessSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateIpAccessSettingsResponse> disassociateIpAccessSettings(
            DisassociateIpAccessSettingsRequest disassociateIpAccessSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates IP access settings from a web portal.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateIpAccessSettingsRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateIpAccessSettingsRequest#builder()}
     * </p>
     *
     * @param disassociateIpAccessSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.DisassociateIpAccessSettingsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DisassociateIpAccessSettings operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.DisassociateIpAccessSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DisassociateIpAccessSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateIpAccessSettingsResponse> disassociateIpAccessSettings(
            Consumer<DisassociateIpAccessSettingsRequest.Builder> disassociateIpAccessSettingsRequest) {
        return disassociateIpAccessSettings(DisassociateIpAccessSettingsRequest.builder()
                .applyMutation(disassociateIpAccessSettingsRequest).build());
    }

    /**
     * <p>
     * Disassociates network settings from a web portal.
     * </p>
     *
     * @param disassociateNetworkSettingsRequest
     * @return A Java Future containing the result of the DisassociateNetworkSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.DisassociateNetworkSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DisassociateNetworkSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateNetworkSettingsResponse> disassociateNetworkSettings(
            DisassociateNetworkSettingsRequest disassociateNetworkSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates network settings from a web portal.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateNetworkSettingsRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateNetworkSettingsRequest#builder()}
     * </p>
     *
     * @param disassociateNetworkSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.DisassociateNetworkSettingsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DisassociateNetworkSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.DisassociateNetworkSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DisassociateNetworkSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateNetworkSettingsResponse> disassociateNetworkSettings(
            Consumer<DisassociateNetworkSettingsRequest.Builder> disassociateNetworkSettingsRequest) {
        return disassociateNetworkSettings(DisassociateNetworkSettingsRequest.builder()
                .applyMutation(disassociateNetworkSettingsRequest).build());
    }

    /**
     * <p>
     * Disassociates a trust store from a web portal.
     * </p>
     *
     * @param disassociateTrustStoreRequest
     * @return A Java Future containing the result of the DisassociateTrustStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.DisassociateTrustStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DisassociateTrustStore"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateTrustStoreResponse> disassociateTrustStore(
            DisassociateTrustStoreRequest disassociateTrustStoreRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates a trust store from a web portal.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateTrustStoreRequest.Builder} avoiding the
     * need to create one manually via {@link DisassociateTrustStoreRequest#builder()}
     * </p>
     *
     * @param disassociateTrustStoreRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.DisassociateTrustStoreRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DisassociateTrustStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.DisassociateTrustStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DisassociateTrustStore"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateTrustStoreResponse> disassociateTrustStore(
            Consumer<DisassociateTrustStoreRequest.Builder> disassociateTrustStoreRequest) {
        return disassociateTrustStore(DisassociateTrustStoreRequest.builder().applyMutation(disassociateTrustStoreRequest)
                .build());
    }

    /**
     * <p>
     * Disassociates user access logging settings from a web portal.
     * </p>
     *
     * @param disassociateUserAccessLoggingSettingsRequest
     * @return A Java Future containing the result of the DisassociateUserAccessLoggingSettings operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.DisassociateUserAccessLoggingSettings
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DisassociateUserAccessLoggingSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateUserAccessLoggingSettingsResponse> disassociateUserAccessLoggingSettings(
            DisassociateUserAccessLoggingSettingsRequest disassociateUserAccessLoggingSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates user access logging settings from a web portal.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DisassociateUserAccessLoggingSettingsRequest.Builder} avoiding the need to create one manually via
     * {@link DisassociateUserAccessLoggingSettingsRequest#builder()}
     * </p>
     *
     * @param disassociateUserAccessLoggingSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.DisassociateUserAccessLoggingSettingsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DisassociateUserAccessLoggingSettings operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.DisassociateUserAccessLoggingSettings
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DisassociateUserAccessLoggingSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateUserAccessLoggingSettingsResponse> disassociateUserAccessLoggingSettings(
            Consumer<DisassociateUserAccessLoggingSettingsRequest.Builder> disassociateUserAccessLoggingSettingsRequest) {
        return disassociateUserAccessLoggingSettings(DisassociateUserAccessLoggingSettingsRequest.builder()
                .applyMutation(disassociateUserAccessLoggingSettingsRequest).build());
    }

    /**
     * <p>
     * Disassociates user settings from a web portal.
     * </p>
     *
     * @param disassociateUserSettingsRequest
     * @return A Java Future containing the result of the DisassociateUserSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.DisassociateUserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DisassociateUserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateUserSettingsResponse> disassociateUserSettings(
            DisassociateUserSettingsRequest disassociateUserSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates user settings from a web portal.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateUserSettingsRequest.Builder} avoiding
     * the need to create one manually via {@link DisassociateUserSettingsRequest#builder()}
     * </p>
     *
     * @param disassociateUserSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.DisassociateUserSettingsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DisassociateUserSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.DisassociateUserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/DisassociateUserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateUserSettingsResponse> disassociateUserSettings(
            Consumer<DisassociateUserSettingsRequest.Builder> disassociateUserSettingsRequest) {
        return disassociateUserSettings(DisassociateUserSettingsRequest.builder().applyMutation(disassociateUserSettingsRequest)
                .build());
    }

    /**
     * <p>
     * Gets browser settings.
     * </p>
     *
     * @param getBrowserSettingsRequest
     * @return A Java Future containing the result of the GetBrowserSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.GetBrowserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/GetBrowserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetBrowserSettingsResponse> getBrowserSettings(GetBrowserSettingsRequest getBrowserSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets browser settings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetBrowserSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link GetBrowserSettingsRequest#builder()}
     * </p>
     *
     * @param getBrowserSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.GetBrowserSettingsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetBrowserSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.GetBrowserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/GetBrowserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetBrowserSettingsResponse> getBrowserSettings(
            Consumer<GetBrowserSettingsRequest.Builder> getBrowserSettingsRequest) {
        return getBrowserSettings(GetBrowserSettingsRequest.builder().applyMutation(getBrowserSettingsRequest).build());
    }

    /**
     * <p>
     * Gets the identity provider.
     * </p>
     *
     * @param getIdentityProviderRequest
     * @return A Java Future containing the result of the GetIdentityProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.GetIdentityProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/GetIdentityProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetIdentityProviderResponse> getIdentityProvider(
            GetIdentityProviderRequest getIdentityProviderRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the identity provider.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetIdentityProviderRequest.Builder} avoiding the
     * need to create one manually via {@link GetIdentityProviderRequest#builder()}
     * </p>
     *
     * @param getIdentityProviderRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.GetIdentityProviderRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetIdentityProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.GetIdentityProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/GetIdentityProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetIdentityProviderResponse> getIdentityProvider(
            Consumer<GetIdentityProviderRequest.Builder> getIdentityProviderRequest) {
        return getIdentityProvider(GetIdentityProviderRequest.builder().applyMutation(getIdentityProviderRequest).build());
    }

    /**
     * <p>
     * Gets the IP access settings.
     * </p>
     *
     * @param getIpAccessSettingsRequest
     * @return A Java Future containing the result of the GetIpAccessSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.GetIpAccessSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/GetIpAccessSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetIpAccessSettingsResponse> getIpAccessSettings(
            GetIpAccessSettingsRequest getIpAccessSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the IP access settings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetIpAccessSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link GetIpAccessSettingsRequest#builder()}
     * </p>
     *
     * @param getIpAccessSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.GetIpAccessSettingsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetIpAccessSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.GetIpAccessSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/GetIpAccessSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetIpAccessSettingsResponse> getIpAccessSettings(
            Consumer<GetIpAccessSettingsRequest.Builder> getIpAccessSettingsRequest) {
        return getIpAccessSettings(GetIpAccessSettingsRequest.builder().applyMutation(getIpAccessSettingsRequest).build());
    }

    /**
     * <p>
     * Gets the network settings.
     * </p>
     *
     * @param getNetworkSettingsRequest
     * @return A Java Future containing the result of the GetNetworkSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.GetNetworkSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/GetNetworkSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetNetworkSettingsResponse> getNetworkSettings(GetNetworkSettingsRequest getNetworkSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the network settings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetNetworkSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link GetNetworkSettingsRequest#builder()}
     * </p>
     *
     * @param getNetworkSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.GetNetworkSettingsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetNetworkSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.GetNetworkSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/GetNetworkSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetNetworkSettingsResponse> getNetworkSettings(
            Consumer<GetNetworkSettingsRequest.Builder> getNetworkSettingsRequest) {
        return getNetworkSettings(GetNetworkSettingsRequest.builder().applyMutation(getNetworkSettingsRequest).build());
    }

    /**
     * <p>
     * Gets the web portal.
     * </p>
     *
     * @param getPortalRequest
     * @return A Java Future containing the result of the GetPortal operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.GetPortal
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/GetPortal" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetPortalResponse> getPortal(GetPortalRequest getPortalRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the web portal.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPortalRequest.Builder} avoiding the need to
     * create one manually via {@link GetPortalRequest#builder()}
     * </p>
     *
     * @param getPortalRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.GetPortalRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetPortal operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.GetPortal
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/GetPortal" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetPortalResponse> getPortal(Consumer<GetPortalRequest.Builder> getPortalRequest) {
        return getPortal(GetPortalRequest.builder().applyMutation(getPortalRequest).build());
    }

    /**
     * <p>
     * Gets the service provider metadata.
     * </p>
     *
     * @param getPortalServiceProviderMetadataRequest
     * @return A Java Future containing the result of the GetPortalServiceProviderMetadata operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.GetPortalServiceProviderMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/GetPortalServiceProviderMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetPortalServiceProviderMetadataResponse> getPortalServiceProviderMetadata(
            GetPortalServiceProviderMetadataRequest getPortalServiceProviderMetadataRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the service provider metadata.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPortalServiceProviderMetadataRequest.Builder}
     * avoiding the need to create one manually via {@link GetPortalServiceProviderMetadataRequest#builder()}
     * </p>
     *
     * @param getPortalServiceProviderMetadataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.GetPortalServiceProviderMetadataRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetPortalServiceProviderMetadata operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.GetPortalServiceProviderMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/GetPortalServiceProviderMetadata"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetPortalServiceProviderMetadataResponse> getPortalServiceProviderMetadata(
            Consumer<GetPortalServiceProviderMetadataRequest.Builder> getPortalServiceProviderMetadataRequest) {
        return getPortalServiceProviderMetadata(GetPortalServiceProviderMetadataRequest.builder()
                .applyMutation(getPortalServiceProviderMetadataRequest).build());
    }

    /**
     * <p>
     * Gets the trust store.
     * </p>
     *
     * @param getTrustStoreRequest
     * @return A Java Future containing the result of the GetTrustStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.GetTrustStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/GetTrustStore" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetTrustStoreResponse> getTrustStore(GetTrustStoreRequest getTrustStoreRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the trust store.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTrustStoreRequest.Builder} avoiding the need to
     * create one manually via {@link GetTrustStoreRequest#builder()}
     * </p>
     *
     * @param getTrustStoreRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.GetTrustStoreRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetTrustStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.GetTrustStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/GetTrustStore" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetTrustStoreResponse> getTrustStore(Consumer<GetTrustStoreRequest.Builder> getTrustStoreRequest) {
        return getTrustStore(GetTrustStoreRequest.builder().applyMutation(getTrustStoreRequest).build());
    }

    /**
     * <p>
     * Gets the trust store certificate.
     * </p>
     *
     * @param getTrustStoreCertificateRequest
     * @return A Java Future containing the result of the GetTrustStoreCertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.GetTrustStoreCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/GetTrustStoreCertificate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetTrustStoreCertificateResponse> getTrustStoreCertificate(
            GetTrustStoreCertificateRequest getTrustStoreCertificateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the trust store certificate.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTrustStoreCertificateRequest.Builder} avoiding
     * the need to create one manually via {@link GetTrustStoreCertificateRequest#builder()}
     * </p>
     *
     * @param getTrustStoreCertificateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.GetTrustStoreCertificateRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetTrustStoreCertificate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.GetTrustStoreCertificate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/GetTrustStoreCertificate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetTrustStoreCertificateResponse> getTrustStoreCertificate(
            Consumer<GetTrustStoreCertificateRequest.Builder> getTrustStoreCertificateRequest) {
        return getTrustStoreCertificate(GetTrustStoreCertificateRequest.builder().applyMutation(getTrustStoreCertificateRequest)
                .build());
    }

    /**
     * <p>
     * Gets user access logging settings.
     * </p>
     *
     * @param getUserAccessLoggingSettingsRequest
     * @return A Java Future containing the result of the GetUserAccessLoggingSettings operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.GetUserAccessLoggingSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/GetUserAccessLoggingSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetUserAccessLoggingSettingsResponse> getUserAccessLoggingSettings(
            GetUserAccessLoggingSettingsRequest getUserAccessLoggingSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets user access logging settings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetUserAccessLoggingSettingsRequest.Builder}
     * avoiding the need to create one manually via {@link GetUserAccessLoggingSettingsRequest#builder()}
     * </p>
     *
     * @param getUserAccessLoggingSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.GetUserAccessLoggingSettingsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetUserAccessLoggingSettings operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.GetUserAccessLoggingSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/GetUserAccessLoggingSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetUserAccessLoggingSettingsResponse> getUserAccessLoggingSettings(
            Consumer<GetUserAccessLoggingSettingsRequest.Builder> getUserAccessLoggingSettingsRequest) {
        return getUserAccessLoggingSettings(GetUserAccessLoggingSettingsRequest.builder()
                .applyMutation(getUserAccessLoggingSettingsRequest).build());
    }

    /**
     * <p>
     * Gets user settings.
     * </p>
     *
     * @param getUserSettingsRequest
     * @return A Java Future containing the result of the GetUserSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.GetUserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/GetUserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetUserSettingsResponse> getUserSettings(GetUserSettingsRequest getUserSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets user settings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetUserSettingsRequest.Builder} avoiding the need
     * to create one manually via {@link GetUserSettingsRequest#builder()}
     * </p>
     *
     * @param getUserSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.GetUserSettingsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetUserSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.GetUserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/GetUserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetUserSettingsResponse> getUserSettings(
            Consumer<GetUserSettingsRequest.Builder> getUserSettingsRequest) {
        return getUserSettings(GetUserSettingsRequest.builder().applyMutation(getUserSettingsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of browser settings.
     * </p>
     *
     * @param listBrowserSettingsRequest
     * @return A Java Future containing the result of the ListBrowserSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.ListBrowserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListBrowserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListBrowserSettingsResponse> listBrowserSettings(
            ListBrowserSettingsRequest listBrowserSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of browser settings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBrowserSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link ListBrowserSettingsRequest#builder()}
     * </p>
     *
     * @param listBrowserSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.ListBrowserSettingsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListBrowserSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.ListBrowserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListBrowserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListBrowserSettingsResponse> listBrowserSettings(
            Consumer<ListBrowserSettingsRequest.Builder> listBrowserSettingsRequest) {
        return listBrowserSettings(ListBrowserSettingsRequest.builder().applyMutation(listBrowserSettingsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listBrowserSettings(software.amazon.awssdk.services.workspacesweb.model.ListBrowserSettingsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListBrowserSettingsPublisher publisher = client.listBrowserSettingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListBrowserSettingsPublisher publisher = client.listBrowserSettingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workspacesweb.model.ListBrowserSettingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workspacesweb.model.ListBrowserSettingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBrowserSettings(software.amazon.awssdk.services.workspacesweb.model.ListBrowserSettingsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listBrowserSettingsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.ListBrowserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListBrowserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBrowserSettingsPublisher listBrowserSettingsPaginator(ListBrowserSettingsRequest listBrowserSettingsRequest) {
        return new ListBrowserSettingsPublisher(this, listBrowserSettingsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listBrowserSettings(software.amazon.awssdk.services.workspacesweb.model.ListBrowserSettingsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListBrowserSettingsPublisher publisher = client.listBrowserSettingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListBrowserSettingsPublisher publisher = client.listBrowserSettingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workspacesweb.model.ListBrowserSettingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workspacesweb.model.ListBrowserSettingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listBrowserSettings(software.amazon.awssdk.services.workspacesweb.model.ListBrowserSettingsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListBrowserSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link ListBrowserSettingsRequest#builder()}
     * </p>
     *
     * @param listBrowserSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.ListBrowserSettingsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.ListBrowserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListBrowserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default ListBrowserSettingsPublisher listBrowserSettingsPaginator(
            Consumer<ListBrowserSettingsRequest.Builder> listBrowserSettingsRequest) {
        return listBrowserSettingsPaginator(ListBrowserSettingsRequest.builder().applyMutation(listBrowserSettingsRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves a list of identity providers for a specific web portal.
     * </p>
     *
     * @param listIdentityProvidersRequest
     * @return A Java Future containing the result of the ListIdentityProviders operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.ListIdentityProviders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListIdentityProviders"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListIdentityProvidersResponse> listIdentityProviders(
            ListIdentityProvidersRequest listIdentityProvidersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of identity providers for a specific web portal.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIdentityProvidersRequest.Builder} avoiding the
     * need to create one manually via {@link ListIdentityProvidersRequest#builder()}
     * </p>
     *
     * @param listIdentityProvidersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.ListIdentityProvidersRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListIdentityProviders operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.ListIdentityProviders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListIdentityProviders"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListIdentityProvidersResponse> listIdentityProviders(
            Consumer<ListIdentityProvidersRequest.Builder> listIdentityProvidersRequest) {
        return listIdentityProviders(ListIdentityProvidersRequest.builder().applyMutation(listIdentityProvidersRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listIdentityProviders(software.amazon.awssdk.services.workspacesweb.model.ListIdentityProvidersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListIdentityProvidersPublisher publisher = client.listIdentityProvidersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListIdentityProvidersPublisher publisher = client.listIdentityProvidersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workspacesweb.model.ListIdentityProvidersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workspacesweb.model.ListIdentityProvidersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIdentityProviders(software.amazon.awssdk.services.workspacesweb.model.ListIdentityProvidersRequest)}
     * operation.</b>
     * </p>
     *
     * @param listIdentityProvidersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.ListIdentityProviders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListIdentityProviders"
     *      target="_top">AWS API Documentation</a>
     */
    default ListIdentityProvidersPublisher listIdentityProvidersPaginator(
            ListIdentityProvidersRequest listIdentityProvidersRequest) {
        return new ListIdentityProvidersPublisher(this, listIdentityProvidersRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listIdentityProviders(software.amazon.awssdk.services.workspacesweb.model.ListIdentityProvidersRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListIdentityProvidersPublisher publisher = client.listIdentityProvidersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListIdentityProvidersPublisher publisher = client.listIdentityProvidersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workspacesweb.model.ListIdentityProvidersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workspacesweb.model.ListIdentityProvidersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIdentityProviders(software.amazon.awssdk.services.workspacesweb.model.ListIdentityProvidersRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIdentityProvidersRequest.Builder} avoiding the
     * need to create one manually via {@link ListIdentityProvidersRequest#builder()}
     * </p>
     *
     * @param listIdentityProvidersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.ListIdentityProvidersRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.ListIdentityProviders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListIdentityProviders"
     *      target="_top">AWS API Documentation</a>
     */
    default ListIdentityProvidersPublisher listIdentityProvidersPaginator(
            Consumer<ListIdentityProvidersRequest.Builder> listIdentityProvidersRequest) {
        return listIdentityProvidersPaginator(ListIdentityProvidersRequest.builder().applyMutation(listIdentityProvidersRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves a list of IP access settings.
     * </p>
     *
     * @param listIpAccessSettingsRequest
     * @return A Java Future containing the result of the ListIpAccessSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.ListIpAccessSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListIpAccessSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListIpAccessSettingsResponse> listIpAccessSettings(
            ListIpAccessSettingsRequest listIpAccessSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of IP access settings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIpAccessSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link ListIpAccessSettingsRequest#builder()}
     * </p>
     *
     * @param listIpAccessSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.ListIpAccessSettingsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListIpAccessSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.ListIpAccessSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListIpAccessSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListIpAccessSettingsResponse> listIpAccessSettings(
            Consumer<ListIpAccessSettingsRequest.Builder> listIpAccessSettingsRequest) {
        return listIpAccessSettings(ListIpAccessSettingsRequest.builder().applyMutation(listIpAccessSettingsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listIpAccessSettings(software.amazon.awssdk.services.workspacesweb.model.ListIpAccessSettingsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListIpAccessSettingsPublisher publisher = client.listIpAccessSettingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListIpAccessSettingsPublisher publisher = client.listIpAccessSettingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workspacesweb.model.ListIpAccessSettingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workspacesweb.model.ListIpAccessSettingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIpAccessSettings(software.amazon.awssdk.services.workspacesweb.model.ListIpAccessSettingsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listIpAccessSettingsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.ListIpAccessSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListIpAccessSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default ListIpAccessSettingsPublisher listIpAccessSettingsPaginator(ListIpAccessSettingsRequest listIpAccessSettingsRequest) {
        return new ListIpAccessSettingsPublisher(this, listIpAccessSettingsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listIpAccessSettings(software.amazon.awssdk.services.workspacesweb.model.ListIpAccessSettingsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListIpAccessSettingsPublisher publisher = client.listIpAccessSettingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListIpAccessSettingsPublisher publisher = client.listIpAccessSettingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workspacesweb.model.ListIpAccessSettingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workspacesweb.model.ListIpAccessSettingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIpAccessSettings(software.amazon.awssdk.services.workspacesweb.model.ListIpAccessSettingsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIpAccessSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link ListIpAccessSettingsRequest#builder()}
     * </p>
     *
     * @param listIpAccessSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.ListIpAccessSettingsRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.ListIpAccessSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListIpAccessSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default ListIpAccessSettingsPublisher listIpAccessSettingsPaginator(
            Consumer<ListIpAccessSettingsRequest.Builder> listIpAccessSettingsRequest) {
        return listIpAccessSettingsPaginator(ListIpAccessSettingsRequest.builder().applyMutation(listIpAccessSettingsRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves a list of network settings.
     * </p>
     *
     * @param listNetworkSettingsRequest
     * @return A Java Future containing the result of the ListNetworkSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.ListNetworkSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListNetworkSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListNetworkSettingsResponse> listNetworkSettings(
            ListNetworkSettingsRequest listNetworkSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of network settings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNetworkSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link ListNetworkSettingsRequest#builder()}
     * </p>
     *
     * @param listNetworkSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.ListNetworkSettingsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListNetworkSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.ListNetworkSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListNetworkSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListNetworkSettingsResponse> listNetworkSettings(
            Consumer<ListNetworkSettingsRequest.Builder> listNetworkSettingsRequest) {
        return listNetworkSettings(ListNetworkSettingsRequest.builder().applyMutation(listNetworkSettingsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listNetworkSettings(software.amazon.awssdk.services.workspacesweb.model.ListNetworkSettingsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListNetworkSettingsPublisher publisher = client.listNetworkSettingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListNetworkSettingsPublisher publisher = client.listNetworkSettingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workspacesweb.model.ListNetworkSettingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workspacesweb.model.ListNetworkSettingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNetworkSettings(software.amazon.awssdk.services.workspacesweb.model.ListNetworkSettingsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listNetworkSettingsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.ListNetworkSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListNetworkSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNetworkSettingsPublisher listNetworkSettingsPaginator(ListNetworkSettingsRequest listNetworkSettingsRequest) {
        return new ListNetworkSettingsPublisher(this, listNetworkSettingsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listNetworkSettings(software.amazon.awssdk.services.workspacesweb.model.ListNetworkSettingsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListNetworkSettingsPublisher publisher = client.listNetworkSettingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListNetworkSettingsPublisher publisher = client.listNetworkSettingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workspacesweb.model.ListNetworkSettingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workspacesweb.model.ListNetworkSettingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNetworkSettings(software.amazon.awssdk.services.workspacesweb.model.ListNetworkSettingsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListNetworkSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link ListNetworkSettingsRequest#builder()}
     * </p>
     *
     * @param listNetworkSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.ListNetworkSettingsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.ListNetworkSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListNetworkSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNetworkSettingsPublisher listNetworkSettingsPaginator(
            Consumer<ListNetworkSettingsRequest.Builder> listNetworkSettingsRequest) {
        return listNetworkSettingsPaginator(ListNetworkSettingsRequest.builder().applyMutation(listNetworkSettingsRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves a list or web portals.
     * </p>
     *
     * @param listPortalsRequest
     * @return A Java Future containing the result of the ListPortals operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.ListPortals
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListPortals" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListPortalsResponse> listPortals(ListPortalsRequest listPortalsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list or web portals.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPortalsRequest.Builder} avoiding the need to
     * create one manually via {@link ListPortalsRequest#builder()}
     * </p>
     *
     * @param listPortalsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.ListPortalsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListPortals operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.ListPortals
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListPortals" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListPortalsResponse> listPortals(Consumer<ListPortalsRequest.Builder> listPortalsRequest) {
        return listPortals(ListPortalsRequest.builder().applyMutation(listPortalsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listPortals(software.amazon.awssdk.services.workspacesweb.model.ListPortalsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListPortalsPublisher publisher = client.listPortalsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListPortalsPublisher publisher = client.listPortalsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workspacesweb.model.ListPortalsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workspacesweb.model.ListPortalsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPortals(software.amazon.awssdk.services.workspacesweb.model.ListPortalsRequest)} operation.</b>
     * </p>
     *
     * @param listPortalsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.ListPortals
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListPortals" target="_top">AWS
     *      API Documentation</a>
     */
    default ListPortalsPublisher listPortalsPaginator(ListPortalsRequest listPortalsRequest) {
        return new ListPortalsPublisher(this, listPortalsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listPortals(software.amazon.awssdk.services.workspacesweb.model.ListPortalsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListPortalsPublisher publisher = client.listPortalsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListPortalsPublisher publisher = client.listPortalsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workspacesweb.model.ListPortalsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workspacesweb.model.ListPortalsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPortals(software.amazon.awssdk.services.workspacesweb.model.ListPortalsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPortalsRequest.Builder} avoiding the need to
     * create one manually via {@link ListPortalsRequest#builder()}
     * </p>
     *
     * @param listPortalsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.ListPortalsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.ListPortals
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListPortals" target="_top">AWS
     *      API Documentation</a>
     */
    default ListPortalsPublisher listPortalsPaginator(Consumer<ListPortalsRequest.Builder> listPortalsRequest) {
        return listPortalsPaginator(ListPortalsRequest.builder().applyMutation(listPortalsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of tags for a resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of tags for a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of trust store certificates.
     * </p>
     *
     * @param listTrustStoreCertificatesRequest
     * @return A Java Future containing the result of the ListTrustStoreCertificates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.ListTrustStoreCertificates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListTrustStoreCertificates"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTrustStoreCertificatesResponse> listTrustStoreCertificates(
            ListTrustStoreCertificatesRequest listTrustStoreCertificatesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of trust store certificates.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTrustStoreCertificatesRequest.Builder} avoiding
     * the need to create one manually via {@link ListTrustStoreCertificatesRequest#builder()}
     * </p>
     *
     * @param listTrustStoreCertificatesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.ListTrustStoreCertificatesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListTrustStoreCertificates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.ListTrustStoreCertificates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListTrustStoreCertificates"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTrustStoreCertificatesResponse> listTrustStoreCertificates(
            Consumer<ListTrustStoreCertificatesRequest.Builder> listTrustStoreCertificatesRequest) {
        return listTrustStoreCertificates(ListTrustStoreCertificatesRequest.builder()
                .applyMutation(listTrustStoreCertificatesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTrustStoreCertificates(software.amazon.awssdk.services.workspacesweb.model.ListTrustStoreCertificatesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListTrustStoreCertificatesPublisher publisher = client.listTrustStoreCertificatesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListTrustStoreCertificatesPublisher publisher = client.listTrustStoreCertificatesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workspacesweb.model.ListTrustStoreCertificatesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workspacesweb.model.ListTrustStoreCertificatesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTrustStoreCertificates(software.amazon.awssdk.services.workspacesweb.model.ListTrustStoreCertificatesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTrustStoreCertificatesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.ListTrustStoreCertificates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListTrustStoreCertificates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTrustStoreCertificatesPublisher listTrustStoreCertificatesPaginator(
            ListTrustStoreCertificatesRequest listTrustStoreCertificatesRequest) {
        return new ListTrustStoreCertificatesPublisher(this, listTrustStoreCertificatesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTrustStoreCertificates(software.amazon.awssdk.services.workspacesweb.model.ListTrustStoreCertificatesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListTrustStoreCertificatesPublisher publisher = client.listTrustStoreCertificatesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListTrustStoreCertificatesPublisher publisher = client.listTrustStoreCertificatesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workspacesweb.model.ListTrustStoreCertificatesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workspacesweb.model.ListTrustStoreCertificatesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTrustStoreCertificates(software.amazon.awssdk.services.workspacesweb.model.ListTrustStoreCertificatesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTrustStoreCertificatesRequest.Builder} avoiding
     * the need to create one manually via {@link ListTrustStoreCertificatesRequest#builder()}
     * </p>
     *
     * @param listTrustStoreCertificatesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.ListTrustStoreCertificatesRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.ListTrustStoreCertificates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListTrustStoreCertificates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTrustStoreCertificatesPublisher listTrustStoreCertificatesPaginator(
            Consumer<ListTrustStoreCertificatesRequest.Builder> listTrustStoreCertificatesRequest) {
        return listTrustStoreCertificatesPaginator(ListTrustStoreCertificatesRequest.builder()
                .applyMutation(listTrustStoreCertificatesRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of trust stores.
     * </p>
     *
     * @param listTrustStoresRequest
     * @return A Java Future containing the result of the ListTrustStores operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.ListTrustStores
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListTrustStores"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTrustStoresResponse> listTrustStores(ListTrustStoresRequest listTrustStoresRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of trust stores.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTrustStoresRequest.Builder} avoiding the need
     * to create one manually via {@link ListTrustStoresRequest#builder()}
     * </p>
     *
     * @param listTrustStoresRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.ListTrustStoresRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTrustStores operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.ListTrustStores
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListTrustStores"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTrustStoresResponse> listTrustStores(
            Consumer<ListTrustStoresRequest.Builder> listTrustStoresRequest) {
        return listTrustStores(ListTrustStoresRequest.builder().applyMutation(listTrustStoresRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTrustStores(software.amazon.awssdk.services.workspacesweb.model.ListTrustStoresRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListTrustStoresPublisher publisher = client.listTrustStoresPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListTrustStoresPublisher publisher = client.listTrustStoresPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workspacesweb.model.ListTrustStoresResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workspacesweb.model.ListTrustStoresResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTrustStores(software.amazon.awssdk.services.workspacesweb.model.ListTrustStoresRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTrustStoresRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.ListTrustStores
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListTrustStores"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTrustStoresPublisher listTrustStoresPaginator(ListTrustStoresRequest listTrustStoresRequest) {
        return new ListTrustStoresPublisher(this, listTrustStoresRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTrustStores(software.amazon.awssdk.services.workspacesweb.model.ListTrustStoresRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListTrustStoresPublisher publisher = client.listTrustStoresPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListTrustStoresPublisher publisher = client.listTrustStoresPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workspacesweb.model.ListTrustStoresResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workspacesweb.model.ListTrustStoresResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTrustStores(software.amazon.awssdk.services.workspacesweb.model.ListTrustStoresRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTrustStoresRequest.Builder} avoiding the need
     * to create one manually via {@link ListTrustStoresRequest#builder()}
     * </p>
     *
     * @param listTrustStoresRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.ListTrustStoresRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.ListTrustStores
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListTrustStores"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTrustStoresPublisher listTrustStoresPaginator(Consumer<ListTrustStoresRequest.Builder> listTrustStoresRequest) {
        return listTrustStoresPaginator(ListTrustStoresRequest.builder().applyMutation(listTrustStoresRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of user access logging settings.
     * </p>
     *
     * @param listUserAccessLoggingSettingsRequest
     * @return A Java Future containing the result of the ListUserAccessLoggingSettings operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.ListUserAccessLoggingSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListUserAccessLoggingSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListUserAccessLoggingSettingsResponse> listUserAccessLoggingSettings(
            ListUserAccessLoggingSettingsRequest listUserAccessLoggingSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of user access logging settings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUserAccessLoggingSettingsRequest.Builder}
     * avoiding the need to create one manually via {@link ListUserAccessLoggingSettingsRequest#builder()}
     * </p>
     *
     * @param listUserAccessLoggingSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.ListUserAccessLoggingSettingsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListUserAccessLoggingSettings operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.ListUserAccessLoggingSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListUserAccessLoggingSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListUserAccessLoggingSettingsResponse> listUserAccessLoggingSettings(
            Consumer<ListUserAccessLoggingSettingsRequest.Builder> listUserAccessLoggingSettingsRequest) {
        return listUserAccessLoggingSettings(ListUserAccessLoggingSettingsRequest.builder()
                .applyMutation(listUserAccessLoggingSettingsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listUserAccessLoggingSettings(software.amazon.awssdk.services.workspacesweb.model.ListUserAccessLoggingSettingsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListUserAccessLoggingSettingsPublisher publisher = client.listUserAccessLoggingSettingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListUserAccessLoggingSettingsPublisher publisher = client.listUserAccessLoggingSettingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workspacesweb.model.ListUserAccessLoggingSettingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workspacesweb.model.ListUserAccessLoggingSettingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUserAccessLoggingSettings(software.amazon.awssdk.services.workspacesweb.model.ListUserAccessLoggingSettingsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listUserAccessLoggingSettingsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.ListUserAccessLoggingSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListUserAccessLoggingSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default ListUserAccessLoggingSettingsPublisher listUserAccessLoggingSettingsPaginator(
            ListUserAccessLoggingSettingsRequest listUserAccessLoggingSettingsRequest) {
        return new ListUserAccessLoggingSettingsPublisher(this, listUserAccessLoggingSettingsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listUserAccessLoggingSettings(software.amazon.awssdk.services.workspacesweb.model.ListUserAccessLoggingSettingsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListUserAccessLoggingSettingsPublisher publisher = client.listUserAccessLoggingSettingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListUserAccessLoggingSettingsPublisher publisher = client.listUserAccessLoggingSettingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workspacesweb.model.ListUserAccessLoggingSettingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workspacesweb.model.ListUserAccessLoggingSettingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUserAccessLoggingSettings(software.amazon.awssdk.services.workspacesweb.model.ListUserAccessLoggingSettingsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUserAccessLoggingSettingsRequest.Builder}
     * avoiding the need to create one manually via {@link ListUserAccessLoggingSettingsRequest#builder()}
     * </p>
     *
     * @param listUserAccessLoggingSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.ListUserAccessLoggingSettingsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.ListUserAccessLoggingSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListUserAccessLoggingSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default ListUserAccessLoggingSettingsPublisher listUserAccessLoggingSettingsPaginator(
            Consumer<ListUserAccessLoggingSettingsRequest.Builder> listUserAccessLoggingSettingsRequest) {
        return listUserAccessLoggingSettingsPaginator(ListUserAccessLoggingSettingsRequest.builder()
                .applyMutation(listUserAccessLoggingSettingsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of user settings.
     * </p>
     *
     * @param listUserSettingsRequest
     * @return A Java Future containing the result of the ListUserSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.ListUserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListUserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListUserSettingsResponse> listUserSettings(ListUserSettingsRequest listUserSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of user settings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUserSettingsRequest.Builder} avoiding the need
     * to create one manually via {@link ListUserSettingsRequest#builder()}
     * </p>
     *
     * @param listUserSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.ListUserSettingsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListUserSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.ListUserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListUserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListUserSettingsResponse> listUserSettings(
            Consumer<ListUserSettingsRequest.Builder> listUserSettingsRequest) {
        return listUserSettings(ListUserSettingsRequest.builder().applyMutation(listUserSettingsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listUserSettings(software.amazon.awssdk.services.workspacesweb.model.ListUserSettingsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListUserSettingsPublisher publisher = client.listUserSettingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListUserSettingsPublisher publisher = client.listUserSettingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workspacesweb.model.ListUserSettingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workspacesweb.model.ListUserSettingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUserSettings(software.amazon.awssdk.services.workspacesweb.model.ListUserSettingsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listUserSettingsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.ListUserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListUserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default ListUserSettingsPublisher listUserSettingsPaginator(ListUserSettingsRequest listUserSettingsRequest) {
        return new ListUserSettingsPublisher(this, listUserSettingsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listUserSettings(software.amazon.awssdk.services.workspacesweb.model.ListUserSettingsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListUserSettingsPublisher publisher = client.listUserSettingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.workspacesweb.paginators.ListUserSettingsPublisher publisher = client.listUserSettingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.workspacesweb.model.ListUserSettingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.workspacesweb.model.ListUserSettingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUserSettings(software.amazon.awssdk.services.workspacesweb.model.ListUserSettingsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListUserSettingsRequest.Builder} avoiding the need
     * to create one manually via {@link ListUserSettingsRequest#builder()}
     * </p>
     *
     * @param listUserSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.ListUserSettingsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.ListUserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/ListUserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default ListUserSettingsPublisher listUserSettingsPaginator(Consumer<ListUserSettingsRequest.Builder> listUserSettingsRequest) {
        return listUserSettingsPaginator(ListUserSettingsRequest.builder().applyMutation(listUserSettingsRequest).build());
    }

    /**
     * <p>
     * Adds or overwrites one or more tags for the specified resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>TooManyTagsException There are too many tags.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds or overwrites one or more tags for the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.TagResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>TooManyTagsException There are too many tags.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes one or more tags from the specified resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes one or more tags from the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.UntagResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates browser settings.
     * </p>
     *
     * @param updateBrowserSettingsRequest
     * @return A Java Future containing the result of the UpdateBrowserSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.UpdateBrowserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/UpdateBrowserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateBrowserSettingsResponse> updateBrowserSettings(
            UpdateBrowserSettingsRequest updateBrowserSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates browser settings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateBrowserSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateBrowserSettingsRequest#builder()}
     * </p>
     *
     * @param updateBrowserSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.UpdateBrowserSettingsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the UpdateBrowserSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.UpdateBrowserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/UpdateBrowserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateBrowserSettingsResponse> updateBrowserSettings(
            Consumer<UpdateBrowserSettingsRequest.Builder> updateBrowserSettingsRequest) {
        return updateBrowserSettings(UpdateBrowserSettingsRequest.builder().applyMutation(updateBrowserSettingsRequest).build());
    }

    /**
     * <p>
     * Updates the identity provider.
     * </p>
     *
     * @param updateIdentityProviderRequest
     * @return A Java Future containing the result of the UpdateIdentityProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.UpdateIdentityProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/UpdateIdentityProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateIdentityProviderResponse> updateIdentityProvider(
            UpdateIdentityProviderRequest updateIdentityProviderRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the identity provider.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateIdentityProviderRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateIdentityProviderRequest#builder()}
     * </p>
     *
     * @param updateIdentityProviderRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.UpdateIdentityProviderRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateIdentityProvider operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.UpdateIdentityProvider
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/UpdateIdentityProvider"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateIdentityProviderResponse> updateIdentityProvider(
            Consumer<UpdateIdentityProviderRequest.Builder> updateIdentityProviderRequest) {
        return updateIdentityProvider(UpdateIdentityProviderRequest.builder().applyMutation(updateIdentityProviderRequest)
                .build());
    }

    /**
     * <p>
     * Updates IP access settings.
     * </p>
     *
     * @param updateIpAccessSettingsRequest
     * @return A Java Future containing the result of the UpdateIpAccessSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.UpdateIpAccessSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/UpdateIpAccessSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateIpAccessSettingsResponse> updateIpAccessSettings(
            UpdateIpAccessSettingsRequest updateIpAccessSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates IP access settings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateIpAccessSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateIpAccessSettingsRequest#builder()}
     * </p>
     *
     * @param updateIpAccessSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.UpdateIpAccessSettingsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateIpAccessSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.UpdateIpAccessSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/UpdateIpAccessSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateIpAccessSettingsResponse> updateIpAccessSettings(
            Consumer<UpdateIpAccessSettingsRequest.Builder> updateIpAccessSettingsRequest) {
        return updateIpAccessSettings(UpdateIpAccessSettingsRequest.builder().applyMutation(updateIpAccessSettingsRequest)
                .build());
    }

    /**
     * <p>
     * Updates network settings.
     * </p>
     *
     * @param updateNetworkSettingsRequest
     * @return A Java Future containing the result of the UpdateNetworkSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.UpdateNetworkSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/UpdateNetworkSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateNetworkSettingsResponse> updateNetworkSettings(
            UpdateNetworkSettingsRequest updateNetworkSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates network settings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateNetworkSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateNetworkSettingsRequest#builder()}
     * </p>
     *
     * @param updateNetworkSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.UpdateNetworkSettingsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the UpdateNetworkSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.UpdateNetworkSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/UpdateNetworkSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateNetworkSettingsResponse> updateNetworkSettings(
            Consumer<UpdateNetworkSettingsRequest.Builder> updateNetworkSettingsRequest) {
        return updateNetworkSettings(UpdateNetworkSettingsRequest.builder().applyMutation(updateNetworkSettingsRequest).build());
    }

    /**
     * <p>
     * Updates a web portal.
     * </p>
     *
     * @param updatePortalRequest
     * @return A Java Future containing the result of the UpdatePortal operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>ConflictException There is a conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.UpdatePortal
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/UpdatePortal" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdatePortalResponse> updatePortal(UpdatePortalRequest updatePortalRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a web portal.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdatePortalRequest.Builder} avoiding the need to
     * create one manually via {@link UpdatePortalRequest#builder()}
     * </p>
     *
     * @param updatePortalRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.UpdatePortalRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdatePortal operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>ConflictException There is a conflict.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.UpdatePortal
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/UpdatePortal" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdatePortalResponse> updatePortal(Consumer<UpdatePortalRequest.Builder> updatePortalRequest) {
        return updatePortal(UpdatePortalRequest.builder().applyMutation(updatePortalRequest).build());
    }

    /**
     * <p>
     * Updates the trust store.
     * </p>
     *
     * @param updateTrustStoreRequest
     * @return A Java Future containing the result of the UpdateTrustStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.UpdateTrustStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/UpdateTrustStore"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateTrustStoreResponse> updateTrustStore(UpdateTrustStoreRequest updateTrustStoreRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the trust store.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateTrustStoreRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateTrustStoreRequest#builder()}
     * </p>
     *
     * @param updateTrustStoreRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.UpdateTrustStoreRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateTrustStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.UpdateTrustStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/UpdateTrustStore"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateTrustStoreResponse> updateTrustStore(
            Consumer<UpdateTrustStoreRequest.Builder> updateTrustStoreRequest) {
        return updateTrustStore(UpdateTrustStoreRequest.builder().applyMutation(updateTrustStoreRequest).build());
    }

    /**
     * <p>
     * Updates the user access logging settings.
     * </p>
     *
     * @param updateUserAccessLoggingSettingsRequest
     * @return A Java Future containing the result of the UpdateUserAccessLoggingSettings operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.UpdateUserAccessLoggingSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/UpdateUserAccessLoggingSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateUserAccessLoggingSettingsResponse> updateUserAccessLoggingSettings(
            UpdateUserAccessLoggingSettingsRequest updateUserAccessLoggingSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the user access logging settings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateUserAccessLoggingSettingsRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateUserAccessLoggingSettingsRequest#builder()}
     * </p>
     *
     * @param updateUserAccessLoggingSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.UpdateUserAccessLoggingSettingsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the UpdateUserAccessLoggingSettings operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.UpdateUserAccessLoggingSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/UpdateUserAccessLoggingSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateUserAccessLoggingSettingsResponse> updateUserAccessLoggingSettings(
            Consumer<UpdateUserAccessLoggingSettingsRequest.Builder> updateUserAccessLoggingSettingsRequest) {
        return updateUserAccessLoggingSettings(UpdateUserAccessLoggingSettingsRequest.builder()
                .applyMutation(updateUserAccessLoggingSettingsRequest).build());
    }

    /**
     * <p>
     * Updates the user settings.
     * </p>
     *
     * @param updateUserSettingsRequest
     * @return A Java Future containing the result of the UpdateUserSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.UpdateUserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/UpdateUserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateUserSettingsResponse> updateUserSettings(UpdateUserSettingsRequest updateUserSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the user settings.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateUserSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateUserSettingsRequest#builder()}
     * </p>
     *
     * @param updateUserSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.workspacesweb.model.UpdateUserSettingsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateUserSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException There is an internal server error.</li>
     *         <li>ResourceNotFoundException The resource cannot be found.</li>
     *         <li>AccessDeniedException Access is denied.</li>
     *         <li>ThrottlingException There is a throttling error.</li>
     *         <li>ValidationException There is a validation error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>WorkSpacesWebException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample WorkSpacesWebAsyncClient.UpdateUserSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/workspaces-web-2020-07-08/UpdateUserSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateUserSettingsResponse> updateUserSettings(
            Consumer<UpdateUserSettingsRequest.Builder> updateUserSettingsRequest) {
        return updateUserSettings(UpdateUserSettingsRequest.builder().applyMutation(updateUserSettingsRequest).build());
    }

    @Override
    default WorkSpacesWebServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link WorkSpacesWebAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static WorkSpacesWebAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link WorkSpacesWebAsyncClient}.
     */
    static WorkSpacesWebAsyncClientBuilder builder() {
        return new DefaultWorkSpacesWebAsyncClientBuilder();
    }
}
