/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspacesweb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateUserSettingsRequest extends WorkSpacesWebRequest implements
        ToCopyableBuilder<CreateUserSettingsRequest.Builder, CreateUserSettingsRequest> {
    private static final SdkField<Map<String, String>> ADDITIONAL_ENCRYPTION_CONTEXT_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("additionalEncryptionContext")
            .getter(getter(CreateUserSettingsRequest::additionalEncryptionContext))
            .setter(setter(Builder::additionalEncryptionContext))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalEncryptionContext")
                    .build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateUserSettingsRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<CookieSynchronizationConfiguration> COOKIE_SYNCHRONIZATION_CONFIGURATION_FIELD = SdkField
            .<CookieSynchronizationConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("cookieSynchronizationConfiguration")
            .getter(getter(CreateUserSettingsRequest::cookieSynchronizationConfiguration))
            .setter(setter(Builder::cookieSynchronizationConfiguration))
            .constructor(CookieSynchronizationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cookieSynchronizationConfiguration")
                    .build()).build();

    private static final SdkField<String> COPY_ALLOWED_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("copyAllowed").getter(getter(CreateUserSettingsRequest::copyAllowedAsString))
            .setter(setter(Builder::copyAllowed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("copyAllowed").build()).build();

    private static final SdkField<String> CUSTOMER_MANAGED_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("customerManagedKey").getter(getter(CreateUserSettingsRequest::customerManagedKey))
            .setter(setter(Builder::customerManagedKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerManagedKey").build())
            .build();

    private static final SdkField<Integer> DISCONNECT_TIMEOUT_IN_MINUTES_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("disconnectTimeoutInMinutes")
            .getter(getter(CreateUserSettingsRequest::disconnectTimeoutInMinutes))
            .setter(setter(Builder::disconnectTimeoutInMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("disconnectTimeoutInMinutes").build())
            .build();

    private static final SdkField<String> DOWNLOAD_ALLOWED_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("downloadAllowed").getter(getter(CreateUserSettingsRequest::downloadAllowedAsString))
            .setter(setter(Builder::downloadAllowed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("downloadAllowed").build()).build();

    private static final SdkField<Integer> IDLE_DISCONNECT_TIMEOUT_IN_MINUTES_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("idleDisconnectTimeoutInMinutes")
            .getter(getter(CreateUserSettingsRequest::idleDisconnectTimeoutInMinutes))
            .setter(setter(Builder::idleDisconnectTimeoutInMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("idleDisconnectTimeoutInMinutes")
                    .build()).build();

    private static final SdkField<String> PASTE_ALLOWED_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("pasteAllowed").getter(getter(CreateUserSettingsRequest::pasteAllowedAsString))
            .setter(setter(Builder::pasteAllowed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pasteAllowed").build()).build();

    private static final SdkField<String> PRINT_ALLOWED_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("printAllowed").getter(getter(CreateUserSettingsRequest::printAllowedAsString))
            .setter(setter(Builder::printAllowed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("printAllowed").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(CreateUserSettingsRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> UPLOAD_ALLOWED_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("uploadAllowed").getter(getter(CreateUserSettingsRequest::uploadAllowedAsString))
            .setter(setter(Builder::uploadAllowed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uploadAllowed").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(ADDITIONAL_ENCRYPTION_CONTEXT_FIELD, CLIENT_TOKEN_FIELD,
                    COOKIE_SYNCHRONIZATION_CONFIGURATION_FIELD, COPY_ALLOWED_FIELD, CUSTOMER_MANAGED_KEY_FIELD,
                    DISCONNECT_TIMEOUT_IN_MINUTES_FIELD, DOWNLOAD_ALLOWED_FIELD, IDLE_DISCONNECT_TIMEOUT_IN_MINUTES_FIELD,
                    PASTE_ALLOWED_FIELD, PRINT_ALLOWED_FIELD, TAGS_FIELD, UPLOAD_ALLOWED_FIELD));

    private final Map<String, String> additionalEncryptionContext;

    private final String clientToken;

    private final CookieSynchronizationConfiguration cookieSynchronizationConfiguration;

    private final String copyAllowed;

    private final String customerManagedKey;

    private final Integer disconnectTimeoutInMinutes;

    private final String downloadAllowed;

    private final Integer idleDisconnectTimeoutInMinutes;

    private final String pasteAllowed;

    private final String printAllowed;

    private final List<Tag> tags;

    private final String uploadAllowed;

    private CreateUserSettingsRequest(BuilderImpl builder) {
        super(builder);
        this.additionalEncryptionContext = builder.additionalEncryptionContext;
        this.clientToken = builder.clientToken;
        this.cookieSynchronizationConfiguration = builder.cookieSynchronizationConfiguration;
        this.copyAllowed = builder.copyAllowed;
        this.customerManagedKey = builder.customerManagedKey;
        this.disconnectTimeoutInMinutes = builder.disconnectTimeoutInMinutes;
        this.downloadAllowed = builder.downloadAllowed;
        this.idleDisconnectTimeoutInMinutes = builder.idleDisconnectTimeoutInMinutes;
        this.pasteAllowed = builder.pasteAllowed;
        this.printAllowed = builder.printAllowed;
        this.tags = builder.tags;
        this.uploadAllowed = builder.uploadAllowed;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdditionalEncryptionContext property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAdditionalEncryptionContext() {
        return additionalEncryptionContext != null && !(additionalEncryptionContext instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The additional encryption context of the user settings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdditionalEncryptionContext} method.
     * </p>
     * 
     * @return The additional encryption context of the user settings.
     */
    public final Map<String, String> additionalEncryptionContext() {
        return additionalEncryptionContext;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency
     * ensures that an API request completes only once. With an idempotent request, if the original request completes
     * successfully, subsequent retries with the same client token returns the result from the original successful
     * request.
     * </p>
     * <p>
     * If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     *         Idempotency ensures that an API request completes only once. With an idempotent request, if the original
     *         request completes successfully, subsequent retries with the same client token returns the result from the
     *         original successful request. </p>
     *         <p>
     *         If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The configuration that specifies which cookies should be synchronized from the end user's local browser to the
     * remote browser.
     * </p>
     * 
     * @return The configuration that specifies which cookies should be synchronized from the end user's local browser
     *         to the remote browser.
     */
    public final CookieSynchronizationConfiguration cookieSynchronizationConfiguration() {
        return cookieSynchronizationConfiguration;
    }

    /**
     * <p>
     * Specifies whether the user can copy text from the streaming session to the local device.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #copyAllowed} will
     * return {@link EnabledType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #copyAllowedAsString}.
     * </p>
     * 
     * @return Specifies whether the user can copy text from the streaming session to the local device.
     * @see EnabledType
     */
    public final EnabledType copyAllowed() {
        return EnabledType.fromValue(copyAllowed);
    }

    /**
     * <p>
     * Specifies whether the user can copy text from the streaming session to the local device.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #copyAllowed} will
     * return {@link EnabledType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #copyAllowedAsString}.
     * </p>
     * 
     * @return Specifies whether the user can copy text from the streaming session to the local device.
     * @see EnabledType
     */
    public final String copyAllowedAsString() {
        return copyAllowed;
    }

    /**
     * <p>
     * The customer managed key used to encrypt sensitive information in the user settings.
     * </p>
     * 
     * @return The customer managed key used to encrypt sensitive information in the user settings.
     */
    public final String customerManagedKey() {
        return customerManagedKey;
    }

    /**
     * <p>
     * The amount of time that a streaming session remains active after users disconnect.
     * </p>
     * 
     * @return The amount of time that a streaming session remains active after users disconnect.
     */
    public final Integer disconnectTimeoutInMinutes() {
        return disconnectTimeoutInMinutes;
    }

    /**
     * <p>
     * Specifies whether the user can download files from the streaming session to the local device.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #downloadAllowed}
     * will return {@link EnabledType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #downloadAllowedAsString}.
     * </p>
     * 
     * @return Specifies whether the user can download files from the streaming session to the local device.
     * @see EnabledType
     */
    public final EnabledType downloadAllowed() {
        return EnabledType.fromValue(downloadAllowed);
    }

    /**
     * <p>
     * Specifies whether the user can download files from the streaming session to the local device.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #downloadAllowed}
     * will return {@link EnabledType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #downloadAllowedAsString}.
     * </p>
     * 
     * @return Specifies whether the user can download files from the streaming session to the local device.
     * @see EnabledType
     */
    public final String downloadAllowedAsString() {
        return downloadAllowed;
    }

    /**
     * <p>
     * The amount of time that users can be idle (inactive) before they are disconnected from their streaming session
     * and the disconnect timeout interval begins.
     * </p>
     * 
     * @return The amount of time that users can be idle (inactive) before they are disconnected from their streaming
     *         session and the disconnect timeout interval begins.
     */
    public final Integer idleDisconnectTimeoutInMinutes() {
        return idleDisconnectTimeoutInMinutes;
    }

    /**
     * <p>
     * Specifies whether the user can paste text from the local device to the streaming session.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pasteAllowed} will
     * return {@link EnabledType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #pasteAllowedAsString}.
     * </p>
     * 
     * @return Specifies whether the user can paste text from the local device to the streaming session.
     * @see EnabledType
     */
    public final EnabledType pasteAllowed() {
        return EnabledType.fromValue(pasteAllowed);
    }

    /**
     * <p>
     * Specifies whether the user can paste text from the local device to the streaming session.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pasteAllowed} will
     * return {@link EnabledType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #pasteAllowedAsString}.
     * </p>
     * 
     * @return Specifies whether the user can paste text from the local device to the streaming session.
     * @see EnabledType
     */
    public final String pasteAllowedAsString() {
        return pasteAllowed;
    }

    /**
     * <p>
     * Specifies whether the user can print to the local device.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #printAllowed} will
     * return {@link EnabledType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #printAllowedAsString}.
     * </p>
     * 
     * @return Specifies whether the user can print to the local device.
     * @see EnabledType
     */
    public final EnabledType printAllowed() {
        return EnabledType.fromValue(printAllowed);
    }

    /**
     * <p>
     * Specifies whether the user can print to the local device.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #printAllowed} will
     * return {@link EnabledType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #printAllowedAsString}.
     * </p>
     * 
     * @return Specifies whether the user can print to the local device.
     * @see EnabledType
     */
    public final String printAllowedAsString() {
        return printAllowed;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags to add to the user settings resource. A tag is a key-value pair.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags to add to the user settings resource. A tag is a key-value pair.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * Specifies whether the user can upload files from the local device to the streaming session.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #uploadAllowed}
     * will return {@link EnabledType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #uploadAllowedAsString}.
     * </p>
     * 
     * @return Specifies whether the user can upload files from the local device to the streaming session.
     * @see EnabledType
     */
    public final EnabledType uploadAllowed() {
        return EnabledType.fromValue(uploadAllowed);
    }

    /**
     * <p>
     * Specifies whether the user can upload files from the local device to the streaming session.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #uploadAllowed}
     * will return {@link EnabledType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #uploadAllowedAsString}.
     * </p>
     * 
     * @return Specifies whether the user can upload files from the local device to the streaming session.
     * @see EnabledType
     */
    public final String uploadAllowedAsString() {
        return uploadAllowed;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAdditionalEncryptionContext() ? additionalEncryptionContext() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(cookieSynchronizationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(copyAllowedAsString());
        hashCode = 31 * hashCode + Objects.hashCode(customerManagedKey());
        hashCode = 31 * hashCode + Objects.hashCode(disconnectTimeoutInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(downloadAllowedAsString());
        hashCode = 31 * hashCode + Objects.hashCode(idleDisconnectTimeoutInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(pasteAllowedAsString());
        hashCode = 31 * hashCode + Objects.hashCode(printAllowedAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(uploadAllowedAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateUserSettingsRequest)) {
            return false;
        }
        CreateUserSettingsRequest other = (CreateUserSettingsRequest) obj;
        return hasAdditionalEncryptionContext() == other.hasAdditionalEncryptionContext()
                && Objects.equals(additionalEncryptionContext(), other.additionalEncryptionContext())
                && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(cookieSynchronizationConfiguration(), other.cookieSynchronizationConfiguration())
                && Objects.equals(copyAllowedAsString(), other.copyAllowedAsString())
                && Objects.equals(customerManagedKey(), other.customerManagedKey())
                && Objects.equals(disconnectTimeoutInMinutes(), other.disconnectTimeoutInMinutes())
                && Objects.equals(downloadAllowedAsString(), other.downloadAllowedAsString())
                && Objects.equals(idleDisconnectTimeoutInMinutes(), other.idleDisconnectTimeoutInMinutes())
                && Objects.equals(pasteAllowedAsString(), other.pasteAllowedAsString())
                && Objects.equals(printAllowedAsString(), other.printAllowedAsString()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(uploadAllowedAsString(), other.uploadAllowedAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("CreateUserSettingsRequest")
                .add("AdditionalEncryptionContext", hasAdditionalEncryptionContext() ? additionalEncryptionContext() : null)
                .add("ClientToken", clientToken())
                .add("CookieSynchronizationConfiguration",
                        cookieSynchronizationConfiguration() == null ? null : "*** Sensitive Data Redacted ***")
                .add("CopyAllowed", copyAllowedAsString()).add("CustomerManagedKey", customerManagedKey())
                .add("DisconnectTimeoutInMinutes", disconnectTimeoutInMinutes())
                .add("DownloadAllowed", downloadAllowedAsString())
                .add("IdleDisconnectTimeoutInMinutes", idleDisconnectTimeoutInMinutes())
                .add("PasteAllowed", pasteAllowedAsString()).add("PrintAllowed", printAllowedAsString())
                .add("Tags", tags() == null ? null : "*** Sensitive Data Redacted ***")
                .add("UploadAllowed", uploadAllowedAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "additionalEncryptionContext":
            return Optional.ofNullable(clazz.cast(additionalEncryptionContext()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "cookieSynchronizationConfiguration":
            return Optional.ofNullable(clazz.cast(cookieSynchronizationConfiguration()));
        case "copyAllowed":
            return Optional.ofNullable(clazz.cast(copyAllowedAsString()));
        case "customerManagedKey":
            return Optional.ofNullable(clazz.cast(customerManagedKey()));
        case "disconnectTimeoutInMinutes":
            return Optional.ofNullable(clazz.cast(disconnectTimeoutInMinutes()));
        case "downloadAllowed":
            return Optional.ofNullable(clazz.cast(downloadAllowedAsString()));
        case "idleDisconnectTimeoutInMinutes":
            return Optional.ofNullable(clazz.cast(idleDisconnectTimeoutInMinutes()));
        case "pasteAllowed":
            return Optional.ofNullable(clazz.cast(pasteAllowedAsString()));
        case "printAllowed":
            return Optional.ofNullable(clazz.cast(printAllowedAsString()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "uploadAllowed":
            return Optional.ofNullable(clazz.cast(uploadAllowedAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateUserSettingsRequest, T> g) {
        return obj -> g.apply((CreateUserSettingsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkSpacesWebRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateUserSettingsRequest> {
        /**
         * <p>
         * The additional encryption context of the user settings.
         * </p>
         * 
         * @param additionalEncryptionContext
         *        The additional encryption context of the user settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalEncryptionContext(Map<String, String> additionalEncryptionContext);

        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency
         * ensures that an API request completes only once. With an idempotent request, if the original request
         * completes successfully, subsequent retries with the same client token returns the result from the original
         * successful request.
         * </p>
         * <p>
         * If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         *        Idempotency ensures that an API request completes only once. With an idempotent request, if the
         *        original request completes successfully, subsequent retries with the same client token returns the
         *        result from the original successful request. </p>
         *        <p>
         *        If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The configuration that specifies which cookies should be synchronized from the end user's local browser to
         * the remote browser.
         * </p>
         * 
         * @param cookieSynchronizationConfiguration
         *        The configuration that specifies which cookies should be synchronized from the end user's local
         *        browser to the remote browser.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cookieSynchronizationConfiguration(CookieSynchronizationConfiguration cookieSynchronizationConfiguration);

        /**
         * <p>
         * The configuration that specifies which cookies should be synchronized from the end user's local browser to
         * the remote browser.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link CookieSynchronizationConfiguration.Builder} avoiding the need to create one manually via
         * {@link CookieSynchronizationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CookieSynchronizationConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #cookieSynchronizationConfiguration(CookieSynchronizationConfiguration)}.
         * 
         * @param cookieSynchronizationConfiguration
         *        a consumer that will call methods on {@link CookieSynchronizationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cookieSynchronizationConfiguration(CookieSynchronizationConfiguration)
         */
        default Builder cookieSynchronizationConfiguration(
                Consumer<CookieSynchronizationConfiguration.Builder> cookieSynchronizationConfiguration) {
            return cookieSynchronizationConfiguration(CookieSynchronizationConfiguration.builder()
                    .applyMutation(cookieSynchronizationConfiguration).build());
        }

        /**
         * <p>
         * Specifies whether the user can copy text from the streaming session to the local device.
         * </p>
         * 
         * @param copyAllowed
         *        Specifies whether the user can copy text from the streaming session to the local device.
         * @see EnabledType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnabledType
         */
        Builder copyAllowed(String copyAllowed);

        /**
         * <p>
         * Specifies whether the user can copy text from the streaming session to the local device.
         * </p>
         * 
         * @param copyAllowed
         *        Specifies whether the user can copy text from the streaming session to the local device.
         * @see EnabledType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnabledType
         */
        Builder copyAllowed(EnabledType copyAllowed);

        /**
         * <p>
         * The customer managed key used to encrypt sensitive information in the user settings.
         * </p>
         * 
         * @param customerManagedKey
         *        The customer managed key used to encrypt sensitive information in the user settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerManagedKey(String customerManagedKey);

        /**
         * <p>
         * The amount of time that a streaming session remains active after users disconnect.
         * </p>
         * 
         * @param disconnectTimeoutInMinutes
         *        The amount of time that a streaming session remains active after users disconnect.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disconnectTimeoutInMinutes(Integer disconnectTimeoutInMinutes);

        /**
         * <p>
         * Specifies whether the user can download files from the streaming session to the local device.
         * </p>
         * 
         * @param downloadAllowed
         *        Specifies whether the user can download files from the streaming session to the local device.
         * @see EnabledType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnabledType
         */
        Builder downloadAllowed(String downloadAllowed);

        /**
         * <p>
         * Specifies whether the user can download files from the streaming session to the local device.
         * </p>
         * 
         * @param downloadAllowed
         *        Specifies whether the user can download files from the streaming session to the local device.
         * @see EnabledType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnabledType
         */
        Builder downloadAllowed(EnabledType downloadAllowed);

        /**
         * <p>
         * The amount of time that users can be idle (inactive) before they are disconnected from their streaming
         * session and the disconnect timeout interval begins.
         * </p>
         * 
         * @param idleDisconnectTimeoutInMinutes
         *        The amount of time that users can be idle (inactive) before they are disconnected from their streaming
         *        session and the disconnect timeout interval begins.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idleDisconnectTimeoutInMinutes(Integer idleDisconnectTimeoutInMinutes);

        /**
         * <p>
         * Specifies whether the user can paste text from the local device to the streaming session.
         * </p>
         * 
         * @param pasteAllowed
         *        Specifies whether the user can paste text from the local device to the streaming session.
         * @see EnabledType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnabledType
         */
        Builder pasteAllowed(String pasteAllowed);

        /**
         * <p>
         * Specifies whether the user can paste text from the local device to the streaming session.
         * </p>
         * 
         * @param pasteAllowed
         *        Specifies whether the user can paste text from the local device to the streaming session.
         * @see EnabledType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnabledType
         */
        Builder pasteAllowed(EnabledType pasteAllowed);

        /**
         * <p>
         * Specifies whether the user can print to the local device.
         * </p>
         * 
         * @param printAllowed
         *        Specifies whether the user can print to the local device.
         * @see EnabledType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnabledType
         */
        Builder printAllowed(String printAllowed);

        /**
         * <p>
         * Specifies whether the user can print to the local device.
         * </p>
         * 
         * @param printAllowed
         *        Specifies whether the user can print to the local device.
         * @see EnabledType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnabledType
         */
        Builder printAllowed(EnabledType printAllowed);

        /**
         * <p>
         * The tags to add to the user settings resource. A tag is a key-value pair.
         * </p>
         * 
         * @param tags
         *        The tags to add to the user settings resource. A tag is a key-value pair.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags to add to the user settings resource. A tag is a key-value pair.
         * </p>
         * 
         * @param tags
         *        The tags to add to the user settings resource. A tag is a key-value pair.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags to add to the user settings resource. A tag is a key-value pair.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.workspacesweb.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.workspacesweb.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.workspacesweb.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.workspacesweb.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * Specifies whether the user can upload files from the local device to the streaming session.
         * </p>
         * 
         * @param uploadAllowed
         *        Specifies whether the user can upload files from the local device to the streaming session.
         * @see EnabledType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnabledType
         */
        Builder uploadAllowed(String uploadAllowed);

        /**
         * <p>
         * Specifies whether the user can upload files from the local device to the streaming session.
         * </p>
         * 
         * @param uploadAllowed
         *        Specifies whether the user can upload files from the local device to the streaming session.
         * @see EnabledType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnabledType
         */
        Builder uploadAllowed(EnabledType uploadAllowed);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkSpacesWebRequest.BuilderImpl implements Builder {
        private Map<String, String> additionalEncryptionContext = DefaultSdkAutoConstructMap.getInstance();

        private String clientToken;

        private CookieSynchronizationConfiguration cookieSynchronizationConfiguration;

        private String copyAllowed;

        private String customerManagedKey;

        private Integer disconnectTimeoutInMinutes;

        private String downloadAllowed;

        private Integer idleDisconnectTimeoutInMinutes;

        private String pasteAllowed;

        private String printAllowed;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String uploadAllowed;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateUserSettingsRequest model) {
            super(model);
            additionalEncryptionContext(model.additionalEncryptionContext);
            clientToken(model.clientToken);
            cookieSynchronizationConfiguration(model.cookieSynchronizationConfiguration);
            copyAllowed(model.copyAllowed);
            customerManagedKey(model.customerManagedKey);
            disconnectTimeoutInMinutes(model.disconnectTimeoutInMinutes);
            downloadAllowed(model.downloadAllowed);
            idleDisconnectTimeoutInMinutes(model.idleDisconnectTimeoutInMinutes);
            pasteAllowed(model.pasteAllowed);
            printAllowed(model.printAllowed);
            tags(model.tags);
            uploadAllowed(model.uploadAllowed);
        }

        public final Map<String, String> getAdditionalEncryptionContext() {
            if (additionalEncryptionContext instanceof SdkAutoConstructMap) {
                return null;
            }
            return additionalEncryptionContext;
        }

        public final void setAdditionalEncryptionContext(Map<String, String> additionalEncryptionContext) {
            this.additionalEncryptionContext = EncryptionContextMapCopier.copy(additionalEncryptionContext);
        }

        @Override
        public final Builder additionalEncryptionContext(Map<String, String> additionalEncryptionContext) {
            this.additionalEncryptionContext = EncryptionContextMapCopier.copy(additionalEncryptionContext);
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final CookieSynchronizationConfiguration.Builder getCookieSynchronizationConfiguration() {
            return cookieSynchronizationConfiguration != null ? cookieSynchronizationConfiguration.toBuilder() : null;
        }

        public final void setCookieSynchronizationConfiguration(
                CookieSynchronizationConfiguration.BuilderImpl cookieSynchronizationConfiguration) {
            this.cookieSynchronizationConfiguration = cookieSynchronizationConfiguration != null ? cookieSynchronizationConfiguration
                    .build() : null;
        }

        @Override
        public final Builder cookieSynchronizationConfiguration(
                CookieSynchronizationConfiguration cookieSynchronizationConfiguration) {
            this.cookieSynchronizationConfiguration = cookieSynchronizationConfiguration;
            return this;
        }

        public final String getCopyAllowed() {
            return copyAllowed;
        }

        public final void setCopyAllowed(String copyAllowed) {
            this.copyAllowed = copyAllowed;
        }

        @Override
        public final Builder copyAllowed(String copyAllowed) {
            this.copyAllowed = copyAllowed;
            return this;
        }

        @Override
        public final Builder copyAllowed(EnabledType copyAllowed) {
            this.copyAllowed(copyAllowed == null ? null : copyAllowed.toString());
            return this;
        }

        public final String getCustomerManagedKey() {
            return customerManagedKey;
        }

        public final void setCustomerManagedKey(String customerManagedKey) {
            this.customerManagedKey = customerManagedKey;
        }

        @Override
        public final Builder customerManagedKey(String customerManagedKey) {
            this.customerManagedKey = customerManagedKey;
            return this;
        }

        public final Integer getDisconnectTimeoutInMinutes() {
            return disconnectTimeoutInMinutes;
        }

        public final void setDisconnectTimeoutInMinutes(Integer disconnectTimeoutInMinutes) {
            this.disconnectTimeoutInMinutes = disconnectTimeoutInMinutes;
        }

        @Override
        public final Builder disconnectTimeoutInMinutes(Integer disconnectTimeoutInMinutes) {
            this.disconnectTimeoutInMinutes = disconnectTimeoutInMinutes;
            return this;
        }

        public final String getDownloadAllowed() {
            return downloadAllowed;
        }

        public final void setDownloadAllowed(String downloadAllowed) {
            this.downloadAllowed = downloadAllowed;
        }

        @Override
        public final Builder downloadAllowed(String downloadAllowed) {
            this.downloadAllowed = downloadAllowed;
            return this;
        }

        @Override
        public final Builder downloadAllowed(EnabledType downloadAllowed) {
            this.downloadAllowed(downloadAllowed == null ? null : downloadAllowed.toString());
            return this;
        }

        public final Integer getIdleDisconnectTimeoutInMinutes() {
            return idleDisconnectTimeoutInMinutes;
        }

        public final void setIdleDisconnectTimeoutInMinutes(Integer idleDisconnectTimeoutInMinutes) {
            this.idleDisconnectTimeoutInMinutes = idleDisconnectTimeoutInMinutes;
        }

        @Override
        public final Builder idleDisconnectTimeoutInMinutes(Integer idleDisconnectTimeoutInMinutes) {
            this.idleDisconnectTimeoutInMinutes = idleDisconnectTimeoutInMinutes;
            return this;
        }

        public final String getPasteAllowed() {
            return pasteAllowed;
        }

        public final void setPasteAllowed(String pasteAllowed) {
            this.pasteAllowed = pasteAllowed;
        }

        @Override
        public final Builder pasteAllowed(String pasteAllowed) {
            this.pasteAllowed = pasteAllowed;
            return this;
        }

        @Override
        public final Builder pasteAllowed(EnabledType pasteAllowed) {
            this.pasteAllowed(pasteAllowed == null ? null : pasteAllowed.toString());
            return this;
        }

        public final String getPrintAllowed() {
            return printAllowed;
        }

        public final void setPrintAllowed(String printAllowed) {
            this.printAllowed = printAllowed;
        }

        @Override
        public final Builder printAllowed(String printAllowed) {
            this.printAllowed = printAllowed;
            return this;
        }

        @Override
        public final Builder printAllowed(EnabledType printAllowed) {
            this.printAllowed(printAllowed == null ? null : printAllowed.toString());
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getUploadAllowed() {
            return uploadAllowed;
        }

        public final void setUploadAllowed(String uploadAllowed) {
            this.uploadAllowed = uploadAllowed;
        }

        @Override
        public final Builder uploadAllowed(String uploadAllowed) {
            this.uploadAllowed = uploadAllowed;
            return this;
        }

        @Override
        public final Builder uploadAllowed(EnabledType uploadAllowed) {
            this.uploadAllowed(uploadAllowed == null ? null : uploadAllowed.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateUserSettingsRequest build() {
            return new CreateUserSettingsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
