/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspacesweb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetBrowserSettingsResponse extends WorkSpacesWebResponse implements
        ToCopyableBuilder<GetBrowserSettingsResponse.Builder, GetBrowserSettingsResponse> {
    private static final SdkField<BrowserSettings> BROWSER_SETTINGS_FIELD = SdkField
            .<BrowserSettings> builder(MarshallingType.SDK_POJO).memberName("browserSettings")
            .getter(getter(GetBrowserSettingsResponse::browserSettings)).setter(setter(Builder::browserSettings))
            .constructor(BrowserSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("browserSettings").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BROWSER_SETTINGS_FIELD));

    private final BrowserSettings browserSettings;

    private GetBrowserSettingsResponse(BuilderImpl builder) {
        super(builder);
        this.browserSettings = builder.browserSettings;
    }

    /**
     * <p>
     * The browser settings.
     * </p>
     * 
     * @return The browser settings.
     */
    public final BrowserSettings browserSettings() {
        return browserSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(browserSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBrowserSettingsResponse)) {
            return false;
        }
        GetBrowserSettingsResponse other = (GetBrowserSettingsResponse) obj;
        return Objects.equals(browserSettings(), other.browserSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetBrowserSettingsResponse").add("BrowserSettings", browserSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "browserSettings":
            return Optional.ofNullable(clazz.cast(browserSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetBrowserSettingsResponse, T> g) {
        return obj -> g.apply((GetBrowserSettingsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkSpacesWebResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetBrowserSettingsResponse> {
        /**
         * <p>
         * The browser settings.
         * </p>
         * 
         * @param browserSettings
         *        The browser settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder browserSettings(BrowserSettings browserSettings);

        /**
         * <p>
         * The browser settings.
         * </p>
         * This is a convenience method that creates an instance of the {@link BrowserSettings.Builder} avoiding the
         * need to create one manually via {@link BrowserSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BrowserSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #browserSettings(BrowserSettings)}.
         * 
         * @param browserSettings
         *        a consumer that will call methods on {@link BrowserSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #browserSettings(BrowserSettings)
         */
        default Builder browserSettings(Consumer<BrowserSettings.Builder> browserSettings) {
            return browserSettings(BrowserSettings.builder().applyMutation(browserSettings).build());
        }
    }

    static final class BuilderImpl extends WorkSpacesWebResponse.BuilderImpl implements Builder {
        private BrowserSettings browserSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBrowserSettingsResponse model) {
            super(model);
            browserSettings(model.browserSettings);
        }

        public final BrowserSettings.Builder getBrowserSettings() {
            return browserSettings != null ? browserSettings.toBuilder() : null;
        }

        public final void setBrowserSettings(BrowserSettings.BuilderImpl browserSettings) {
            this.browserSettings = browserSettings != null ? browserSettings.build() : null;
        }

        @Override
        public final Builder browserSettings(BrowserSettings browserSettings) {
            this.browserSettings = browserSettings;
            return this;
        }

        @Override
        public GetBrowserSettingsResponse build() {
            return new GetBrowserSettingsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
