/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspacesweb.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The summary of the portal.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PortalSummary implements SdkPojo, Serializable, ToCopyableBuilder<PortalSummary.Builder, PortalSummary> {
    private static final SdkField<String> AUTHENTICATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("authenticationType").getter(getter(PortalSummary::authenticationTypeAsString))
            .setter(setter(Builder::authenticationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authenticationType").build())
            .build();

    private static final SdkField<String> BROWSER_SETTINGS_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("browserSettingsArn").getter(getter(PortalSummary::browserSettingsArn))
            .setter(setter(Builder::browserSettingsArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("browserSettingsArn").build())
            .build();

    private static final SdkField<String> BROWSER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("browserType").getter(getter(PortalSummary::browserTypeAsString)).setter(setter(Builder::browserType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("browserType").build()).build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDate").getter(getter(PortalSummary::creationDate)).setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(PortalSummary::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("instanceType").getter(getter(PortalSummary::instanceTypeAsString)).setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceType").build()).build();

    private static final SdkField<String> IP_ACCESS_SETTINGS_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ipAccessSettingsArn").getter(getter(PortalSummary::ipAccessSettingsArn))
            .setter(setter(Builder::ipAccessSettingsArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ipAccessSettingsArn").build())
            .build();

    private static final SdkField<Integer> MAX_CONCURRENT_SESSIONS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxConcurrentSessions").getter(getter(PortalSummary::maxConcurrentSessions))
            .setter(setter(Builder::maxConcurrentSessions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxConcurrentSessions").build())
            .build();

    private static final SdkField<String> NETWORK_SETTINGS_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("networkSettingsArn").getter(getter(PortalSummary::networkSettingsArn))
            .setter(setter(Builder::networkSettingsArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkSettingsArn").build())
            .build();

    private static final SdkField<String> PORTAL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("portalArn").getter(getter(PortalSummary::portalArn)).setter(setter(Builder::portalArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portalArn").build()).build();

    private static final SdkField<String> PORTAL_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("portalEndpoint").getter(getter(PortalSummary::portalEndpoint)).setter(setter(Builder::portalEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portalEndpoint").build()).build();

    private static final SdkField<String> PORTAL_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("portalStatus").getter(getter(PortalSummary::portalStatusAsString)).setter(setter(Builder::portalStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portalStatus").build()).build();

    private static final SdkField<String> RENDERER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("rendererType").getter(getter(PortalSummary::rendererTypeAsString)).setter(setter(Builder::rendererType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rendererType").build()).build();

    private static final SdkField<String> TRUST_STORE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("trustStoreArn").getter(getter(PortalSummary::trustStoreArn)).setter(setter(Builder::trustStoreArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trustStoreArn").build()).build();

    private static final SdkField<String> USER_ACCESS_LOGGING_SETTINGS_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("userAccessLoggingSettingsArn")
            .getter(getter(PortalSummary::userAccessLoggingSettingsArn))
            .setter(setter(Builder::userAccessLoggingSettingsArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userAccessLoggingSettingsArn")
                    .build()).build();

    private static final SdkField<String> USER_SETTINGS_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("userSettingsArn").getter(getter(PortalSummary::userSettingsArn))
            .setter(setter(Builder::userSettingsArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userSettingsArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHENTICATION_TYPE_FIELD,
            BROWSER_SETTINGS_ARN_FIELD, BROWSER_TYPE_FIELD, CREATION_DATE_FIELD, DISPLAY_NAME_FIELD, INSTANCE_TYPE_FIELD,
            IP_ACCESS_SETTINGS_ARN_FIELD, MAX_CONCURRENT_SESSIONS_FIELD, NETWORK_SETTINGS_ARN_FIELD, PORTAL_ARN_FIELD,
            PORTAL_ENDPOINT_FIELD, PORTAL_STATUS_FIELD, RENDERER_TYPE_FIELD, TRUST_STORE_ARN_FIELD,
            USER_ACCESS_LOGGING_SETTINGS_ARN_FIELD, USER_SETTINGS_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String authenticationType;

    private final String browserSettingsArn;

    private final String browserType;

    private final Instant creationDate;

    private final String displayName;

    private final String instanceType;

    private final String ipAccessSettingsArn;

    private final Integer maxConcurrentSessions;

    private final String networkSettingsArn;

    private final String portalArn;

    private final String portalEndpoint;

    private final String portalStatus;

    private final String rendererType;

    private final String trustStoreArn;

    private final String userAccessLoggingSettingsArn;

    private final String userSettingsArn;

    private PortalSummary(BuilderImpl builder) {
        this.authenticationType = builder.authenticationType;
        this.browserSettingsArn = builder.browserSettingsArn;
        this.browserType = builder.browserType;
        this.creationDate = builder.creationDate;
        this.displayName = builder.displayName;
        this.instanceType = builder.instanceType;
        this.ipAccessSettingsArn = builder.ipAccessSettingsArn;
        this.maxConcurrentSessions = builder.maxConcurrentSessions;
        this.networkSettingsArn = builder.networkSettingsArn;
        this.portalArn = builder.portalArn;
        this.portalEndpoint = builder.portalEndpoint;
        this.portalStatus = builder.portalStatus;
        this.rendererType = builder.rendererType;
        this.trustStoreArn = builder.trustStoreArn;
        this.userAccessLoggingSettingsArn = builder.userAccessLoggingSettingsArn;
        this.userSettingsArn = builder.userSettingsArn;
    }

    /**
     * <p>
     * The type of authentication integration points used when signing into the web portal. Defaults to
     * <code>Standard</code>.
     * </p>
     * <p>
     * <code>Standard</code> web portals are authenticated directly through your identity provider. You need to call
     * <code>CreateIdentityProvider</code> to integrate your identity provider with your web portal. User and group
     * access to your web portal is controlled through your identity provider.
     * </p>
     * <p>
     * <code>IAM Identity Center</code> web portals are authenticated through IAM Identity Center (successor to Single
     * Sign-On). Identity sources (including external identity provider integration), plus user and group access to your
     * web portal, can be configured in the IAM Identity Center.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authenticationType} will return {@link AuthenticationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #authenticationTypeAsString}.
     * </p>
     * 
     * @return The type of authentication integration points used when signing into the web portal. Defaults to
     *         <code>Standard</code>.</p>
     *         <p>
     *         <code>Standard</code> web portals are authenticated directly through your identity provider. You need to
     *         call <code>CreateIdentityProvider</code> to integrate your identity provider with your web portal. User
     *         and group access to your web portal is controlled through your identity provider.
     *         </p>
     *         <p>
     *         <code>IAM Identity Center</code> web portals are authenticated through IAM Identity Center (successor to
     *         Single Sign-On). Identity sources (including external identity provider integration), plus user and group
     *         access to your web portal, can be configured in the IAM Identity Center.
     * @see AuthenticationType
     */
    public final AuthenticationType authenticationType() {
        return AuthenticationType.fromValue(authenticationType);
    }

    /**
     * <p>
     * The type of authentication integration points used when signing into the web portal. Defaults to
     * <code>Standard</code>.
     * </p>
     * <p>
     * <code>Standard</code> web portals are authenticated directly through your identity provider. You need to call
     * <code>CreateIdentityProvider</code> to integrate your identity provider with your web portal. User and group
     * access to your web portal is controlled through your identity provider.
     * </p>
     * <p>
     * <code>IAM Identity Center</code> web portals are authenticated through IAM Identity Center (successor to Single
     * Sign-On). Identity sources (including external identity provider integration), plus user and group access to your
     * web portal, can be configured in the IAM Identity Center.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authenticationType} will return {@link AuthenticationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #authenticationTypeAsString}.
     * </p>
     * 
     * @return The type of authentication integration points used when signing into the web portal. Defaults to
     *         <code>Standard</code>.</p>
     *         <p>
     *         <code>Standard</code> web portals are authenticated directly through your identity provider. You need to
     *         call <code>CreateIdentityProvider</code> to integrate your identity provider with your web portal. User
     *         and group access to your web portal is controlled through your identity provider.
     *         </p>
     *         <p>
     *         <code>IAM Identity Center</code> web portals are authenticated through IAM Identity Center (successor to
     *         Single Sign-On). Identity sources (including external identity provider integration), plus user and group
     *         access to your web portal, can be configured in the IAM Identity Center.
     * @see AuthenticationType
     */
    public final String authenticationTypeAsString() {
        return authenticationType;
    }

    /**
     * <p>
     * The ARN of the browser settings that is associated with the web portal.
     * </p>
     * 
     * @return The ARN of the browser settings that is associated with the web portal.
     */
    public final String browserSettingsArn() {
        return browserSettingsArn;
    }

    /**
     * <p>
     * The browser type of the web portal.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #browserType} will
     * return {@link BrowserType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #browserTypeAsString}.
     * </p>
     * 
     * @return The browser type of the web portal.
     * @see BrowserType
     */
    public final BrowserType browserType() {
        return BrowserType.fromValue(browserType);
    }

    /**
     * <p>
     * The browser type of the web portal.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #browserType} will
     * return {@link BrowserType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #browserTypeAsString}.
     * </p>
     * 
     * @return The browser type of the web portal.
     * @see BrowserType
     */
    public final String browserTypeAsString() {
        return browserType;
    }

    /**
     * <p>
     * The creation date of the web portal.
     * </p>
     * 
     * @return The creation date of the web portal.
     */
    public final Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * The name of the web portal.
     * </p>
     * 
     * @return The name of the web portal.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The type and resources of the underlying instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link InstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The type and resources of the underlying instance.
     * @see InstanceType
     */
    public final InstanceType instanceType() {
        return InstanceType.fromValue(instanceType);
    }

    /**
     * <p>
     * The type and resources of the underlying instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link InstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The type and resources of the underlying instance.
     * @see InstanceType
     */
    public final String instanceTypeAsString() {
        return instanceType;
    }

    /**
     * <p>
     * The ARN of the IP access settings.
     * </p>
     * 
     * @return The ARN of the IP access settings.
     */
    public final String ipAccessSettingsArn() {
        return ipAccessSettingsArn;
    }

    /**
     * <p>
     * The maximum number of concurrent sessions for the portal.
     * </p>
     * 
     * @return The maximum number of concurrent sessions for the portal.
     */
    public final Integer maxConcurrentSessions() {
        return maxConcurrentSessions;
    }

    /**
     * <p>
     * The ARN of the network settings that is associated with the web portal.
     * </p>
     * 
     * @return The ARN of the network settings that is associated with the web portal.
     */
    public final String networkSettingsArn() {
        return networkSettingsArn;
    }

    /**
     * <p>
     * The ARN of the web portal.
     * </p>
     * 
     * @return The ARN of the web portal.
     */
    public final String portalArn() {
        return portalArn;
    }

    /**
     * <p>
     * The endpoint URL of the web portal that users access in order to start streaming sessions.
     * </p>
     * 
     * @return The endpoint URL of the web portal that users access in order to start streaming sessions.
     */
    public final String portalEndpoint() {
        return portalEndpoint;
    }

    /**
     * <p>
     * The status of the web portal.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #portalStatus} will
     * return {@link PortalStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #portalStatusAsString}.
     * </p>
     * 
     * @return The status of the web portal.
     * @see PortalStatus
     */
    public final PortalStatus portalStatus() {
        return PortalStatus.fromValue(portalStatus);
    }

    /**
     * <p>
     * The status of the web portal.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #portalStatus} will
     * return {@link PortalStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #portalStatusAsString}.
     * </p>
     * 
     * @return The status of the web portal.
     * @see PortalStatus
     */
    public final String portalStatusAsString() {
        return portalStatus;
    }

    /**
     * <p>
     * The renderer that is used in streaming sessions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rendererType} will
     * return {@link RendererType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #rendererTypeAsString}.
     * </p>
     * 
     * @return The renderer that is used in streaming sessions.
     * @see RendererType
     */
    public final RendererType rendererType() {
        return RendererType.fromValue(rendererType);
    }

    /**
     * <p>
     * The renderer that is used in streaming sessions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rendererType} will
     * return {@link RendererType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #rendererTypeAsString}.
     * </p>
     * 
     * @return The renderer that is used in streaming sessions.
     * @see RendererType
     */
    public final String rendererTypeAsString() {
        return rendererType;
    }

    /**
     * <p>
     * The ARN of the trust that is associated with this web portal.
     * </p>
     * 
     * @return The ARN of the trust that is associated with this web portal.
     */
    public final String trustStoreArn() {
        return trustStoreArn;
    }

    /**
     * <p>
     * The ARN of the user access logging settings that is associated with the web portal.
     * </p>
     * 
     * @return The ARN of the user access logging settings that is associated with the web portal.
     */
    public final String userAccessLoggingSettingsArn() {
        return userAccessLoggingSettingsArn;
    }

    /**
     * <p>
     * The ARN of the user settings that is associated with the web portal.
     * </p>
     * 
     * @return The ARN of the user settings that is associated with the web portal.
     */
    public final String userSettingsArn() {
        return userSettingsArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(authenticationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(browserSettingsArn());
        hashCode = 31 * hashCode + Objects.hashCode(browserTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(ipAccessSettingsArn());
        hashCode = 31 * hashCode + Objects.hashCode(maxConcurrentSessions());
        hashCode = 31 * hashCode + Objects.hashCode(networkSettingsArn());
        hashCode = 31 * hashCode + Objects.hashCode(portalArn());
        hashCode = 31 * hashCode + Objects.hashCode(portalEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(portalStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(rendererTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(trustStoreArn());
        hashCode = 31 * hashCode + Objects.hashCode(userAccessLoggingSettingsArn());
        hashCode = 31 * hashCode + Objects.hashCode(userSettingsArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PortalSummary)) {
            return false;
        }
        PortalSummary other = (PortalSummary) obj;
        return Objects.equals(authenticationTypeAsString(), other.authenticationTypeAsString())
                && Objects.equals(browserSettingsArn(), other.browserSettingsArn())
                && Objects.equals(browserTypeAsString(), other.browserTypeAsString())
                && Objects.equals(creationDate(), other.creationDate()) && Objects.equals(displayName(), other.displayName())
                && Objects.equals(instanceTypeAsString(), other.instanceTypeAsString())
                && Objects.equals(ipAccessSettingsArn(), other.ipAccessSettingsArn())
                && Objects.equals(maxConcurrentSessions(), other.maxConcurrentSessions())
                && Objects.equals(networkSettingsArn(), other.networkSettingsArn())
                && Objects.equals(portalArn(), other.portalArn()) && Objects.equals(portalEndpoint(), other.portalEndpoint())
                && Objects.equals(portalStatusAsString(), other.portalStatusAsString())
                && Objects.equals(rendererTypeAsString(), other.rendererTypeAsString())
                && Objects.equals(trustStoreArn(), other.trustStoreArn())
                && Objects.equals(userAccessLoggingSettingsArn(), other.userAccessLoggingSettingsArn())
                && Objects.equals(userSettingsArn(), other.userSettingsArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PortalSummary").add("AuthenticationType", authenticationTypeAsString())
                .add("BrowserSettingsArn", browserSettingsArn()).add("BrowserType", browserTypeAsString())
                .add("CreationDate", creationDate())
                .add("DisplayName", displayName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("InstanceType", instanceTypeAsString()).add("IpAccessSettingsArn", ipAccessSettingsArn())
                .add("MaxConcurrentSessions", maxConcurrentSessions()).add("NetworkSettingsArn", networkSettingsArn())
                .add("PortalArn", portalArn()).add("PortalEndpoint", portalEndpoint())
                .add("PortalStatus", portalStatusAsString()).add("RendererType", rendererTypeAsString())
                .add("TrustStoreArn", trustStoreArn()).add("UserAccessLoggingSettingsArn", userAccessLoggingSettingsArn())
                .add("UserSettingsArn", userSettingsArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "authenticationType":
            return Optional.ofNullable(clazz.cast(authenticationTypeAsString()));
        case "browserSettingsArn":
            return Optional.ofNullable(clazz.cast(browserSettingsArn()));
        case "browserType":
            return Optional.ofNullable(clazz.cast(browserTypeAsString()));
        case "creationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "instanceType":
            return Optional.ofNullable(clazz.cast(instanceTypeAsString()));
        case "ipAccessSettingsArn":
            return Optional.ofNullable(clazz.cast(ipAccessSettingsArn()));
        case "maxConcurrentSessions":
            return Optional.ofNullable(clazz.cast(maxConcurrentSessions()));
        case "networkSettingsArn":
            return Optional.ofNullable(clazz.cast(networkSettingsArn()));
        case "portalArn":
            return Optional.ofNullable(clazz.cast(portalArn()));
        case "portalEndpoint":
            return Optional.ofNullable(clazz.cast(portalEndpoint()));
        case "portalStatus":
            return Optional.ofNullable(clazz.cast(portalStatusAsString()));
        case "rendererType":
            return Optional.ofNullable(clazz.cast(rendererTypeAsString()));
        case "trustStoreArn":
            return Optional.ofNullable(clazz.cast(trustStoreArn()));
        case "userAccessLoggingSettingsArn":
            return Optional.ofNullable(clazz.cast(userAccessLoggingSettingsArn()));
        case "userSettingsArn":
            return Optional.ofNullable(clazz.cast(userSettingsArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PortalSummary, T> g) {
        return obj -> g.apply((PortalSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PortalSummary> {
        /**
         * <p>
         * The type of authentication integration points used when signing into the web portal. Defaults to
         * <code>Standard</code>.
         * </p>
         * <p>
         * <code>Standard</code> web portals are authenticated directly through your identity provider. You need to call
         * <code>CreateIdentityProvider</code> to integrate your identity provider with your web portal. User and group
         * access to your web portal is controlled through your identity provider.
         * </p>
         * <p>
         * <code>IAM Identity Center</code> web portals are authenticated through IAM Identity Center (successor to
         * Single Sign-On). Identity sources (including external identity provider integration), plus user and group
         * access to your web portal, can be configured in the IAM Identity Center.
         * </p>
         * 
         * @param authenticationType
         *        The type of authentication integration points used when signing into the web portal. Defaults to
         *        <code>Standard</code>.</p>
         *        <p>
         *        <code>Standard</code> web portals are authenticated directly through your identity provider. You need
         *        to call <code>CreateIdentityProvider</code> to integrate your identity provider with your web portal.
         *        User and group access to your web portal is controlled through your identity provider.
         *        </p>
         *        <p>
         *        <code>IAM Identity Center</code> web portals are authenticated through IAM Identity Center (successor
         *        to Single Sign-On). Identity sources (including external identity provider integration), plus user and
         *        group access to your web portal, can be configured in the IAM Identity Center.
         * @see AuthenticationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthenticationType
         */
        Builder authenticationType(String authenticationType);

        /**
         * <p>
         * The type of authentication integration points used when signing into the web portal. Defaults to
         * <code>Standard</code>.
         * </p>
         * <p>
         * <code>Standard</code> web portals are authenticated directly through your identity provider. You need to call
         * <code>CreateIdentityProvider</code> to integrate your identity provider with your web portal. User and group
         * access to your web portal is controlled through your identity provider.
         * </p>
         * <p>
         * <code>IAM Identity Center</code> web portals are authenticated through IAM Identity Center (successor to
         * Single Sign-On). Identity sources (including external identity provider integration), plus user and group
         * access to your web portal, can be configured in the IAM Identity Center.
         * </p>
         * 
         * @param authenticationType
         *        The type of authentication integration points used when signing into the web portal. Defaults to
         *        <code>Standard</code>.</p>
         *        <p>
         *        <code>Standard</code> web portals are authenticated directly through your identity provider. You need
         *        to call <code>CreateIdentityProvider</code> to integrate your identity provider with your web portal.
         *        User and group access to your web portal is controlled through your identity provider.
         *        </p>
         *        <p>
         *        <code>IAM Identity Center</code> web portals are authenticated through IAM Identity Center (successor
         *        to Single Sign-On). Identity sources (including external identity provider integration), plus user and
         *        group access to your web portal, can be configured in the IAM Identity Center.
         * @see AuthenticationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthenticationType
         */
        Builder authenticationType(AuthenticationType authenticationType);

        /**
         * <p>
         * The ARN of the browser settings that is associated with the web portal.
         * </p>
         * 
         * @param browserSettingsArn
         *        The ARN of the browser settings that is associated with the web portal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder browserSettingsArn(String browserSettingsArn);

        /**
         * <p>
         * The browser type of the web portal.
         * </p>
         * 
         * @param browserType
         *        The browser type of the web portal.
         * @see BrowserType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BrowserType
         */
        Builder browserType(String browserType);

        /**
         * <p>
         * The browser type of the web portal.
         * </p>
         * 
         * @param browserType
         *        The browser type of the web portal.
         * @see BrowserType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BrowserType
         */
        Builder browserType(BrowserType browserType);

        /**
         * <p>
         * The creation date of the web portal.
         * </p>
         * 
         * @param creationDate
         *        The creation date of the web portal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * The name of the web portal.
         * </p>
         * 
         * @param displayName
         *        The name of the web portal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The type and resources of the underlying instance.
         * </p>
         * 
         * @param instanceType
         *        The type and resources of the underlying instance.
         * @see InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceType
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The type and resources of the underlying instance.
         * </p>
         * 
         * @param instanceType
         *        The type and resources of the underlying instance.
         * @see InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceType
         */
        Builder instanceType(InstanceType instanceType);

        /**
         * <p>
         * The ARN of the IP access settings.
         * </p>
         * 
         * @param ipAccessSettingsArn
         *        The ARN of the IP access settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipAccessSettingsArn(String ipAccessSettingsArn);

        /**
         * <p>
         * The maximum number of concurrent sessions for the portal.
         * </p>
         * 
         * @param maxConcurrentSessions
         *        The maximum number of concurrent sessions for the portal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxConcurrentSessions(Integer maxConcurrentSessions);

        /**
         * <p>
         * The ARN of the network settings that is associated with the web portal.
         * </p>
         * 
         * @param networkSettingsArn
         *        The ARN of the network settings that is associated with the web portal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkSettingsArn(String networkSettingsArn);

        /**
         * <p>
         * The ARN of the web portal.
         * </p>
         * 
         * @param portalArn
         *        The ARN of the web portal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portalArn(String portalArn);

        /**
         * <p>
         * The endpoint URL of the web portal that users access in order to start streaming sessions.
         * </p>
         * 
         * @param portalEndpoint
         *        The endpoint URL of the web portal that users access in order to start streaming sessions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portalEndpoint(String portalEndpoint);

        /**
         * <p>
         * The status of the web portal.
         * </p>
         * 
         * @param portalStatus
         *        The status of the web portal.
         * @see PortalStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PortalStatus
         */
        Builder portalStatus(String portalStatus);

        /**
         * <p>
         * The status of the web portal.
         * </p>
         * 
         * @param portalStatus
         *        The status of the web portal.
         * @see PortalStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PortalStatus
         */
        Builder portalStatus(PortalStatus portalStatus);

        /**
         * <p>
         * The renderer that is used in streaming sessions.
         * </p>
         * 
         * @param rendererType
         *        The renderer that is used in streaming sessions.
         * @see RendererType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RendererType
         */
        Builder rendererType(String rendererType);

        /**
         * <p>
         * The renderer that is used in streaming sessions.
         * </p>
         * 
         * @param rendererType
         *        The renderer that is used in streaming sessions.
         * @see RendererType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RendererType
         */
        Builder rendererType(RendererType rendererType);

        /**
         * <p>
         * The ARN of the trust that is associated with this web portal.
         * </p>
         * 
         * @param trustStoreArn
         *        The ARN of the trust that is associated with this web portal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trustStoreArn(String trustStoreArn);

        /**
         * <p>
         * The ARN of the user access logging settings that is associated with the web portal.
         * </p>
         * 
         * @param userAccessLoggingSettingsArn
         *        The ARN of the user access logging settings that is associated with the web portal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userAccessLoggingSettingsArn(String userAccessLoggingSettingsArn);

        /**
         * <p>
         * The ARN of the user settings that is associated with the web portal.
         * </p>
         * 
         * @param userSettingsArn
         *        The ARN of the user settings that is associated with the web portal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userSettingsArn(String userSettingsArn);
    }

    static final class BuilderImpl implements Builder {
        private String authenticationType;

        private String browserSettingsArn;

        private String browserType;

        private Instant creationDate;

        private String displayName;

        private String instanceType;

        private String ipAccessSettingsArn;

        private Integer maxConcurrentSessions;

        private String networkSettingsArn;

        private String portalArn;

        private String portalEndpoint;

        private String portalStatus;

        private String rendererType;

        private String trustStoreArn;

        private String userAccessLoggingSettingsArn;

        private String userSettingsArn;

        private BuilderImpl() {
        }

        private BuilderImpl(PortalSummary model) {
            authenticationType(model.authenticationType);
            browserSettingsArn(model.browserSettingsArn);
            browserType(model.browserType);
            creationDate(model.creationDate);
            displayName(model.displayName);
            instanceType(model.instanceType);
            ipAccessSettingsArn(model.ipAccessSettingsArn);
            maxConcurrentSessions(model.maxConcurrentSessions);
            networkSettingsArn(model.networkSettingsArn);
            portalArn(model.portalArn);
            portalEndpoint(model.portalEndpoint);
            portalStatus(model.portalStatus);
            rendererType(model.rendererType);
            trustStoreArn(model.trustStoreArn);
            userAccessLoggingSettingsArn(model.userAccessLoggingSettingsArn);
            userSettingsArn(model.userSettingsArn);
        }

        public final String getAuthenticationType() {
            return authenticationType;
        }

        public final void setAuthenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
        }

        @Override
        public final Builder authenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
            return this;
        }

        @Override
        public final Builder authenticationType(AuthenticationType authenticationType) {
            this.authenticationType(authenticationType == null ? null : authenticationType.toString());
            return this;
        }

        public final String getBrowserSettingsArn() {
            return browserSettingsArn;
        }

        public final void setBrowserSettingsArn(String browserSettingsArn) {
            this.browserSettingsArn = browserSettingsArn;
        }

        @Override
        public final Builder browserSettingsArn(String browserSettingsArn) {
            this.browserSettingsArn = browserSettingsArn;
            return this;
        }

        public final String getBrowserType() {
            return browserType;
        }

        public final void setBrowserType(String browserType) {
            this.browserType = browserType;
        }

        @Override
        public final Builder browserType(String browserType) {
            this.browserType = browserType;
            return this;
        }

        @Override
        public final Builder browserType(BrowserType browserType) {
            this.browserType(browserType == null ? null : browserType.toString());
            return this;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final String getIpAccessSettingsArn() {
            return ipAccessSettingsArn;
        }

        public final void setIpAccessSettingsArn(String ipAccessSettingsArn) {
            this.ipAccessSettingsArn = ipAccessSettingsArn;
        }

        @Override
        public final Builder ipAccessSettingsArn(String ipAccessSettingsArn) {
            this.ipAccessSettingsArn = ipAccessSettingsArn;
            return this;
        }

        public final Integer getMaxConcurrentSessions() {
            return maxConcurrentSessions;
        }

        public final void setMaxConcurrentSessions(Integer maxConcurrentSessions) {
            this.maxConcurrentSessions = maxConcurrentSessions;
        }

        @Override
        public final Builder maxConcurrentSessions(Integer maxConcurrentSessions) {
            this.maxConcurrentSessions = maxConcurrentSessions;
            return this;
        }

        public final String getNetworkSettingsArn() {
            return networkSettingsArn;
        }

        public final void setNetworkSettingsArn(String networkSettingsArn) {
            this.networkSettingsArn = networkSettingsArn;
        }

        @Override
        public final Builder networkSettingsArn(String networkSettingsArn) {
            this.networkSettingsArn = networkSettingsArn;
            return this;
        }

        public final String getPortalArn() {
            return portalArn;
        }

        public final void setPortalArn(String portalArn) {
            this.portalArn = portalArn;
        }

        @Override
        public final Builder portalArn(String portalArn) {
            this.portalArn = portalArn;
            return this;
        }

        public final String getPortalEndpoint() {
            return portalEndpoint;
        }

        public final void setPortalEndpoint(String portalEndpoint) {
            this.portalEndpoint = portalEndpoint;
        }

        @Override
        public final Builder portalEndpoint(String portalEndpoint) {
            this.portalEndpoint = portalEndpoint;
            return this;
        }

        public final String getPortalStatus() {
            return portalStatus;
        }

        public final void setPortalStatus(String portalStatus) {
            this.portalStatus = portalStatus;
        }

        @Override
        public final Builder portalStatus(String portalStatus) {
            this.portalStatus = portalStatus;
            return this;
        }

        @Override
        public final Builder portalStatus(PortalStatus portalStatus) {
            this.portalStatus(portalStatus == null ? null : portalStatus.toString());
            return this;
        }

        public final String getRendererType() {
            return rendererType;
        }

        public final void setRendererType(String rendererType) {
            this.rendererType = rendererType;
        }

        @Override
        public final Builder rendererType(String rendererType) {
            this.rendererType = rendererType;
            return this;
        }

        @Override
        public final Builder rendererType(RendererType rendererType) {
            this.rendererType(rendererType == null ? null : rendererType.toString());
            return this;
        }

        public final String getTrustStoreArn() {
            return trustStoreArn;
        }

        public final void setTrustStoreArn(String trustStoreArn) {
            this.trustStoreArn = trustStoreArn;
        }

        @Override
        public final Builder trustStoreArn(String trustStoreArn) {
            this.trustStoreArn = trustStoreArn;
            return this;
        }

        public final String getUserAccessLoggingSettingsArn() {
            return userAccessLoggingSettingsArn;
        }

        public final void setUserAccessLoggingSettingsArn(String userAccessLoggingSettingsArn) {
            this.userAccessLoggingSettingsArn = userAccessLoggingSettingsArn;
        }

        @Override
        public final Builder userAccessLoggingSettingsArn(String userAccessLoggingSettingsArn) {
            this.userAccessLoggingSettingsArn = userAccessLoggingSettingsArn;
            return this;
        }

        public final String getUserSettingsArn() {
            return userSettingsArn;
        }

        public final void setUserSettingsArn(String userSettingsArn) {
            this.userSettingsArn = userSettingsArn;
        }

        @Override
        public final Builder userSettingsArn(String userSettingsArn) {
            this.userSettingsArn = userSettingsArn;
            return this;
        }

        @Override
        public PortalSummary build() {
            return new PortalSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
