/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspacesweb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreatePortalRequest extends WorkSpacesWebRequest implements
        ToCopyableBuilder<CreatePortalRequest.Builder, CreatePortalRequest> {
    private static final SdkField<Map<String, String>> ADDITIONAL_ENCRYPTION_CONTEXT_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("additionalEncryptionContext")
            .getter(getter(CreatePortalRequest::additionalEncryptionContext))
            .setter(setter(Builder::additionalEncryptionContext))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalEncryptionContext")
                    .build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> AUTHENTICATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("authenticationType").getter(getter(CreatePortalRequest::authenticationTypeAsString))
            .setter(setter(Builder::authenticationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authenticationType").build())
            .build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreatePortalRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> CUSTOMER_MANAGED_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("customerManagedKey").getter(getter(CreatePortalRequest::customerManagedKey))
            .setter(setter(Builder::customerManagedKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerManagedKey").build())
            .build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(CreatePortalRequest::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("instanceType").getter(getter(CreatePortalRequest::instanceTypeAsString))
            .setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceType").build()).build();

    private static final SdkField<Integer> MAX_CONCURRENT_SESSIONS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxConcurrentSessions").getter(getter(CreatePortalRequest::maxConcurrentSessions))
            .setter(setter(Builder::maxConcurrentSessions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxConcurrentSessions").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(CreatePortalRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ADDITIONAL_ENCRYPTION_CONTEXT_FIELD, AUTHENTICATION_TYPE_FIELD, CLIENT_TOKEN_FIELD, CUSTOMER_MANAGED_KEY_FIELD,
            DISPLAY_NAME_FIELD, INSTANCE_TYPE_FIELD, MAX_CONCURRENT_SESSIONS_FIELD, TAGS_FIELD));

    private final Map<String, String> additionalEncryptionContext;

    private final String authenticationType;

    private final String clientToken;

    private final String customerManagedKey;

    private final String displayName;

    private final String instanceType;

    private final Integer maxConcurrentSessions;

    private final List<Tag> tags;

    private CreatePortalRequest(BuilderImpl builder) {
        super(builder);
        this.additionalEncryptionContext = builder.additionalEncryptionContext;
        this.authenticationType = builder.authenticationType;
        this.clientToken = builder.clientToken;
        this.customerManagedKey = builder.customerManagedKey;
        this.displayName = builder.displayName;
        this.instanceType = builder.instanceType;
        this.maxConcurrentSessions = builder.maxConcurrentSessions;
        this.tags = builder.tags;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdditionalEncryptionContext property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAdditionalEncryptionContext() {
        return additionalEncryptionContext != null && !(additionalEncryptionContext instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The additional encryption context of the portal.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdditionalEncryptionContext} method.
     * </p>
     * 
     * @return The additional encryption context of the portal.
     */
    public final Map<String, String> additionalEncryptionContext() {
        return additionalEncryptionContext;
    }

    /**
     * <p>
     * The type of authentication integration points used when signing into the web portal. Defaults to
     * <code>Standard</code>.
     * </p>
     * <p>
     * <code>Standard</code> web portals are authenticated directly through your identity provider. You need to call
     * <code>CreateIdentityProvider</code> to integrate your identity provider with your web portal. User and group
     * access to your web portal is controlled through your identity provider.
     * </p>
     * <p>
     * <code>IAM Identity Center</code> web portals are authenticated through IAM Identity Center (successor to Single
     * Sign-On). Identity sources (including external identity provider integration), plus user and group access to your
     * web portal, can be configured in the IAM Identity Center.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authenticationType} will return {@link AuthenticationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #authenticationTypeAsString}.
     * </p>
     * 
     * @return The type of authentication integration points used when signing into the web portal. Defaults to
     *         <code>Standard</code>.</p>
     *         <p>
     *         <code>Standard</code> web portals are authenticated directly through your identity provider. You need to
     *         call <code>CreateIdentityProvider</code> to integrate your identity provider with your web portal. User
     *         and group access to your web portal is controlled through your identity provider.
     *         </p>
     *         <p>
     *         <code>IAM Identity Center</code> web portals are authenticated through IAM Identity Center (successor to
     *         Single Sign-On). Identity sources (including external identity provider integration), plus user and group
     *         access to your web portal, can be configured in the IAM Identity Center.
     * @see AuthenticationType
     */
    public final AuthenticationType authenticationType() {
        return AuthenticationType.fromValue(authenticationType);
    }

    /**
     * <p>
     * The type of authentication integration points used when signing into the web portal. Defaults to
     * <code>Standard</code>.
     * </p>
     * <p>
     * <code>Standard</code> web portals are authenticated directly through your identity provider. You need to call
     * <code>CreateIdentityProvider</code> to integrate your identity provider with your web portal. User and group
     * access to your web portal is controlled through your identity provider.
     * </p>
     * <p>
     * <code>IAM Identity Center</code> web portals are authenticated through IAM Identity Center (successor to Single
     * Sign-On). Identity sources (including external identity provider integration), plus user and group access to your
     * web portal, can be configured in the IAM Identity Center.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authenticationType} will return {@link AuthenticationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #authenticationTypeAsString}.
     * </p>
     * 
     * @return The type of authentication integration points used when signing into the web portal. Defaults to
     *         <code>Standard</code>.</p>
     *         <p>
     *         <code>Standard</code> web portals are authenticated directly through your identity provider. You need to
     *         call <code>CreateIdentityProvider</code> to integrate your identity provider with your web portal. User
     *         and group access to your web portal is controlled through your identity provider.
     *         </p>
     *         <p>
     *         <code>IAM Identity Center</code> web portals are authenticated through IAM Identity Center (successor to
     *         Single Sign-On). Identity sources (including external identity provider integration), plus user and group
     *         access to your web portal, can be configured in the IAM Identity Center.
     * @see AuthenticationType
     */
    public final String authenticationTypeAsString() {
        return authenticationType;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency
     * ensures that an API request completes only once. With an idempotent request, if the original request completes
     * successfully, subsequent retries with the same client token returns the result from the original successful
     * request.
     * </p>
     * <p>
     * If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.
     * </p>
     * 
     * @return A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     *         Idempotency ensures that an API request completes only once. With an idempotent request, if the original
     *         request completes successfully, subsequent retries with the same client token returns the result from the
     *         original successful request. </p>
     *         <p>
     *         If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The customer managed key of the web portal.
     * </p>
     * 
     * @return The customer managed key of the web portal.
     */
    public final String customerManagedKey() {
        return customerManagedKey;
    }

    /**
     * <p>
     * The name of the web portal. This is not visible to users who log into the web portal.
     * </p>
     * 
     * @return The name of the web portal. This is not visible to users who log into the web portal.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The type and resources of the underlying instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link InstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The type and resources of the underlying instance.
     * @see InstanceType
     */
    public final InstanceType instanceType() {
        return InstanceType.fromValue(instanceType);
    }

    /**
     * <p>
     * The type and resources of the underlying instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link InstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The type and resources of the underlying instance.
     * @see InstanceType
     */
    public final String instanceTypeAsString() {
        return instanceType;
    }

    /**
     * <p>
     * The maximum number of concurrent sessions for the portal.
     * </p>
     * 
     * @return The maximum number of concurrent sessions for the portal.
     */
    public final Integer maxConcurrentSessions() {
        return maxConcurrentSessions;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags to add to the web portal. A tag is a key-value pair.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags to add to the web portal. A tag is a key-value pair.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAdditionalEncryptionContext() ? additionalEncryptionContext() : null);
        hashCode = 31 * hashCode + Objects.hashCode(authenticationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(customerManagedKey());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxConcurrentSessions());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePortalRequest)) {
            return false;
        }
        CreatePortalRequest other = (CreatePortalRequest) obj;
        return hasAdditionalEncryptionContext() == other.hasAdditionalEncryptionContext()
                && Objects.equals(additionalEncryptionContext(), other.additionalEncryptionContext())
                && Objects.equals(authenticationTypeAsString(), other.authenticationTypeAsString())
                && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(customerManagedKey(), other.customerManagedKey())
                && Objects.equals(displayName(), other.displayName())
                && Objects.equals(instanceTypeAsString(), other.instanceTypeAsString())
                && Objects.equals(maxConcurrentSessions(), other.maxConcurrentSessions()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreatePortalRequest")
                .add("AdditionalEncryptionContext", hasAdditionalEncryptionContext() ? additionalEncryptionContext() : null)
                .add("AuthenticationType", authenticationTypeAsString()).add("ClientToken", clientToken())
                .add("CustomerManagedKey", customerManagedKey())
                .add("DisplayName", displayName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("InstanceType", instanceTypeAsString()).add("MaxConcurrentSessions", maxConcurrentSessions())
                .add("Tags", tags() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "additionalEncryptionContext":
            return Optional.ofNullable(clazz.cast(additionalEncryptionContext()));
        case "authenticationType":
            return Optional.ofNullable(clazz.cast(authenticationTypeAsString()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "customerManagedKey":
            return Optional.ofNullable(clazz.cast(customerManagedKey()));
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "instanceType":
            return Optional.ofNullable(clazz.cast(instanceTypeAsString()));
        case "maxConcurrentSessions":
            return Optional.ofNullable(clazz.cast(maxConcurrentSessions()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreatePortalRequest, T> g) {
        return obj -> g.apply((CreatePortalRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends WorkSpacesWebRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreatePortalRequest> {
        /**
         * <p>
         * The additional encryption context of the portal.
         * </p>
         * 
         * @param additionalEncryptionContext
         *        The additional encryption context of the portal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalEncryptionContext(Map<String, String> additionalEncryptionContext);

        /**
         * <p>
         * The type of authentication integration points used when signing into the web portal. Defaults to
         * <code>Standard</code>.
         * </p>
         * <p>
         * <code>Standard</code> web portals are authenticated directly through your identity provider. You need to call
         * <code>CreateIdentityProvider</code> to integrate your identity provider with your web portal. User and group
         * access to your web portal is controlled through your identity provider.
         * </p>
         * <p>
         * <code>IAM Identity Center</code> web portals are authenticated through IAM Identity Center (successor to
         * Single Sign-On). Identity sources (including external identity provider integration), plus user and group
         * access to your web portal, can be configured in the IAM Identity Center.
         * </p>
         * 
         * @param authenticationType
         *        The type of authentication integration points used when signing into the web portal. Defaults to
         *        <code>Standard</code>.</p>
         *        <p>
         *        <code>Standard</code> web portals are authenticated directly through your identity provider. You need
         *        to call <code>CreateIdentityProvider</code> to integrate your identity provider with your web portal.
         *        User and group access to your web portal is controlled through your identity provider.
         *        </p>
         *        <p>
         *        <code>IAM Identity Center</code> web portals are authenticated through IAM Identity Center (successor
         *        to Single Sign-On). Identity sources (including external identity provider integration), plus user and
         *        group access to your web portal, can be configured in the IAM Identity Center.
         * @see AuthenticationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthenticationType
         */
        Builder authenticationType(String authenticationType);

        /**
         * <p>
         * The type of authentication integration points used when signing into the web portal. Defaults to
         * <code>Standard</code>.
         * </p>
         * <p>
         * <code>Standard</code> web portals are authenticated directly through your identity provider. You need to call
         * <code>CreateIdentityProvider</code> to integrate your identity provider with your web portal. User and group
         * access to your web portal is controlled through your identity provider.
         * </p>
         * <p>
         * <code>IAM Identity Center</code> web portals are authenticated through IAM Identity Center (successor to
         * Single Sign-On). Identity sources (including external identity provider integration), plus user and group
         * access to your web portal, can be configured in the IAM Identity Center.
         * </p>
         * 
         * @param authenticationType
         *        The type of authentication integration points used when signing into the web portal. Defaults to
         *        <code>Standard</code>.</p>
         *        <p>
         *        <code>Standard</code> web portals are authenticated directly through your identity provider. You need
         *        to call <code>CreateIdentityProvider</code> to integrate your identity provider with your web portal.
         *        User and group access to your web portal is controlled through your identity provider.
         *        </p>
         *        <p>
         *        <code>IAM Identity Center</code> web portals are authenticated through IAM Identity Center (successor
         *        to Single Sign-On). Identity sources (including external identity provider integration), plus user and
         *        group access to your web portal, can be configured in the IAM Identity Center.
         * @see AuthenticationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthenticationType
         */
        Builder authenticationType(AuthenticationType authenticationType);

        /**
         * <p>
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request. Idempotency
         * ensures that an API request completes only once. With an idempotent request, if the original request
         * completes successfully, subsequent retries with the same client token returns the result from the original
         * successful request.
         * </p>
         * <p>
         * If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         *        Idempotency ensures that an API request completes only once. With an idempotent request, if the
         *        original request completes successfully, subsequent retries with the same client token returns the
         *        result from the original successful request. </p>
         *        <p>
         *        If you do not specify a client token, one is automatically generated by the Amazon Web Services SDK.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The customer managed key of the web portal.
         * </p>
         * 
         * @param customerManagedKey
         *        The customer managed key of the web portal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerManagedKey(String customerManagedKey);

        /**
         * <p>
         * The name of the web portal. This is not visible to users who log into the web portal.
         * </p>
         * 
         * @param displayName
         *        The name of the web portal. This is not visible to users who log into the web portal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The type and resources of the underlying instance.
         * </p>
         * 
         * @param instanceType
         *        The type and resources of the underlying instance.
         * @see InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceType
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The type and resources of the underlying instance.
         * </p>
         * 
         * @param instanceType
         *        The type and resources of the underlying instance.
         * @see InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceType
         */
        Builder instanceType(InstanceType instanceType);

        /**
         * <p>
         * The maximum number of concurrent sessions for the portal.
         * </p>
         * 
         * @param maxConcurrentSessions
         *        The maximum number of concurrent sessions for the portal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxConcurrentSessions(Integer maxConcurrentSessions);

        /**
         * <p>
         * The tags to add to the web portal. A tag is a key-value pair.
         * </p>
         * 
         * @param tags
         *        The tags to add to the web portal. A tag is a key-value pair.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags to add to the web portal. A tag is a key-value pair.
         * </p>
         * 
         * @param tags
         *        The tags to add to the web portal. A tag is a key-value pair.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags to add to the web portal. A tag is a key-value pair.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.workspacesweb.model.Tag.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.workspacesweb.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.workspacesweb.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.workspacesweb.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends WorkSpacesWebRequest.BuilderImpl implements Builder {
        private Map<String, String> additionalEncryptionContext = DefaultSdkAutoConstructMap.getInstance();

        private String authenticationType;

        private String clientToken;

        private String customerManagedKey;

        private String displayName;

        private String instanceType;

        private Integer maxConcurrentSessions;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePortalRequest model) {
            super(model);
            additionalEncryptionContext(model.additionalEncryptionContext);
            authenticationType(model.authenticationType);
            clientToken(model.clientToken);
            customerManagedKey(model.customerManagedKey);
            displayName(model.displayName);
            instanceType(model.instanceType);
            maxConcurrentSessions(model.maxConcurrentSessions);
            tags(model.tags);
        }

        public final Map<String, String> getAdditionalEncryptionContext() {
            if (additionalEncryptionContext instanceof SdkAutoConstructMap) {
                return null;
            }
            return additionalEncryptionContext;
        }

        public final void setAdditionalEncryptionContext(Map<String, String> additionalEncryptionContext) {
            this.additionalEncryptionContext = EncryptionContextMapCopier.copy(additionalEncryptionContext);
        }

        @Override
        public final Builder additionalEncryptionContext(Map<String, String> additionalEncryptionContext) {
            this.additionalEncryptionContext = EncryptionContextMapCopier.copy(additionalEncryptionContext);
            return this;
        }

        public final String getAuthenticationType() {
            return authenticationType;
        }

        public final void setAuthenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
        }

        @Override
        public final Builder authenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
            return this;
        }

        @Override
        public final Builder authenticationType(AuthenticationType authenticationType) {
            this.authenticationType(authenticationType == null ? null : authenticationType.toString());
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getCustomerManagedKey() {
            return customerManagedKey;
        }

        public final void setCustomerManagedKey(String customerManagedKey) {
            this.customerManagedKey = customerManagedKey;
        }

        @Override
        public final Builder customerManagedKey(String customerManagedKey) {
            this.customerManagedKey = customerManagedKey;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final Integer getMaxConcurrentSessions() {
            return maxConcurrentSessions;
        }

        public final void setMaxConcurrentSessions(Integer maxConcurrentSessions) {
            this.maxConcurrentSessions = maxConcurrentSessions;
        }

        @Override
        public final Builder maxConcurrentSessions(Integer maxConcurrentSessions) {
            this.maxConcurrentSessions = maxConcurrentSessions;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePortalRequest build() {
            return new CreatePortalRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
