/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspacesweb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for in-session inline redaction.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InlineRedactionConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<InlineRedactionConfiguration.Builder, InlineRedactionConfiguration> {
    private static final SdkField<Integer> GLOBAL_CONFIDENCE_LEVEL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("globalConfidenceLevel").getter(getter(InlineRedactionConfiguration::globalConfidenceLevel))
            .setter(setter(Builder::globalConfidenceLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("globalConfidenceLevel").build())
            .build();

    private static final SdkField<List<String>> GLOBAL_ENFORCED_URLS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("globalEnforcedUrls")
            .getter(getter(InlineRedactionConfiguration::globalEnforcedUrls))
            .setter(setter(Builder::globalEnforcedUrls))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("globalEnforcedUrls").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> GLOBAL_EXEMPT_URLS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("globalExemptUrls")
            .getter(getter(InlineRedactionConfiguration::globalExemptUrls))
            .setter(setter(Builder::globalExemptUrls))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("globalExemptUrls").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<InlineRedactionPattern>> INLINE_REDACTION_PATTERNS_FIELD = SdkField
            .<List<InlineRedactionPattern>> builder(MarshallingType.LIST)
            .memberName("inlineRedactionPatterns")
            .getter(getter(InlineRedactionConfiguration::inlineRedactionPatterns))
            .setter(setter(Builder::inlineRedactionPatterns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inlineRedactionPatterns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InlineRedactionPattern> builder(MarshallingType.SDK_POJO)
                                            .constructor(InlineRedactionPattern::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GLOBAL_CONFIDENCE_LEVEL_FIELD,
            GLOBAL_ENFORCED_URLS_FIELD, GLOBAL_EXEMPT_URLS_FIELD, INLINE_REDACTION_PATTERNS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("globalConfidenceLevel", GLOBAL_CONFIDENCE_LEVEL_FIELD);
                    put("globalEnforcedUrls", GLOBAL_ENFORCED_URLS_FIELD);
                    put("globalExemptUrls", GLOBAL_EXEMPT_URLS_FIELD);
                    put("inlineRedactionPatterns", INLINE_REDACTION_PATTERNS_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final Integer globalConfidenceLevel;

    private final List<String> globalEnforcedUrls;

    private final List<String> globalExemptUrls;

    private final List<InlineRedactionPattern> inlineRedactionPatterns;

    private InlineRedactionConfiguration(BuilderImpl builder) {
        this.globalConfidenceLevel = builder.globalConfidenceLevel;
        this.globalEnforcedUrls = builder.globalEnforcedUrls;
        this.globalExemptUrls = builder.globalExemptUrls;
        this.inlineRedactionPatterns = builder.inlineRedactionPatterns;
    }

    /**
     * <p>
     * The global confidence level for the inline redaction configuration. This indicates the certainty of data type
     * matches in the redaction process. Confidence level 3 means high confidence, and requires a formatted text pattern
     * match in order for content to be redacted. Confidence level 2 means medium confidence, and redaction considers
     * both formatted and unformatted text, and adds keyword associate to the logic. Confidence level 1 means low
     * confidence, and redaction is enforced for both formatted pattern + unformatted pattern without keyword. This is
     * applied to patterns that do not have a pattern-level confidence level. Defaults to confidence level 2.
     * </p>
     * 
     * @return The global confidence level for the inline redaction configuration. This indicates the certainty of data
     *         type matches in the redaction process. Confidence level 3 means high confidence, and requires a formatted
     *         text pattern match in order for content to be redacted. Confidence level 2 means medium confidence, and
     *         redaction considers both formatted and unformatted text, and adds keyword associate to the logic.
     *         Confidence level 1 means low confidence, and redaction is enforced for both formatted pattern +
     *         unformatted pattern without keyword. This is applied to patterns that do not have a pattern-level
     *         confidence level. Defaults to confidence level 2.
     */
    public final Integer globalConfidenceLevel() {
        return globalConfidenceLevel;
    }

    /**
     * For responses, this returns true if the service returned a value for the GlobalEnforcedUrls property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasGlobalEnforcedUrls() {
        return globalEnforcedUrls != null && !(globalEnforcedUrls instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The global enforced URL configuration for the inline redaction configuration. This is applied to patterns that do
     * not have a pattern-level enforced URL list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGlobalEnforcedUrls} method.
     * </p>
     * 
     * @return The global enforced URL configuration for the inline redaction configuration. This is applied to patterns
     *         that do not have a pattern-level enforced URL list.
     */
    public final List<String> globalEnforcedUrls() {
        return globalEnforcedUrls;
    }

    /**
     * For responses, this returns true if the service returned a value for the GlobalExemptUrls property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasGlobalExemptUrls() {
        return globalExemptUrls != null && !(globalExemptUrls instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The global exempt URL configuration for the inline redaction configuration. This is applied to patterns that do
     * not have a pattern-level exempt URL list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGlobalExemptUrls} method.
     * </p>
     * 
     * @return The global exempt URL configuration for the inline redaction configuration. This is applied to patterns
     *         that do not have a pattern-level exempt URL list.
     */
    public final List<String> globalExemptUrls() {
        return globalExemptUrls;
    }

    /**
     * For responses, this returns true if the service returned a value for the InlineRedactionPatterns property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasInlineRedactionPatterns() {
        return inlineRedactionPatterns != null && !(inlineRedactionPatterns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The inline redaction patterns to be enabled for the inline redaction configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInlineRedactionPatterns} method.
     * </p>
     * 
     * @return The inline redaction patterns to be enabled for the inline redaction configuration.
     */
    public final List<InlineRedactionPattern> inlineRedactionPatterns() {
        return inlineRedactionPatterns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(globalConfidenceLevel());
        hashCode = 31 * hashCode + Objects.hashCode(hasGlobalEnforcedUrls() ? globalEnforcedUrls() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasGlobalExemptUrls() ? globalExemptUrls() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasInlineRedactionPatterns() ? inlineRedactionPatterns() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InlineRedactionConfiguration)) {
            return false;
        }
        InlineRedactionConfiguration other = (InlineRedactionConfiguration) obj;
        return Objects.equals(globalConfidenceLevel(), other.globalConfidenceLevel())
                && hasGlobalEnforcedUrls() == other.hasGlobalEnforcedUrls()
                && Objects.equals(globalEnforcedUrls(), other.globalEnforcedUrls())
                && hasGlobalExemptUrls() == other.hasGlobalExemptUrls()
                && Objects.equals(globalExemptUrls(), other.globalExemptUrls())
                && hasInlineRedactionPatterns() == other.hasInlineRedactionPatterns()
                && Objects.equals(inlineRedactionPatterns(), other.inlineRedactionPatterns());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InlineRedactionConfiguration").add("GlobalConfidenceLevel", globalConfidenceLevel())
                .add("GlobalEnforcedUrls", globalEnforcedUrls() == null ? null : "*** Sensitive Data Redacted ***")
                .add("GlobalExemptUrls", globalExemptUrls() == null ? null : "*** Sensitive Data Redacted ***")
                .add("InlineRedactionPatterns", hasInlineRedactionPatterns() ? inlineRedactionPatterns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "globalConfidenceLevel":
            return Optional.ofNullable(clazz.cast(globalConfidenceLevel()));
        case "globalEnforcedUrls":
            return Optional.ofNullable(clazz.cast(globalEnforcedUrls()));
        case "globalExemptUrls":
            return Optional.ofNullable(clazz.cast(globalExemptUrls()));
        case "inlineRedactionPatterns":
            return Optional.ofNullable(clazz.cast(inlineRedactionPatterns()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<InlineRedactionConfiguration, T> g) {
        return obj -> g.apply((InlineRedactionConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InlineRedactionConfiguration> {
        /**
         * <p>
         * The global confidence level for the inline redaction configuration. This indicates the certainty of data type
         * matches in the redaction process. Confidence level 3 means high confidence, and requires a formatted text
         * pattern match in order for content to be redacted. Confidence level 2 means medium confidence, and redaction
         * considers both formatted and unformatted text, and adds keyword associate to the logic. Confidence level 1
         * means low confidence, and redaction is enforced for both formatted pattern + unformatted pattern without
         * keyword. This is applied to patterns that do not have a pattern-level confidence level. Defaults to
         * confidence level 2.
         * </p>
         * 
         * @param globalConfidenceLevel
         *        The global confidence level for the inline redaction configuration. This indicates the certainty of
         *        data type matches in the redaction process. Confidence level 3 means high confidence, and requires a
         *        formatted text pattern match in order for content to be redacted. Confidence level 2 means medium
         *        confidence, and redaction considers both formatted and unformatted text, and adds keyword associate to
         *        the logic. Confidence level 1 means low confidence, and redaction is enforced for both formatted
         *        pattern + unformatted pattern without keyword. This is applied to patterns that do not have a
         *        pattern-level confidence level. Defaults to confidence level 2.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalConfidenceLevel(Integer globalConfidenceLevel);

        /**
         * <p>
         * The global enforced URL configuration for the inline redaction configuration. This is applied to patterns
         * that do not have a pattern-level enforced URL list.
         * </p>
         * 
         * @param globalEnforcedUrls
         *        The global enforced URL configuration for the inline redaction configuration. This is applied to
         *        patterns that do not have a pattern-level enforced URL list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalEnforcedUrls(Collection<String> globalEnforcedUrls);

        /**
         * <p>
         * The global enforced URL configuration for the inline redaction configuration. This is applied to patterns
         * that do not have a pattern-level enforced URL list.
         * </p>
         * 
         * @param globalEnforcedUrls
         *        The global enforced URL configuration for the inline redaction configuration. This is applied to
         *        patterns that do not have a pattern-level enforced URL list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalEnforcedUrls(String... globalEnforcedUrls);

        /**
         * <p>
         * The global exempt URL configuration for the inline redaction configuration. This is applied to patterns that
         * do not have a pattern-level exempt URL list.
         * </p>
         * 
         * @param globalExemptUrls
         *        The global exempt URL configuration for the inline redaction configuration. This is applied to
         *        patterns that do not have a pattern-level exempt URL list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalExemptUrls(Collection<String> globalExemptUrls);

        /**
         * <p>
         * The global exempt URL configuration for the inline redaction configuration. This is applied to patterns that
         * do not have a pattern-level exempt URL list.
         * </p>
         * 
         * @param globalExemptUrls
         *        The global exempt URL configuration for the inline redaction configuration. This is applied to
         *        patterns that do not have a pattern-level exempt URL list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalExemptUrls(String... globalExemptUrls);

        /**
         * <p>
         * The inline redaction patterns to be enabled for the inline redaction configuration.
         * </p>
         * 
         * @param inlineRedactionPatterns
         *        The inline redaction patterns to be enabled for the inline redaction configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inlineRedactionPatterns(Collection<InlineRedactionPattern> inlineRedactionPatterns);

        /**
         * <p>
         * The inline redaction patterns to be enabled for the inline redaction configuration.
         * </p>
         * 
         * @param inlineRedactionPatterns
         *        The inline redaction patterns to be enabled for the inline redaction configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inlineRedactionPatterns(InlineRedactionPattern... inlineRedactionPatterns);

        /**
         * <p>
         * The inline redaction patterns to be enabled for the inline redaction configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.workspacesweb.model.InlineRedactionPattern.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.workspacesweb.model.InlineRedactionPattern#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.workspacesweb.model.InlineRedactionPattern.Builder#build()} is called
         * immediately and its result is passed to {@link #inlineRedactionPatterns(List<InlineRedactionPattern>)}.
         * 
         * @param inlineRedactionPatterns
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.workspacesweb.model.InlineRedactionPattern.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inlineRedactionPatterns(java.util.Collection<InlineRedactionPattern>)
         */
        Builder inlineRedactionPatterns(Consumer<InlineRedactionPattern.Builder>... inlineRedactionPatterns);
    }

    static final class BuilderImpl implements Builder {
        private Integer globalConfidenceLevel;

        private List<String> globalEnforcedUrls = DefaultSdkAutoConstructList.getInstance();

        private List<String> globalExemptUrls = DefaultSdkAutoConstructList.getInstance();

        private List<InlineRedactionPattern> inlineRedactionPatterns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InlineRedactionConfiguration model) {
            globalConfidenceLevel(model.globalConfidenceLevel);
            globalEnforcedUrls(model.globalEnforcedUrls);
            globalExemptUrls(model.globalExemptUrls);
            inlineRedactionPatterns(model.inlineRedactionPatterns);
        }

        public final Integer getGlobalConfidenceLevel() {
            return globalConfidenceLevel;
        }

        public final void setGlobalConfidenceLevel(Integer globalConfidenceLevel) {
            this.globalConfidenceLevel = globalConfidenceLevel;
        }

        @Override
        public final Builder globalConfidenceLevel(Integer globalConfidenceLevel) {
            this.globalConfidenceLevel = globalConfidenceLevel;
            return this;
        }

        public final Collection<String> getGlobalEnforcedUrls() {
            if (globalEnforcedUrls instanceof SdkAutoConstructList) {
                return null;
            }
            return globalEnforcedUrls;
        }

        public final void setGlobalEnforcedUrls(Collection<String> globalEnforcedUrls) {
            this.globalEnforcedUrls = GlobalInlineRedactionUrlsCopier.copy(globalEnforcedUrls);
        }

        @Override
        public final Builder globalEnforcedUrls(Collection<String> globalEnforcedUrls) {
            this.globalEnforcedUrls = GlobalInlineRedactionUrlsCopier.copy(globalEnforcedUrls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalEnforcedUrls(String... globalEnforcedUrls) {
            globalEnforcedUrls(Arrays.asList(globalEnforcedUrls));
            return this;
        }

        public final Collection<String> getGlobalExemptUrls() {
            if (globalExemptUrls instanceof SdkAutoConstructList) {
                return null;
            }
            return globalExemptUrls;
        }

        public final void setGlobalExemptUrls(Collection<String> globalExemptUrls) {
            this.globalExemptUrls = GlobalInlineRedactionUrlsCopier.copy(globalExemptUrls);
        }

        @Override
        public final Builder globalExemptUrls(Collection<String> globalExemptUrls) {
            this.globalExemptUrls = GlobalInlineRedactionUrlsCopier.copy(globalExemptUrls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder globalExemptUrls(String... globalExemptUrls) {
            globalExemptUrls(Arrays.asList(globalExemptUrls));
            return this;
        }

        public final List<InlineRedactionPattern.Builder> getInlineRedactionPatterns() {
            List<InlineRedactionPattern.Builder> result = InlineRedactionPatternsCopier
                    .copyToBuilder(this.inlineRedactionPatterns);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInlineRedactionPatterns(Collection<InlineRedactionPattern.BuilderImpl> inlineRedactionPatterns) {
            this.inlineRedactionPatterns = InlineRedactionPatternsCopier.copyFromBuilder(inlineRedactionPatterns);
        }

        @Override
        public final Builder inlineRedactionPatterns(Collection<InlineRedactionPattern> inlineRedactionPatterns) {
            this.inlineRedactionPatterns = InlineRedactionPatternsCopier.copy(inlineRedactionPatterns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inlineRedactionPatterns(InlineRedactionPattern... inlineRedactionPatterns) {
            inlineRedactionPatterns(Arrays.asList(inlineRedactionPatterns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inlineRedactionPatterns(Consumer<InlineRedactionPattern.Builder>... inlineRedactionPatterns) {
            inlineRedactionPatterns(Stream.of(inlineRedactionPatterns)
                    .map(c -> InlineRedactionPattern.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public InlineRedactionConfiguration build() {
            return new InlineRedactionConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
