/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.workspacesweb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The set of patterns that determine the data types redacted in session.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InlineRedactionPattern implements SdkPojo, Serializable,
        ToCopyableBuilder<InlineRedactionPattern.Builder, InlineRedactionPattern> {
    private static final SdkField<String> BUILT_IN_PATTERN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("builtInPatternId").getter(getter(InlineRedactionPattern::builtInPatternId))
            .setter(setter(Builder::builtInPatternId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("builtInPatternId").build()).build();

    private static final SdkField<Integer> CONFIDENCE_LEVEL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("confidenceLevel").getter(getter(InlineRedactionPattern::confidenceLevel))
            .setter(setter(Builder::confidenceLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("confidenceLevel").build()).build();

    private static final SdkField<CustomPattern> CUSTOM_PATTERN_FIELD = SdkField
            .<CustomPattern> builder(MarshallingType.SDK_POJO).memberName("customPattern")
            .getter(getter(InlineRedactionPattern::customPattern)).setter(setter(Builder::customPattern))
            .constructor(CustomPattern::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customPattern").build()).build();

    private static final SdkField<List<String>> ENFORCED_URLS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("enforcedUrls")
            .getter(getter(InlineRedactionPattern::enforcedUrls))
            .setter(setter(Builder::enforcedUrls))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enforcedUrls").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> EXEMPT_URLS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("exemptUrls")
            .getter(getter(InlineRedactionPattern::exemptUrls))
            .setter(setter(Builder::exemptUrls))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exemptUrls").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<RedactionPlaceHolder> REDACTION_PLACE_HOLDER_FIELD = SdkField
            .<RedactionPlaceHolder> builder(MarshallingType.SDK_POJO).memberName("redactionPlaceHolder")
            .getter(getter(InlineRedactionPattern::redactionPlaceHolder)).setter(setter(Builder::redactionPlaceHolder))
            .constructor(RedactionPlaceHolder::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("redactionPlaceHolder").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUILT_IN_PATTERN_ID_FIELD,
            CONFIDENCE_LEVEL_FIELD, CUSTOM_PATTERN_FIELD, ENFORCED_URLS_FIELD, EXEMPT_URLS_FIELD, REDACTION_PLACE_HOLDER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("builtInPatternId", BUILT_IN_PATTERN_ID_FIELD);
                    put("confidenceLevel", CONFIDENCE_LEVEL_FIELD);
                    put("customPattern", CUSTOM_PATTERN_FIELD);
                    put("enforcedUrls", ENFORCED_URLS_FIELD);
                    put("exemptUrls", EXEMPT_URLS_FIELD);
                    put("redactionPlaceHolder", REDACTION_PLACE_HOLDER_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String builtInPatternId;

    private final Integer confidenceLevel;

    private final CustomPattern customPattern;

    private final List<String> enforcedUrls;

    private final List<String> exemptUrls;

    private final RedactionPlaceHolder redactionPlaceHolder;

    private InlineRedactionPattern(BuilderImpl builder) {
        this.builtInPatternId = builder.builtInPatternId;
        this.confidenceLevel = builder.confidenceLevel;
        this.customPattern = builder.customPattern;
        this.enforcedUrls = builder.enforcedUrls;
        this.exemptUrls = builder.exemptUrls;
        this.redactionPlaceHolder = builder.redactionPlaceHolder;
    }

    /**
     * <p>
     * The built-in pattern from the list of preconfigured patterns. Either a customPattern or builtInPatternId is
     * required.
     * </p>
     * 
     * @return The built-in pattern from the list of preconfigured patterns. Either a customPattern or builtInPatternId
     *         is required.
     */
    public final String builtInPatternId() {
        return builtInPatternId;
    }

    /**
     * <p>
     * The confidence level for inline redaction pattern. This indicates the certainty of data type matches in the
     * redaction process. Confidence level 3 means high confidence, and requires a formatted text pattern match in order
     * for content to be redacted. Confidence level 2 means medium confidence, and redaction considers both formatted
     * and unformatted text, and adds keyword associate to the logic. Confidence level 1 means low confidence, and
     * redaction is enforced for both formatted pattern + unformatted pattern without keyword. This overrides the global
     * confidence level.
     * </p>
     * 
     * @return The confidence level for inline redaction pattern. This indicates the certainty of data type matches in
     *         the redaction process. Confidence level 3 means high confidence, and requires a formatted text pattern
     *         match in order for content to be redacted. Confidence level 2 means medium confidence, and redaction
     *         considers both formatted and unformatted text, and adds keyword associate to the logic. Confidence level
     *         1 means low confidence, and redaction is enforced for both formatted pattern + unformatted pattern
     *         without keyword. This overrides the global confidence level.
     */
    public final Integer confidenceLevel() {
        return confidenceLevel;
    }

    /**
     * <p>
     * &gt;The configuration for a custom pattern. Either a customPattern or builtInPatternId is required.
     * </p>
     * 
     * @return &gt;The configuration for a custom pattern. Either a customPattern or builtInPatternId is required.
     */
    public final CustomPattern customPattern() {
        return customPattern;
    }

    /**
     * For responses, this returns true if the service returned a value for the EnforcedUrls property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEnforcedUrls() {
        return enforcedUrls != null && !(enforcedUrls instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The enforced URL configuration for the inline redaction pattern. This will override the global enforced URL
     * configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEnforcedUrls} method.
     * </p>
     * 
     * @return The enforced URL configuration for the inline redaction pattern. This will override the global enforced
     *         URL configuration.
     */
    public final List<String> enforcedUrls() {
        return enforcedUrls;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExemptUrls property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasExemptUrls() {
        return exemptUrls != null && !(exemptUrls instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The exempt URL configuration for the inline redaction pattern. This will override the global exempt URL
     * configuration for the inline redaction pattern.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExemptUrls} method.
     * </p>
     * 
     * @return The exempt URL configuration for the inline redaction pattern. This will override the global exempt URL
     *         configuration for the inline redaction pattern.
     */
    public final List<String> exemptUrls() {
        return exemptUrls;
    }

    /**
     * <p>
     * The redaction placeholder that will replace the redacted text in session for the inline redaction pattern.
     * </p>
     * 
     * @return The redaction placeholder that will replace the redacted text in session for the inline redaction
     *         pattern.
     */
    public final RedactionPlaceHolder redactionPlaceHolder() {
        return redactionPlaceHolder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(builtInPatternId());
        hashCode = 31 * hashCode + Objects.hashCode(confidenceLevel());
        hashCode = 31 * hashCode + Objects.hashCode(customPattern());
        hashCode = 31 * hashCode + Objects.hashCode(hasEnforcedUrls() ? enforcedUrls() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasExemptUrls() ? exemptUrls() : null);
        hashCode = 31 * hashCode + Objects.hashCode(redactionPlaceHolder());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InlineRedactionPattern)) {
            return false;
        }
        InlineRedactionPattern other = (InlineRedactionPattern) obj;
        return Objects.equals(builtInPatternId(), other.builtInPatternId())
                && Objects.equals(confidenceLevel(), other.confidenceLevel())
                && Objects.equals(customPattern(), other.customPattern()) && hasEnforcedUrls() == other.hasEnforcedUrls()
                && Objects.equals(enforcedUrls(), other.enforcedUrls()) && hasExemptUrls() == other.hasExemptUrls()
                && Objects.equals(exemptUrls(), other.exemptUrls())
                && Objects.equals(redactionPlaceHolder(), other.redactionPlaceHolder());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InlineRedactionPattern")
                .add("BuiltInPatternId", builtInPatternId() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ConfidenceLevel", confidenceLevel()).add("CustomPattern", customPattern())
                .add("EnforcedUrls", enforcedUrls() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ExemptUrls", exemptUrls() == null ? null : "*** Sensitive Data Redacted ***")
                .add("RedactionPlaceHolder", redactionPlaceHolder()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "builtInPatternId":
            return Optional.ofNullable(clazz.cast(builtInPatternId()));
        case "confidenceLevel":
            return Optional.ofNullable(clazz.cast(confidenceLevel()));
        case "customPattern":
            return Optional.ofNullable(clazz.cast(customPattern()));
        case "enforcedUrls":
            return Optional.ofNullable(clazz.cast(enforcedUrls()));
        case "exemptUrls":
            return Optional.ofNullable(clazz.cast(exemptUrls()));
        case "redactionPlaceHolder":
            return Optional.ofNullable(clazz.cast(redactionPlaceHolder()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<InlineRedactionPattern, T> g) {
        return obj -> g.apply((InlineRedactionPattern) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InlineRedactionPattern> {
        /**
         * <p>
         * The built-in pattern from the list of preconfigured patterns. Either a customPattern or builtInPatternId is
         * required.
         * </p>
         * 
         * @param builtInPatternId
         *        The built-in pattern from the list of preconfigured patterns. Either a customPattern or
         *        builtInPatternId is required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder builtInPatternId(String builtInPatternId);

        /**
         * <p>
         * The confidence level for inline redaction pattern. This indicates the certainty of data type matches in the
         * redaction process. Confidence level 3 means high confidence, and requires a formatted text pattern match in
         * order for content to be redacted. Confidence level 2 means medium confidence, and redaction considers both
         * formatted and unformatted text, and adds keyword associate to the logic. Confidence level 1 means low
         * confidence, and redaction is enforced for both formatted pattern + unformatted pattern without keyword. This
         * overrides the global confidence level.
         * </p>
         * 
         * @param confidenceLevel
         *        The confidence level for inline redaction pattern. This indicates the certainty of data type matches
         *        in the redaction process. Confidence level 3 means high confidence, and requires a formatted text
         *        pattern match in order for content to be redacted. Confidence level 2 means medium confidence, and
         *        redaction considers both formatted and unformatted text, and adds keyword associate to the logic.
         *        Confidence level 1 means low confidence, and redaction is enforced for both formatted pattern +
         *        unformatted pattern without keyword. This overrides the global confidence level.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder confidenceLevel(Integer confidenceLevel);

        /**
         * <p>
         * &gt;The configuration for a custom pattern. Either a customPattern or builtInPatternId is required.
         * </p>
         * 
         * @param customPattern
         *        &gt;The configuration for a custom pattern. Either a customPattern or builtInPatternId is required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customPattern(CustomPattern customPattern);

        /**
         * <p>
         * &gt;The configuration for a custom pattern. Either a customPattern or builtInPatternId is required.
         * </p>
         * This is a convenience method that creates an instance of the {@link CustomPattern.Builder} avoiding the need
         * to create one manually via {@link CustomPattern#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomPattern.Builder#build()} is called immediately and its
         * result is passed to {@link #customPattern(CustomPattern)}.
         * 
         * @param customPattern
         *        a consumer that will call methods on {@link CustomPattern.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customPattern(CustomPattern)
         */
        default Builder customPattern(Consumer<CustomPattern.Builder> customPattern) {
            return customPattern(CustomPattern.builder().applyMutation(customPattern).build());
        }

        /**
         * <p>
         * The enforced URL configuration for the inline redaction pattern. This will override the global enforced URL
         * configuration.
         * </p>
         * 
         * @param enforcedUrls
         *        The enforced URL configuration for the inline redaction pattern. This will override the global
         *        enforced URL configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enforcedUrls(Collection<String> enforcedUrls);

        /**
         * <p>
         * The enforced URL configuration for the inline redaction pattern. This will override the global enforced URL
         * configuration.
         * </p>
         * 
         * @param enforcedUrls
         *        The enforced URL configuration for the inline redaction pattern. This will override the global
         *        enforced URL configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enforcedUrls(String... enforcedUrls);

        /**
         * <p>
         * The exempt URL configuration for the inline redaction pattern. This will override the global exempt URL
         * configuration for the inline redaction pattern.
         * </p>
         * 
         * @param exemptUrls
         *        The exempt URL configuration for the inline redaction pattern. This will override the global exempt
         *        URL configuration for the inline redaction pattern.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exemptUrls(Collection<String> exemptUrls);

        /**
         * <p>
         * The exempt URL configuration for the inline redaction pattern. This will override the global exempt URL
         * configuration for the inline redaction pattern.
         * </p>
         * 
         * @param exemptUrls
         *        The exempt URL configuration for the inline redaction pattern. This will override the global exempt
         *        URL configuration for the inline redaction pattern.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exemptUrls(String... exemptUrls);

        /**
         * <p>
         * The redaction placeholder that will replace the redacted text in session for the inline redaction pattern.
         * </p>
         * 
         * @param redactionPlaceHolder
         *        The redaction placeholder that will replace the redacted text in session for the inline redaction
         *        pattern.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redactionPlaceHolder(RedactionPlaceHolder redactionPlaceHolder);

        /**
         * <p>
         * The redaction placeholder that will replace the redacted text in session for the inline redaction pattern.
         * </p>
         * This is a convenience method that creates an instance of the {@link RedactionPlaceHolder.Builder} avoiding
         * the need to create one manually via {@link RedactionPlaceHolder#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RedactionPlaceHolder.Builder#build()} is called immediately and
         * its result is passed to {@link #redactionPlaceHolder(RedactionPlaceHolder)}.
         * 
         * @param redactionPlaceHolder
         *        a consumer that will call methods on {@link RedactionPlaceHolder.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #redactionPlaceHolder(RedactionPlaceHolder)
         */
        default Builder redactionPlaceHolder(Consumer<RedactionPlaceHolder.Builder> redactionPlaceHolder) {
            return redactionPlaceHolder(RedactionPlaceHolder.builder().applyMutation(redactionPlaceHolder).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String builtInPatternId;

        private Integer confidenceLevel;

        private CustomPattern customPattern;

        private List<String> enforcedUrls = DefaultSdkAutoConstructList.getInstance();

        private List<String> exemptUrls = DefaultSdkAutoConstructList.getInstance();

        private RedactionPlaceHolder redactionPlaceHolder;

        private BuilderImpl() {
        }

        private BuilderImpl(InlineRedactionPattern model) {
            builtInPatternId(model.builtInPatternId);
            confidenceLevel(model.confidenceLevel);
            customPattern(model.customPattern);
            enforcedUrls(model.enforcedUrls);
            exemptUrls(model.exemptUrls);
            redactionPlaceHolder(model.redactionPlaceHolder);
        }

        public final String getBuiltInPatternId() {
            return builtInPatternId;
        }

        public final void setBuiltInPatternId(String builtInPatternId) {
            this.builtInPatternId = builtInPatternId;
        }

        @Override
        public final Builder builtInPatternId(String builtInPatternId) {
            this.builtInPatternId = builtInPatternId;
            return this;
        }

        public final Integer getConfidenceLevel() {
            return confidenceLevel;
        }

        public final void setConfidenceLevel(Integer confidenceLevel) {
            this.confidenceLevel = confidenceLevel;
        }

        @Override
        public final Builder confidenceLevel(Integer confidenceLevel) {
            this.confidenceLevel = confidenceLevel;
            return this;
        }

        public final CustomPattern.Builder getCustomPattern() {
            return customPattern != null ? customPattern.toBuilder() : null;
        }

        public final void setCustomPattern(CustomPattern.BuilderImpl customPattern) {
            this.customPattern = customPattern != null ? customPattern.build() : null;
        }

        @Override
        public final Builder customPattern(CustomPattern customPattern) {
            this.customPattern = customPattern;
            return this;
        }

        public final Collection<String> getEnforcedUrls() {
            if (enforcedUrls instanceof SdkAutoConstructList) {
                return null;
            }
            return enforcedUrls;
        }

        public final void setEnforcedUrls(Collection<String> enforcedUrls) {
            this.enforcedUrls = InlineRedactionUrlsCopier.copy(enforcedUrls);
        }

        @Override
        public final Builder enforcedUrls(Collection<String> enforcedUrls) {
            this.enforcedUrls = InlineRedactionUrlsCopier.copy(enforcedUrls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enforcedUrls(String... enforcedUrls) {
            enforcedUrls(Arrays.asList(enforcedUrls));
            return this;
        }

        public final Collection<String> getExemptUrls() {
            if (exemptUrls instanceof SdkAutoConstructList) {
                return null;
            }
            return exemptUrls;
        }

        public final void setExemptUrls(Collection<String> exemptUrls) {
            this.exemptUrls = InlineRedactionUrlsCopier.copy(exemptUrls);
        }

        @Override
        public final Builder exemptUrls(Collection<String> exemptUrls) {
            this.exemptUrls = InlineRedactionUrlsCopier.copy(exemptUrls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exemptUrls(String... exemptUrls) {
            exemptUrls(Arrays.asList(exemptUrls));
            return this;
        }

        public final RedactionPlaceHolder.Builder getRedactionPlaceHolder() {
            return redactionPlaceHolder != null ? redactionPlaceHolder.toBuilder() : null;
        }

        public final void setRedactionPlaceHolder(RedactionPlaceHolder.BuilderImpl redactionPlaceHolder) {
            this.redactionPlaceHolder = redactionPlaceHolder != null ? redactionPlaceHolder.build() : null;
        }

        @Override
        public final Builder redactionPlaceHolder(RedactionPlaceHolder redactionPlaceHolder) {
            this.redactionPlaceHolder = redactionPlaceHolder;
            return this;
        }

        @Override
        public InlineRedactionPattern build() {
            return new InlineRedactionPattern(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
